/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.symbology.AbstractTacticalSymbol;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525ModifierRetriever;
import gov.nasa.worldwind.symbology.milstd2525.SymbolCode;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.media.opengl.GL2;

public class EchelonSymbol
extends AbstractTacticalSymbol {
    protected static final Offset DEFAULT_OFFSET = Offset.fromFraction(0.5, -0.5);
    protected String sidc;
    protected Position orientationPosition;
    protected Angle rotation;

    public EchelonSymbol(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.SymbolCodeIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        SymbolCode symbolCode = new SymbolCode(string);
        String string3 = symbolCode.getEchelon();
        if (SymbolCode.isFieldEmpty(string3)) {
            String string4 = Logging.getMessage("Symbology.InvalidSymbolCode", string);
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.sidc = string;
        this.setAltitudeMode(1);
        this.setOffset(DEFAULT_OFFSET);
        String string5 = Configuration.getStringValue("gov.nasa.worldwind.avkey.MilStd2525IconRetrieverPath", "http://worldwind.arc.nasa.gov/milstd2525c/rev1/");
        this.setIconRetriever(new MilStd2525ModifierRetriever(string5));
    }

    public Position getOrientationPosition() {
        return this.orientationPosition;
    }

    public void setOrientationPosition(Position position) {
        this.orientationPosition = position;
    }

    @Override
    public String getIdentifier() {
        SymbolCode symbolCode = new SymbolCode(this.sidc);
        String string = symbolCode.getEchelon();
        return "-" + string;
    }

    @Override
    protected AVList assembleIconRetrieverParameters(AVList aVList) {
        Material material;
        if ((aVList = super.assembleIconRetrieverParameters(aVList)) == null) {
            aVList = new AVListImpl();
        }
        if ((material = this.getActiveAttributes().getTextModifierMaterial()) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.Color", material.getDiffuse());
        }
        return aVList;
    }

    @Override
    protected void computeTransform(DrawContext drawContext) {
        Object object;
        super.computeTransform(drawContext);
        boolean bl = false;
        if (this.orientationPosition != null) {
            object = drawContext.computeTerrainPoint(this.orientationPosition.getLatitude(), this.orientationPosition.getLongitude(), 0.0);
            Vec4 vec4 = drawContext.getView().project((Vec4)object);
            this.rotation = this.computeRotation(this.screenPoint, vec4);
            boolean bl2 = bl = this.screenPoint.x <= vec4.x;
        }
        if (this.getOffset() != null && this.iconRect != null) {
            object = this.getOffset().computeOffset(this.iconRect.getWidth(), this.iconRect.getHeight(), null, null);
            if (this.rotation != null) {
                double d = ((Point2D)object).getY();
                if (bl) {
                    d = -(d + this.iconRect.getHeight());
                }
                Vec4 vec4 = new Vec4(((Point2D)object).getX(), d);
                Matrix matrix = Matrix.fromRotationZ(this.rotation.multiply(-1.0));
                vec4 = vec4.transformBy3(matrix);
                object = new Point((int)vec4.getX(), (int)vec4.getY());
            }
            this.dx = -this.iconRect.getX() - ((Point2D)object).getX();
            this.dy = -(this.iconRect.getY() - ((Point2D)object).getY());
        } else {
            this.dx = 0.0;
            this.dy = 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawIcon(DrawContext drawContext) {
        boolean bl = false;
        GL2 gL2 = drawContext.getGL().getGL2();
        try {
            if (this.rotation != null) {
                gL2.glPushMatrix();
                gL2.glRotated(this.rotation.degrees, 0.0, 0.0, 1.0);
                bl = true;
            }
            gL2.glDisable(2929);
            super.drawIcon(drawContext);
        }
        finally {
            gL2.glEnable(2929);
            if (bl) {
                gL2.glPopMatrix();
            }
        }
    }

    protected Angle computeRotation(Vec4 vec4, Vec4 vec42) {
        double d = vec4.x - vec42.x;
        double d2 = vec4.y - vec42.y;
        if (d != 0.0) {
            double d3 = Math.atan(d2 / d);
            return Angle.fromRadians(d3);
        }
        return Angle.POS90;
    }
}

