/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.symbology.AbstractIconRetriever;
import gov.nasa.worldwind.symbology.SymbologyConstants;
import gov.nasa.worldwind.symbology.milstd2525.SymbolCode;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class MilStd2525ModifierRetriever
extends AbstractIconRetriever {
    protected static final Color DEFAULT_COLOR = Color.BLACK;
    protected static final String PATH_PREFIX = "modifiers";
    protected static final String PATH_SUFFIX = ".png";
    protected static final int[] variableWidths = new int[]{88, 93, 114, 119};

    public MilStd2525ModifierRetriever(String string) {
        super(string);
    }

    @Override
    public BufferedImage createIcon(String string, AVList aVList) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.SymbolCodeIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        String string3 = this.composePath(string, aVList);
        if (string3 == null) {
            String string4 = Logging.getMessage("Symbology.SymbolIconNotFound", string);
            Logging.logger().severe(string4);
            throw new WWRuntimeException(string4);
        }
        BufferedImage bufferedImage = this.readImage(string3);
        if (bufferedImage == null) {
            String string5 = Logging.getMessage("Symbology.SymbolIconNotFound", string);
            Logging.logger().severe(string5);
            throw new WWRuntimeException(string5);
        }
        if (this.mustApplyColor(string)) {
            Color color = this.getColorFromParams(aVList);
            if (color == null) {
                color = DEFAULT_COLOR;
            }
            this.multiply(bufferedImage, color);
        }
        return bufferedImage;
    }

    protected String composePath(String string, AVList aVList) {
        Integer n;
        AVList aVList2 = SymbolCode.parseSymbolModifierCode(string, null);
        if (aVList2 == null) {
            return null;
        }
        if (aVList != null) {
            aVList2.setValues(aVList);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PATH_PREFIX).append("/");
        stringBuilder.append(string.toLowerCase());
        if (this.isVariableWidth(aVList2) && (n = this.chooseBestFittingWidth(aVList2)) != null) {
            stringBuilder.append("_").append(n);
        }
        stringBuilder.append(PATH_SUFFIX);
        return stringBuilder.toString();
    }

    protected boolean isVariableWidth(AVList aVList) {
        return aVList.hasKey("AB") || aVList.hasKey("gov.nasa.worldwind.symbology.OperationalConditionAlternate");
    }

    protected boolean mustApplyColor(String string) {
        return !SymbologyConstants.OPERATIONAL_CONDITION_ALTERNATE_ALL.contains(string.toUpperCase());
    }

    protected Integer chooseBestFittingWidth(AVList aVList) {
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.Width");
        if (object == null || !(object instanceof Number)) {
            return null;
        }
        int n = ((Number)object).intValue();
        int n2 = variableWidths[0];
        int n3 = Math.abs(n - n2);
        for (int i = 1; i < variableWidths.length; ++i) {
            int n4 = Math.abs(n - variableWidths[i]);
            if (n4 >= n3) continue;
            n2 = variableWidths[i];
            n3 = n4;
        }
        return n2;
    }

    protected Color getColorFromParams(AVList aVList) {
        if (aVList == null) {
            return null;
        }
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.Color");
        return object instanceof Color ? (Color)object : null;
    }
}

