/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.symbology.AbstractIconRetriever;
import gov.nasa.worldwind.symbology.milstd2525.SymbolCode;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MilStd2525IconRetriever
extends AbstractIconRetriever {
    protected static final String FILLS_PATH = "fills";
    protected static final String FRAMES_PATH = "frames";
    protected static final String ICONS_PATH = "icons";
    protected static final String TACTICAL_SYMBOLS_PATH = "tacsym";
    protected static final String UNKNOWN_PATH = "unk";
    protected static final Color FILL_COLOR_LIGHT_RED = new Color(255, 128, 128);
    protected static final Color FILL_COLOR_LIGHT_BLUE = new Color(128, 224, 255);
    protected static final Color FILL_COLOR_LIGHT_GREEN = new Color(170, 255, 170);
    protected static final Color FILL_COLOR_LIGHT_YELLOW = new Color(255, 255, 128);
    protected static final Color FILL_COLOR_LIGHT_PURPLE = new Color(255, 161, 255);
    protected static final Color FRAME_COLOR_RED = new Color(255, 0, 0);
    protected static final Color FRAME_COLOR_BLUE = new Color(0, 255, 255);
    protected static final Color FRAME_COLOR_GREEN = new Color(0, 255, 0);
    protected static final Color FRAME_COLOR_YELLOW = new Color(255, 255, 0);
    protected static final Color FRAME_COLOR_PURPLE = new Color(255, 0, 255);
    protected static final Color ICON_COLOR_RED = new Color(255, 0, 0);
    protected static final Color ICON_COLOR_ORANGE = new Color(255, 140, 0);
    protected static final Color ICON_COLOR_GREEN = new Color(0, 255, 0);
    protected static final Color ICON_COLOR_DARK_GREEN = new Color(0, 128, 0);
    protected static final Color ICON_COLOR_YELLOW = new Color(255, 255, 0);
    protected static final Color DEFAULT_FRAME_COLOR = Color.BLACK;
    protected static final Color DEFAULT_ICON_COLOR = Color.BLACK;
    protected static final String DEFAULT_IMAGE_FORMAT = "image/png";
    protected static final int CIRCLE_RADIUS = 16;
    protected static final int CIRCLE_LINE_WIDTH = 2;
    protected static final Map<String, String> schemePathMap = new HashMap<String, String>();
    protected static final Map<String, Color> fillColorMap = new HashMap<String, Color>();
    protected static final Map<String, Color> frameColorMap = new HashMap<String, Color>();
    protected static final Map<String, Color> iconColorMap = new HashMap<String, Color>();
    protected static final Set<String> unfilledIconMap = new HashSet<String>();
    protected static final Set<String> unframedIconMap = new HashSet<String>();
    protected static final Set<String> emsEquipment = new HashSet<String>();

    public MilStd2525IconRetriever(String string) {
        super(string);
    }

    @Override
    public BufferedImage createIcon(String string, AVList aVList) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.SymbolCodeIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        SymbolCode symbolCode = new SymbolCode(string);
        BufferedImage bufferedImage = null;
        boolean bl = this.mustDrawFill(symbolCode, aVList);
        boolean bl2 = this.mustDrawIcon(symbolCode, aVList);
        boolean bl3 = this.mustDrawFrame(symbolCode, aVList);
        if (bl3 || bl2) {
            if (bl && bl3) {
                bufferedImage = this.drawFill(symbolCode, aVList, null);
            }
            if (bl3) {
                bufferedImage = this.drawFrame(symbolCode, aVList, bufferedImage);
            }
            if (bl2) {
                bufferedImage = this.drawIcon(symbolCode, aVList, bufferedImage);
            }
        }
        if (bufferedImage == null) {
            bufferedImage = this.drawCircle(symbolCode, aVList, bufferedImage);
        }
        return bufferedImage;
    }

    protected boolean mustDrawFill(SymbolCode symbolCode, AVList aVList) {
        String string = symbolCode.toMaskedString().toLowerCase();
        if (unfilledIconMap.contains(string)) {
            return false;
        }
        Object object = aVList != null ? aVList.getValue("gov.nasa.worldwind.symbology.ShowFill") : null;
        return object == null || object.equals(Boolean.TRUE);
    }

    protected boolean mustDrawFrame(SymbolCode symbolCode, AVList aVList) {
        String string = symbolCode.toMaskedString().toLowerCase();
        if (unframedIconMap.contains(string)) {
            return false;
        }
        Object object = aVList != null ? aVList.getValue("gov.nasa.worldwind.symbology.ShowFrame") : null;
        return object == null || object.equals(Boolean.TRUE);
    }

    protected boolean mustDrawIcon(SymbolCode symbolCode, AVList aVList) {
        Object object = aVList != null ? aVList.getValue("gov.nasa.worldwind.symbology.ShowIcon") : null;
        return object == null || object.equals(Boolean.TRUE);
    }

    protected BufferedImage drawFill(SymbolCode symbolCode, AVList aVList, BufferedImage bufferedImage) {
        String string = this.composeFillPath(symbolCode);
        Color color = this.getFillColor(symbolCode, aVList);
        return string != null ? this.drawIconComponent(string, color, bufferedImage) : bufferedImage;
    }

    protected BufferedImage drawFrame(SymbolCode symbolCode, AVList aVList, BufferedImage bufferedImage) {
        String string = this.composeFramePath(symbolCode);
        Color color = this.getFrameColor(symbolCode, aVList);
        return string != null ? this.drawIconComponent(string, color, bufferedImage) : bufferedImage;
    }

    protected BufferedImage drawIcon(SymbolCode symbolCode, AVList aVList, BufferedImage bufferedImage) {
        String string = this.composeIconPath(symbolCode, aVList);
        Color color = this.getIconColor(symbolCode, aVList);
        return string != null ? this.drawIconComponent(string, color, bufferedImage) : bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage drawCircle(SymbolCode symbolCode, AVList aVList, BufferedImage bufferedImage) {
        Color color;
        Color color2 = DEFAULT_FRAME_COLOR;
        Color color3 = color = this.mustDrawFill(symbolCode, aVList) ? this.getFillColor(symbolCode, aVList) : DEFAULT_ICON_COLOR;
        if (bufferedImage == null) {
            int n = 32;
            bufferedImage = new BufferedImage(n, n, 2);
        }
        Graphics2D graphics2D = null;
        try {
            graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n = (int)((double)bufferedImage.getWidth() / 2.0 - 16.0 + 2.0);
            int n2 = 28;
            Ellipse2D.Double double_ = new Ellipse2D.Double(n, n, n2, n2);
            graphics2D.setColor(color);
            graphics2D.fill(double_);
            graphics2D.setColor(color2);
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.draw(double_);
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
        return bufferedImage;
    }

    protected BufferedImage drawIconComponent(String string, Color color, BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = this.readImage(string);
        if (bufferedImage2 == null) {
            String string2 = Logging.getMessage("Symbology.MissingIconComponent", string);
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (color != null) {
            this.multiply(bufferedImage2, color);
        }
        if (bufferedImage != null) {
            bufferedImage2 = this.drawImage(bufferedImage2, bufferedImage);
        }
        return bufferedImage2;
    }

    protected String composeFillPath(SymbolCode symbolCode) {
        String string = this.getMaskedFillCode(symbolCode);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(FILLS_PATH).append("/");
        stringBuilder.append(TACTICAL_SYMBOLS_PATH).append("/");
        stringBuilder.append(string.toLowerCase());
        stringBuilder.append(WWIO.makeSuffixForMimeType(DEFAULT_IMAGE_FORMAT));
        return stringBuilder.toString();
    }

    protected String composeFramePath(SymbolCode symbolCode) {
        String string = this.getMaskedFrameCode(symbolCode);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(FRAMES_PATH).append("/");
        stringBuilder.append(TACTICAL_SYMBOLS_PATH).append("/");
        stringBuilder.append(string.toLowerCase());
        stringBuilder.append(WWIO.makeSuffixForMimeType(DEFAULT_IMAGE_FORMAT));
        return stringBuilder.toString();
    }

    protected String composeIconPath(SymbolCode symbolCode, AVList aVList) {
        String string = symbolCode.getScheme();
        String string2 = symbolCode.getBattleDimension();
        if (string2 != null && string2.equalsIgnoreCase("Z")) {
            String string3 = this.getMaskedUnknownIconCode(symbolCode, aVList);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ICONS_PATH).append("/");
            stringBuilder.append(UNKNOWN_PATH).append("/");
            stringBuilder.append(string3.toLowerCase());
            stringBuilder.append(WWIO.makeSuffixForMimeType(DEFAULT_IMAGE_FORMAT));
            return stringBuilder.toString();
        }
        if (SymbolCode.isFieldEmpty(symbolCode.getFunctionId())) {
            return null;
        }
        String string4 = this.getMaskedIconCode(symbolCode, aVList);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ICONS_PATH).append("/");
        stringBuilder.append(schemePathMap.get(string.toLowerCase())).append("/");
        stringBuilder.append(string4.toLowerCase());
        stringBuilder.append(WWIO.makeSuffixForMimeType(DEFAULT_IMAGE_FORMAT));
        return stringBuilder.toString();
    }

    protected Color getFillColor(SymbolCode symbolCode, AVList aVList) {
        Color color = this.getColorFromParams(aVList);
        return color != null ? color : fillColorMap.get(symbolCode.getStandardIdentity().toLowerCase());
    }

    protected Color getFrameColor(SymbolCode symbolCode, AVList aVList) {
        if (this.isDashedFrame(symbolCode)) {
            return null;
        }
        if (this.mustDrawFill(symbolCode, aVList)) {
            return DEFAULT_FRAME_COLOR;
        }
        Color color = this.getColorFromParams(aVList);
        return color != null ? color : frameColorMap.get(symbolCode.getStandardIdentity().toLowerCase());
    }

    protected Color getIconColor(SymbolCode symbolCode, AVList aVList) {
        String string = symbolCode.toMaskedString().toLowerCase();
        if (this.mustDrawFrame(symbolCode, aVList)) {
            return iconColorMap.containsKey(string) ? iconColorMap.get(string) : DEFAULT_ICON_COLOR;
        }
        if (this.mustDrawFill(symbolCode, aVList)) {
            Color color = this.getColorFromParams(aVList);
            return color != null ? color : fillColorMap.get(symbolCode.getStandardIdentity().toLowerCase());
        }
        return iconColorMap.containsKey(string) ? iconColorMap.get(string) : DEFAULT_ICON_COLOR;
    }

    protected Color getColorFromParams(AVList aVList) {
        if (aVList == null) {
            return null;
        }
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.Color");
        return object instanceof Color ? (Color)object : null;
    }

    protected String getMaskedFillCode(SymbolCode symbolCode) {
        symbolCode = this.transformToWarfightingScheme(symbolCode);
        String string = this.getSimpleStandardIdentity(symbolCode);
        String string2 = symbolCode.getBattleDimension();
        String string3 = this.getGroundFunctionId(symbolCode);
        StringBuilder stringBuilder = new StringBuilder();
        SymbolCode.appendFieldValue(stringBuilder, null, 1);
        SymbolCode.appendFieldValue(stringBuilder, string, 1);
        SymbolCode.appendFieldValue(stringBuilder, string2, 1);
        SymbolCode.appendFieldValue(stringBuilder, null, 1);
        SymbolCode.appendFieldValue(stringBuilder, string3, 6);
        SymbolCode.appendFieldValue(stringBuilder, null, 2);
        SymbolCode.appendFieldValue(stringBuilder, null, 2);
        SymbolCode.appendFieldValue(stringBuilder, null, 1);
        return stringBuilder.toString();
    }

    protected String getMaskedFrameCode(SymbolCode symbolCode) {
        symbolCode = this.transformToWarfightingScheme(symbolCode);
        String string = symbolCode.getStandardIdentity();
        String string2 = symbolCode.getBattleDimension();
        String string3 = this.getSimpleStatus(symbolCode);
        String string4 = this.getGroundFunctionId(symbolCode);
        StringBuilder stringBuilder = new StringBuilder();
        SymbolCode.appendFieldValue(stringBuilder, null, 1);
        SymbolCode.appendFieldValue(stringBuilder, string, 1);
        SymbolCode.appendFieldValue(stringBuilder, string2, 1);
        SymbolCode.appendFieldValue(stringBuilder, string3, 1);
        SymbolCode.appendFieldValue(stringBuilder, string4, 6);
        SymbolCode.appendFieldValue(stringBuilder, null, 2);
        SymbolCode.appendFieldValue(stringBuilder, null, 2);
        SymbolCode.appendFieldValue(stringBuilder, null, 1);
        return stringBuilder.toString();
    }

    protected SymbolCode transformToWarfightingScheme(SymbolCode symbolCode) {
        String string = symbolCode.toMaskedString().toLowerCase();
        String string2 = symbolCode.getScheme();
        String string3 = symbolCode.getBattleDimension();
        SymbolCode symbolCode2 = new SymbolCode();
        symbolCode2.setScheme("S");
        symbolCode2.setStandardIdentity(symbolCode.getStandardIdentity());
        symbolCode2.setStatus(symbolCode.getStatus());
        if (string2 != null && string2.equalsIgnoreCase("I")) {
            symbolCode2.setBattleDimension(string3);
            if (string3 != null && string3.equalsIgnoreCase("G")) {
                symbolCode2.setFunctionId("E-----");
            }
            return symbolCode2;
        }
        if (string2 != null && string2.equalsIgnoreCase("O")) {
            symbolCode2.setBattleDimension("G");
            symbolCode2.setFunctionId("U-----");
            return symbolCode2;
        }
        if (string2 != null && string2.equalsIgnoreCase("E")) {
            symbolCode2.setBattleDimension("G");
            symbolCode2.setFunctionId(emsEquipment.contains(string) ? "E-----" : "U-----");
            return symbolCode2;
        }
        return symbolCode;
    }

    protected String getMaskedIconCode(SymbolCode symbolCode, AVList aVList) {
        String string = this.getSimpleStandardIdentity(symbolCode);
        String string2 = this.getSimpleStatus(symbolCode);
        if (this.mustDrawFrame(symbolCode, aVList)) {
            string2 = "P";
        }
        SymbolCode symbolCode2 = new SymbolCode(symbolCode.toString());
        symbolCode2.setStandardIdentity(string);
        symbolCode2.setStatus(string2);
        symbolCode2.setSymbolModifier(null);
        symbolCode2.setCountryCode(null);
        symbolCode2.setOrderOfBattle(null);
        return symbolCode2.toString();
    }

    protected String getMaskedUnknownIconCode(SymbolCode symbolCode, AVList aVList) {
        String string = this.getSimpleStandardIdentity(symbolCode);
        String string2 = symbolCode.getBattleDimension();
        String string3 = this.getSimpleStatus(symbolCode);
        if (this.mustDrawFrame(symbolCode, aVList)) {
            string3 = "P";
        }
        StringBuilder stringBuilder = new StringBuilder();
        SymbolCode.appendFieldValue(stringBuilder, null, 1);
        SymbolCode.appendFieldValue(stringBuilder, string, 1);
        SymbolCode.appendFieldValue(stringBuilder, string2, 1);
        SymbolCode.appendFieldValue(stringBuilder, string3, 1);
        SymbolCode.appendFieldValue(stringBuilder, null, 6);
        SymbolCode.appendFieldValue(stringBuilder, null, 2);
        SymbolCode.appendFieldValue(stringBuilder, null, 2);
        SymbolCode.appendFieldValue(stringBuilder, null, 1);
        return stringBuilder.toString();
    }

    protected boolean isDashedFrame(SymbolCode symbolCode) {
        String string = symbolCode.getStandardIdentity();
        return string != null && (string.equalsIgnoreCase("P") || string.equalsIgnoreCase("A") || string.equalsIgnoreCase("S") || string.equalsIgnoreCase("G") || string.equalsIgnoreCase("M"));
    }

    protected String getSimpleStandardIdentity(SymbolCode symbolCode) {
        String string = symbolCode.getStandardIdentity();
        if (string != null && (string.equalsIgnoreCase("P") || string.equalsIgnoreCase("U") || string.equalsIgnoreCase("G") || string.equalsIgnoreCase("W"))) {
            return "U";
        }
        if (string != null && (string.equalsIgnoreCase("F") || string.equalsIgnoreCase("A") || string.equalsIgnoreCase("D") || string.equalsIgnoreCase("M") || string.equalsIgnoreCase("J") || string.equalsIgnoreCase("K"))) {
            return "F";
        }
        if (string != null && (string.equalsIgnoreCase("N") || string.equalsIgnoreCase("L"))) {
            return "N";
        }
        if (string != null && (string.equalsIgnoreCase("H") || string.equalsIgnoreCase("S"))) {
            return "H";
        }
        return string;
    }

    protected String getSimpleStatus(SymbolCode symbolCode) {
        String string = symbolCode.getStatus();
        if (string != null && string.equalsIgnoreCase("A")) {
            return "A";
        }
        return "P";
    }

    protected String getGroundFunctionId(SymbolCode symbolCode) {
        String string = symbolCode.getScheme();
        String string2 = symbolCode.getBattleDimension();
        String string3 = symbolCode.getFunctionId();
        if (string != null && string.equalsIgnoreCase("S") && string2 != null && string2.equalsIgnoreCase("G")) {
            if (string3 != null && string3.toLowerCase().startsWith("u")) {
                return "u-----";
            }
            if (string3 != null && string3.toLowerCase().startsWith("e")) {
                return "e-----";
            }
            if (string3 != null && string3.toLowerCase().startsWith("i")) {
                return "i-----";
            }
        }
        return null;
    }

    static {
        schemePathMap.put("s", "war");
        schemePathMap.put("i", "sigint");
        schemePathMap.put("o", "stbops");
        schemePathMap.put("e", "ems");
        fillColorMap.put("p", FILL_COLOR_LIGHT_YELLOW);
        fillColorMap.put("u", FILL_COLOR_LIGHT_YELLOW);
        fillColorMap.put("f", FILL_COLOR_LIGHT_BLUE);
        fillColorMap.put("n", FILL_COLOR_LIGHT_GREEN);
        fillColorMap.put("h", FILL_COLOR_LIGHT_RED);
        fillColorMap.put("a", FILL_COLOR_LIGHT_BLUE);
        fillColorMap.put("s", FILL_COLOR_LIGHT_RED);
        fillColorMap.put("g", FILL_COLOR_LIGHT_YELLOW);
        fillColorMap.put("w", FILL_COLOR_LIGHT_YELLOW);
        fillColorMap.put("d", FILL_COLOR_LIGHT_BLUE);
        fillColorMap.put("l", FILL_COLOR_LIGHT_GREEN);
        fillColorMap.put("m", FILL_COLOR_LIGHT_BLUE);
        fillColorMap.put("j", FILL_COLOR_LIGHT_RED);
        fillColorMap.put("k", FILL_COLOR_LIGHT_RED);
        frameColorMap.put("p", FRAME_COLOR_YELLOW);
        frameColorMap.put("u", FRAME_COLOR_YELLOW);
        frameColorMap.put("f", FRAME_COLOR_BLUE);
        frameColorMap.put("n", FRAME_COLOR_GREEN);
        frameColorMap.put("h", FRAME_COLOR_RED);
        frameColorMap.put("a", FRAME_COLOR_BLUE);
        frameColorMap.put("s", FRAME_COLOR_RED);
        frameColorMap.put("g", FRAME_COLOR_YELLOW);
        frameColorMap.put("w", FRAME_COLOR_YELLOW);
        frameColorMap.put("d", FRAME_COLOR_BLUE);
        frameColorMap.put("l", FRAME_COLOR_GREEN);
        frameColorMap.put("m", FRAME_COLOR_BLUE);
        frameColorMap.put("j", FRAME_COLOR_RED);
        frameColorMap.put("k", FRAME_COLOR_RED);
        iconColorMap.put("e-f-a----------", null);
        iconColorMap.put("e-f-aa---------", null);
        iconColorMap.put("e-f-ab---------", null);
        iconColorMap.put("e-f-ad---------", null);
        iconColorMap.put("e-f-ag---------", null);
        iconColorMap.put("e-f-ba---------", null);
        iconColorMap.put("e-f-bb---------", null);
        iconColorMap.put("e-f-bc---------", null);
        iconColorMap.put("e-f-bd---------", null);
        iconColorMap.put("e-f-c----------", null);
        iconColorMap.put("e-f-ca---------", null);
        iconColorMap.put("e-f-cb---------", null);
        iconColorMap.put("e-f-cc---------", null);
        iconColorMap.put("e-f-cd---------", null);
        iconColorMap.put("e-f-ce---------", null);
        iconColorMap.put("e-f-cf---------", null);
        iconColorMap.put("e-f-cg---------", null);
        iconColorMap.put("e-f-ch---------", null);
        iconColorMap.put("e-f-ci---------", null);
        iconColorMap.put("e-f-cj---------", null);
        iconColorMap.put("e-f-ee---------", null);
        iconColorMap.put("e-f-f----------", null);
        iconColorMap.put("e-f-g----------", null);
        iconColorMap.put("e-f-h----------", null);
        iconColorMap.put("e-f-ha---------", null);
        iconColorMap.put("e-f-hb---------", null);
        iconColorMap.put("e-f-ia---------", null);
        iconColorMap.put("e-f-id---------", null);
        iconColorMap.put("e-f-jb---------", null);
        iconColorMap.put("e-f-ld---------", null);
        iconColorMap.put("e-f-le---------", null);
        iconColorMap.put("e-f-lf---------", null);
        iconColorMap.put("e-f-lm---------", null);
        iconColorMap.put("e-f-lo---------", null);
        iconColorMap.put("e-f-lp---------", null);
        iconColorMap.put("e-f-me---------", null);
        iconColorMap.put("e-f-mf---------", null);
        iconColorMap.put("e-f-mg---------", null);
        iconColorMap.put("e-f-mh---------", null);
        iconColorMap.put("e-f-mi---------", null);
        iconColorMap.put("e-i-b----------", null);
        iconColorMap.put("e-i-ca---------", null);
        iconColorMap.put("e-i-cc---------", null);
        iconColorMap.put("e-i-d----------", null);
        iconColorMap.put("e-i-da---------", new Color(255, 254, 111));
        iconColorMap.put("e-i-dc---------", null);
        iconColorMap.put("e-i-dd---------", null);
        iconColorMap.put("e-i-de---------", null);
        iconColorMap.put("e-i-df---------", null);
        iconColorMap.put("e-i-dg---------", null);
        iconColorMap.put("e-i-dh---------", null);
        iconColorMap.put("e-i-di---------", null);
        iconColorMap.put("e-i-dj---------", null);
        iconColorMap.put("e-i-dm---------", null);
        iconColorMap.put("e-i-e----------", null);
        iconColorMap.put("e-i-ea---------", null);
        iconColorMap.put("e-i-f----------", null);
        iconColorMap.put("e-i-fa---------", null);
        iconColorMap.put("e-o-ae---------", null);
        iconColorMap.put("e-o-af---------", null);
        iconColorMap.put("e-o-aj---------", null);
        iconColorMap.put("e-o-ak---------", null);
        iconColorMap.put("e-o-am---------", null);
        iconColorMap.put("e-o-b----------", null);
        iconColorMap.put("e-o-ba---------", null);
        iconColorMap.put("e-o-bb---------", null);
        iconColorMap.put("e-o-bc---------", null);
        iconColorMap.put("e-o-bd---------", null);
        iconColorMap.put("e-o-be---------", null);
        iconColorMap.put("e-o-bf---------", null);
        iconColorMap.put("e-o-bg---------", null);
        iconColorMap.put("e-o-bh---------", null);
        iconColorMap.put("e-o-bi---------", null);
        iconColorMap.put("e-o-bj---------", null);
        iconColorMap.put("e-o-cc---------", null);
        iconColorMap.put("e-o-cd---------", null);
        iconColorMap.put("e-o-de---------", null);
        iconColorMap.put("e-o-dea--------", null);
        iconColorMap.put("e-o-deb--------", null);
        iconColorMap.put("e-o-dec--------", null);
        iconColorMap.put("e-o-df---------", null);
        iconColorMap.put("e-o-dfa--------", null);
        iconColorMap.put("e-o-dfb--------", null);
        iconColorMap.put("e-o-dfc--------", null);
        iconColorMap.put("e-o-dk---------", null);
        iconColorMap.put("e-o-dn---------", null);
        iconColorMap.put("e-o-dna--------", null);
        iconColorMap.put("e-o-dnc--------", null);
        iconColorMap.put("e-o-do---------", null);
        iconColorMap.put("e-o-doa--------", null);
        iconColorMap.put("e-o-dob--------", null);
        iconColorMap.put("e-o-doc--------", null);
        iconColorMap.put("o-o-ha---------", null);
        iconColorMap.put("o-o-hv---------", null);
        iconColorMap.put("o-o-y----------", null);
        iconColorMap.put("o-o-yh---------", null);
        iconColorMap.put("o-o-yt---------", null);
        iconColorMap.put("o-o-yw---------", null);
        iconColorMap.put("s-a-cf---------", null);
        iconColorMap.put("s-a-ch---------", null);
        iconColorMap.put("s-a-cl---------", null);
        iconColorMap.put("s-a-w----------", FILL_COLOR_LIGHT_YELLOW);
        iconColorMap.put("s-a-wm---------", FILL_COLOR_LIGHT_YELLOW);
        iconColorMap.put("s-a-wma--------", FILL_COLOR_LIGHT_YELLOW);
        iconColorMap.put("s-a-wmaa-------", FILL_COLOR_LIGHT_YELLOW);
        iconColorMap.put("s-a-wmap-------", FILL_COLOR_LIGHT_YELLOW);
        iconColorMap.put("s-a-wmas-------", FILL_COLOR_LIGHT_YELLOW);
        iconColorMap.put("s-a-wmb--------", FILL_COLOR_LIGHT_YELLOW);
        iconColorMap.put("s-a-wmcm-------", FILL_COLOR_LIGHT_YELLOW);
        iconColorMap.put("s-a-wms--------", FILL_COLOR_LIGHT_YELLOW);
        iconColorMap.put("s-a-wmsa-------", FILL_COLOR_LIGHT_YELLOW);
        iconColorMap.put("s-a-wmsb-------", FILL_COLOR_LIGHT_YELLOW);
        iconColorMap.put("s-a-wmss-------", FILL_COLOR_LIGHT_YELLOW);
        iconColorMap.put("s-a-wmsu-------", FILL_COLOR_LIGHT_YELLOW);
        iconColorMap.put("s-a-wmu--------", FILL_COLOR_LIGHT_YELLOW);
        iconColorMap.put("s-f-gp---------", null);
        iconColorMap.put("s-f-gpa--------", null);
        iconColorMap.put("s-f-nb---------", null);
        iconColorMap.put("s-g-evca-------", null);
        iconColorMap.put("s-g-evcah------", null);
        iconColorMap.put("s-g-evcal------", null);
        iconColorMap.put("s-g-evcam------", null);
        iconColorMap.put("s-g-evcf-------", null);
        iconColorMap.put("s-g-evcfh------", null);
        iconColorMap.put("s-g-evcfl------", null);
        iconColorMap.put("s-g-evcfm------", null);
        iconColorMap.put("s-g-evcj-------", null);
        iconColorMap.put("s-g-evcjh------", null);
        iconColorMap.put("s-g-evcjl------", null);
        iconColorMap.put("s-g-evcjm------", null);
        iconColorMap.put("s-g-evcm-------", null);
        iconColorMap.put("s-g-evcmh------", null);
        iconColorMap.put("s-g-evcml------", null);
        iconColorMap.put("s-g-evcmm------", null);
        iconColorMap.put("s-g-evco-------", null);
        iconColorMap.put("s-g-evcoh------", null);
        iconColorMap.put("s-g-evcol------", null);
        iconColorMap.put("s-g-evcom------", null);
        iconColorMap.put("s-g-evct-------", null);
        iconColorMap.put("s-g-evcth------", null);
        iconColorMap.put("s-g-evctl------", null);
        iconColorMap.put("s-g-evctm------", null);
        iconColorMap.put("s-g-evcu-------", null);
        iconColorMap.put("s-g-evcuh------", null);
        iconColorMap.put("s-g-evcul------", null);
        iconColorMap.put("s-g-evcum------", null);
        iconColorMap.put("s-g-ucfs-------", null);
        iconColorMap.put("s-g-ucfsa------", null);
        iconColorMap.put("s-g-ucfsl------", null);
        iconColorMap.put("s-g-ucfso------", null);
        iconColorMap.put("s-g-ucfss------", null);
        iconColorMap.put("s-g-ucfts------", null);
        iconColorMap.put("s-g-uumrs------", null);
        iconColorMap.put("s-g-uumrss-----", null);
        iconColorMap.put("s-g-uusx-------", null);
        iconColorMap.put("s-p-t----------", null);
        iconColorMap.put("s-s-c----------", null);
        iconColorMap.put("s-s-nh---------", null);
        iconColorMap.put("s-s-xa---------", null);
        iconColorMap.put("s-s-xar--------", null);
        iconColorMap.put("s-s-xas--------", null);
        iconColorMap.put("s-s-xf---------", null);
        iconColorMap.put("s-s-xfdf-------", null);
        iconColorMap.put("s-s-xfdr-------", null);
        iconColorMap.put("s-s-xftr-------", null);
        iconColorMap.put("s-s-xh---------", null);
        iconColorMap.put("s-s-xl---------", null);
        iconColorMap.put("s-s-xm---------", null);
        iconColorMap.put("s-s-xmc--------", null);
        iconColorMap.put("s-s-xmf--------", null);
        iconColorMap.put("s-s-xmh--------", null);
        iconColorMap.put("s-s-xmo--------", null);
        iconColorMap.put("s-s-xmp--------", null);
        iconColorMap.put("s-s-xmr--------", null);
        iconColorMap.put("s-s-xmto-------", null);
        iconColorMap.put("s-s-xmtu-------", null);
        iconColorMap.put("s-s-xp---------", null);
        iconColorMap.put("s-s-xr---------", null);
        iconColorMap.put("s-u-e----------", ICON_COLOR_GREEN);
        iconColorMap.put("s-u-nd---------", null);
        iconColorMap.put("s-u-sca--------", null);
        iconColorMap.put("s-u-scb--------", null);
        iconColorMap.put("s-u-scg--------", null);
        iconColorMap.put("s-u-scm--------", null);
        iconColorMap.put("s-u-sna--------", null);
        iconColorMap.put("s-u-snb--------", null);
        iconColorMap.put("s-u-sng--------", null);
        iconColorMap.put("s-u-snm--------", null);
        iconColorMap.put("s-u-v----------", ICON_COLOR_GREEN);
        iconColorMap.put("s-u-wdm--------", ICON_COLOR_DARK_GREEN);
        iconColorMap.put("s-u-wdmg-------", ICON_COLOR_DARK_GREEN);
        iconColorMap.put("s-u-wdmm-------", ICON_COLOR_DARK_GREEN);
        iconColorMap.put("s-u-wm---------", ICON_COLOR_RED);
        iconColorMap.put("s-u-wma--------", ICON_COLOR_DARK_GREEN);
        iconColorMap.put("s-u-wmb--------", ICON_COLOR_YELLOW);
        iconColorMap.put("s-u-wmbd-------", ICON_COLOR_GREEN);
        iconColorMap.put("s-u-wmc--------", ICON_COLOR_ORANGE);
        iconColorMap.put("s-u-wmd--------", ICON_COLOR_GREEN);
        iconColorMap.put("s-u-wme--------", ICON_COLOR_YELLOW);
        iconColorMap.put("s-u-wmf--------", ICON_COLOR_RED);
        iconColorMap.put("s-u-wmfc-------", ICON_COLOR_ORANGE);
        iconColorMap.put("s-u-wmfd-------", ICON_COLOR_GREEN);
        iconColorMap.put("s-u-wmfe-------", ICON_COLOR_YELLOW);
        iconColorMap.put("s-u-wmfo-------", ICON_COLOR_DARK_GREEN);
        iconColorMap.put("s-u-wmfr-------", ICON_COLOR_YELLOW);
        iconColorMap.put("s-u-wmfx-------", ICON_COLOR_DARK_GREEN);
        iconColorMap.put("s-u-wmg--------", ICON_COLOR_RED);
        iconColorMap.put("s-u-wmgc-------", ICON_COLOR_ORANGE);
        iconColorMap.put("s-u-wmgd-------", ICON_COLOR_GREEN);
        iconColorMap.put("s-u-wmge-------", ICON_COLOR_YELLOW);
        iconColorMap.put("s-u-wmgo-------", ICON_COLOR_DARK_GREEN);
        iconColorMap.put("s-u-wmgr-------", ICON_COLOR_YELLOW);
        iconColorMap.put("s-u-wmgx-------", ICON_COLOR_DARK_GREEN);
        iconColorMap.put("s-u-wmm--------", ICON_COLOR_RED);
        iconColorMap.put("s-u-wmmc-------", ICON_COLOR_ORANGE);
        iconColorMap.put("s-u-wmmd-------", ICON_COLOR_GREEN);
        iconColorMap.put("s-u-wmme-------", ICON_COLOR_YELLOW);
        iconColorMap.put("s-u-wmmo-------", ICON_COLOR_DARK_GREEN);
        iconColorMap.put("s-u-wmmr-------", ICON_COLOR_YELLOW);
        iconColorMap.put("s-u-wmmx-------", ICON_COLOR_DARK_GREEN);
        iconColorMap.put("s-u-wmn--------", ICON_COLOR_DARK_GREEN);
        iconColorMap.put("s-u-wmo--------", ICON_COLOR_RED);
        iconColorMap.put("s-u-wmod-------", ICON_COLOR_GREEN);
        iconColorMap.put("s-u-wmr--------", ICON_COLOR_YELLOW);
        iconColorMap.put("s-u-wms--------", ICON_COLOR_RED);
        iconColorMap.put("s-u-wmsd-------", ICON_COLOR_GREEN);
        iconColorMap.put("s-u-wmsx-------", ICON_COLOR_DARK_GREEN);
        iconColorMap.put("s-u-wmx--------", ICON_COLOR_DARK_GREEN);
        iconColorMap.put("s-u-x----------", ICON_COLOR_RED);
        unfilledIconMap.add("s-u-wm---------");
        unfilledIconMap.add("s-u-wmd--------");
        unfilledIconMap.add("s-u-wmg--------");
        unfilledIconMap.add("s-u-wmgd-------");
        unfilledIconMap.add("s-u-wmgx-------");
        unfilledIconMap.add("s-u-wmge-------");
        unfilledIconMap.add("s-u-wmgc-------");
        unfilledIconMap.add("s-u-wmgr-------");
        unfilledIconMap.add("s-u-wmgo-------");
        unfilledIconMap.add("s-u-wmm--------");
        unfilledIconMap.add("s-u-wmmd-------");
        unfilledIconMap.add("s-u-wmmx-------");
        unfilledIconMap.add("s-u-wmme-------");
        unfilledIconMap.add("s-u-wmmc-------");
        unfilledIconMap.add("s-u-wmmr-------");
        unfilledIconMap.add("s-u-wmmo-------");
        unfilledIconMap.add("s-u-wmf--------");
        unfilledIconMap.add("s-u-wmfd-------");
        unfilledIconMap.add("s-u-wmfx-------");
        unfilledIconMap.add("s-u-wmfe-------");
        unfilledIconMap.add("s-u-wmfc-------");
        unfilledIconMap.add("s-u-wmfr-------");
        unfilledIconMap.add("s-u-wmfo-------");
        unfilledIconMap.add("s-u-wmo--------");
        unfilledIconMap.add("s-u-wmod-------");
        unfilledIconMap.add("s-u-wmx--------");
        unfilledIconMap.add("s-u-wme--------");
        unfilledIconMap.add("s-u-wma--------");
        unfilledIconMap.add("s-u-wmc--------");
        unfilledIconMap.add("s-u-wmr--------");
        unfilledIconMap.add("s-u-wmb--------");
        unfilledIconMap.add("s-u-wmbd-------");
        unfilledIconMap.add("s-u-wmn--------");
        unfilledIconMap.add("s-u-wms--------");
        unfilledIconMap.add("s-u-wmsx-------");
        unfilledIconMap.add("s-u-wmsd-------");
        unfilledIconMap.add("s-u-wdm--------");
        unfilledIconMap.add("s-u-wdmg-------");
        unfilledIconMap.add("s-u-wdmm-------");
        unfilledIconMap.add("s-u-e----------");
        unfilledIconMap.add("s-u-v----------");
        unfilledIconMap.add("s-u-x----------");
        unframedIconMap.add("s-s-o----------");
        unframedIconMap.add("s-u-nd---------");
        emsEquipment.add("e-o-ab---------");
        emsEquipment.add("e-o-ae---------");
        emsEquipment.add("e-o-af---------");
        emsEquipment.add("e-o-bb---------");
        emsEquipment.add("e-o-cb---------");
        emsEquipment.add("e-o-cc---------");
        emsEquipment.add("e-o-db---------");
        emsEquipment.add("e-o-ddb--------");
        emsEquipment.add("e-o-deb--------");
        emsEquipment.add("e-o-dfb--------");
        emsEquipment.add("e-o-dgb--------");
        emsEquipment.add("e-o-dhb--------");
        emsEquipment.add("e-o-dib--------");
        emsEquipment.add("e-o-djb--------");
        emsEquipment.add("e-o-dlb--------");
        emsEquipment.add("e-o-dmb--------");
        emsEquipment.add("e-o-dob--------");
        emsEquipment.add("e-o-pea--------");
        emsEquipment.add("e-o-peb--------");
        emsEquipment.add("e-o-pec--------");
        emsEquipment.add("e-o-ped--------");
        emsEquipment.add("e-o-pee--------");
        emsEquipment.add("e-f-ba---------");
        emsEquipment.add("e-f-ma---------");
        emsEquipment.add("e-f-mc---------");
    }
}

