/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology;

import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.symbology.TacticalSymbolAttributes;
import gov.nasa.worldwind.util.Logging;
import java.awt.Font;

public class BasicTacticalSymbolAttributes
implements TacticalSymbolAttributes {
    public static final double DEFAULT_SCALE = 1.0;
    public static final double DEFAULT_OPACITY = 1.0;
    public static final Font DEFAULT_TEXT_MODIFIER_FONT = Font.decode("Arial-PLAIN-18");
    public static final Material DEFAULT_TEXT_MODIFIER_MATERIAL = Material.BLACK;
    protected Double scale;
    protected Material interiorMaterial;
    protected Double opacity;
    protected Font textModifierFont;
    protected Material textModifierMaterial;

    public BasicTacticalSymbolAttributes() {
    }

    public BasicTacticalSymbolAttributes(Double d, Material material, Double d2, Font font, Material material2) {
        if (d != null && d < 0.0) {
            String string = Logging.getMessage("generic.ScaleOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 != null && (d2 < 0.0 || d2 > 1.0)) {
            String string = Logging.getMessage("generic.OpacityOutOfRange", d2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.scale = d;
        this.interiorMaterial = material;
        this.opacity = d2;
        this.textModifierFont = font;
        this.textModifierMaterial = material2;
    }

    @Override
    public void copy(TacticalSymbolAttributes tacticalSymbolAttributes) {
        if (tacticalSymbolAttributes != null) {
            this.scale = tacticalSymbolAttributes.getScale();
            this.interiorMaterial = tacticalSymbolAttributes.getInteriorMaterial();
            this.opacity = tacticalSymbolAttributes.getOpacity();
            this.textModifierFont = tacticalSymbolAttributes.getTextModifierFont();
            this.textModifierMaterial = tacticalSymbolAttributes.getTextModifierMaterial();
        }
    }

    @Override
    public Double getScale() {
        return this.scale;
    }

    @Override
    public void setScale(Double d) {
        if (d != null && d < 0.0) {
            String string = Logging.getMessage("generic.ScaleOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.scale = d;
    }

    @Override
    public Material getInteriorMaterial() {
        return this.interiorMaterial;
    }

    @Override
    public void setInteriorMaterial(Material material) {
        this.interiorMaterial = material;
    }

    @Override
    public Double getOpacity() {
        return this.opacity;
    }

    @Override
    public void setOpacity(Double d) {
        if (d != null && (d < 0.0 || d > 1.0)) {
            String string = Logging.getMessage("generic.OpacityOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.opacity = d;
    }

    @Override
    public Font getTextModifierFont() {
        return this.textModifierFont;
    }

    @Override
    public void setTextModifierFont(Font font) {
        this.textModifierFont = font;
    }

    @Override
    public Material getTextModifierMaterial() {
        return this.textModifierMaterial;
    }

    @Override
    public void setTextModifierMaterial(Material material) {
        this.textModifierMaterial = material;
    }
}

