/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.GlobeStateKey;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.airspaces.AbstractAirspace;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.DetailLevel;
import gov.nasa.worldwind.render.airspaces.Geometry;
import gov.nasa.worldwind.render.airspaces.ScreenSizeDetailLevel;
import gov.nasa.worldwind.util.GeometryBuilder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.RestorableSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL2;

public class Box
extends AbstractAirspace {
    public static final int FACE_TOP = 0;
    public static final int FACE_BOTTOM = 1;
    public static final int FACE_LEFT = 2;
    public static final int FACE_RIGHT = 3;
    public static final int FACE_FRONT = 4;
    public static final int FACE_BACK = 5;
    protected static final int A_LOW_LEFT = 0;
    protected static final int A_LOW_RIGHT = 1;
    protected static final int A_UPR_LEFT = 2;
    protected static final int A_UPR_RIGHT = 3;
    protected static final int B_LOW_LEFT = 4;
    protected static final int B_LOW_RIGHT = 5;
    protected static final int B_UPR_LEFT = 6;
    protected static final int B_UPR_RIGHT = 7;
    protected static final int LOW_FACE = 0;
    protected static final int UPR_FACE = 1;
    protected static final int SIDE_FACE = 2;
    protected static final int DEFAULT_PILLARS = 8;
    protected static final int DEFAULT_STACKS = 4;
    protected static final int DEFAULT_HEIGHT_STACKS = 1;
    protected static final int MINIMAL_GEOMETRY_PILLARS = 8;
    protected static final int MINIMAL_GEOMETRY_STACKS = 4;
    private LatLon location1 = LatLon.ZERO;
    private LatLon location2 = LatLon.ZERO;
    private double leftWidth = 1.0;
    private double rightWidth = 1.0;
    private boolean enableStartCap = true;
    private boolean enableEndCap = true;
    protected Map<Globe, BoxData> boxData = new HashMap<Globe, BoxData>(2);
    private boolean forceCullFace = false;
    private int pillars = 8;
    private int stacks = 4;
    private int heightStacks = 1;

    public Box(LatLon latLon, LatLon latLon2, double d, double d2) {
        if (latLon == null) {
            String string = "nullValue.Location1IsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLon2 == null) {
            String string = "nullValue.Location2IsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "leftWidth=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "rightWidth=" + d2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.location1 = latLon;
        this.location2 = latLon2;
        this.leftWidth = d;
        this.rightWidth = d2;
        this.makeDefaultDetailLevels();
    }

    public Box(AirspaceAttributes airspaceAttributes) {
        super(airspaceAttributes);
        this.makeDefaultDetailLevels();
    }

    public Box() {
        this.makeDefaultDetailLevels();
    }

    private void makeDefaultDetailLevels() {
        ArrayList<DetailLevel> arrayList = new ArrayList<DetailLevel>();
        double[] dArray = ScreenSizeDetailLevel.computeDefaultScreenSizeRamp(5);
        ScreenSizeDetailLevel screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[0], "Detail-Level-0");
        screenSizeDetailLevel.setValue("Pillars", 8);
        screenSizeDetailLevel.setValue("Stacks", 4);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[1], "Detail-Level-1");
        screenSizeDetailLevel.setValue("Pillars", 6);
        screenSizeDetailLevel.setValue("Stacks", 3);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[2], "Detail-Level-2");
        screenSizeDetailLevel.setValue("Pillars", 4);
        screenSizeDetailLevel.setValue("Stacks", 2);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[3], "Detail-Level-3");
        screenSizeDetailLevel.setValue("Pillars", 2);
        screenSizeDetailLevel.setValue("Stacks", 1);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[4], "Detail-Level-4");
        screenSizeDetailLevel.setValue("Pillars", 1);
        screenSizeDetailLevel.setValue("Stacks", 1);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", true);
        arrayList.add(screenSizeDetailLevel);
        this.setDetailLevels(arrayList);
    }

    public LatLon[] getLocations() {
        LatLon[] latLonArray = new LatLon[]{this.location1, this.location2};
        return latLonArray;
    }

    public void setLocations(LatLon latLon, LatLon latLon2) {
        if (latLon == null) {
            String string = "nullValue.Location1IsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLon2 == null) {
            String string = "nullValue.Location2IsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.location1 = latLon;
        this.location2 = latLon2;
        this.setExtentOutOfDate();
    }

    public double[] getWidths() {
        double[] dArray = new double[]{this.leftWidth, this.rightWidth};
        return dArray;
    }

    public void setWidths(double d, double d2) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "leftWidth=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "rightWidth=" + d2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.leftWidth = d;
        this.rightWidth = d2;
        this.setExtentOutOfDate();
    }

    public boolean[] isEnableCaps() {
        boolean[] blArray = new boolean[]{this.enableStartCap, this.enableEndCap};
        return blArray;
    }

    public void setEnableCaps(boolean bl, boolean bl2) {
        this.enableStartCap = bl;
        this.enableEndCap = bl2;
    }

    public void setEnableCaps(boolean bl) {
        this.setEnableCaps(bl, bl);
    }

    public void setEnableStartCap(boolean bl) {
        this.setEnableCaps(bl, this.enableEndCap);
    }

    public void setEnableEndCap(boolean bl) {
        this.setEnableCaps(this.enableStartCap, bl);
    }

    public Vec4[] getVertices() {
        return this.getVertices(null);
    }

    public void setVertices(Vec4[] vec4Array) {
        this.setVertices(null, vec4Array);
    }

    public boolean isVerticesValid(Globe globe) {
        BoxData boxData = this.boxData.get(globe);
        return boxData != null && boxData.globeStateKey != null && boxData.globeStateKey.equals(globe.getGlobeStateKey());
    }

    public Vec4[] getVertices(Globe globe) {
        BoxData boxData = this.boxData.get(globe);
        return boxData != null ? boxData.vertices : null;
    }

    public void setVertices(Globe globe, Vec4[] vec4Array) {
        if (vec4Array == null) {
            this.boxData.remove(globe);
        } else {
            if (vec4Array.length < 8) {
                String string = Logging.getMessage("generic.ArrayInvalidLength", "vertices.length=" + vec4Array.length);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            BoxData boxData = this.boxData.get(globe);
            if (boxData == null) {
                boxData = new BoxData();
                this.boxData.put(globe, boxData);
            }
            System.arraycopy(vec4Array, 0, boxData.vertices, 0, 8);
            boxData.globeStateKey = globe.getGlobeStateKey();
        }
        this.setExtentOutOfDate();
    }

    public void clearVertices() {
        this.boxData.clear();
    }

    public static Vec4[] computeStandardVertices(Globe globe, double d, Box box) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (box == null) {
            String string = Logging.getMessage("nullValue.BoxIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = box.getAltitudes(d);
        Vec4 vec4 = globe.computePointFromPosition(box.location1, dArray[0]);
        Vec4 vec42 = globe.computePointFromPosition(box.location1, dArray[1]);
        Vec4 vec43 = globe.computePointFromPosition(box.location2, dArray[0]);
        Vec4 vec44 = globe.computePointFromPosition(box.location2, dArray[1]);
        Vec4 vec45 = globe.computeSurfaceNormalAtPoint(vec4);
        Vec4 vec46 = globe.computeSurfaceNormalAtPoint(vec43);
        Vec4 vec47 = vec43.subtract3(vec4).normalize3();
        Vec4 vec48 = vec47.cross3(vec45).normalize3();
        Vec4 vec49 = vec47.cross3(vec46).normalize3();
        Vec4[] vec4Array = new Vec4[]{new Line(vec4, vec48).getPointAt(-box.leftWidth), new Line(vec4, vec48).getPointAt(box.rightWidth), new Line(vec42, vec48).getPointAt(-box.leftWidth), new Line(vec42, vec48).getPointAt(box.rightWidth), new Line(vec43, vec49).getPointAt(-box.leftWidth), new Line(vec43, vec49).getPointAt(box.rightWidth), new Line(vec44, vec49).getPointAt(-box.leftWidth), new Line(vec44, vec49).getPointAt(box.rightWidth)};
        return vec4Array;
    }

    public static Plane[] computeStandardPlanes(Globe globe, double d, Box box) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (box == null) {
            String string = Logging.getMessage("nullValue.BoxIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4[] vec4Array = Box.computeStandardVertices(globe, d, box);
        if (vec4Array == null || vec4Array.length != 8) {
            return null;
        }
        Plane[] planeArray = new Plane[]{Plane.fromPoints(vec4Array[3], vec4Array[7], vec4Array[2]), Plane.fromPoints(vec4Array[1], vec4Array[0], vec4Array[5]), Plane.fromPoints(vec4Array[0], vec4Array[2], vec4Array[4]), Plane.fromPoints(vec4Array[1], vec4Array[5], vec4Array[3]), Plane.fromPoints(vec4Array[1], vec4Array[3], vec4Array[0]), Plane.fromPoints(vec4Array[4], vec4Array[6], vec4Array[5])};
        return planeArray;
    }

    @Override
    public Position getReferencePosition() {
        double[] dArray = this.getAltitudes();
        return new Position(this.location1, dArray[0]);
    }

    @Override
    protected gov.nasa.worldwind.geom.Box computeExtent(Globe globe, double d) {
        List<Vec4> list = this.computeMinimalGeometry(globe, d);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return gov.nasa.worldwind.geom.Box.computeBoundingBox(list);
    }

    @Override
    protected List<Vec4> computeMinimalGeometry(Globe globe, double d) {
        Vec4[] vec4Array = this.getVertices(globe);
        if (vec4Array == null) {
            vec4Array = Box.computeStandardVertices(globe, d, this);
        }
        float[] fArray = new float[12];
        this.makeControlPoints(vec4Array, 3, 7, 6, 2, Vec4.ZERO, fArray);
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        int n = geometryBuilder.getBilinearSurfaceVertexCount(8, 4);
        int n2 = 3 * n;
        float[] fArray2 = new float[n2];
        geometryBuilder.makeBilinearSurfaceVertices(fArray, 0, 8, 4, fArray2);
        LatLon[] latLonArray = new LatLon[n];
        for (int i = 0; i < n; ++i) {
            Vec4 vec4 = Vec4.fromFloatArray(fArray2, 3 * i, 3);
            latLonArray[i] = globe.computePositionFromPoint(vec4);
        }
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>();
        this.makeExtremePoints(globe, d, Arrays.asList(latLonArray), arrayList);
        return arrayList;
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        super.doMoveTo(position, position2);
        LatLon[] latLonArray = this.getLocations();
        int n = latLonArray.length;
        for (int i = 0; i < n; ++i) {
            double d = LatLon.greatCircleDistance((LatLon)position, (LatLon)latLonArray[i]).radians;
            double d2 = LatLon.greatCircleAzimuth((LatLon)position, (LatLon)latLonArray[i]).radians;
            latLonArray[i] = LatLon.greatCircleEndPosition((LatLon)position2, d2, d);
        }
        this.setLocations(latLonArray[0], latLonArray[1]);
    }

    protected boolean isForceCullFace() {
        return this.forceCullFace;
    }

    protected void setForceCullFace(boolean bl) {
        this.forceCullFace = bl;
    }

    protected int getPillars() {
        return this.pillars;
    }

    protected void setPillars(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "pillars=" + n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pillars = n;
    }

    protected int getStacks() {
        return this.stacks;
    }

    protected void setStacks(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "stacks=" + n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.stacks = n;
    }

    protected int getHeightStacks() {
        return this.heightStacks;
    }

    protected Vec4 computeReferenceCenter(DrawContext drawContext) {
        Extent extent = this.getExtent(drawContext);
        return extent != null ? extent.getCenter() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRenderGeometry(DrawContext drawContext, String string) {
        Object object;
        Object object2;
        if (drawContext == null) {
            String string2 = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (drawContext.getGL() == null) {
            String string3 = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        Vec4[] vec4Array = this.getVertices(drawContext.getGlobe());
        if (vec4Array == null) {
            vec4Array = Box.computeStandardVertices(drawContext.getGlobe(), drawContext.getVerticalExaggeration(), this);
        }
        double[] dArray = this.getAltitudes(drawContext.getVerticalExaggeration());
        boolean[] blArray = this.isTerrainConforming();
        boolean[] blArray2 = this.isEnableCaps();
        int n = this.pillars;
        int n2 = this.stacks;
        int n3 = this.heightStacks;
        if (this.isEnableLevelOfDetail()) {
            object2 = this.computeDetailLevel(drawContext);
            object = object2.getValue("Pillars");
            if (object != null && object instanceof Integer) {
                n = (Integer)object;
            }
            if ((object = object2.getValue("Stacks")) != null && object instanceof Integer) {
                n2 = (Integer)object;
            }
            if ((object = object2.getValue("DisableTerrainConformance")) != null && object instanceof Boolean && ((Boolean)object).booleanValue()) {
                blArray[1] = false;
                blArray[0] = false;
            }
        }
        object2 = this.computeReferenceCenter(drawContext);
        this.setExpiryTime(this.nextExpiryTime(drawContext, blArray));
        this.clearElevationMap();
        object = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        try {
            drawContext.getView().pushReferenceCenter(drawContext, (Vec4)object2);
            if (this.forceCullFace || !blArray2[0] || !blArray2[1]) {
                oGLStackHandler.pushAttrib((GL2)object, 8);
                object.glEnable(2884);
                object.glFrontFace(2305);
            }
            if ("Airspace.DrawStyleFill".equals(string)) {
                this.drawBoxFill(drawContext, vec4Array, dArray, blArray, blArray2, n, n2, n3, (Vec4)object2);
            } else if ("Airspace.DrawStyleOutline".equals(string)) {
                this.drawBoxOutline(drawContext, vec4Array, dArray, blArray, blArray2, n, n2, n3, (Vec4)object2);
            }
        }
        finally {
            drawContext.getView().popReferenceCenter(drawContext);
            oGLStackHandler.pop((GL2)object);
        }
    }

    private void drawBoxFill(DrawContext drawContext, Vec4[] vec4Array, double[] dArray, boolean[] blArray, boolean[] blArray2, int n, int n2, int n3, Vec4 vec4) {
        Geometry geometry = this.getBoxIndexFillGeometry(blArray2, n, n2, n3);
        Geometry geometry2 = this.getBoxVertexGeometry(drawContext, vec4Array, dArray, blArray, blArray2, n, n2, n3, vec4);
        this.getRenderer().drawGeometry(drawContext, geometry, geometry2);
    }

    private void drawBoxOutline(DrawContext drawContext, Vec4[] vec4Array, double[] dArray, boolean[] blArray, boolean[] blArray2, int n, int n2, int n3, Vec4 vec4) {
        Geometry geometry = this.getBoxIndexOutlineGeometry(blArray2, n, n2, n3);
        Geometry geometry2 = this.getBoxVertexGeometry(drawContext, vec4Array, dArray, blArray, blArray2, n, n2, n3, vec4);
        this.getRenderer().drawGeometry(drawContext, geometry, geometry2);
    }

    private Geometry getBoxIndexFillGeometry(boolean[] blArray, int n, int n2, int n3) {
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(this.getClass(), "Box.FillIndices", blArray[0], blArray[1], n, n2, n3);
        Geometry geometry = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry == null) {
            geometry = new Geometry();
            this.makeBoxFillIndices(blArray, n, n2, n3, geometry);
            this.getGeometryCache().add(cacheKey, geometry);
        }
        return geometry;
    }

    private Geometry getBoxIndexOutlineGeometry(boolean[] blArray, int n, int n2, int n3) {
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(this.getClass(), "Box.OutlineIndices", blArray[0], blArray[1], n, n2, n3);
        Geometry geometry = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry == null) {
            geometry = new Geometry();
            this.makeBoxOutlineIndices(blArray, n, n2, n3, geometry);
            this.getGeometryCache().add(cacheKey, geometry);
        }
        return geometry;
    }

    private Geometry getBoxVertexGeometry(DrawContext drawContext, Vec4[] vec4Array, double[] dArray, boolean[] blArray, boolean[] blArray2, int n, int n2, int n3, Vec4 vec4) {
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(drawContext.getGlobe(), this.getClass(), "Box.Vertices", vec4Array, dArray[0], dArray[1], blArray[0], blArray[1], blArray2[0], blArray2[1], n, n2, n3, vec4);
        Geometry geometry = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry == null || this.isExpired(drawContext, geometry)) {
            if (geometry == null) {
                geometry = new Geometry();
            }
            this.makeBoxVertices(drawContext, vec4Array, dArray, blArray, blArray2, n, n2, n3, vec4, geometry);
            this.updateExpiryCriteria(drawContext, geometry);
            this.getGeometryCache().add(cacheKey, geometry);
        }
        return geometry;
    }

    private void makeFaceInfo(boolean[] blArray, int n, int n2, int n3, FaceRenderInfo[] faceRenderInfoArray) {
        faceRenderInfoArray[0] = new FaceRenderInfo(1, 3, 7, 6, 2, n, n2, 0);
        faceRenderInfoArray[1] = new FaceRenderInfo(0, 0, 4, 5, 1, n, n2, 0);
        faceRenderInfoArray[2] = new FaceRenderInfo(2, 4, 0, 2, 6, n, n3, 0);
        faceRenderInfoArray[3] = new FaceRenderInfo(2, 1, 5, 7, 3, n, n3, 0);
        if (blArray[0]) {
            faceRenderInfoArray[4] = new FaceRenderInfo(2, 0, 1, 3, 2, n2, n3, 0);
        }
        if (blArray[1]) {
            faceRenderInfoArray[5] = new FaceRenderInfo(2, 5, 4, 6, 7, n2, n3, 0);
        }
    }

    private void makeBoxFillIndices(boolean[] blArray, int n, int n2, int n3, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        FaceRenderInfo[] faceRenderInfoArray = new FaceRenderInfo[6];
        this.makeFaceInfo(blArray, n, n2, n3, faceRenderInfoArray);
        int n4 = geometryBuilder.getBilinearSurfaceFillDrawMode();
        int n5 = 0;
        int n6 = 0;
        FaceRenderInfo faceRenderInfo = null;
        for (int i = 0; i < 6; ++i) {
            if (faceRenderInfoArray[i] == null) continue;
            if (faceRenderInfo != null) {
                n5 += 2;
            }
            faceRenderInfoArray[i].firstIndex = n5;
            faceRenderInfoArray[i].firstVertex = n6;
            faceRenderInfoArray[i].indexCount = geometryBuilder.getBilinearSurfaceFillIndexCount(faceRenderInfoArray[i].uStacks, faceRenderInfoArray[i].vStacks);
            faceRenderInfoArray[i].vertexCount = geometryBuilder.getBilinearSurfaceVertexCount(faceRenderInfoArray[i].uStacks, faceRenderInfoArray[i].vStacks);
            n5 += faceRenderInfoArray[i].indexCount;
            n6 += faceRenderInfoArray[i].vertexCount;
            faceRenderInfo = faceRenderInfoArray[i];
        }
        int[] nArray = new int[n5];
        faceRenderInfo = null;
        for (int i = 0; i < 6; ++i) {
            if (faceRenderInfoArray[i] == null) continue;
            geometryBuilder.makeBilinearSurfaceFillIndices(faceRenderInfoArray[i].firstVertex, faceRenderInfoArray[i].uStacks, faceRenderInfoArray[i].vStacks, faceRenderInfoArray[i].firstIndex, nArray);
            if (faceRenderInfo != null) {
                int n7 = faceRenderInfo.firstIndex + faceRenderInfo.indexCount;
                int n8 = faceRenderInfo.firstIndex + faceRenderInfo.indexCount - 1;
                int n9 = faceRenderInfoArray[i].firstIndex;
                nArray[n7++] = nArray[n8];
                nArray[n7] = nArray[n9];
            }
            faceRenderInfo = faceRenderInfoArray[i];
        }
        geometry.setElementData(n4, n5, nArray);
    }

    private void makeBoxOutlineIndices(boolean[] blArray, int n, int n2, int n3, Geometry geometry) {
        int n4;
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        FaceRenderInfo[] faceRenderInfoArray = new FaceRenderInfo[6];
        this.makeFaceInfo(blArray, n, n2, n3, faceRenderInfoArray);
        int n5 = geometryBuilder.getBilinearSurfaceOutlineDrawMode();
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < 6; ++i) {
            if (faceRenderInfoArray[i] == null) continue;
            n4 = this.getOutlineMask(i, blArray);
            faceRenderInfoArray[i].firstIndex = n6;
            faceRenderInfoArray[i].firstVertex = n7;
            faceRenderInfoArray[i].indexCount = geometryBuilder.getBilinearSurfaceOutlineIndexCount(faceRenderInfoArray[i].uStacks, faceRenderInfoArray[i].vStacks, n4);
            faceRenderInfoArray[i].vertexCount = geometryBuilder.getBilinearSurfaceVertexCount(faceRenderInfoArray[i].uStacks, faceRenderInfoArray[i].vStacks);
            n6 += faceRenderInfoArray[i].indexCount;
            n7 += faceRenderInfoArray[i].vertexCount;
        }
        int[] nArray = new int[n6];
        for (n4 = 0; n4 < 6; ++n4) {
            if (faceRenderInfoArray[n4] == null) continue;
            int n8 = this.getOutlineMask(n4, blArray);
            geometryBuilder.makeBilinearSurfaceOutlineIndices(faceRenderInfoArray[n4].firstVertex, faceRenderInfoArray[n4].uStacks, faceRenderInfoArray[n4].vStacks, n8, faceRenderInfoArray[n4].firstIndex, nArray);
        }
        geometry.setElementData(n5, n6, nArray);
    }

    private int getOutlineMask(int n, boolean[] blArray) {
        if (n == 2 || n == 3) {
            return 15;
        }
        if ((n == 4 || n == 5) && (n == 4 && blArray[0] || n == 5 && blArray[1])) {
            return 3;
        }
        return 0;
    }

    private void makeBoxVertices(DrawContext drawContext, Vec4[] vec4Array, double[] dArray, boolean[] blArray, boolean[] blArray2, int n, int n2, int n3, Vec4 vec4, Geometry geometry) {
        int n4;
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        FaceRenderInfo[] faceRenderInfoArray = new FaceRenderInfo[6];
        this.makeFaceInfo(blArray2, n, n2, n3, faceRenderInfoArray);
        int n5 = 0;
        for (n4 = 0; n4 < 6; ++n4) {
            if (faceRenderInfoArray[n4] == null) continue;
            faceRenderInfoArray[n4].firstVertex = n5;
            faceRenderInfoArray[n4].vertexCount = geometryBuilder.getBilinearSurfaceVertexCount(faceRenderInfoArray[n4].uStacks, faceRenderInfoArray[n4].vStacks);
            n5 += faceRenderInfoArray[n4].vertexCount;
        }
        n4 = 3 * n5;
        float[] fArray = new float[n4];
        float[] fArray2 = new float[n4];
        float[] fArray3 = new float[12];
        for (int i = 0; i < 6; ++i) {
            if (faceRenderInfoArray[i] == null) continue;
            this.makeControlPoints(vec4Array, faceRenderInfoArray[i].ll, faceRenderInfoArray[i].lr, faceRenderInfoArray[i].ur, faceRenderInfoArray[i].ul, vec4, fArray3);
            geometryBuilder.setOrientation(faceRenderInfoArray[i].orientation);
            geometryBuilder.makeBilinearSurfaceVertices(fArray3, faceRenderInfoArray[i].firstVertex, faceRenderInfoArray[i].uStacks, faceRenderInfoArray[i].vStacks, fArray);
            if (faceRenderInfoArray[i].faceType == 0 || faceRenderInfoArray[i].faceType == 1) {
                this.makeTerrainConformant(drawContext, faceRenderInfoArray[i].faceType, dArray, blArray, faceRenderInfoArray[i].firstVertex, faceRenderInfoArray[i].vertexCount, fArray, vec4);
            } else if (faceRenderInfoArray[i].faceType == 2) {
                this.makeSideFaceTerrainConformant(drawContext, dArray, blArray, faceRenderInfoArray[i].firstVertex, faceRenderInfoArray[i].uStacks, faceRenderInfoArray[i].vStacks, fArray, vec4);
            }
            geometryBuilder.makeBilinearSurfaceVertexNormals(faceRenderInfoArray[i].firstVertex, faceRenderInfoArray[i].uStacks, faceRenderInfoArray[i].vStacks, fArray, faceRenderInfoArray[i].firstVertex, fArray2);
        }
        geometry.setVertexData(n5, fArray);
        geometry.setNormalData(n5, fArray2);
    }

    private void makeControlPoints(Vec4[] vec4Array, int n, int n2, int n3, int n4, Vec4 vec4, float[] fArray) {
        fArray[0] = (float)(vec4Array[n].x - vec4.x);
        fArray[1] = (float)(vec4Array[n].y - vec4.y);
        fArray[2] = (float)(vec4Array[n].z - vec4.z);
        fArray[3] = (float)(vec4Array[n2].x - vec4.x);
        fArray[4] = (float)(vec4Array[n2].y - vec4.y);
        fArray[5] = (float)(vec4Array[n2].z - vec4.z);
        fArray[6] = (float)(vec4Array[n3].x - vec4.x);
        fArray[7] = (float)(vec4Array[n3].y - vec4.y);
        fArray[8] = (float)(vec4Array[n3].z - vec4.z);
        fArray[9] = (float)(vec4Array[n4].x - vec4.x);
        fArray[10] = (float)(vec4Array[n4].y - vec4.y);
        fArray[11] = (float)(vec4Array[n4].z - vec4.z);
    }

    private void makeTerrainConformant(DrawContext drawContext, int n, double[] dArray, boolean[] blArray, int n2, int n3, float[] fArray, Vec4 vec4) {
        Globe globe = drawContext.getGlobe();
        double d = n == 0 ? dArray[0] : dArray[1];
        boolean bl = n == 0 && blArray[0] || n == 1 && blArray[1];
        for (int i = 0; i < n3; ++i) {
            int n4 = 3 * (n2 + i);
            Vec4 vec42 = new Vec4((double)fArray[n4] + vec4.x, (double)fArray[n4 + 1] + vec4.y, (double)fArray[n4 + 2] + vec4.z);
            Position position = globe.computePositionFromPoint(vec42);
            double d2 = d;
            if (bl) {
                d2 += this.computeElevationAt(drawContext, position.getLatitude(), position.getLongitude());
            }
            vec42 = globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), d2);
            fArray[n4] = (float)(vec42.x - vec4.x);
            fArray[n4 + 1] = (float)(vec42.y - vec4.y);
            fArray[n4 + 2] = (float)(vec42.z - vec4.z);
        }
    }

    private void makeSideFaceTerrainConformant(DrawContext drawContext, double[] dArray, boolean[] blArray, int n, int n2, int n3, float[] fArray, Vec4 vec4) {
        Globe globe = drawContext.getGlobe();
        double d = dArray[0];
        double d2 = (dArray[1] - dArray[0]) / (double)n3;
        int n4 = 0;
        while (n4 <= n3) {
            for (int i = 0; i <= n2; ++i) {
                int n5 = i + n4 * (n2 + 1);
                n5 = 3 * (n + n5);
                Vec4 vec42 = new Vec4((double)fArray[n5] + vec4.x, (double)fArray[n5 + 1] + vec4.y, (double)fArray[n5 + 2] + vec4.z);
                Position position = globe.computePositionFromPoint(vec42);
                double d3 = d;
                if (n4 == 0 && blArray[0] || n4 == n3 && blArray[1]) {
                    d3 += this.computeElevationAt(drawContext, position.getLatitude(), position.getLongitude());
                }
                vec42 = globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), d3);
                fArray[n5] = (float)(vec42.x - vec4.x);
                fArray[n5 + 1] = (float)(vec42.y - vec4.y);
                fArray[n5 + 2] = (float)(vec42.z - vec4.z);
            }
            ++n4;
            d += d2;
        }
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsLatLon(stateObject, "location1", this.location1);
        restorableSupport.addStateValueAsLatLon(stateObject, "location2", this.location2);
        restorableSupport.addStateValueAsDouble(stateObject, "leftWidth", this.leftWidth);
        restorableSupport.addStateValueAsDouble(stateObject, "rightWidth", this.rightWidth);
        restorableSupport.addStateValueAsBoolean(stateObject, "enableStartCap", this.enableStartCap);
        restorableSupport.addStateValueAsBoolean(stateObject, "enableEndCap", this.enableEndCap);
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Boolean bl;
        Double d;
        LatLon latLon;
        super.doRestoreState(restorableSupport, stateObject);
        LatLon latLon2 = restorableSupport.getStateValueAsLatLon(stateObject, "location1");
        if (latLon2 == null) {
            latLon2 = this.getLocations()[0];
        }
        if ((latLon = restorableSupport.getStateValueAsLatLon(stateObject, "location2")) == null) {
            latLon = this.getLocations()[1];
        }
        this.setLocations(latLon2, latLon);
        Double d2 = restorableSupport.getStateValueAsDouble(stateObject, "leftWidth");
        if (d2 == null) {
            d2 = this.getWidths()[0];
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "rightWidth")) == null) {
            d = this.getWidths()[1];
        }
        this.setWidths(d2, d);
        Boolean bl2 = restorableSupport.getStateValueAsBoolean(stateObject, "enableStartCap");
        if (bl2 == null) {
            bl2 = this.isEnableCaps()[0];
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "enableEndCap")) == null) {
            bl = this.isEnableCaps()[1];
        }
        this.setEnableCaps(bl2, bl);
    }

    private static class FaceRenderInfo {
        int faceType;
        int ll;
        int lr;
        int ul;
        int ur;
        int uStacks;
        int vStacks;
        int orientation;
        int firstVertex;
        int vertexCount;
        int firstIndex;
        int indexCount;

        private FaceRenderInfo(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            this.faceType = n;
            this.ll = n2;
            this.lr = n3;
            this.ur = n4;
            this.ul = n5;
            this.uStacks = n6;
            this.vStacks = n7;
            this.orientation = n8;
        }
    }

    protected static class BoxData {
        public GlobeStateKey globeStateKey;
        public Vec4[] vertices = new Vec4[8];
    }
}

