/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Exportable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.ogc.kml.impl.KMLExportUtil;
import gov.nasa.worldwind.render.AbstractSurfaceShape;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import gov.nasa.worldwind.util.WWMath;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SurfacePolygon
extends AbstractSurfaceShape
implements Exportable {
    protected List<Iterable<? extends LatLon>> boundaries = new ArrayList<Iterable<? extends LatLon>>();

    public SurfacePolygon() {
    }

    public SurfacePolygon(ShapeAttributes shapeAttributes) {
        super(shapeAttributes);
    }

    public SurfacePolygon(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setOuterBoundary(iterable);
    }

    public SurfacePolygon(ShapeAttributes shapeAttributes, Iterable<? extends LatLon> iterable) {
        super(shapeAttributes);
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setOuterBoundary(iterable);
    }

    @Override
    public Iterable<? extends LatLon> getLocations(Globe globe) {
        return this.getOuterBoundary();
    }

    public Iterable<? extends LatLon> getLocations() {
        return this.getOuterBoundary();
    }

    public List<Iterable<? extends LatLon>> getBoundaries() {
        return this.boundaries;
    }

    public void setLocations(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setOuterBoundary(iterable);
    }

    public Iterable<? extends LatLon> getOuterBoundary() {
        return this.boundaries.size() > 0 ? this.boundaries.get(0) : null;
    }

    public void setOuterBoundary(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.boundaries.size() > 0) {
            this.boundaries.set(0, iterable);
        } else {
            this.boundaries.add(iterable);
        }
        this.onShapeChanged();
    }

    public void addInnerBoundary(Iterable<? extends LatLon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.boundaries.add(iterable);
        this.onShapeChanged();
    }

    @Override
    public Position getReferencePosition() {
        if (this.getOuterBoundary() == null) {
            return null;
        }
        Iterator<? extends LatLon> iterator = this.getOuterBoundary().iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return new Position(iterator.next(), 0.0);
    }

    @Override
    protected List<List<LatLon>> createGeometry(Globe globe, SurfaceTileDrawContext surfaceTileDrawContext) {
        if (this.boundaries.isEmpty()) {
            return null;
        }
        ArrayList<List<LatLon>> arrayList = new ArrayList<List<LatLon>>();
        double d = this.computeEdgeIntervalsPerDegree(surfaceTileDrawContext);
        for (Iterable<? extends LatLon> iterable : this.boundaries) {
            ArrayList<LatLon> arrayList2 = new ArrayList<LatLon>();
            this.generateIntermediateLocations(iterable, d, true, arrayList2);
            if (WWMath.computeWindingOrderOfLocations(arrayList2) != "gov.nasa.worldwind.avkey.CounterClockWise") {
                Collections.reverse(arrayList2);
            }
            arrayList.add(arrayList2);
        }
        if (arrayList.isEmpty() || ((List)arrayList.get(0)).size() < 3) {
            return null;
        }
        return arrayList;
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        if (this.boundaries.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.boundaries.size(); ++i) {
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
            for (LatLon latLon : this.boundaries.get(i)) {
                Angle angle = LatLon.greatCircleAzimuth(position, latLon);
                Angle angle2 = LatLon.greatCircleDistance(position, latLon);
                arrayList.add(LatLon.greatCircleEndPosition((LatLon)position2, angle, angle2));
            }
            this.boundaries.set(i, arrayList);
        }
        this.onShapeChanged();
    }

    @Override
    protected void handleUnsuccessfulInteriorTessellation(DrawContext drawContext) {
        super.handleUnsuccessfulInteriorTessellation(drawContext);
        this.boundaries.clear();
        this.onShapeChanged();
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        if (!this.boundaries.isEmpty()) {
            RestorableSupport.StateObject stateObject2 = restorableSupport.addStateObject(stateObject, "boundaries");
            for (Iterable<? extends LatLon> iterable : this.boundaries) {
                restorableSupport.addStateValueAsLatLonList(stateObject2, "boundary", iterable);
            }
        }
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doRestoreState(restorableSupport, stateObject);
        RestorableSupport.StateObject stateObject2 = restorableSupport.getStateObject(stateObject, "boundaries");
        if (stateObject2 != null) {
            this.boundaries.clear();
            RestorableSupport.StateObject[] stateObjectArray = restorableSupport.getAllStateObjects(stateObject2, "boundary");
            if (stateObjectArray != null) {
                for (RestorableSupport.StateObject stateObject3 : stateObjectArray) {
                    List<LatLon> list;
                    if (stateObject3 == null || (list = restorableSupport.getStateObjectAsLatLonList(stateObject3)) == null) continue;
                    this.boundaries.add(list);
                }
            }
            this.onShapeChanged();
        }
    }

    @Override
    protected void legacyRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.legacyRestoreState(restorableSupport, stateObject);
        List<LatLon> list = restorableSupport.getStateValueAsLatLonList(stateObject, "locationList");
        if (list == null) {
            list = restorableSupport.getStateValueAsLatLonList(stateObject, "locations");
        }
        if (list != null) {
            this.setOuterBoundary(list);
        }
    }

    @Override
    protected void exportAsKML(Object object) throws IOException, XMLStreamException {
        Iterator<Iterable<? extends LatLon>> iterator;
        String string;
        XMLStreamWriter xMLStreamWriter = null;
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        boolean bl = true;
        if (object instanceof XMLStreamWriter) {
            xMLStreamWriter = (XMLStreamWriter)object;
            bl = false;
        } else if (object instanceof Writer) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((Writer)object);
        } else if (object instanceof OutputStream) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((OutputStream)object);
        }
        if (xMLStreamWriter == null) {
            String string2 = Logging.getMessage("Export.UnsupportedOutputObject");
            Logging.logger().warning(string2);
            throw new IllegalArgumentException(string2);
        }
        xMLStreamWriter.writeStartElement("Placemark");
        String string3 = (String)this.getValue("gov.nasa.worldwind.avkey.DisplayName");
        if (string3 != null) {
            xMLStreamWriter.writeStartElement("name");
            xMLStreamWriter.writeCharacters(string3);
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeStartElement("visibility");
        xMLStreamWriter.writeCharacters(KMLExportUtil.kmlBoolean(this.isVisible()));
        xMLStreamWriter.writeEndElement();
        String string4 = (String)this.getValue("gov.nasa.worldwind.avkey.Server.ShortDescription");
        if (string4 != null) {
            xMLStreamWriter.writeStartElement("Snippet");
            xMLStreamWriter.writeCharacters(string4);
            xMLStreamWriter.writeEndElement();
        }
        if ((string = (String)this.getValue("gov.nasa.worldwind.avkey.BalloonText")) != null) {
            xMLStreamWriter.writeStartElement("description");
            xMLStreamWriter.writeCharacters(string);
            xMLStreamWriter.writeEndElement();
        }
        ShapeAttributes shapeAttributes = this.getAttributes();
        ShapeAttributes shapeAttributes2 = this.getHighlightAttributes();
        if (shapeAttributes != null || shapeAttributes2 != null) {
            xMLStreamWriter.writeStartElement("StyleMap");
            KMLExportUtil.exportAttributesAsKML(xMLStreamWriter, "normal", shapeAttributes);
            KMLExportUtil.exportAttributesAsKML(xMLStreamWriter, "highlight", shapeAttributes2);
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeStartElement("Polygon");
        xMLStreamWriter.writeStartElement("extrude");
        xMLStreamWriter.writeCharacters("0");
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("altitudeMode");
        xMLStreamWriter.writeCharacters("clampToGround");
        xMLStreamWriter.writeEndElement();
        Iterable<? extends LatLon> iterable = this.getOuterBoundary();
        if (iterable != null) {
            xMLStreamWriter.writeStartElement("outerBoundaryIs");
            KMLExportUtil.exportBoundaryAsLinearRing(xMLStreamWriter, iterable, null);
            xMLStreamWriter.writeEndElement();
        }
        if ((iterator = this.boundaries.iterator()).hasNext()) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            Iterable<? extends LatLon> iterable2 = iterator.next();
            xMLStreamWriter.writeStartElement("innerBoundaryIs");
            KMLExportUtil.exportBoundaryAsLinearRing(xMLStreamWriter, iterable2, null);
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.flush();
        if (bl) {
            xMLStreamWriter.close();
        }
    }
}

