/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceEllipse;
import gov.nasa.worldwind.util.Logging;

public class SurfaceCircle
extends SurfaceEllipse {
    public SurfaceCircle() {
    }

    public SurfaceCircle(ShapeAttributes shapeAttributes) {
        super(shapeAttributes);
    }

    public SurfaceCircle(LatLon latLon, double d) {
        super(latLon, d, d);
    }

    public SurfaceCircle(LatLon latLon, double d, int n) {
        super(latLon, d, d, Angle.ZERO, n);
    }

    public SurfaceCircle(ShapeAttributes shapeAttributes, LatLon latLon, double d) {
        super(shapeAttributes, latLon, d, d);
    }

    public SurfaceCircle(ShapeAttributes shapeAttributes, LatLon latLon, double d, int n) {
        super(shapeAttributes, latLon, d, d, Angle.ZERO, n);
    }

    public double getRadius() {
        return this.getMajorRadius();
    }

    public void setRadius(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("Geom.RadiusIsNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setRadii(d, d);
    }
}

