/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.UserFacingIcon;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;

public class Pedestal
extends UserFacingIcon {
    private double spacingPixels = 2.0;
    private double scale = 1.0;

    public Pedestal(String string, Position position) {
        super(string, position);
    }

    public double getSpacingPixels() {
        return this.spacingPixels;
    }

    public void setSpacingPixels(double d) {
        this.spacingPixels = d;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    @Override
    public String getRestorableState() {
        RestorableSupport restorableSupport = null;
        String string = super.getRestorableState();
        if (string != null) {
            try {
                restorableSupport = RestorableSupport.parse(string);
            }
            catch (Exception exception) {
                String string2 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
                Logging.logger().severe(string2);
            }
        }
        if (restorableSupport == null) {
            restorableSupport = RestorableSupport.newRestorableSupport();
        }
        if (restorableSupport == null) {
            return null;
        }
        restorableSupport.addStateValueAsDouble("spacingPixels", this.spacingPixels);
        restorableSupport.addStateValueAsDouble("scale", this.scale);
        return restorableSupport.getStateAsXml();
    }

    @Override
    public void restoreState(String string) {
        Double d;
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            super.restoreState(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        Double d2 = restorableSupport.getStateValueAsDouble("spacingPixels");
        if (d2 != null) {
            this.setSpacingPixels(d2);
        }
        if ((d = restorableSupport.getStateValueAsDouble("scale")) != null) {
            this.setScale(d);
        }
    }
}

