/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.awt.geom.Point2D;

public class Offset {
    public static final Offset CENTER = Offset.fromFraction(0.5, 0.5);
    public static final Offset BOTTOM_CENTER = Offset.fromFraction(0.5, 0.0);
    public static final Offset TOP_CENTER = Offset.fromFraction(0.5, 1.0);
    public static final Offset LEFT_CENTER = Offset.fromFraction(0.0, 0.5);
    public static final Offset RIGHT_CENTER = Offset.fromFraction(1.0, 0.5);
    protected Double x;
    protected Double y;
    protected String xUnits;
    protected String yUnits;

    public Offset(Double d, Double d2, String string, String string2) {
        this.x = d;
        this.y = d2;
        this.xUnits = string;
        this.yUnits = string2;
    }

    public static Offset fromFraction(double d, double d2) {
        return new Offset(d, d2, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction");
    }

    public Double getX() {
        return this.x;
    }

    public void setX(Double d) {
        this.x = d;
    }

    public Double getY() {
        return this.y;
    }

    public void setY(Double d) {
        this.y = d;
    }

    public String getXUnits() {
        return this.xUnits;
    }

    public void setXUnits(String string) {
        this.xUnits = string;
    }

    public String getYUnits() {
        return this.yUnits;
    }

    public void setYUnits(String string) {
        this.yUnits = string;
    }

    public Point2D.Double computeOffset(double d, double d2, Double d3, Double d4) {
        String string;
        double d5 = 0.0;
        double d6 = 0.0;
        if (this.getX() != null) {
            string = this.getXUnits();
            d5 = "gov.nasa.worldwind.avkey.Pixels".equals(string) ? this.getX() : ("gov.nasa.worldwind.avkey.InsetPixels".equals(string) ? d - this.getX() : ("gov.nasa.worldwind.avkey.Fraction".equals(string) ? d * this.getX() : this.getX()));
        }
        if (this.getY() != null) {
            string = this.getYUnits();
            d6 = "gov.nasa.worldwind.avkey.Pixels".equals(string) ? this.getY() : ("gov.nasa.worldwind.avkey.InsetPixels".equals(string) ? d2 - this.getY() : ("gov.nasa.worldwind.avkey.Fraction".equals(string) ? d2 * this.getY() : this.getY()));
        }
        if (d3 != null) {
            d5 *= d3.doubleValue();
        }
        if (d4 != null) {
            d6 *= d4.doubleValue();
        }
        return new Point2D.Double(d5, d6);
    }

    public void getRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (restorableSupport == null) {
            String string = Logging.getMessage("nullValue.RestorableSupportIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.getX() != null) {
            restorableSupport.addStateValueAsDouble(stateObject, "x", this.getX());
        }
        if (this.getY() != null) {
            restorableSupport.addStateValueAsDouble(stateObject, "y", this.getY());
        }
        if (this.getXUnits() != null) {
            restorableSupport.addStateValueAsString(stateObject, "xUnits", this.getXUnits());
        }
        if (this.getYUnits() != null) {
            restorableSupport.addStateValueAsString(stateObject, "yUnits", this.getYUnits());
        }
    }

    public void restoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        String string;
        if (restorableSupport == null) {
            String string2 = Logging.getMessage("nullValue.RestorableSupportIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Double d = restorableSupport.getStateValueAsDouble(stateObject, "x");
        if (d != null) {
            this.setX(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "y")) != null) {
            this.setY(d);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "xUnits")) != null) {
            this.setXUnits(string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "yUnits")) != null) {
            this.setYUnits(string);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Offset offset = (Offset)object;
        if (this.x != null ? !this.x.equals(offset.x) : offset.x != null) {
            return false;
        }
        if (this.y != null ? !this.y.equals(offset.y) : offset.y != null) {
            return false;
        }
        if (this.xUnits != null ? !this.xUnits.equals(offset.xUnits) : offset.xUnits != null) {
            return false;
        }
        return !(this.yUnits != null ? !this.yUnits.equals(offset.yUnits) : offset.yUnits != null);
    }

    public int hashCode() {
        int n = this.x != null ? this.x.hashCode() : 0;
        n = 31 * n + (this.y != null ? this.y.hashCode() : 0);
        n = 31 * n + (this.xUnits != null ? this.xUnits.hashCode() : 0);
        n = 31 * n + (this.yUnits != null ? this.yUnits.hashCode() : 0);
        return n;
    }
}

