/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml.impl;

import gov.nasa.worldwind.ogc.kml.KMLRegion;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayDeque;
import java.util.Deque;

public class KMLTraversalContext {
    protected Deque<KMLRegion> regionStack = new ArrayDeque<KMLRegion>();
    protected double detailHint;

    public void initialize() {
        this.regionStack.clear();
        this.detailHint = 0.0;
    }

    public void pushRegion(KMLRegion kMLRegion) {
        if (kMLRegion == null) {
            String string = Logging.getMessage("nullValue.RegionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.regionStack.push(kMLRegion);
    }

    public KMLRegion peekRegion() {
        return this.regionStack.peek();
    }

    public KMLRegion popRegion() {
        return this.regionStack.pop();
    }

    public double getDetailHint() {
        return this.detailHint;
    }

    public void setDetailHint(double d) {
        this.detailHint = d;
    }
}

