/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml;

import gov.nasa.worldwind.ogc.kml.KMLAbstractObject;
import gov.nasa.worldwind.ogc.kml.KMLChange;
import gov.nasa.worldwind.ogc.kml.KMLCreate;
import gov.nasa.worldwind.ogc.kml.KMLDelete;
import gov.nasa.worldwind.ogc.kml.KMLRoot;
import gov.nasa.worldwind.ogc.kml.KMLUpdateOperation;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class KMLUpdate
extends KMLAbstractObject {
    protected List<KMLUpdateOperation> operations;
    protected boolean updatesApplied;

    public KMLUpdate(String string) {
        super(string);
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (object instanceof KMLChange) {
            this.addChange((KMLChange)object);
        } else if (object instanceof KMLCreate) {
            this.addCreate((KMLCreate)object);
        } else if (object instanceof KMLDelete) {
            this.addDelete((KMLDelete)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    public String getTargetHref() {
        return (String)this.getField("targetHref");
    }

    protected void addChange(KMLChange kMLChange) {
        if (this.operations == null) {
            this.operations = new ArrayList<KMLUpdateOperation>();
        }
        this.operations.add(kMLChange);
    }

    protected void addCreate(KMLCreate kMLCreate) {
        if (this.operations == null) {
            this.operations = new ArrayList<KMLUpdateOperation>();
        }
        this.operations.add(kMLCreate);
    }

    protected void addDelete(KMLDelete kMLDelete) {
        if (this.operations == null) {
            this.operations = new ArrayList<KMLUpdateOperation>();
        }
        this.operations.add(kMLDelete);
    }

    public boolean isUpdatesApplied() {
        return this.updatesApplied;
    }

    public void applyOperations() {
        this.updatesApplied = true;
        if (WWUtil.isEmpty(this.getTargetHref())) {
            return;
        }
        if (this.operations == null || this.operations.size() == 0) {
            return;
        }
        Object object = this.getRoot().resolveReference(this.getTargetHref());
        if (object == null || !(object instanceof KMLRoot)) {
            return;
        }
        KMLRoot kMLRoot = (KMLRoot)object;
        for (KMLUpdateOperation kMLUpdateOperation : this.operations) {
            kMLUpdateOperation.applyOperation(kMLRoot);
        }
        kMLRoot.firePropertyChange("gov.nasa.worldwind.avkey.Updated", null, this);
    }
}

