/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.ogc.kml.KMLAbstractGeometry;
import gov.nasa.worldwind.ogc.kml.KMLAbstractObject;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class KMLPoint
extends KMLAbstractGeometry {
    protected Position coordinates;

    public KMLPoint(String string) {
        super(string);
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEvent.asStartElement().getName().getLocalPart().equals("coordinates")) {
            this.setCoordinates((Position.PositionList)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    public boolean isExtrude() {
        return this.getExtrude() == Boolean.TRUE;
    }

    public Boolean getExtrude() {
        return (Boolean)this.getField("extrude");
    }

    public String getAltitudeMode() {
        return (String)this.getField("altitudeMode");
    }

    public Position getCoordinates() {
        return this.coordinates;
    }

    protected void setCoordinates(Position.PositionList positionList) {
        if (positionList != null && positionList.list.size() > 0) {
            this.coordinates = positionList.list.get(0);
        }
    }

    @Override
    public void applyChange(KMLAbstractObject kMLAbstractObject) {
        if (!(kMLAbstractObject instanceof KMLPoint)) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        KMLPoint kMLPoint = (KMLPoint)kMLAbstractObject;
        if (kMLPoint.getCoordinates() != null) {
            this.coordinates = kMLPoint.getCoordinates();
        }
        super.applyChange(kMLAbstractObject);
    }
}

