/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml;

import gov.nasa.worldwind.ogc.kml.KMLAbstractObject;
import gov.nasa.worldwind.ogc.kml.KMLAbstractSubStyle;
import gov.nasa.worldwind.ogc.kml.KMLItemIcon;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class KMLListStyle
extends KMLAbstractSubStyle {
    protected List<KMLItemIcon> itemIcons = new ArrayList<KMLItemIcon>();

    public KMLListStyle(String string) {
        super(string);
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (object instanceof KMLItemIcon) {
            this.addItemIcon((KMLItemIcon)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    public String getListItemType() {
        return (String)this.getField("listItemType");
    }

    public String getBgColor() {
        return (String)this.getField("bgColor");
    }

    protected void addItemIcon(KMLItemIcon kMLItemIcon) {
        this.itemIcons.add(kMLItemIcon);
    }

    public List<KMLItemIcon> getItemIcons() {
        return this.itemIcons;
    }

    public Integer getMaxSnippetLines() {
        return (Integer)this.getField("maxSnippetLines");
    }

    @Override
    public void applyChange(KMLAbstractObject kMLAbstractObject) {
        if (!(kMLAbstractObject instanceof KMLListStyle)) {
            String string = Logging.getMessage("KML.InvalidElementType", kMLAbstractObject.getClass().getName());
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        KMLListStyle kMLListStyle = (KMLListStyle)kMLAbstractObject;
        if (kMLListStyle.getItemIcons() != null && kMLListStyle.getItemIcons().size() > 0) {
            this.mergeItemIcons(kMLListStyle);
        }
        super.applyChange(kMLAbstractObject);
    }

    protected void mergeItemIcons(KMLListStyle kMLListStyle) {
        ArrayList arrayList = new ArrayList(this.getItemIcons().size());
        Collections.copy(arrayList, this.getItemIcons());
        for (KMLItemIcon kMLItemIcon : kMLListStyle.getItemIcons()) {
            String string = kMLItemIcon.getId();
            if (!WWUtil.isEmpty(string)) {
                for (KMLItemIcon kMLItemIcon2 : arrayList) {
                    String string2 = kMLItemIcon2.getId();
                    if (WWUtil.isEmpty(string2) || !string2.equals(string)) continue;
                    this.getItemIcons().remove(kMLItemIcon2);
                }
            }
            this.getItemIcons().add(kMLItemIcon);
        }
    }
}

