/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.rpf.wizard;

public class ETRCalculator {
    private int step = -1;
    private int numSteps = -1;
    private int stepsNeededForEstimate = 1;
    private long startTime = -1L;
    private long updateFrequency = 1000L;
    private long etr = -1L;
    private long nextUpdateTime = -1L;

    public int getStep() {
        return this.step;
    }

    public void setStep(int n) {
        this.step = n < 0 ? -1 : n;
    }

    public int getNumSteps() {
        return this.numSteps;
    }

    public void setNumSteps(int n) {
        this.numSteps = n < 0 ? -1 : n;
    }

    public double getStepsNeededForEstimate() {
        return this.stepsNeededForEstimate;
    }

    public void setStepsNeededForEstimate(int n) {
        this.stepsNeededForEstimate = n < 1 ? 1 : n;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long l) {
        this.startTime = l;
        this.nextUpdateTime = this.startTime + this.updateFrequency;
    }

    public long getUpdateFrequency() {
        return this.updateFrequency;
    }

    public void setUpdateFrequency(long l) {
        this.updateFrequency = l < 0L ? 0L : l;
    }

    public long getEstimatedTimeRemaining() {
        if (this.step >= 0 && this.step >= this.stepsNeededForEstimate && this.numSteps >= 0 && this.startTime >= 0L) {
            long l = System.currentTimeMillis();
            if (this.nextUpdateTime < l) {
                this.nextUpdateTime = l + this.updateFrequency;
                double d = l - this.startTime;
                double d2 = (double)this.step / (double)(this.numSteps - 1);
                this.etr = (long)(d / d2 - d);
            }
        } else {
            this.etr = -1L;
        }
        return this.etr < 0L ? -1L : this.etr;
    }
}

