/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.IconRenderer;
import gov.nasa.worldwind.render.Pedestal;
import gov.nasa.worldwind.render.WWIcon;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.util.BasicQuadTree;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class IconLayer
extends AbstractLayer {
    protected final BasicQuadTree<WWIcon> icons = new BasicQuadTree(8, Sector.FULL_SPHERE, null, false);
    protected Iterable<WWIcon> iconsOverride;
    protected IconRenderer iconRenderer = new IconRenderer();
    private Pedestal pedestal;
    private boolean regionCulling = true;
    protected Set<WWIcon> lastActiveIcons;
    protected long frameId;

    public void addIcon(WWIcon wWIcon) {
        if (wWIcon == null) {
            String string = Logging.getMessage("nullValue.Icon");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.iconsOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.icons.add(wWIcon, wWIcon.getPosition().asDegreesArray());
    }

    public void addIcons(Iterable<WWIcon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.iconsOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        for (WWIcon wWIcon : iterable) {
            if (wWIcon == null) continue;
            this.icons.add(wWIcon, wWIcon.getPosition().asDegreesArray());
        }
    }

    public void removeIcon(WWIcon wWIcon) {
        if (wWIcon == null) {
            String string = Logging.getMessage("nullValue.Icon");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.iconsOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.icons.remove(wWIcon);
    }

    public void removeAllIcons() {
        if (this.iconsOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.clearIcons();
    }

    protected void clearIcons() {
        if (this.icons != null) {
            this.icons.clear();
        }
    }

    public Iterable<WWIcon> getIcons() {
        if (this.iconsOverride != null) {
            return this.iconsOverride;
        }
        if (this.icons != null) {
            return this.icons;
        }
        return Collections.emptyList();
    }

    public boolean isRegionCulling() {
        return this.regionCulling;
    }

    public void setRegionCulling(boolean bl) {
        this.regionCulling = bl;
    }

    protected Iterable<WWIcon> getActiveIcons(DrawContext drawContext) {
        if (this.iconsOverride != null) {
            return this.iconsOverride;
        }
        if (this.lastActiveIcons != null && this.frameId == drawContext.getFrameTimeStamp()) {
            return this.lastActiveIcons;
        }
        this.lastActiveIcons = null;
        if (!this.isRegionCulling()) {
            return this.icons;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null || sectorGeometryList.size() == 0) {
            return Collections.emptyList();
        }
        this.lastActiveIcons = this.icons.getItemsInRegions(sectorGeometryList, (Set<WWIcon>)new HashSet());
        this.frameId = drawContext.getFrameTimeStamp();
        return this.lastActiveIcons;
    }

    public void setIcons(Iterable<WWIcon> iterable) {
        this.iconsOverride = iterable;
        this.clearIcons();
    }

    public Pedestal getPedestal() {
        return this.pedestal;
    }

    public void setPedestal(Pedestal pedestal) {
        this.pedestal = pedestal;
    }

    public boolean isHorizonClippingEnabled() {
        return this.iconRenderer.isHorizonClippingEnabled();
    }

    public void setHorizonClippingEnabled(boolean bl) {
        this.iconRenderer.setHorizonClippingEnabled(bl);
    }

    public boolean isViewClippingEnabled() {
        return this.iconRenderer.isViewClippingEnabled();
    }

    public void setViewClippingEnabled(boolean bl) {
        this.iconRenderer.setViewClippingEnabled(bl);
    }

    public boolean isPickFrustumClippingEnabled() {
        return this.iconRenderer.isPickFrustumClippingEnabled();
    }

    public void setPickFrustumClippingEnabled(boolean bl) {
        this.iconRenderer.setPickFrustumClippingEnabled(bl);
    }

    public boolean isAlwaysUseAbsoluteElevation() {
        return this.iconRenderer.isAlwaysUseAbsoluteElevation();
    }

    public void setAlwaysUseAbsoluteElevation(boolean bl) {
        this.iconRenderer.setAlwaysUseAbsoluteElevation(bl);
    }

    @Override
    public void setOpacity(double d) {
        super.setOpacity(d);
    }

    @Override
    public double getOpacity() {
        return super.getOpacity();
    }

    public boolean isAllowBatchPicking() {
        return this.iconRenderer.isAllowBatchPicking();
    }

    public void setAllowBatchPicking(boolean bl) {
        this.iconRenderer.setAllowBatchPicking(bl);
    }

    @Override
    protected void doPick(DrawContext drawContext, Point point) {
        this.iconRenderer.setPedestal(this.pedestal);
        this.iconRenderer.pick(drawContext, this.getActiveIcons(drawContext), point, this);
    }

    @Override
    protected void doRender(DrawContext drawContext) {
        this.iconRenderer.setPedestal(this.pedestal);
        this.iconRenderer.render(drawContext, this.getActiveIcons(drawContext));
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.IconLayer.Name");
    }
}

