/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.globes.EllipsoidalGlobe;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.GlobeStateKey;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;

public class FlatGlobe
extends EllipsoidalGlobe {
    public static final String PROJECTION_LAT_LON = "gov.nasa.worldwind.globes.projectionLatLon";
    public static final String PROJECTION_MERCATOR = "gov.nasa.worldwind.globes.projectionMercator";
    public static final String PROJECTION_SINUSOIDAL = "gov.nasa.worldwind.globes.projectionSinusoidal";
    public static final String PROJECTION_MODIFIED_SINUSOIDAL = "gov.nasa.worldwind.globes.projectionModifiedSinusoidal";
    private String projection = "gov.nasa.worldwind.globes.projectionMercator";

    public FlatGlobe(double d, double d2, double d3, ElevationModel elevationModel) {
        super(d, d2, d3, elevationModel);
    }

    @Override
    public Object getStateKey(DrawContext drawContext) {
        return this.getGlobeStateKey(drawContext);
    }

    @Override
    public GlobeStateKey getGlobeStateKey(DrawContext drawContext) {
        return new FlatStateKey(drawContext);
    }

    @Override
    public GlobeStateKey getGlobeStateKey() {
        return new FlatStateKey((Globe)this);
    }

    @Override
    public double getRadiusAt(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.getMaximumRadius();
    }

    @Override
    public double getRadiusAt(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.getMaximumRadius();
    }

    public void setProjection(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.projection.equals(string)) {
            return;
        }
        this.projection = string;
        this.setTessellator(null);
    }

    public String getProjection() {
        return this.projection;
    }

    @Override
    protected Intersection[] intersect(Line line, double d, double d2) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Plane plane = new Plane(0.0, 0.0, 1.0, -(d - this.equatorialRadius));
        Vec4 vec4 = plane.intersect(line);
        if (vec4 == null) {
            return null;
        }
        Position position = this.computePositionFromPoint(vec4);
        if (position == null) {
            return null;
        }
        if (position.getLatitude().degrees < -90.0 || position.getLatitude().degrees > 90.0 || position.getLongitude().degrees < -180.0 || position.getLongitude().degrees > 180.0) {
            return null;
        }
        return new Intersection[]{new Intersection(vec4, false)};
    }

    @Override
    public boolean intersects(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.intersect(line) != null;
    }

    @Override
    public boolean intersects(Plane plane) {
        if (plane == null) {
            String string = Logging.getMessage("nullValue.PlaneIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = plane.getNormal();
        return vec4.x != 0.0 || vec4.y != 0.0 || vec4.z != 1.0;
    }

    @Override
    public Vec4 computeSurfaceNormalAtLocation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Vec4.UNIT_Z;
    }

    @Override
    public Vec4 computeSurfaceNormalAtPoint(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Vec4.UNIT_Z;
    }

    @Override
    public Vec4 computeNorthPointingTangentAtLocation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Vec4.UNIT_Y;
    }

    @Override
    public Matrix computeSurfaceOrientationAtPosition(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = this.geodeticToCartesian(angle, angle2, d);
        return Matrix.fromTranslation(vec4);
    }

    @Override
    public Matrix computeSurfaceOrientationAtPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.computeSurfaceOrientationAtPosition(position.getLatitude(), position.getLongitude(), position.getElevation());
    }

    @Override
    public double getElevation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle.degrees < -90.0 || angle.degrees > 90.0 || angle2.degrees < -180.0 || angle2.degrees > 180.0) {
            return 0.0;
        }
        return super.getElevation(angle, angle2);
    }

    @Override
    protected Vec4 geodeticToCartesian(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = null;
        if (this.projection.equals(PROJECTION_LAT_LON)) {
            vec4 = new Vec4(this.equatorialRadius * angle2.radians, this.equatorialRadius * angle.radians, d);
        } else if (this.projection.equals(PROJECTION_MERCATOR)) {
            if (angle.degrees > 75.0) {
                angle = Angle.fromDegrees(75.0);
            }
            if (angle.degrees < -75.0) {
                angle = Angle.fromDegrees(-75.0);
            }
            vec4 = new Vec4(this.equatorialRadius * angle2.radians, this.equatorialRadius * Math.log(Math.tan(0.7853981633974483 + angle.radians / 2.0)), d);
        } else if (this.projection.equals(PROJECTION_SINUSOIDAL)) {
            double d2 = angle.cos();
            vec4 = new Vec4(d2 > 0.0 ? this.equatorialRadius * angle2.radians * angle.cos() : 0.0, this.equatorialRadius * angle.radians, d);
        } else if (this.projection.equals(PROJECTION_MODIFIED_SINUSOIDAL)) {
            double d3 = angle.cos();
            vec4 = new Vec4(d3 > 0.0 ? this.equatorialRadius * angle2.radians * Math.pow(d3, 0.3) : 0.0, this.equatorialRadius * angle.radians, d);
        } else {
            String string = Logging.getMessage("generic.UnknownProjection", this.projection);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return vec4;
    }

    @Override
    protected Position cartesianToGeodetic(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position = null;
        if (this.projection.equals(PROJECTION_LAT_LON)) {
            position = Position.fromRadians(vec4.y / this.equatorialRadius, vec4.x / this.equatorialRadius, vec4.z);
        } else if (this.projection.equals(PROJECTION_MERCATOR)) {
            position = Position.fromRadians(Math.atan(Math.sinh(vec4.y / this.equatorialRadius)), vec4.x / this.equatorialRadius, vec4.z);
        } else if (this.projection.equals(PROJECTION_SINUSOIDAL)) {
            double d;
            double d2 = Math.cos(d = vec4.y / this.equatorialRadius);
            position = Position.fromRadians(d, d2 > 0.0 ? vec4.x / this.equatorialRadius / d2 : 0.0, vec4.z);
        } else if (this.projection.equals(PROJECTION_MODIFIED_SINUSOIDAL)) {
            double d;
            double d3 = Math.cos(d = vec4.y / this.equatorialRadius);
            position = Position.fromRadians(d, d3 > 0.0 ? vec4.x / this.equatorialRadius / Math.pow(d3, 0.3) : 0.0, vec4.z);
        }
        return position;
    }

    @Override
    public boolean isPointAboveElevation(Vec4 vec4, double d) {
        if (vec4 == null) {
            return false;
        }
        return vec4.z() > d;
    }

    private class FlatStateKey
    extends EllipsoidalGlobe.StateKey {
        protected final String projection;
        protected double verticalExaggeration;

        public FlatStateKey(DrawContext drawContext) {
            super(drawContext);
            this.projection = FlatGlobe.this.projection;
        }

        public FlatStateKey(Globe globe) {
            super(globe);
            this.projection = FlatGlobe.this.projection;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            FlatStateKey flatStateKey = (FlatStateKey)object;
            if (Double.compare(flatStateKey.verticalExaggeration, this.verticalExaggeration) != 0) {
                return false;
            }
            return !(this.projection != null ? !this.projection.equals(flatStateKey.projection) : flatStateKey.projection != null);
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.projection != null ? this.projection.hashCode() : 0);
            long l = this.verticalExaggeration != 0.0 ? Double.doubleToLongBits(this.verticalExaggeration) : 0L;
            n = 31 * n + (int)(l ^ l >>> 32);
            return n;
        }
    }
}

