/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.formats.vpf.VPFBoundingBox;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.ExtentHolder;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;

public class VPFTile
implements ExtentHolder {
    private int id;
    private String name;
    private VPFBoundingBox bounds;

    public VPFTile(int n, String string, VPFBoundingBox vPFBoundingBox) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (vPFBoundingBox == null) {
            String string3 = Logging.getMessage("nullValue.BoundingBoxIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.id = n;
        this.name = string;
        this.bounds = vPFBoundingBox;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public VPFBoundingBox getBounds() {
        return this.bounds;
    }

    @Override
    public Extent getExtent(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Sector.computeBoundingCylinder(globe, d, this.bounds.toSector());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        VPFTile vPFTile = (VPFTile)object;
        if (this.id != vPFTile.id) {
            return false;
        }
        if (this.bounds != null ? !this.bounds.equals(vPFTile.bounds) : vPFTile.bounds != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(vPFTile.name) : vPFTile.name != null);
    }

    public int hashCode() {
        int n = this.id;
        n = 31 * n + (this.name != null ? this.name.hashCode() : 0);
        n = 31 * n + (this.bounds != null ? this.bounds.hashCode() : 0);
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.id);
        stringBuilder.append(": ");
        stringBuilder.append(this.name);
        return stringBuilder.toString();
    }
}

