/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.formats.vpf.VPFFeature;
import gov.nasa.worldwind.formats.vpf.VPFPrimitiveData;
import gov.nasa.worldwind.formats.vpf.VPFSymbolAttributes;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfacePolyline;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import gov.nasa.worldwind.util.VecBufferSequence;
import java.util.Arrays;
import java.util.List;
import javax.media.opengl.GL2;

public class VPFSurfaceLine
extends SurfacePolyline {
    protected Sector sector;
    protected VecBufferSequence buffer;
    protected LatLon referenceLocation;

    public VPFSurfaceLine(VPFFeature vPFFeature, VPFPrimitiveData vPFPrimitiveData) {
        String string = vPFFeature.getFeatureClass().getPrimitiveTableName();
        int[] nArray = vPFFeature.getPrimitiveIds();
        this.sector = vPFFeature.getBounds().toSector();
        this.buffer = (VecBufferSequence)vPFPrimitiveData.getPrimitiveCoords(string).slice(nArray);
        this.referenceLocation = vPFFeature.getBounds().toSector().getCentroid();
    }

    @Override
    protected List<Sector> computeSectors(Globe globe) {
        if (this.sector == null || this.sector.equals(Sector.EMPTY_SECTOR)) {
            return null;
        }
        return Arrays.asList(this.sector);
    }

    @Override
    public Iterable<? extends LatLon> getLocations() {
        return this.buffer.getLocations();
    }

    @Override
    public void setLocations(Iterable<? extends LatLon> iterable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Position getReferencePosition() {
        return new Position(this.referenceLocation, 0.0);
    }

    @Override
    protected void applyModelviewTransform(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        Matrix matrix = surfaceTileDrawContext.getModelviewMatrix();
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glMultMatrixd(matrix.toArray(new double[16], 0, false), 0);
    }

    @Override
    protected ShapeAttributes createActiveAttributes() {
        return new VPFSymbolAttributes();
    }

    @Override
    protected void determineActiveGeometry(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
    }

    @Override
    protected void drawOutline(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        this.applyOutlineState(drawContext, this.getActiveAttributes());
        int n = this.isClosed() ? 2 : 3;
        this.buffer.bindAsVertexBuffer(drawContext);
        this.buffer.multiDrawArrays(drawContext, n);
    }
}

