/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.vpf.VPFBasicFeatureClassFactory;
import gov.nasa.worldwind.formats.vpf.VPFBasicFeatureFactory;
import gov.nasa.worldwind.formats.vpf.VPFBasicPrimitiveDataFactory;
import gov.nasa.worldwind.formats.vpf.VPFBoundingBox;
import gov.nasa.worldwind.formats.vpf.VPFBufferedRecordData;
import gov.nasa.worldwind.formats.vpf.VPFCoverage;
import gov.nasa.worldwind.formats.vpf.VPFDatabase;
import gov.nasa.worldwind.formats.vpf.VPFFeature;
import gov.nasa.worldwind.formats.vpf.VPFFeatureClass;
import gov.nasa.worldwind.formats.vpf.VPFFeatureClassSchema;
import gov.nasa.worldwind.formats.vpf.VPFFeatureTableFilter;
import gov.nasa.worldwind.formats.vpf.VPFPrimitiveData;
import gov.nasa.worldwind.formats.vpf.VPFRecord;
import gov.nasa.worldwind.formats.vpf.VPFTile;
import gov.nasa.worldwind.formats.vpf.VPFUtils;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VPFLibrary
extends AVListImpl {
    private VPFDatabase database;
    private VPFBoundingBox bounds;
    private Map<String, VPFCoverage> coverageMap = new HashMap<String, VPFCoverage>();
    private Map<Integer, VPFTile> tileMap = new HashMap<Integer, VPFTile>();
    private VPFTile[] tiles;
    private VPFBufferedRecordData libraryHeaderTable;
    private VPFBufferedRecordData coverageAttributeTable;
    private VPFBufferedRecordData geographicReferenceTable;

    protected VPFLibrary(VPFDatabase vPFDatabase) {
        if (vPFDatabase == null) {
            String string = Logging.getMessage("nullValue.DatabaseIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.database = vPFDatabase;
    }

    public static VPFLibrary fromFile(VPFDatabase vPFDatabase, String string) {
        VPFCoverage vPFCoverage;
        Collection<VPFCoverage> collection;
        if (vPFDatabase == null) {
            String string2 = Logging.getMessage("nullValue.DatabaseIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (WWUtil.isEmpty(string)) {
            String string3 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        File file = new File(vPFDatabase.getFilePath(), string);
        if (!file.exists()) {
            String string4 = Logging.getMessage("generic.FileNotFound", file.getPath());
            Logging.logger().severe(string4);
            throw new WWRuntimeException(string4);
        }
        VPFBufferedRecordData vPFBufferedRecordData = VPFUtils.readTable(new File(file, "lht"));
        if (vPFBufferedRecordData == null) {
            String string5 = Logging.getMessage("VPF.LibraryHeaderTableMissing");
            throw new WWRuntimeException(string5);
        }
        VPFBufferedRecordData vPFBufferedRecordData2 = VPFUtils.readTable(new File(file, "cat"));
        if (vPFBufferedRecordData2 == null) {
            String string6 = Logging.getMessage("VPF.CoverageAttributeTableMissing");
            throw new WWRuntimeException(string6);
        }
        VPFBufferedRecordData vPFBufferedRecordData3 = VPFUtils.readTable(new File(file, "grt"));
        if (vPFBufferedRecordData3 == null) {
            String string7 = Logging.getMessage("VPF.GeographicReferenceTableMissing");
            throw new WWRuntimeException(string7);
        }
        VPFLibrary vPFLibrary = new VPFLibrary(vPFDatabase);
        vPFLibrary.setLibraryHeaderTable(vPFBufferedRecordData);
        vPFLibrary.setCoverageAttributeTable(vPFBufferedRecordData2);
        vPFLibrary.setGeographicReferenceTable(vPFBufferedRecordData3);
        VPFRecord vPFRecord = vPFDatabase.getLibraryAttributeTable().getRecord("library_name", string);
        if (vPFRecord != null) {
            vPFLibrary.bounds = VPFUtils.getExtent(vPFRecord);
        }
        if ((vPFRecord = vPFBufferedRecordData.getRecord(1)) != null) {
            VPFUtils.checkAndSetValue(vPFRecord, "library_name", "gov.nasa.worldwind.avkey.DisplayName", vPFLibrary);
            VPFUtils.checkAndSetValue(vPFRecord, "description", "gov.nasa.worldwind.avkey.Description", vPFLibrary);
        }
        if ((collection = VPFLibrary.createCoverages(vPFLibrary, vPFBufferedRecordData2)) != null) {
            vPFLibrary.setCoverages(collection);
        }
        if ((vPFCoverage = vPFLibrary.getCoverage("tileref")) != null) {
            VPFTile[] vPFTileArray = VPFLibrary.createTiles(vPFCoverage);
            if (vPFTileArray != null) {
                vPFLibrary.setTiles(vPFTileArray);
            } else {
                String object = Logging.getMessage("VPF.NoTilesInTileReferenceCoverage");
                Logging.logger().warning(object);
            }
        }
        for (VPFCoverage vPFCoverage2 : vPFLibrary.getCoverages()) {
            boolean bl = VPFLibrary.isCoverageTiled(vPFLibrary, vPFCoverage2);
            vPFCoverage2.setTiled(bl);
        }
        return vPFLibrary;
    }

    public VPFDatabase getDatabase() {
        return this.database;
    }

    public String getName() {
        return this.getStringValue("gov.nasa.worldwind.avkey.DisplayName");
    }

    public String getDescription() {
        return this.getStringValue("gov.nasa.worldwind.avkey.Description");
    }

    public String getFilePath() {
        StringBuilder stringBuilder = new StringBuilder(this.database.getFilePath());
        stringBuilder.append(File.separator);
        stringBuilder.append(this.getName());
        return stringBuilder.toString();
    }

    public VPFBoundingBox getBounds() {
        return this.bounds;
    }

    public int getNumCoverages() {
        return this.coverageMap.size();
    }

    public boolean containsCoverage(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.coverageMap.containsKey(string);
    }

    public VPFCoverage getCoverage(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.coverageMap.get(string);
    }

    public Set<String> getCoverageNames() {
        return Collections.unmodifiableSet(this.coverageMap.keySet());
    }

    public Collection<VPFCoverage> getCoverages() {
        return Collections.unmodifiableCollection(this.coverageMap.values());
    }

    public void setCoverages(Collection<? extends VPFCoverage> collection) {
        this.removeAllCoverages();
        if (collection != null) {
            this.addAllCoverages(collection);
        }
    }

    public void addCoverage(VPFCoverage vPFCoverage) {
        if (vPFCoverage == null) {
            String string = Logging.getMessage("nullValue.CoverageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.coverageMap.put(vPFCoverage.getName(), vPFCoverage);
    }

    public void addAllCoverages(Collection<? extends VPFCoverage> collection) {
        if (collection == null) {
            String string = Logging.getMessage("nullValue.CollectionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (VPFCoverage vPFCoverage : collection) {
            this.addCoverage(vPFCoverage);
        }
    }

    public void removeCoverage(VPFCoverage vPFCoverage) {
        if (vPFCoverage == null) {
            String string = Logging.getMessage("nullValue.CoverageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.coverageMap.remove(vPFCoverage.getName());
    }

    public void removeAllCoverages() {
        this.coverageMap.clear();
    }

    public boolean hasTiledCoverages() {
        return this.getCoverage("tileref") != null;
    }

    public int getNumTiles() {
        return this.tiles != null ? this.tiles.length : 0;
    }

    public VPFTile[] getTiles() {
        if (this.tiles == null) {
            return null;
        }
        VPFTile[] vPFTileArray = new VPFTile[this.tiles.length];
        System.arraycopy(this.tiles, 0, vPFTileArray, 0, this.tiles.length);
        return vPFTileArray;
    }

    public void setTiles(VPFTile[] vPFTileArray) {
        if (vPFTileArray == null) {
            this.tiles = null;
            this.tileMap.clear();
            return;
        }
        this.tiles = new VPFTile[vPFTileArray.length];
        System.arraycopy(vPFTileArray, 0, this.tiles, 0, vPFTileArray.length);
        this.tileMap.clear();
        for (VPFTile vPFTile : vPFTileArray) {
            this.tileMap.put(vPFTile.getId(), vPFTile);
        }
    }

    public VPFTile getTile(int n) {
        return this.tileMap.get(n);
    }

    public String getProductType() {
        if (this.libraryHeaderTable == null || this.libraryHeaderTable.getNumRecords() == 0) {
            return null;
        }
        VPFRecord vPFRecord = this.libraryHeaderTable.getRecord(1);
        Object object = vPFRecord != null ? vPFRecord.getValue("product_type") : null;
        return object != null ? object.toString() : null;
    }

    public double getMapScale() {
        if (this.libraryHeaderTable == null || this.libraryHeaderTable.getNumRecords() == 0) {
            return 0.0;
        }
        VPFRecord vPFRecord = this.libraryHeaderTable.getRecord(1);
        Object object = vPFRecord != null ? vPFRecord.getValue("scale") : null;
        return object != null && object instanceof Number ? ((Number)object).doubleValue() : 0.0;
    }

    public Angle computeArcLengthFromMapDistance(double d) {
        if (this.geographicReferenceTable == null || this.geographicReferenceTable.getNumRecords() == 0) {
            return null;
        }
        VPFRecord vPFRecord = this.geographicReferenceTable.getRecord(1);
        if (vPFRecord == null) {
            return null;
        }
        String string = (String)vPFRecord.getValue("units");
        Double d2 = VPFLibrary.parseUnitsCoefficient(string);
        if (d2 == null) {
            String string2 = Logging.getMessage("VPF.UnrecognizedUnits", string);
            Logging.logger().severe(string2);
            return null;
        }
        string = (String)vPFRecord.getValue("ellipsoid_detail");
        double[] dArray = VPFLibrary.parseEllipsoidDetail(string);
        if (dArray == null || dArray.length != 2) {
            String string3 = Logging.getMessage("VPF.UnrecognizedEllipsoidDetail", string);
            Logging.logger().severe(string3);
            return null;
        }
        double d3 = this.getMapScale() * d / 1000.0;
        double d4 = d2 * Math.max(dArray[0], dArray[1]);
        return Angle.fromRadians(d3 / d4);
    }

    public VPFBufferedRecordData getLibraryHeaderTable() {
        return this.libraryHeaderTable;
    }

    public void setLibraryHeaderTable(VPFBufferedRecordData vPFBufferedRecordData) {
        if (vPFBufferedRecordData == null) {
            String string = Logging.getMessage("nullValue.TableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.libraryHeaderTable = vPFBufferedRecordData;
    }

    public VPFBufferedRecordData getGeographicReferenceTable() {
        return this.geographicReferenceTable;
    }

    public void setGeographicReferenceTable(VPFBufferedRecordData vPFBufferedRecordData) {
        if (vPFBufferedRecordData == null) {
            String string = Logging.getMessage("nullValue.TableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.geographicReferenceTable = vPFBufferedRecordData;
    }

    public VPFBufferedRecordData getCoverageAttributeTable() {
        return this.coverageAttributeTable;
    }

    public void setCoverageAttributeTable(VPFBufferedRecordData vPFBufferedRecordData) {
        if (vPFBufferedRecordData == null) {
            String string = Logging.getMessage("nullValue.TableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.coverageAttributeTable = vPFBufferedRecordData;
    }

    protected static Double parseUnitsCoefficient(String string) {
        if (WWUtil.isEmpty(string)) {
            return null;
        }
        if (string.toLowerCase().startsWith("f")) {
            return 0.3048000000012192;
        }
        if (string.toLowerCase().startsWith("m")) {
            return 1.0;
        }
        return null;
    }

    protected static double[] parseEllipsoidDetail(String string) {
        if (WWUtil.isEmpty(string)) {
            return null;
        }
        Pattern pattern = Pattern.compile("[A][=](.+)\\s+[B][=](.+)\\s+?(.+)?");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        if (WWUtil.isEmpty(string2) || WWUtil.isEmpty(string3)) {
            return null;
        }
        Double d = WWUtil.convertStringToDouble(string2);
        Double d2 = WWUtil.convertStringToDouble(string3);
        if (d == null || d2 == null) {
            return null;
        }
        return new double[]{d, d2};
    }

    protected static Collection<VPFCoverage> createCoverages(VPFLibrary vPFLibrary, VPFBufferedRecordData vPFBufferedRecordData) {
        ArrayList<VPFCoverage> arrayList = new ArrayList<VPFCoverage>();
        for (VPFRecord vPFRecord : vPFBufferedRecordData) {
            VPFCoverage vPFCoverage;
            String string = (String)vPFRecord.getValue("coverage_name");
            if (string == null || (vPFCoverage = VPFUtils.readCoverage(vPFLibrary, string)) == null) continue;
            arrayList.add(vPFCoverage);
        }
        return arrayList;
    }

    protected static boolean isCoverageTiled(VPFLibrary vPFLibrary, VPFCoverage vPFCoverage) {
        if (vPFCoverage.getName().equals("tileref")) {
            return false;
        }
        if (vPFLibrary == null || vPFLibrary.getCoverage("tileref") == null) {
            return false;
        }
        VPFTile[] vPFTileArray = vPFLibrary.getTiles();
        if (vPFTileArray == null) {
            return false;
        }
        for (VPFTile vPFTile : vPFTileArray) {
            File file = new File(vPFCoverage.getFilePath(), vPFTile.getName());
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    protected static VPFTile[] createTiles(VPFCoverage vPFCoverage) {
        VPFFeatureClassSchema[] vPFFeatureClassSchemaArray = vPFCoverage.getFeatureClasses(new VPFFeatureTableFilter());
        if (vPFFeatureClassSchemaArray == null || vPFFeatureClassSchemaArray.length == 0) {
            return null;
        }
        VPFFeatureClassSchema vPFFeatureClassSchema = null;
        for (VPFFeatureClassSchema vPFFeatureClassSchema2 : vPFFeatureClassSchemaArray) {
            if (!vPFFeatureClassSchema2.getClassName().equalsIgnoreCase("tileref")) continue;
            vPFFeatureClassSchema = vPFFeatureClassSchema2;
            break;
        }
        if (vPFFeatureClassSchema == null) {
            return null;
        }
        VPFBasicFeatureClassFactory vPFBasicFeatureClassFactory = new VPFBasicFeatureClassFactory();
        VPFFeatureClass vPFFeatureClass = vPFBasicFeatureClassFactory.createFromSchema(vPFCoverage, vPFFeatureClassSchema);
        return VPFLibrary.createTiles(vPFFeatureClass);
    }

    protected static VPFTile[] createTiles(VPFFeatureClass vPFFeatureClass) {
        VPFBasicPrimitiveDataFactory vPFBasicPrimitiveDataFactory = new VPFBasicPrimitiveDataFactory(null);
        VPFPrimitiveData vPFPrimitiveData = vPFBasicPrimitiveDataFactory.createPrimitiveData(vPFFeatureClass.getCoverage());
        if (vPFPrimitiveData == null) {
            return null;
        }
        VPFBasicFeatureFactory vPFBasicFeatureFactory = new VPFBasicFeatureFactory(null, vPFPrimitiveData);
        Collection<? extends VPFFeature> collection = vPFFeatureClass.createFeatures(vPFBasicFeatureFactory);
        if (collection == null || collection.size() == 0) {
            return null;
        }
        VPFTile[] vPFTileArray = new VPFTile[collection.size()];
        int n = 0;
        for (VPFFeature vPFFeature : collection) {
            String string = vPFFeature.getStringValue("tile_name");
            if (string != null) {
                string = VPFLibrary.fixTileName(string);
            }
            vPFTileArray[n++] = new VPFTile(vPFFeature.getId(), string, vPFFeature.getBounds());
        }
        return vPFTileArray;
    }

    protected static String fixTileName(String string) {
        string = string.toLowerCase();
        string = string.replace("\\", File.separator);
        return string;
    }
}

