/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.json;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.formats.json.JSONEvent;
import gov.nasa.worldwind.formats.json.JSONEventParser;
import gov.nasa.worldwind.formats.json.JSONEventParserContext;
import gov.nasa.worldwind.util.Logging;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BasicJSONEventParser
implements JSONEventParser {
    protected AVList fields;
    protected List<Object> array;

    @Override
    public Object parse(JSONEventParserContext jSONEventParserContext, JSONEvent jSONEvent) throws IOException {
        if (jSONEventParserContext == null) {
            String string = Logging.getMessage("nullValue.ParserContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (jSONEvent == null) {
            String string = Logging.getMessage("nullValue.EventIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (jSONEvent.isStartObject()) {
            return this.parseObject(jSONEventParserContext, jSONEvent);
        }
        if (jSONEvent.isStartArray()) {
            return this.parseArray(jSONEventParserContext, jSONEvent);
        }
        if (jSONEvent.isScalarValue()) {
            return this.parseScalarContent(jSONEventParserContext, jSONEvent);
        }
        Logging.logger().warning(Logging.getMessage("generic.UnexpectedEvent", jSONEvent));
        return null;
    }

    protected JSONEventParser allocate(JSONEventParserContext jSONEventParserContext, JSONEvent jSONEvent) {
        if (jSONEventParserContext == null) {
            String string = Logging.getMessage("nullValue.ParserContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (jSONEvent == null) {
            String string = Logging.getMessage("nullValue.EventIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return jSONEventParserContext.allocate(jSONEvent);
    }

    protected Object parseObject(JSONEventParserContext jSONEventParserContext, JSONEvent jSONEvent) throws IOException {
        if (!jSONEvent.isStartObject()) {
            String string = Logging.getMessage("generic.InvalidEvent", jSONEvent);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        jSONEvent = jSONEventParserContext.nextEvent();
        while (jSONEventParserContext.hasNext()) {
            if (jSONEvent != null) {
                if (jSONEvent.isEndObject()) break;
                if (jSONEvent.isFieldName()) {
                    this.parseObjectField(jSONEventParserContext, jSONEvent);
                } else {
                    Logging.logger().warning(Logging.getMessage("generic.UnexpectedEvent", jSONEvent));
                }
            }
            jSONEvent = jSONEventParserContext.nextEvent();
        }
        return this.resolveObject(jSONEventParserContext, jSONEvent);
    }

    protected void parseObjectField(JSONEventParserContext jSONEventParserContext, JSONEvent jSONEvent) throws IOException {
        if (!jSONEvent.isFieldName()) {
            String string = Logging.getMessage("generic.InvalidEvent", jSONEvent);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        jSONEventParserContext.pushFieldName(jSONEvent.getFieldName());
        if (jSONEventParserContext.hasNext()) {
            JSONEvent jSONEvent2 = jSONEventParserContext.nextEvent();
            if (jSONEvent2.isStartObject() || jSONEvent2.isStartArray()) {
                this.addFieldContent(jSONEventParserContext, this.parseComplexContent(jSONEventParserContext, jSONEvent2));
            } else if (jSONEvent2.isScalarValue()) {
                this.addFieldContent(jSONEventParserContext, this.parseScalarContent(jSONEventParserContext, jSONEvent2));
            } else {
                Logging.logger().warning(Logging.getMessage("generic.UnexpectedEvent", jSONEvent2));
            }
        } else {
            this.addFieldContent(jSONEventParserContext, null);
        }
        jSONEventParserContext.popFieldName();
    }

    protected void addFieldContent(JSONEventParserContext jSONEventParserContext, Object object) {
        if (this.fields == null) {
            this.fields = new AVListImpl();
        }
        this.fields.setValue(jSONEventParserContext.getCurrentFieldName(), object);
    }

    protected Object resolveObject(JSONEventParserContext jSONEventParserContext, JSONEvent jSONEvent) {
        return this.fields;
    }

    protected Object parseArray(JSONEventParserContext jSONEventParserContext, JSONEvent jSONEvent) throws IOException {
        if (!jSONEvent.isStartArray()) {
            String string = Logging.getMessage("generic.InvalidEvent", jSONEvent);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        jSONEvent = jSONEventParserContext.nextEvent();
        while (jSONEventParserContext.hasNext()) {
            if (jSONEvent != null) {
                if (jSONEvent.isEndArray()) break;
                this.parseArrayEntry(jSONEventParserContext, jSONEvent);
            }
            jSONEvent = jSONEventParserContext.nextEvent();
        }
        return this.resolveArray(jSONEventParserContext, jSONEvent);
    }

    protected void parseArrayEntry(JSONEventParserContext jSONEventParserContext, JSONEvent jSONEvent) throws IOException {
        if (jSONEvent.isStartObject() || jSONEvent.isStartArray()) {
            this.addArrayEntry(this.parseComplexContent(jSONEventParserContext, jSONEvent));
        } else if (jSONEvent.isScalarValue()) {
            this.addArrayEntry(this.parseScalarContent(jSONEventParserContext, jSONEvent));
        } else {
            Logging.logger().warning(Logging.getMessage("generic.UnexpectedEvent", jSONEvent));
        }
    }

    protected void addArrayEntry(Object object) {
        if (this.array == null) {
            this.array = new ArrayList<Object>();
        }
        this.array.add(object);
    }

    protected Object resolveArray(JSONEventParserContext jSONEventParserContext, JSONEvent jSONEvent) {
        return this.array.toArray(new Object[this.array.size()]);
    }

    protected Object parseComplexContent(JSONEventParserContext jSONEventParserContext, JSONEvent jSONEvent) throws IOException {
        JSONEventParser jSONEventParser = this.allocate(jSONEventParserContext, jSONEvent);
        if (jSONEventParser == null) {
            jSONEventParser = jSONEventParserContext.getUnrecognizedParser();
        }
        return jSONEventParser != null ? jSONEventParser.parse(jSONEventParserContext, jSONEvent) : null;
    }

    protected Object parseScalarContent(JSONEventParserContext jSONEventParserContext, JSONEvent jSONEvent) throws IOException {
        return jSONEvent.asScalarValue();
    }
}

