/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.gpx;

import gov.nasa.worldwind.formats.gpx.ElementParser;
import gov.nasa.worldwind.formats.gpx.GpxRoutePoint;
import gov.nasa.worldwind.tracks.Track;
import gov.nasa.worldwind.tracks.TrackPoint;
import gov.nasa.worldwind.tracks.TrackSegment;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GpxRoute
extends ElementParser
implements Track,
TrackSegment {
    private String name;
    private List<TrackPoint> points = new ArrayList<TrackPoint>();

    public GpxRoute(String string, String string2, String string3, Attributes attributes) {
        super("rte");
    }

    @Override
    public List<TrackSegment> getSegments() {
        return Arrays.asList(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNumPoints() {
        return this.points.size();
    }

    @Override
    public List<TrackPoint> getPoints() {
        return this.points;
    }

    @Override
    public void doStartElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2 == null) {
            String string4 = Logging.getMessage("nullValue.LNameIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            String string5 = Logging.getMessage("nullValue.URIIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (string3 == null) {
            String string6 = Logging.getMessage("nullValue.QNameIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        if (attributes == null) {
            String string7 = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string7);
            throw new IllegalArgumentException(string7);
        }
        if (string2.equalsIgnoreCase("rtept")) {
            this.currentElement = new GpxRoutePoint(string, string2, string3, attributes);
            this.points.add((TrackPoint)((Object)this.currentElement));
        }
    }

    @Override
    public void doEndElement(String string, String string2, String string3) throws SAXException {
        if (string2 == null) {
            String string4 = Logging.getMessage("nullValue.LNameIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string2.equalsIgnoreCase("name")) {
            this.name = this.currentCharacters;
        }
    }
}

