/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.dds;

public class Color24 {
    public int r;
    public int g;
    public int b;

    public Color24() {
        this.b = 0;
        this.g = 0;
        this.r = 0;
    }

    public Color24(int n, int n2, int n3) {
        this.r = n;
        this.g = n2;
        this.b = n3;
    }

    public int getPixel888() {
        return this.r << 16 | this.g << 8 | this.b;
    }

    public static Color24 fromPixel565(int n) {
        Color24 color24 = new Color24();
        color24.r = (int)((long)n & 0xF800L) >>> 8;
        color24.g = (int)((long)n & 0x7E0L) >>> 3;
        color24.b = (int)((long)n & 0x1FL) << 3;
        return color24;
    }

    public static Color24 multiplyAlpha(Color24 color24, int n) {
        Color24 color242 = new Color24();
        double d = (double)n / 256.0;
        color242.r = (int)((double)color24.r * d);
        color242.g = (int)((double)color24.g * d);
        color242.b = (int)((double)color24.b * d);
        return color242;
    }

    public static Color24[] expandLookupTable(short s, short s2) {
        Color24 color24 = Color24.fromPixel565(s);
        Color24 color242 = Color24.fromPixel565(s2);
        Color24 color243 = new Color24();
        Color24 color244 = new Color24();
        color243.r = (2 * color24.r + color242.r + 1) / 3;
        color243.g = (2 * color24.g + color242.g + 1) / 3;
        color243.b = (2 * color24.b + color242.b + 1) / 3;
        color244.r = (color24.r + 2 * color242.r + 1) / 3;
        color244.g = (color24.g + 2 * color242.g + 1) / 3;
        color244.b = (color24.b + 2 * color242.b + 1) / 3;
        return new Color24[]{color24, color242, color243, color244};
    }
}

