/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.event;

import gov.nasa.worldwind.event.WWEvent;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;

public class SelectEvent
extends WWEvent {
    public static final String LEFT_CLICK = "gov.nasa.worldwind.SelectEvent.LeftClick";
    public static final String LEFT_DOUBLE_CLICK = "gov.nasa.worldwind.SelectEvent.LeftDoubleClick";
    public static final String RIGHT_CLICK = "gov.nasa.worldwind.SelectEvent.RightClick";
    public static final String LEFT_PRESS = "gov.nasa.worldwind.SelectEvent.LeftPress";
    public static final String RIGHT_PRESS = "gov.nasa.worldwind.SelectEvent.RightPress";
    public static final String HOVER = "gov.nasa.worldwind.SelectEvent.Hover";
    public static final String ROLLOVER = "gov.nasa.worldwind.SelectEvent.Rollover";
    public static final String DRAG = "gov.nasa.worldwind.SelectEvent.Drag";
    public static final String DRAG_END = "gov.nasa.worldwind.SelectEvent.DragEnd";
    public static final String BOX_ROLLOVER = "gov.nasa.worldwind.SelectEvent.BoxRollover";
    private final String eventAction;
    private final Point pickPoint;
    private final Rectangle pickRect;
    private final MouseEvent mouseEvent;
    private final PickedObjectList pickedObjects;

    public SelectEvent(Object object, String string, MouseEvent mouseEvent, PickedObjectList pickedObjectList) {
        super(object);
        this.eventAction = string;
        this.pickPoint = mouseEvent != null ? mouseEvent.getPoint() : null;
        this.pickRect = null;
        this.mouseEvent = mouseEvent;
        this.pickedObjects = pickedObjectList;
    }

    public SelectEvent(Object object, String string, Point point, PickedObjectList pickedObjectList) {
        super(object);
        this.eventAction = string;
        this.pickPoint = point;
        this.pickRect = null;
        this.mouseEvent = null;
        this.pickedObjects = pickedObjectList;
    }

    public SelectEvent(Object object, String string, Rectangle rectangle, PickedObjectList pickedObjectList) {
        super(object);
        this.eventAction = string;
        this.pickPoint = null;
        this.pickRect = rectangle;
        this.mouseEvent = null;
        this.pickedObjects = pickedObjectList;
    }

    @Override
    public void consume() {
        super.consume();
        if (this.getMouseEvent() != null) {
            this.getMouseEvent().consume();
        }
    }

    public String getEventAction() {
        return this.eventAction != null ? this.eventAction : "gov.nasa.worldwind.SelectEvent.UnknownEventAction";
    }

    public Point getPickPoint() {
        return this.pickPoint;
    }

    public Rectangle getPickRectangle() {
        return this.pickRect;
    }

    public MouseEvent getMouseEvent() {
        return this.mouseEvent;
    }

    public boolean hasObjects() {
        return this.pickedObjects != null && this.pickedObjects.size() > 0;
    }

    public PickedObjectList getObjects() {
        return this.pickedObjects;
    }

    public PickedObject getTopPickedObject() {
        return this.hasObjects() ? this.pickedObjects.getTopPickedObject() : null;
    }

    public Object getTopObject() {
        PickedObject pickedObject = this.getTopPickedObject();
        return pickedObject != null ? pickedObject.getObject() : null;
    }

    public List<PickedObject> getAllTopPickedObjects() {
        return this.hasObjects() ? this.pickedObjects.getAllTopPickedObjects() : null;
    }

    public List<?> getAllTopObjects() {
        return this.hasObjects() ? this.pickedObjects.getAllTopObjects() : null;
    }

    public boolean isRollover() {
        return this.getEventAction() == ROLLOVER;
    }

    public boolean isHover() {
        return this.getEventAction() == HOVER;
    }

    public boolean isDragEnd() {
        return this.getEventAction() == DRAG_END;
    }

    public boolean isDrag() {
        return this.getEventAction() == DRAG;
    }

    public boolean isRightPress() {
        return this.getEventAction() == RIGHT_PRESS;
    }

    public boolean isRightClick() {
        return this.getEventAction() == RIGHT_CLICK;
    }

    public boolean isLeftDoubleClick() {
        return this.getEventAction() == LEFT_DOUBLE_CLICK;
    }

    public boolean isLeftClick() {
        return this.getEventAction() == LEFT_CLICK;
    }

    public boolean isLeftPress() {
        return this.getEventAction() == LEFT_PRESS;
    }

    public boolean isBoxSelect() {
        return this.getEventAction() == BOX_ROLLOVER;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName() + " " + (this.eventAction != null ? this.eventAction : Logging.getMessage("generic.Unknown")));
        if (this.pickedObjects != null && this.pickedObjects.getTopObject() != null) {
            stringBuilder.append(", ").append(this.pickedObjects.getTopObject().getClass().getName());
        }
        return stringBuilder.toString();
    }
}

