/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.AbstractDataRasterWriter;
import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.WWIO;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;

public class ImageIORasterWriter
extends AbstractDataRasterWriter {
    private boolean writeGeoreferenceFiles;

    public ImageIORasterWriter(boolean bl) {
        super(ImageIO.getWriterMIMETypes(), ImageIORasterWriter.getImageIOWriterSuffixes());
        this.writeGeoreferenceFiles = bl;
    }

    public ImageIORasterWriter() {
        this(true);
    }

    public boolean isWriteGeoreferenceFiles() {
        return this.writeGeoreferenceFiles;
    }

    public void setWriteGeoreferenceFiles(boolean bl) {
        this.writeGeoreferenceFiles = bl;
    }

    @Override
    protected boolean doCanWrite(DataRaster dataRaster, String string, File file) {
        return dataRaster != null && dataRaster instanceof BufferedImageRaster;
    }

    @Override
    protected void doWrite(DataRaster dataRaster, String string, File file) throws IOException {
        this.writeImage(dataRaster, string, file);
        if (this.isWriteGeoreferenceFiles()) {
            AVListImpl aVListImpl = new AVListImpl();
            this.initWorldFileParams(dataRaster, aVListImpl);
            File file2 = file.getParentFile();
            String string2 = WWIO.replaceSuffix(file.getName(), "");
            String string3 = WWIO.getSuffix(file.getName());
            String string4 = this.suffixForWorldFile(string3);
            this.writeImageMetadata(new File(file2, string2 + "." + string4), aVListImpl);
        }
    }

    protected void writeImage(DataRaster dataRaster, String string, File file) throws IOException {
        BufferedImageRaster bufferedImageRaster = (BufferedImageRaster)dataRaster;
        BufferedImage bufferedImage = bufferedImageRaster.getBufferedImage();
        ImageIO.write((RenderedImage)bufferedImage, string, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeImageMetadata(File file, AVList aVList) throws IOException {
        Sector sector = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
        int[] nArray = (int[])aVList.getValue("gov.nasa.worldwind.worldFile.ImageSize");
        double d = sector.getDeltaLonDegrees() / (double)nArray[0];
        double d2 = -sector.getDeltaLatDegrees() / (double)nArray[1];
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = sector.getMinLongitude().degrees + d * 0.5;
        double d6 = sector.getMaxLatitude().degrees + d2 * 0.5;
        PrintWriter printWriter = new PrintWriter(file);
        try {
            printWriter.println(d);
            printWriter.println(d3);
            printWriter.println(d4);
            printWriter.println(d2);
            printWriter.println(d5);
            printWriter.println(d6);
        }
        finally {
            printWriter.close();
        }
    }

    protected String suffixForWorldFile(String string) {
        int n = string.length();
        if (n < 2) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Character.toLowerCase(string.charAt(0)));
        stringBuilder.append(Character.toLowerCase(string.charAt(n - 1)));
        stringBuilder.append("w");
        return stringBuilder.toString();
    }

    protected void initWorldFileParams(DataRaster dataRaster, AVList aVList) {
        int[] nArray = new int[]{dataRaster.getWidth(), dataRaster.getHeight()};
        aVList.setValue("gov.nasa.worldwind.worldFile.ImageSize", nArray);
        Sector sector = dataRaster.getSector();
        aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
    }

    private static String[] getImageIOWriterSuffixes() {
        String[] stringArray;
        Iterator<ImageWriterSpi> iterator;
        try {
            iterator = IIORegistry.getDefaultInstance().getServiceProviders(ImageWriterSpi.class, true);
        }
        catch (Exception exception) {
            return new String[0];
        }
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            stringArray = iterator.next();
            String[] stringArray2 = stringArray.getFileSuffixes();
            hashSet.addAll(Arrays.asList(stringArray2));
        }
        stringArray = new String[hashSet.size()];
        hashSet.toArray(stringArray);
        return stringArray;
    }
}

