/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.animation;

import gov.nasa.worldwind.animation.AngleAnimator;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.util.PropertyAccessor;

public class RotateToAngleAnimator
extends AngleAnimator {
    private double minEpsilon = 1.0E-4;
    private double smoothing = 0.9;

    public RotateToAngleAnimator(Angle angle, Angle angle2, double d, PropertyAccessor.AngleAccessor angleAccessor) {
        super(null, angle, angle2, angleAccessor);
        this.smoothing = d;
    }

    @Override
    public void next() {
        if (this.hasNext()) {
            this.set(1.0 - this.smoothing);
        }
    }

    @Override
    protected void setImpl(double d) {
        Angle angle = this.nextAngle(d);
        if (angle == null) {
            return;
        }
        boolean bl = this.propertyAccessor.setAngle(angle);
        if (!bl) {
            this.flagLastStateInvalid();
        }
        if (d >= 1.0) {
            this.stop();
        }
    }

    public Angle nextAngle(double d) {
        boolean bl;
        Angle angle = this.end;
        Angle angle2 = this.propertyAccessor.getAngle();
        double d2 = Math.abs(angle.subtract((Angle)angle2).degrees);
        boolean bl2 = bl = d2 < this.minEpsilon;
        if (bl) {
            this.stop();
        } else {
            angle = Angle.mix(d, angle2, this.end);
        }
        return angle;
    }
}

