/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h4;

import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdflib.HDFChunkInfo;
import ncsa.hdf.hdflib.HDFCompInfo;
import ncsa.hdf.hdflib.HDFDeflateCompInfo;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFJPEGCompInfo;
import ncsa.hdf.hdflib.HDFLibrary;
import ncsa.hdf.hdflib.HDFNBITCompInfo;
import ncsa.hdf.hdflib.HDFSKPHUFFCompInfo;
import ncsa.hdf.hdflib.HDFSZIPCompInfo;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.h4.H4Datatype;
import ncsa.hdf.object.h4.H4File;

public class H4SDS
extends ScalarDS {
    private static final long serialVersionUID = 2557157923292438696L;
    public static final int DFTAG_NDG_NETCDF = 67687001;
    private List attributeList;
    private int sdid;
    private int datatypeID = -1;
    private int nAttributes = -1;

    public H4SDS(FileFormat theFile, String name, String path) {
        this(theFile, name, path, null);
    }

    public H4SDS(FileFormat theFile, String name, String path, long[] oid) {
        super(theFile, name, path, oid);
        this.unsignedConverted = false;
        this.sdid = ((H4File)this.getFileFormat()).getSDAccessID();
    }

    @Override
    public boolean hasAttribute() {
        if (this.nAttributes < 0) {
            this.sdid = ((H4File)this.getFileFormat()).getSDAccessID();
            int id = this.open();
            try {
                String[] objName = new String[]{""};
                int[] sdInfo = new int[]{0, 0, 0};
                int[] tmpDim = new int[32];
                HDFLibrary.SDgetinfo((int)id, (String[])objName, (int[])tmpDim, (int[])sdInfo);
                this.nAttributes = sdInfo[2];
            }
            catch (Exception ex) {
                this.nAttributes = 0;
            }
            this.close(id);
        }
        return this.nAttributes > 0;
    }

    @Override
    public byte[][] readPalette(int idx) {
        return null;
    }

    @Override
    public byte[] getPaletteRefs() {
        return null;
    }

    @Override
    public Datatype getDatatype() {
        if (this.datatype == null) {
            this.datatype = new H4Datatype(this.datatypeID);
        }
        return this.datatype;
    }

    @Override
    public Dataset copy(Group pgroup, String dname, long[] dims, Object buff) throws Exception {
        H4SDS dataset = null;
        int srcdid = -1;
        int dstdid = -1;
        int tid = -1;
        int size = 1;
        int theRank = 2;
        String path = null;
        int[] count = null;
        int[] start = null;
        if (pgroup == null) {
            return null;
        }
        if (dname == null) {
            dname = this.getName();
        }
        path = pgroup.isRoot() ? "/" : pgroup.getPath() + pgroup.getName() + "/";
        srcdid = this.open();
        if (srcdid < 0) {
            return null;
        }
        if (dims == null) {
            theRank = this.getRank();
            if (theRank <= 0) {
                this.init();
            }
            theRank = this.getRank();
            dims = this.getDims();
        } else {
            theRank = dims.length;
        }
        start = new int[theRank];
        count = new int[theRank];
        for (int i = 0; i < theRank; ++i) {
            start[i] = 0;
            count[i] = (int)dims[i];
            size *= count[i];
        }
        tid = this.datatypeID;
        dstdid = HDFLibrary.SDcreate((int)((H4File)pgroup.getFileFormat()).getSDAccessID(), (String)dname, (int)tid, (int)theRank, (int[])count);
        if (dstdid < 0) {
            return null;
        }
        int ref = HDFLibrary.SDidtoref((int)dstdid);
        if (!pgroup.isRoot()) {
            int vgid = pgroup.open();
            HDFLibrary.Vaddtagref((int)vgid, (int)720, (int)ref);
            pgroup.close(vgid);
        }
        this.copyAttribute(srcdid, dstdid);
        if (buff == null) {
            buff = new byte[size * HDFLibrary.DFKNTsize((int)tid)];
            HDFLibrary.SDreaddata((int)srcdid, (int[])start, null, (int[])count, (Object)buff);
        }
        HDFLibrary.SDwritedata((int)dstdid, (int[])start, null, (int[])count, (Object)buff);
        long[] oid = new long[]{720L, ref};
        dataset = new H4SDS(pgroup.getFileFormat(), dname, path, oid);
        pgroup.addToMemberList(dataset);
        this.close(srcdid);
        try {
            HDFLibrary.SDendaccess((int)dstdid);
        }
        catch (HDFException ex) {
            // empty catch block
        }
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readBytes() throws HDFException {
        int id;
        byte[] theData = null;
        if (this.rank <= 0) {
            this.init();
        }
        if ((id = this.open()) < 0) {
            return null;
        }
        int datasize = 1;
        int[] select = new int[this.rank];
        int[] start = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            datasize *= (int)this.selectedDims[i];
            select[i] = (int)this.selectedDims[i];
            start[i] = (int)this.startDims[i];
        }
        int[] stride = null;
        if (this.selectedStride != null) {
            stride = new int[this.rank];
            for (int i = 0; i < this.rank; ++i) {
                stride[i] = (int)this.selectedStride[i];
            }
        }
        try {
            int size = HDFLibrary.DFKNTsize((int)this.datatypeID) * datasize;
            theData = new byte[size];
            HDFLibrary.SDreaddata((int)id, (int[])start, (int[])stride, (int[])select, (byte[])theData);
        }
        finally {
            this.close(id);
        }
        return theData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read() throws HDFException {
        int id;
        String[] theData = null;
        if (this.rank <= 0) {
            this.init();
        }
        if ((id = this.open()) < 0) {
            return null;
        }
        int datasize = 1;
        int[] select = new int[this.rank];
        int[] start = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            datasize *= (int)this.selectedDims[i];
            select[i] = (int)this.selectedDims[i];
            start[i] = (int)this.startDims[i];
        }
        int[] stride = null;
        if (this.selectedStride != null) {
            stride = new int[this.rank];
            for (int i = 0; i < this.rank; ++i) {
                stride[i] = (int)this.selectedStride[i];
            }
        }
        try {
            theData = H4Datatype.allocateArray(this.datatypeID, datasize);
            if (theData != null) {
                HDFLibrary.HXsetdir((String)this.getFileFormat().getParent());
                boolean status = HDFLibrary.SDreaddata((int)id, (int[])start, (int[])stride, (int[])select, (Object)theData);
                if (this.isText) {
                    theData = H4SDS.byteToString((byte[])theData, select[0]);
                }
            }
        }
        finally {
            this.close(id);
        }
        if (this.fillValue == null && this.isImageDisplay) {
            try {
                this.getMetadata();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.isDefaultImageOrder = this.rank <= 1 || this.selectedIndex[0] <= this.selectedIndex[1];
        return theData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Object buf) throws HDFException {
        if (buf == null) {
            return;
        }
        int id = this.open();
        if (id < 0) {
            return;
        }
        int[] select = new int[this.rank];
        int[] start = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            select[i] = (int)this.selectedDims[i];
            start[i] = (int)this.startDims[i];
        }
        int[] stride = null;
        if (this.selectedStride != null) {
            stride = new int[this.rank];
            for (int i = 0; i < this.rank; ++i) {
                stride[i] = (int)this.selectedStride[i];
            }
        }
        Object tmpData = buf;
        try {
            if (this.isUnsigned && this.unsignedConverted) {
                tmpData = H4SDS.convertToUnsignedC(buf);
            }
            HDFLibrary.HXsetdir((String)this.getFileFormat().getParent());
            HDFLibrary.SDwritedata((int)id, (int[])start, (int[])stride, (int[])select, (Object)tmpData);
        }
        finally {
            tmpData = null;
            this.close(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getMetadata() throws HDFException {
        if (this.attributeList != null) {
            return this.attributeList;
        }
        int id = this.open();
        String[] objName = new String[]{""};
        int[] sdInfo = new int[]{0, 0, 0};
        try {
            int[] tmpDim = new int[32];
            HDFLibrary.SDgetinfo((int)id, (String[])objName, (int[])tmpDim, (int[])sdInfo);
            int n = sdInfo[2];
            if (this.attributeList == null && n > 0) {
                this.attributeList = new Vector(n, 5);
            }
            boolean b = false;
            String[] attrName = new String[1];
            int[] attrInfo = new int[]{0, 0};
            for (int i = 0; i < n; ++i) {
                attrName[0] = "";
                try {
                    b = HDFLibrary.SDattrinfo((int)id, (int)i, (String[])attrName, (int[])attrInfo);
                    attrInfo[0] = attrInfo[0] & 0xFFFFBFFF;
                }
                catch (HDFException ex) {
                    b = false;
                }
                if (!b) continue;
                long[] attrDims = new long[]{attrInfo[1]};
                Attribute attr = new Attribute(attrName[0], new H4Datatype(attrInfo[0]), attrDims);
                this.attributeList.add(attr);
                String[] buf = H4Datatype.allocateArray(attrInfo[0], attrInfo[1]);
                try {
                    HDFLibrary.SDreadattr((int)id, (int)i, (Object)buf);
                }
                catch (HDFException ex) {
                    buf = null;
                }
                if (buf == null) continue;
                if (attrInfo[0] == 4 || attrInfo[0] == 3) {
                    buf = Dataset.byteToString((byte[])buf, attrInfo[1]);
                } else if (attrName[0].equalsIgnoreCase("fillValue") || attrName[0].equalsIgnoreCase("_fillValue")) {
                    this.fillValue = buf;
                }
                attr.setValue(buf);
            }
        }
        finally {
            this.close(id);
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object info) throws Exception {
        if (!(info instanceof Attribute)) {
            return;
        }
        this.getFileFormat().writeAttribute(this, (Attribute)info, true);
        if (this.attributeList == null) {
            this.attributeList = new Vector();
        }
        this.attributeList.add(info);
    }

    @Override
    public void removeMetadata(Object info) throws HDFException {
    }

    @Override
    public int open() {
        int id = -1;
        try {
            int index = 0;
            int tag = (int)this.oid[0];
            index = tag == 67687001 ? (int)this.oid[1] : HDFLibrary.SDreftoindex((int)this.sdid, (int)((int)this.oid[1]));
            id = HDFLibrary.SDselect((int)this.sdid, (int)index);
        }
        catch (HDFException ex) {
            id = -1;
        }
        return id;
    }

    @Override
    public void close(int id) {
        try {
            HDFLibrary.SDendaccess((int)id);
        }
        catch (HDFException hDFException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.rank > 0) {
            return;
        }
        int id = this.open();
        String[] objName = new String[]{""};
        String[] dimName = new String[]{""};
        int[] dimInfo = new int[]{0, 0, 0};
        int[] sdInfo = new int[]{0, 0, 0};
        boolean isUnlimited = false;
        int[] idims = new int[32];
        try {
            HDFLibrary.SDgetinfo((int)id, (String[])objName, (int[])idims, (int[])sdInfo);
            sdInfo[1] = sdInfo[1] & 0xFFFFBFFF;
            this.nAttributes = sdInfo[2];
            this.rank = sdInfo[0];
            if (this.rank <= 0) {
                this.rank = 1;
                idims[0] = 1;
            }
            isUnlimited = HDFLibrary.SDisrecord((int)id);
            this.datatypeID = sdInfo[1];
            this.isText = this.datatypeID == 4 || this.datatypeID == 3;
            try {
                this.dimNames = new String[this.rank];
                for (int i = 0; i < this.rank; ++i) {
                    int dimid = HDFLibrary.SDgetdimid((int)id, (int)i);
                    HDFLibrary.SDdiminfo((int)dimid, (String[])dimName, (int[])dimInfo);
                    this.dimNames[i] = dimName[0];
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                HDFDeflateCompInfo comp;
                HDFCompInfo compInfo = new HDFCompInfo();
                boolean status = HDFLibrary.SDgetcompress((int)id, (HDFCompInfo)compInfo);
                if (compInfo.ctype == 4) {
                    comp = new HDFDeflateCompInfo();
                    HDFLibrary.SDgetcompress((int)id, (HDFCompInfo)comp);
                    this.compression = "GZIP(level=" + comp.level + ")";
                } else if (compInfo.ctype == 5) {
                    comp = new HDFSZIPCompInfo();
                    HDFLibrary.SDgetcompress((int)id, (HDFCompInfo)comp);
                    this.compression = "SZIP(bits_per_pixel=" + comp.bits_per_pixel + ",options_mask=" + comp.options_mask + ",pixels=" + comp.pixels + ",pixels_per_block=" + comp.pixels_per_block + ",pixels_per_scanline=" + comp.pixels_per_scanline + ")";
                } else if (compInfo.ctype == 7) {
                    comp = new HDFJPEGCompInfo();
                    HDFLibrary.SDgetcompress((int)id, (HDFCompInfo)comp);
                    this.compression = "JPEG(quality=" + comp.quality + ",options_mask=" + ",force_baseline=" + comp.force_baseline + ")";
                } else if (compInfo.ctype == 3) {
                    comp = new HDFSKPHUFFCompInfo();
                    HDFLibrary.SDgetcompress((int)id, (HDFCompInfo)comp);
                    this.compression = "SKPHUFF(skp_size=" + comp.skp_size + ")";
                } else if (compInfo.ctype == 1) {
                    this.compression = "RLE";
                } else if (compInfo.ctype == 2) {
                    comp = new HDFNBITCompInfo();
                    HDFLibrary.SDgetcompress((int)id, (HDFCompInfo)comp);
                    this.compression = "NBIT(nt=" + comp.nt + ",bit_len=" + comp.bit_len + ",ctype=" + comp.ctype + ",fill_one=" + comp.fill_one + ",sign_ext=" + comp.sign_ext + ",start_bit=" + comp.start_bit + ")";
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                HDFChunkInfo chunkInfo = new HDFChunkInfo();
                int[] cflag = new int[]{0};
                try {
                    boolean status = HDFLibrary.SDgetchunkinfo((int)id, (HDFChunkInfo)chunkInfo, (int[])cflag);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
                if (cflag[0] == 0) {
                    this.chunkSize = null;
                } else {
                    this.chunkSize = new long[this.rank];
                    for (int i = 0; i < this.rank; ++i) {
                        this.chunkSize[i] = chunkInfo.chunk_lengths[i];
                    }
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        catch (HDFException ex) {
        }
        finally {
            this.close(id);
        }
        this.isUnsigned = H4Datatype.isUnsigned(this.datatypeID);
        if (idims == null) {
            return;
        }
        this.dims = new long[this.rank];
        this.maxDims = new long[this.rank];
        this.startDims = new long[this.rank];
        this.selectedDims = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.startDims[i] = 0L;
            this.selectedDims[i] = 1L;
            this.dims[i] = this.maxDims[i] = (long)idims[i];
        }
        if (isUnlimited) {
            this.maxDims[0] = -1L;
        }
        this.selectedIndex[0] = 0;
        this.selectedIndex[1] = 1;
        this.selectedIndex[2] = 2;
        if (this.rank == 1) {
            this.selectedDims[0] = this.dims[0];
        }
        if (this.rank > 1) {
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.isText ? 1L : this.dims[1];
        }
    }

    @Override
    public byte[][] getPalette() {
        return this.palette;
    }

    public static H4SDS create(String name, Group pgroup, Datatype type, long[] dims, long[] maxdims, long[] chunks, int gzip, Object fillValue, Object data) throws Exception {
        H4SDS dataset = null;
        if (pgroup == null || name == null || dims == null) {
            return null;
        }
        H4File file = (H4File)pgroup.getFileFormat();
        if (file == null) {
            return null;
        }
        String path = "/";
        if (!pgroup.isRoot()) {
            path = pgroup.getPath() + pgroup.getName() + "/";
        }
        int tsize = 1;
        int rank = dims.length;
        int[] idims = new int[rank];
        int[] start = new int[rank];
        for (int i = 0; i < rank; ++i) {
            idims[i] = (int)dims[i];
            start[i] = 0;
            tsize *= idims[i];
        }
        if (maxdims != null && maxdims[0] <= 0L) {
            idims[0] = 0;
        }
        int[] ichunks = null;
        if (chunks != null) {
            ichunks = new int[rank];
            for (int i = 0; i < rank; ++i) {
                ichunks[i] = (int)chunks[i];
            }
        }
        if (idims[0] == 0 && (ichunks != null || gzip > 0)) {
            throw new HDFException("Unlimted cannot be used with chunking or compression");
        }
        int sdid = file.getSDAccessID();
        int tid = type.toNative();
        int sdsid = HDFLibrary.SDcreate((int)sdid, (String)name, (int)tid, (int)rank, (int[])idims);
        int vsize = HDFLibrary.DFKNTsize((int)tid);
        byte[] fill = new byte[vsize];
        for (int i = 0; i < vsize; ++i) {
            fill[i] = 0;
        }
        HDFLibrary.SDsetfillvalue((int)sdsid, (byte[])fill);
        if (sdsid < 0) {
            throw new HDFException("Unable to create the new dataset.");
        }
        HDFDeflateCompInfo compInfo = null;
        if (gzip > 0) {
            compInfo = new HDFDeflateCompInfo();
            compInfo.level = gzip;
            if (chunks == null) {
                HDFLibrary.SDsetcompress((int)sdsid, (int)4, (HDFCompInfo)compInfo);
            }
        }
        if (chunks != null) {
            HDFChunkInfo chunkInfo = new HDFChunkInfo(ichunks);
            int flag = 1;
            if (gzip > 0) {
                flag = 3;
                chunkInfo = new HDFChunkInfo(ichunks, 4, (HDFCompInfo)compInfo);
            }
            try {
                HDFLibrary.SDsetchunk((int)sdsid, (HDFChunkInfo)chunkInfo, (int)flag);
            }
            catch (Throwable err) {
                err.printStackTrace();
                throw new HDFException("SDsetchunk failed.");
            }
        }
        if (sdsid > 0 && data != null) {
            HDFLibrary.SDwritedata((int)sdsid, (int[])start, null, (int[])idims, (Object)data);
        }
        int ref = HDFLibrary.SDidtoref((int)sdsid);
        if (!pgroup.isRoot()) {
            int vgid = pgroup.open();
            if (vgid < 0) {
                if (sdsid > 0) {
                    HDFLibrary.SDendaccess((int)sdsid);
                }
                throw new HDFException("Unable to open the parent group.");
            }
            HDFLibrary.Vaddtagref((int)vgid, (int)720, (int)ref);
            pgroup.close(vgid);
        }
        try {
            if (sdsid > 0) {
                HDFLibrary.SDendaccess((int)sdsid);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        long[] oid = new long[]{720L, ref};
        dataset = new H4SDS(file, name, path, oid);
        if (dataset != null) {
            pgroup.addToMemberList(dataset);
        }
        return dataset;
    }

    public static H4SDS create(String name, Group pgroup, Datatype type, long[] dims, long[] maxdims, long[] chunks, int gzip, Object data) throws Exception {
        return H4SDS.create(name, pgroup, type, dims, maxdims, chunks, gzip, null, data);
    }

    private void copyAttribute(int srcdid, int dstdid) {
        try {
            String[] objName = new String[]{""};
            int[] sdInfo = new int[]{0, 0, 0};
            int[] tmpDim = new int[32];
            HDFLibrary.SDgetinfo((int)srcdid, (String[])objName, (int[])tmpDim, (int[])sdInfo);
            int numberOfAttributes = sdInfo[2];
            boolean b = false;
            String[] attrName = new String[1];
            int[] attrInfo = new int[]{0, 0};
            for (int i = 0; i < numberOfAttributes; ++i) {
                attrName[0] = "";
                try {
                    b = HDFLibrary.SDattrinfo((int)srcdid, (int)i, (String[])attrName, (int[])attrInfo);
                }
                catch (HDFException ex) {
                    b = false;
                }
                if (!b) continue;
                byte[] attrBuff = new byte[attrInfo[1] * HDFLibrary.DFKNTsize((int)attrInfo[0])];
                try {
                    HDFLibrary.SDreadattr((int)srcdid, (int)i, (byte[])attrBuff);
                }
                catch (HDFException ex) {
                    attrBuff = null;
                }
                if (attrBuff == null) continue;
                HDFLibrary.SDsetattr((int)dstdid, (String)attrName[0], (int)attrInfo[0], (int)attrInfo[1], (byte[])attrBuff);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List getMetadata(int ... attrPropList) throws Exception {
        throw new UnsupportedOperationException("getMetadata(int... attrPropList) is not supported");
    }
}

