/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.HObject;

public abstract class Group
extends HObject {
    private static final long serialVersionUID = 3913174542591568052L;
    private List<HObject> memberList;
    protected Group parent;
    protected int nMembersInFile;
    public static final int LINK_TYPE_HARD = 0;
    public static final int LINK_TYPE_SOFT = 1;
    public static final int LINK_TYPE_EXTERNAL = 64;
    public static final int CRT_ORDER_TRACKED = 1;
    public static final int CRT_ORDER_INDEXED = 2;

    public Group(FileFormat theFile, String name, String path, Group parent) {
        this(theFile, name, path, parent, null);
    }

    @Deprecated
    public Group(FileFormat theFile, String name, String path, Group parent, long[] oid) {
        super(theFile, name, path, oid);
        this.parent = parent;
    }

    public void clear() {
        if (this.memberList != null) {
            ((Vector)this.memberList).setSize(0);
        }
    }

    public void addToMemberList(HObject object) {
        if (this.memberList == null) {
            int size = Math.min(this.getNumberOfMembersInFile(), this.getFileFormat().getMaxMembers());
            this.memberList = new Vector<HObject>(size + 5);
        }
        if (object != null && !this.memberList.contains(object)) {
            this.memberList.add(object);
        }
    }

    public void removeFromMemberList(HObject object) {
        if (this.memberList != null) {
            this.memberList.remove(object);
        }
    }

    public List<HObject> getMemberList() {
        FileFormat theFile = this.getFileFormat();
        String thePath = this.getPath();
        String theName = this.getName();
        if (this.memberList == null && theFile != null) {
            int size = Math.min(this.getNumberOfMembersInFile(), this.getFileFormat().getMaxMembers());
            this.memberList = new Vector<HObject>(size + 5);
            try {
                theFile.open();
            }
            catch (Exception ex) {
                // empty catch block
            }
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)theFile.getRootNode();
            if (root == null) {
                return this.memberList;
            }
            Enumeration<TreeNode> emu = root.depthFirstEnumeration();
            Group g = null;
            Object uObj = null;
            while (emu.hasMoreElements()) {
                uObj = ((DefaultMutableTreeNode)emu.nextElement()).getUserObject();
                if (!(uObj instanceof Group) || (g = (Group)uObj).getPath() == null || (!this.isRoot() || !g.isRoot()) && (!thePath.equals(g.getPath()) || !g.getName().endsWith(theName))) continue;
                this.memberList = g.getMemberList();
                break;
            }
        }
        return this.memberList;
    }

    @Override
    public void setName(String newName) throws Exception {
        super.setName(newName);
        if (this.memberList != null) {
            int n = this.memberList.size();
            HObject theObj = null;
            for (int i = 0; i < n; ++i) {
                theObj = this.memberList.get(i);
                theObj.setPath(this.getPath() + newName + "/");
            }
        }
    }

    public final Group getParent() {
        return this.parent;
    }

    public final boolean isRoot() {
        return this.parent == null;
    }

    public int getNumberOfMembersInFile() {
        return this.nMembersInFile;
    }
}

