/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gui.swing;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.IllegalFilterException;
import org.geotools.gui.swing.HighlightManager;
import org.geotools.gui.swing.SelectionManager;
import org.geotools.gui.swing.event.HighlightChangeListener;
import org.geotools.gui.swing.event.HighlightChangedEvent;
import org.geotools.gui.swing.event.SelectionChangeListener;
import org.geotools.gui.swing.event.SelectionChangedEvent;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.map.event.MapLayerListEvent;
import org.geotools.map.event.MapLayerListListener;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.LabelCacheDefault;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Contains;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMapPane
extends JPanel
implements MouseListener,
MouseMotionListener,
HighlightChangeListener,
SelectionChangeListener,
PropertyChangeListener,
MapLayerListListener {
    private static final long serialVersionUID = -8647971481359690499L;
    public static final int Reset = 0;
    public static final int ZoomIn = 1;
    public static final int ZoomOut = 2;
    public static final int Pan = 3;
    public static final int Select = 4;
    private static final int POLYGON = 0;
    private static final int LINE = 1;
    private static final int POINT = 2;
    GTRenderer renderer;
    private GTRenderer highlightRenderer;
    private GTRenderer selectionRenderer;
    MapContext context;
    private MapContext selectionContext;
    Envelope mapArea;
    private Rectangle oldRect = null;
    private Envelope oldMapArea = null;
    private BufferedImage baseImage;
    private BufferedImage selectImage;
    private Style selectionStyle;
    private MapLayer selectionLayer;
    private MapLayer highlightLayer;
    private HighlightManager highlightManager;
    private boolean highlight = true;
    FilterFactory2 ff;
    GeometryFactory gf = new GeometryFactory();
    FeatureCollection selection;
    FeatureCollection highlightFeature;
    private int state = 1;
    private double zoomFactor = 2.0;
    Style lineHighlightStyle;
    Style pointHighlightStyle;
    Style polygonHighlightStyle;
    Style polygonSelectionStyle;
    Style pointSelectionStyle;
    Style lineSelectionStyle;
    boolean changed = true;
    LabelCache labelCache = new LabelCacheDefault();
    private boolean reset = false;
    int startX;
    int startY;
    private boolean clickable;
    int lastX;
    int lastY;
    private SelectionManager selectionManager;

    public JMapPane() {
        this(null, true, null, null);
    }

    public JMapPane(GTRenderer render, MapContext context) {
        this(null, true, render, context);
    }

    public JMapPane(LayoutManager layout, boolean isDoubleBuffered, GTRenderer render, MapContext context) {
        super(layout, isDoubleBuffered);
        this.ff = (FilterFactory2)CommonFactoryFinder.getFilterFactory(null);
        this.setRenderer(render);
        this.setContext(context);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setHighlightManager(new HighlightManager(this.highlightLayer));
        this.setSelectionManager(new SelectionManager(this.selectionLayer));
        this.lineHighlightStyle = this.setupStyle(1, Color.red);
        this.pointHighlightStyle = this.setupStyle(2, Color.red);
        this.polygonHighlightStyle = this.setupStyle(0, Color.red);
        this.polygonSelectionStyle = this.setupStyle(0, Color.cyan);
        this.pointSelectionStyle = this.setupStyle(2, Color.cyan);
        this.lineSelectionStyle = this.setupStyle(1, Color.cyan);
        this.setCursor(new Cursor(1));
    }

    public GTRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(GTRenderer renderer) {
        Map<String, Boolean> hints = new HashMap();
        if (renderer instanceof StreamingRenderer) {
            hints = renderer.getRendererHints();
            if (hints == null) {
                hints = new HashMap();
            }
            if (hints.containsKey("labelCache")) {
                this.labelCache = (LabelCache)hints.get("labelCache");
            } else {
                hints.put("labelCache", (Boolean)this.labelCache);
            }
            renderer.setRendererHints(hints);
        }
        this.renderer = renderer;
        this.highlightRenderer = new StreamingRenderer();
        this.selectionRenderer = new StreamingRenderer();
        hints.put("memoryPreloadingEnabled", Boolean.FALSE);
        this.highlightRenderer.setRendererHints(hints);
        this.selectionRenderer.setRendererHints(hints);
        if (this.context != null) {
            this.renderer.setContext(this.context);
        }
    }

    public MapContext getContext() {
        return this.context;
    }

    public void setContext(MapContext context) {
        if (this.context != null) {
            this.context.removeMapLayerListListener((MapLayerListListener)this);
        }
        this.context = context;
        if (context != null) {
            this.context.addMapLayerListListener((MapLayerListListener)this);
        }
        if (this.renderer != null) {
            this.renderer.setContext(this.context);
        }
    }

    public Envelope getMapArea() {
        return this.mapArea;
    }

    public void setMapArea(Envelope mapArea) {
        this.mapArea = mapArea;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public MapLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    public void setSelectionLayer(MapLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
        if (this.selectionManager != null) {
            this.selectionManager.setSelectionLayer(selectionLayer);
        }
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
    }

    public MapLayer getHighlightLayer() {
        return this.highlightLayer;
    }

    public void setHighlightLayer(MapLayer highlightLayer) {
        this.highlightLayer = highlightLayer;
        if (this.highlightManager != null) {
            this.highlightManager.setHighlightLayer(highlightLayer);
        }
    }

    public HighlightManager getHighlightManager() {
        return this.highlightManager;
    }

    public void setHighlightManager(HighlightManager highlightManager) {
        this.highlightManager = highlightManager;
        this.highlightManager.addHighlightChangeListener(this);
        this.addMouseMotionListener(this.highlightManager);
    }

    public Style getLineHighlightStyle() {
        return this.lineHighlightStyle;
    }

    public void setLineHighlightStyle(Style lineHighlightStyle) {
        this.lineHighlightStyle = lineHighlightStyle;
    }

    public Style getLineSelectionStyle() {
        return this.lineSelectionStyle;
    }

    public void setLineSelectionStyle(Style lineSelectionStyle) {
        this.lineSelectionStyle = lineSelectionStyle;
    }

    public Style getPointHighlightStyle() {
        return this.pointHighlightStyle;
    }

    public void setPointHighlightStyle(Style pointHighlightStyle) {
        this.pointHighlightStyle = pointHighlightStyle;
    }

    public Style getPointSelectionStyle() {
        return this.pointSelectionStyle;
    }

    public void setPointSelectionStyle(Style pointSelectionStyle) {
        this.pointSelectionStyle = pointSelectionStyle;
    }

    public Style getPolygonHighlightStyle() {
        return this.polygonHighlightStyle;
    }

    public void setPolygonHighlightStyle(Style polygonHighlightStyle) {
        this.polygonHighlightStyle = polygonHighlightStyle;
    }

    public Style getPolygonSelectionStyle() {
        return this.polygonSelectionStyle;
    }

    public void setPolygonSelectionStyle(Style polygonSelectionStyle) {
        this.polygonSelectionStyle = polygonSelectionStyle;
    }

    @Override
    protected void paintComponent(Graphics g) {
        String type;
        super.paintComponent(g);
        if (this.renderer == null || this.mapArea == null) {
            return;
        }
        Rectangle r = this.getBounds();
        Rectangle dr = new Rectangle(r.width, r.height);
        if (!r.equals(this.oldRect) || this.reset) {
            if (!r.equals(this.oldRect)) {
                try {
                    this.mapArea = this.context.getLayerBounds();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.changed = true;
            this.reset = false;
            this.oldRect = r;
            this.mapArea = this.fixAspectRatio(r, this.mapArea);
        }
        if (!this.mapArea.equals((Object)this.oldMapArea)) {
            this.changed = true;
            this.oldMapArea = this.mapArea;
            this.context.setAreaOfInterest(this.mapArea, this.context.getCoordinateReferenceSystem());
        }
        if (this.changed) {
            this.changed = false;
            this.baseImage = new BufferedImage(dr.width, dr.height, 2);
            Graphics2D ig = this.baseImage.createGraphics();
            this.renderer.setContext(this.context);
            this.labelCache.clear();
            this.renderer.paint(ig, dr, this.mapArea);
        }
        ((Graphics2D)g).drawImage((Image)this.baseImage, 0, 0, this);
        if (this.selection != null && this.selection.size() > 0) {
            type = this.selectionLayer.getFeatureSource().getSchema().getGeometryDescriptor().getType().getBinding().getName();
            if (type == null) {
                type = "polygon";
            }
            if (type.toLowerCase().endsWith("polygon")) {
                this.selectionStyle = this.polygonSelectionStyle;
            } else if (type.toLowerCase().endsWith("point")) {
                this.selectionStyle = this.pointSelectionStyle;
            } else if (type.toLowerCase().endsWith("line")) {
                this.selectionStyle = this.lineSelectionStyle;
            }
            this.selectionContext = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            this.selectionContext.addLayer(this.selection, this.selectionStyle);
            this.selectionRenderer.setContext(this.selectionContext);
            this.selectImage = new BufferedImage(dr.width, dr.height, 2);
            Graphics2D ig = this.selectImage.createGraphics();
            this.selectionRenderer.paint(ig, dr, this.mapArea);
            ((Graphics2D)g).drawImage((Image)this.selectImage, 0, 0, this);
        }
        if (this.highlight && this.highlightFeature != null && this.highlightFeature.size() > 0) {
            type = this.highlightLayer.getFeatureSource().getSchema().getGeometryDescriptor().getType().getBinding().getName();
            if (type == null) {
                type = "polygon";
            }
            Style highlightStyle = null;
            if (type.toLowerCase().endsWith("polygon")) {
                highlightStyle = this.polygonHighlightStyle;
            } else if (type.toLowerCase().endsWith("point")) {
                highlightStyle = this.pointHighlightStyle;
            } else if (type.toLowerCase().endsWith("line")) {
                highlightStyle = this.lineHighlightStyle;
            }
            DefaultMapContext highlightContext = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            highlightContext.addLayer(this.highlightFeature, highlightStyle);
            this.highlightRenderer.setContext((MapContext)highlightContext);
            this.highlightRenderer.paint((Graphics2D)g, dr, this.mapArea);
        }
    }

    private Envelope fixAspectRatio(Rectangle r, Envelope mapArea) {
        double mapWidth = mapArea.getWidth();
        double mapHeight = mapArea.getHeight();
        double scaleX = r.getWidth() / mapArea.getWidth();
        double scaleY = r.getHeight() / mapArea.getHeight();
        double scale = 1.0;
        scale = scaleX < scaleY ? scaleX : scaleY;
        double deltaX = r.getWidth() / scale - mapWidth;
        double deltaY = r.getHeight() / scale - mapHeight;
        Coordinate ll = new Coordinate(mapArea.getMinX() - deltaX / 2.0, mapArea.getMinY() - deltaY / 2.0);
        Coordinate ur = new Coordinate(mapArea.getMaxX() + deltaX / 2.0, mapArea.getMaxY() + deltaY / 2.0);
        return new Envelope(ll, ur);
    }

    public void doSelection(double x, double y, MapLayer layer) {
        Point geometry = this.gf.createPoint(new Coordinate(x, y));
        this.findFeature((Geometry)geometry, layer);
    }

    private void findFeature(Geometry geometry, MapLayer layer) throws IndexOutOfBoundsException {
        Contains f = null;
        if (this.context == null || layer == null) {
            return;
        }
        try {
            String name = layer.getFeatureSource().getSchema().getGeometryDescriptor().getLocalName();
            if (name == "") {
                name = "the_geom";
            }
            try {
                f = this.ff.contains((Expression)this.ff.property(name), (Expression)this.ff.literal((Object)geometry));
                if (this.selectionManager != null) {
                    System.out.println("selection changed");
                    this.selectionManager.selectionChanged(this, (Filter)f);
                }
            }
            catch (IllegalFilterException e) {
                e.printStackTrace();
            }
        }
        catch (IllegalFilterException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Rectangle bounds = this.getBounds();
        double x = e.getX();
        double y = e.getY();
        double width = this.mapArea.getWidth();
        double height = this.mapArea.getHeight();
        double width2 = this.mapArea.getWidth() / 2.0;
        double height2 = this.mapArea.getHeight() / 2.0;
        double mapX = x * width / (double)bounds.width + this.mapArea.getMinX();
        double mapY = (bounds.getHeight() - y) * height / (double)bounds.height + this.mapArea.getMinY();
        double zlevel = 1.0;
        switch (this.state) {
            case 3: {
                zlevel = 1.0;
                break;
            }
            case 1: {
                zlevel = this.zoomFactor;
                break;
            }
            case 2: {
                zlevel = 1.0 / this.zoomFactor;
                break;
            }
            case 4: {
                this.doSelection(mapX, mapY, this.selectionLayer);
                return;
            }
            default: {
                return;
            }
        }
        Coordinate ll = new Coordinate(mapX - width2 / zlevel, mapY - height2 / zlevel);
        Coordinate ur = new Coordinate(mapX + width2 / zlevel, mapY + height2 / zlevel);
        this.mapArea = new Envelope(ll, ur);
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.startX = e.getX();
        this.startY = e.getY();
        this.lastX = 0;
        this.lastY = 0;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int endX = e.getX();
        int endY = e.getY();
        if (this.state == 1 || this.state == 2) {
            this.drawRectangle(this.getGraphics());
        }
        this.processDrag(this.startX, this.startY, endX, endY);
        this.lastX = 0;
        this.lastY = 0;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Graphics graphics = this.getGraphics();
        int x = e.getX();
        int y = e.getY();
        if (this.state == 3) {
            if (this.lastX > 0 && this.lastY > 0) {
                int dx = this.lastX - this.startX;
                int dy = this.lastY - this.startY;
                graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                ((Graphics2D)graphics).drawImage((Image)this.baseImage, dx, dy, this);
            }
            this.lastX = x;
            this.lastY = y;
        } else if (this.state == 1 || this.state == 2) {
            graphics.setXORMode(Color.RED);
            if (this.lastX > 0 && this.lastY > 0) {
                this.drawRectangle(graphics);
            }
            this.lastX = x;
            this.lastY = y;
            this.drawRectangle(graphics);
        } else if (this.state == 4 && this.selectionLayer != null) {
            Rectangle bounds = this.getBounds();
            double mapWidth = this.mapArea.getWidth();
            double mapHeight = this.mapArea.getHeight();
            double x1 = (double)this.startX * mapWidth / (double)bounds.width + this.mapArea.getMinX();
            double y1 = (bounds.getHeight() - (double)this.startY) * mapHeight / (double)bounds.height + this.mapArea.getMinY();
            double x2 = (double)x * mapWidth / (double)bounds.width + this.mapArea.getMinX();
            double y2 = (bounds.getHeight() - (double)y) * mapHeight / (double)bounds.height + this.mapArea.getMinY();
            double left = Math.min(x1, x2);
            double right = Math.max(x1, x2);
            double bottom = Math.min(y1, y2);
            double top = Math.max(y1, y2);
            String name = this.selectionLayer.getFeatureSource().getSchema().getGeometryDescriptor().getLocalName();
            if (name == "") {
                name = "the_geom";
            }
            BBOX bb = this.ff.bbox((Expression)this.ff.property(name), left, bottom, right, top, this.getContext().getCoordinateReferenceSystem().toString());
            if (this.selectionManager != null) {
                this.selectionManager.selectionChanged(this, (Filter)bb);
            }
            graphics.setXORMode(Color.green);
            this.lastX = x;
            this.lastY = y;
            this.drawRectangle(graphics);
        }
    }

    private void processDrag(int x1, int y1, int x2, int y2) {
        if (x1 == x2 && y1 == y2) {
            if (this.isClickable()) {
                this.mouseClicked(new MouseEvent(this, 0, new Date().getTime(), 0, x1, y1, y2, false));
            }
            return;
        }
        Rectangle bounds = this.getBounds();
        double mapWidth = this.mapArea.getWidth();
        double mapHeight = this.mapArea.getHeight();
        double startX = (double)x1 * mapWidth / (double)bounds.width + this.mapArea.getMinX();
        double startY = (bounds.getHeight() - (double)y1) * mapHeight / (double)bounds.height + this.mapArea.getMinY();
        double endX = (double)x2 * mapWidth / (double)bounds.width + this.mapArea.getMinX();
        double endY = (bounds.getHeight() - (double)y2) * mapHeight / (double)bounds.height + this.mapArea.getMinY();
        if (this.state == 3) {
            double deltaX1 = endX - startX;
            double left = this.mapArea.getMinX() - deltaX1;
            double right = this.mapArea.getMaxX() - deltaX1;
            double deltaY1 = endY - startY;
            double bottom = this.mapArea.getMinY() - deltaY1;
            double top = this.mapArea.getMaxY() - deltaY1;
            Coordinate ll = new Coordinate(left, bottom);
            Coordinate ur = new Coordinate(right, top);
            this.mapArea = this.fixAspectRatio(this.getBounds(), new Envelope(ll, ur));
        } else if (this.state == 1) {
            double left = Math.min(startX, endX);
            double right = Math.max(startX, endX);
            double bottom = Math.min(startY, endY);
            double top = Math.max(startY, endY);
            Coordinate ll = new Coordinate(left, bottom);
            Coordinate ur = new Coordinate(right, top);
            this.mapArea = this.fixAspectRatio(this.getBounds(), new Envelope(ll, ur));
        } else if (this.state == 2) {
            double left = Math.min(startX, endX);
            double right = Math.max(startX, endX);
            double bottom = Math.min(startY, endY);
            double top = Math.max(startY, endY);
            double nWidth = mapWidth * mapWidth / (right - left);
            double nHeight = mapHeight * mapHeight / (top - bottom);
            double deltaX1 = left - this.mapArea.getMinX();
            double nDeltaX1 = deltaX1 * nWidth / mapWidth;
            double deltaY1 = bottom - this.mapArea.getMinY();
            double nDeltaY1 = deltaY1 * nHeight / mapHeight;
            Coordinate ll = new Coordinate(this.mapArea.getMinX() - nDeltaX1, this.mapArea.getMinY() - nDeltaY1);
            double deltaX2 = this.mapArea.getMaxX() - right;
            double nDeltaX2 = deltaX2 * nWidth / mapWidth;
            double deltaY2 = this.mapArea.getMaxY() - top;
            double nDeltaY2 = deltaY2 * nHeight / mapHeight;
            Coordinate ur = new Coordinate(this.mapArea.getMaxX() + nDeltaX2, this.mapArea.getMaxY() + nDeltaY2);
            this.mapArea = this.fixAspectRatio(this.getBounds(), new Envelope(ll, ur));
        } else if (this.state == 4 && this.selectionLayer != null) {
            double left = Math.min(startX, endX);
            double right = Math.max(startX, endX);
            double bottom = Math.min(startY, endY);
            double top = Math.max(startY, endY);
            String name = this.selectionLayer.getFeatureSource().getSchema().getGeometryDescriptor().getLocalName();
            if (name == "") {
                name = "the_geom";
            }
            BBOX bb = this.ff.bbox((Expression)this.ff.property(name), left, bottom, right, top, this.getContext().getCoordinateReferenceSystem().toString());
            if (this.selectionManager != null) {
                this.selectionManager.selectionChanged(this, (Filter)bb);
            }
        }
        this.repaint();
    }

    private boolean isClickable() {
        return this.clickable;
    }

    private Style setupStyle(int type, Color color) {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
        StyleBuilder sb = new StyleBuilder();
        Style s = sf.createStyle();
        s.setTitle("selection");
        PolygonSymbolizer ps = sb.createPolygonSymbolizer(color);
        ps.setStroke(sb.createStroke(color));
        LineSymbolizer ls = sb.createLineSymbolizer(color);
        Graphic h = sb.createGraphic();
        h.setMarks(new Mark[]{sb.createMark("square", color)});
        PointSymbolizer pts = sb.createPointSymbolizer(h);
        switch (type) {
            case 0: {
                s = sb.createStyle((Symbolizer)ps);
                break;
            }
            case 2: {
                s = sb.createStyle((Symbolizer)pts);
                break;
            }
            case 1: {
                s = sb.createStyle((Symbolizer)ls);
            }
        }
        return s;
    }

    @Override
    public void highlightChanged(HighlightChangedEvent e) {
        Filter f = e.getFilter();
        try {
            this.highlightFeature = this.highlightLayer.getFeatureSource().getFeatures(f);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equalsIgnoreCase("crs")) {
            this.context.setAreaOfInterest((Envelope)this.context.getAreaOfInterest(), (CoordinateReferenceSystem)evt.getNewValue());
        }
    }

    public boolean isReset() {
        return this.reset;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }

    public void layerAdded(MapLayerListEvent event) {
        this.changed = true;
        if (this.context.getLayers().length == 1) {
            try {
                this.mapArea = this.context.getLayerBounds();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.reset = true;
        }
        this.repaint();
    }

    public void layerRemoved(MapLayerListEvent event) {
        this.changed = true;
        this.repaint();
    }

    public void layerChanged(MapLayerListEvent event) {
        this.changed = true;
        this.repaint();
    }

    public void layerMoved(MapLayerListEvent event) {
        this.changed = true;
        this.repaint();
    }

    private void drawRectangle(Graphics graphics) {
        int left = Math.min(this.startX, this.lastX);
        int right = Math.max(this.startX, this.lastX);
        int top = Math.max(this.startY, this.lastY);
        int bottom = Math.min(this.startY, this.lastY);
        int width = right - left;
        int height = top - bottom;
        graphics.drawRect(left, bottom, width, height);
    }

    public void setClickable(boolean clickable) {
        this.clickable = clickable;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public FeatureCollection<? extends FeatureType, ? extends Feature> getSelection() {
        return this.selection;
    }

    public void setSelection(FeatureCollection<? extends FeatureType, ? extends Feature> selection) {
        this.selection = selection;
        this.repaint();
    }

    @Override
    public void selectionChanged(SelectionChangedEvent e) {
        try {
            this.selection = this.selectionLayer.getFeatureSource().getFeatures(e.getFilter());
            this.repaint();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public void setSelectionManager(SelectionManager selectionManager) {
        this.selectionManager = selectionManager;
        this.selectionManager.addSelectionChangeListener(this);
    }
}

