/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DelegatingFeatureReader;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.MaxFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.ResourceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.crs.ReprojectFeatureReader;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ContentState;
import org.geotools.factory.Hints;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.visitor.PropertyNameResolvingVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContentFeatureSource
implements FeatureSource<SimpleFeatureType, SimpleFeature> {
    protected ContentEntry entry;
    protected Transaction transaction;
    protected Set<Hints.Key> hints;
    protected Query query;
    protected SimpleFeatureType schema;
    private QueryCapabilities queryCapabilities;

    public ContentFeatureSource(ContentEntry entry, Query query) {
        this.entry = entry;
        this.query = query;
        this.queryCapabilities = new QueryCapabilities();
        this.hints = new HashSet<Hints.Key>();
        this.hints.add((Hints.Key)Hints.JTS_GEOMETRY_FACTORY);
        this.hints.add((Hints.Key)Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
        this.hints.add(Hints.FEATURE_2D);
        this.addHints(this.hints);
        this.hints = Collections.unmodifiableSet(this.hints);
    }

    public ContentEntry getEntry() {
        return this.entry;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public ContentState getState() {
        return this.entry.getState(this.transaction);
    }

    public ContentDataStore getDataStore() {
        return this.entry.getDataStore();
    }

    public final boolean isView() {
        return this.query != null && this.query != Query.ALL;
    }

    @Override
    public ResourceInfo getInfo() {
        return new ResourceInfo(){
            final Set<String> words = new HashSet<String>();
            {
                this.words.add("features");
                this.words.add(ContentFeatureSource.this.getSchema().getTypeName());
            }

            @Override
            public ReferencedEnvelope getBounds() {
                try {
                    return ContentFeatureSource.this.getBounds();
                }
                catch (IOException e) {
                    return null;
                }
            }

            @Override
            public CoordinateReferenceSystem getCRS() {
                return ContentFeatureSource.this.getSchema().getCoordinateReferenceSystem();
            }

            @Override
            public String getDescription() {
                return null;
            }

            @Override
            public Set<String> getKeywords() {
                return this.words;
            }

            @Override
            public String getName() {
                return ContentFeatureSource.this.getSchema().getTypeName();
            }

            @Override
            public URI getSchema() {
                Name name = ContentFeatureSource.this.getSchema().getName();
                try {
                    URI namespace = new URI(name.getNamespaceURI());
                    return namespace;
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }

            @Override
            public String getTitle() {
                Name name = ContentFeatureSource.this.getSchema().getName();
                return name.getLocalPart();
            }
        };
    }

    @Override
    public Name getName() {
        return this.getSchema().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SimpleFeatureType getSchema() {
        if (this.schema != null) {
            return this.schema;
        }
        SimpleFeatureType featureType = this.getAbsoluteSchema();
        if (this.query != null && this.query.getPropertyNames() != Query.ALL_NAMES) {
            ContentFeatureSource contentFeatureSource = this;
            synchronized (contentFeatureSource) {
                if (this.schema == null) {
                    this.schema = SimpleFeatureTypeBuilder.retype(featureType, this.query.getPropertyNames());
                }
            }
            return this.schema;
        }
        return featureType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SimpleFeatureType getAbsoluteSchema() {
        ContentState state = this.entry.getState(this.transaction);
        SimpleFeatureType featureType = state.getFeatureType();
        if (featureType == null) {
            ContentState contentState = state;
            synchronized (contentState) {
                if (featureType == null) {
                    try {
                        featureType = this.buildFeatureType();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    state.setFeatureType(featureType);
                }
            }
        }
        return featureType;
    }

    @Override
    public final ReferencedEnvelope getBounds() throws IOException {
        return this.getBounds(Query.ALL);
    }

    @Override
    public final ReferencedEnvelope getBounds(Query query) throws IOException {
        query = this.joinQuery(query);
        query = this.resolvePropertyNames(query);
        ReferencedEnvelope bounds = this.getBoundsInternal(query);
        return bounds;
    }

    protected abstract ReferencedEnvelope getBoundsInternal(Query var1) throws IOException;

    @Override
    public final int getCount(Query query) throws IOException {
        query = this.joinQuery(query);
        query = this.resolvePropertyNames(query);
        int count = this.getCountInternal(query);
        return count;
    }

    protected abstract int getCountInternal(Query var1) throws IOException;

    public final ContentFeatureCollection getFeatures() throws IOException {
        Query query = this.joinQuery(Query.ALL);
        return new ContentFeatureCollection(this, query);
    }

    public final FeatureReader<SimpleFeatureType, SimpleFeature> getReader() throws IOException {
        return this.getReader(Query.ALL);
    }

    public final ContentFeatureCollection getFeatures(Query query) throws IOException {
        query = this.joinQuery(query);
        return new ContentFeatureCollection(this, query);
    }

    public final FeatureReader<SimpleFeatureType, SimpleFeature> getReader(Query query) throws IOException {
        SimpleFeatureType target;
        query = this.joinQuery(query);
        query = this.resolvePropertyNames(query);
        DelegatingFeatureReader<SimpleFeatureType, SimpleFeature> reader = this.getReaderInternal(query);
        if (!this.canFilter() && query.getFilter() != null && query.getFilter() != Filter.INCLUDE) {
            reader = new FilteringFeatureReader<SimpleFeatureType, SimpleFeature>(reader, query.getFilter());
        }
        if (!this.canReproject() && query.getCoordinateSystemReproject() != null) {
            try {
                reader = new ReprojectFeatureReader(reader, query.getCoordinateSystemReproject());
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw (IOException)new IOException("Error occurred trying to reproject data").initCause(e);
            }
        }
        if (!this.canLimit() && query.getMaxFeatures() != -1 && query.getMaxFeatures() < Integer.MAX_VALUE) {
            reader = new MaxFeatureReader<SimpleFeatureType, SimpleFeature>(reader, query.getMaxFeatures());
        }
        if (!this.canSort() && query.getSortBy() != null && query.getSortBy().length != 0) {
            throw new UnsupportedOperationException("sorting unsupported");
        }
        if (!this.canRetype() && query.getPropertyNames() != Query.ALL_NAMES && !(target = SimpleFeatureTypeBuilder.retype(this.getSchema(), query.getPropertyNames())).equals(reader.getFeatureType())) {
            reader = new ReTypeFeatureReader(reader, target, false);
        }
        return reader;
    }

    protected abstract FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query var1) throws IOException;

    protected boolean canReproject() {
        return false;
    }

    protected boolean canLimit() {
        return false;
    }

    protected boolean canFilter() {
        return false;
    }

    protected boolean canRetype() {
        return false;
    }

    protected boolean canSort() {
        return false;
    }

    public final ContentFeatureSource getView(Query query) throws IOException {
        query = this.joinQuery(query);
        query = this.resolvePropertyNames(query);
        Class<?> clazz = this.getClass();
        try {
            Constructor<?> c = clazz.getConstructor(ContentEntry.class, Query.class);
            ContentFeatureSource source = (ContentFeatureSource)c.newInstance(this.getEntry(), query);
            source.setTransaction(this.transaction);
            return source;
        }
        catch (Exception e) {
            String msg = "Subclass must implement Constructor(ContentEntry,Query)";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    public final ContentFeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new DefaultQuery(this.getSchema().getTypeName(), filter));
    }

    public final FeatureReader<SimpleFeatureType, SimpleFeature> getReader(Filter filter) throws IOException {
        return this.getReader(new DefaultQuery(this.getSchema().getTypeName(), filter));
    }

    public final ContentFeatureSource getView(Filter filter) throws IOException {
        return this.getView(new DefaultQuery(this.getSchema().getTypeName(), filter));
    }

    @Override
    public final void addFeatureListener(FeatureListener listener) {
        this.entry.getState(this.transaction).addListener(listener);
    }

    @Override
    public final void removeFeatureListener(FeatureListener listener) {
        this.entry.getState(this.transaction).removeListener(listener);
    }

    @Override
    public final Set getSupportedHints() {
        return this.hints;
    }

    protected void addHints(Set<Hints.Key> hints) {
    }

    protected Query joinQuery(Query query) {
        if (this.query == null || this.query == Query.ALL) {
            return query;
        }
        if (query == null) {
            return this.query;
        }
        return DataUtilities.mixQueries(this.query, query, null);
    }

    protected Query resolvePropertyNames(Query query) {
        Filter resolved = this.resolvePropertyNames(query.getFilter());
        if (resolved == query.getFilter()) {
            return query;
        }
        DefaultQuery newQuery = new DefaultQuery(query);
        newQuery.setFilter(resolved);
        return newQuery;
    }

    protected Filter resolvePropertyNames(Filter filter) {
        if (filter == null || filter == Filter.INCLUDE || filter == Filter.EXCLUDE) {
            return filter;
        }
        return (Filter)filter.accept((FilterVisitor)new PropertyNameResolvingVisitor(this.getSchema()), null);
    }

    protected abstract SimpleFeatureType buildFeatureType() throws IOException;

    @Override
    public QueryCapabilities getQueryCapabilities() {
        return this.queryCapabilities;
    }
}

