/*
 * Decompiled with CFR 0.152.
 */
package jams.math.distributions;

import jams.math.distributions.Gaus8_fcn;

public class Gaus8 {
    static final double x1 = 0.1834346424956498;
    static final double x2 = 0.525532409916329;
    static final double x3 = 0.7966664774136267;
    static final double x4 = 0.9602898564975363;
    static final double w1 = 0.362683783378362;
    static final double w2 = 0.31370664587788727;
    static final double w3 = 0.22238103445337448;
    static final double w4 = 0.10122853629037626;
    static final double sq2 = 1.41421356;
    static final int nlmn = 1;
    static final int kmx = 5000;
    static final int kml = 6;

    public static double gaus8(Gaus8_fcn integclass, double a, double b, double[] err, int[] ierr) {
        double g8xh;
        double c;
        double[] aa = new double[61];
        double[] hh = new double[61];
        double[] vl = new double[61];
        double[] gr = new double[61];
        int[] lr = new int[61];
        int nbits = 53;
        int nlmx = Math.min(60, nbits * 5 / 8);
        double ans = 0.0;
        ierr[0] = 1;
        double ce = 0.0;
        if (a == b) {
            if (err[0] < 0.0) {
                err[0] = ce;
            }
            return ans;
        }
        int lmx = nlmx;
        int lmn = 1;
        if (b != 0.0 && Gaus8.sign(1.0, b) * a > 0.0 && (c = Math.abs(1.0 - a / b)) <= 0.1) {
            if (c <= 0.0) {
                if (err[0] < 0.0) {
                    err[0] = ce;
                }
                return ans;
            }
            double anib = 0.5 - Math.log(c) / 0.69314718;
            int nib = (int)anib;
            lmx = Math.min(nlmx, nbits - nib - 7);
            if (lmx < 1) {
                ierr[0] = -1;
                System.out.print("\n\nGaus8 --- a and b are too nearly equal to allow normal integration.\nans is set to 0 and ierr[0] is set to -1.\n\n");
                if (err[0] < 0.0) {
                    err[0] = ce;
                }
                return ans;
            }
            lmn = Math.min(lmn, lmx);
        }
        double tol = Math.max(Math.abs(err[0]), Math.pow(2.0, 5 - nbits)) / 2.0;
        if (err[0] == 0.0) {
            tol = Math.sqrt(2.22E-16);
        }
        double eps = tol;
        hh[1] = (b - a) / 4.0;
        aa[1] = a;
        lr[1] = 1;
        int l = 1;
        double x = aa[l] + 2.0 * hh[l];
        double h = 2.0 * hh[l];
        double est = g8xh = h * (0.362683783378362 * (integclass.f_to_integrate(x - 0.1834346424956498 * h) + integclass.f_to_integrate(x + 0.1834346424956498 * h)) + 0.31370664587788727 * (integclass.f_to_integrate(x - 0.525532409916329 * h) + integclass.f_to_integrate(x + 0.525532409916329 * h)) + (0.22238103445337448 * (integclass.f_to_integrate(x - 0.7966664774136267 * h) + integclass.f_to_integrate(x + 0.7966664774136267 * h)) + 0.10122853629037626 * (integclass.f_to_integrate(x - 0.9602898564975363 * h) + integclass.f_to_integrate(x + 0.9602898564975363 * h))));
        int k = 8;
        double area = Math.abs(est);
        double ef = 0.5;
        boolean mxl = false;
        while (true) {
            double vr;
            double ae;
            x = aa[l] + hh[l];
            h = hh[l];
            double gl = g8xh = h * (0.362683783378362 * (integclass.f_to_integrate(x - 0.1834346424956498 * h) + integclass.f_to_integrate(x + 0.1834346424956498 * h)) + 0.31370664587788727 * (integclass.f_to_integrate(x - 0.525532409916329 * h) + integclass.f_to_integrate(x + 0.525532409916329 * h)) + (0.22238103445337448 * (integclass.f_to_integrate(x - 0.7966664774136267 * h) + integclass.f_to_integrate(x + 0.7966664774136267 * h)) + 0.10122853629037626 * (integclass.f_to_integrate(x - 0.9602898564975363 * h) + integclass.f_to_integrate(x + 0.9602898564975363 * h))));
            x = aa[l] + 3.0 * hh[l];
            h = hh[l];
            gr[l] = g8xh = h * (0.362683783378362 * (integclass.f_to_integrate(x - 0.1834346424956498 * h) + integclass.f_to_integrate(x + 0.1834346424956498 * h)) + 0.31370664587788727 * (integclass.f_to_integrate(x - 0.525532409916329 * h) + integclass.f_to_integrate(x + 0.525532409916329 * h)) + (0.22238103445337448 * (integclass.f_to_integrate(x - 0.7966664774136267 * h) + integclass.f_to_integrate(x + 0.7966664774136267 * h)) + 0.10122853629037626 * (integclass.f_to_integrate(x - 0.9602898564975363 * h) + integclass.f_to_integrate(x + 0.9602898564975363 * h))));
            k += 16;
            area += Math.abs(gl) + Math.abs(gr[l]) - Math.abs(est);
            double glr = gl + gr[l];
            double ee = Math.abs(est - glr) * ef;
            if (ee - (ae = Math.max(eps * area, tol * Math.abs(glr))) > 0.0) {
                if (k > 5000) {
                    lmx = 6;
                }
                if (l < lmx) {
                    eps *= 0.5;
                    ef /= 1.41421356;
                    hh[++l] = hh[l - 1] * 0.5;
                    lr[l] = -1;
                    aa[l] = aa[l - 1];
                    est = gl;
                    continue;
                }
                mxl = true;
                ce += est - glr;
                if (lr[l] <= 0) {
                    vl[l] = glr;
                    est = gr[l - 1];
                    lr[l] = 1;
                    int n = l;
                    aa[n] = aa[n] + 4.0 * hh[l];
                    continue;
                }
                vr = glr;
                while (true) {
                    if (l <= 1) {
                        ans = vr;
                        if (mxl && Math.abs(ce) > 2.0 * tol * area) {
                            ierr[0] = 2;
                            System.out.print("\n\nans is probably insufficiently accurate.\n\n");
                        }
                        if (err[0] < 0.0) {
                            err[0] = ce;
                        }
                        return ans;
                    }
                    eps *= 2.0;
                    ef *= 1.41421356;
                    if ((double)lr[--l] <= 0.0) break;
                    vr += vl[l + 1];
                }
                vl[l] = vl[l + 1] + vr;
                est = gr[l - 1];
                lr[l] = 1;
                int n = l;
                aa[n] = aa[n] + 4.0 * hh[l];
                continue;
            }
            ce += est - glr;
            if (lr[l] <= 0) {
                vl[l] = glr;
                est = gr[l - 1];
                lr[l] = 1;
                int n = l;
                aa[n] = aa[n] + 4.0 * hh[l];
                continue;
            }
            vr = glr;
            while (true) {
                if (l <= 1) {
                    ans = vr;
                    if (mxl && Math.abs(ce) > 2.0 * tol * area) {
                        ierr[0] = 2;
                        System.out.print("\n\nans is probably insufficiently accurate.\n\n");
                    }
                    if (err[0] < 0.0) {
                        err[0] = ce;
                    }
                    return ans;
                }
                eps *= 2.0;
                ef *= 1.41421356;
                if ((double)lr[--l] <= 0.0) break;
                vr += vl[l + 1];
            }
            vl[l] = vl[l + 1] + vr;
            est = gr[l - 1];
            lr[l] = 1;
            int n = l;
            aa[n] = aa[n] + 4.0 * hh[l];
        }
    }

    public static double sign(double a, double b) {
        if (b < 0.0) {
            return -Math.abs(a);
        }
        return Math.abs(a);
    }
}

