/*
 * Decompiled with CFR 0.152.
 */
package jams.io;

import jams.data.NamedDataSupplier;
import jams.io.SimpleOutputDataStore;
import jams.io.dbf.DBFException;
import jams.io.dbf.DBFField;
import jams.io.dbf.DBFReader;
import jams.io.dbf.DBFWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;

public class ShapeFileOutputDataStore {
    DBFWriter writer = null;
    File shapeFileTemplate;
    File targetDirectory;
    File targetFile;

    public ShapeFileOutputDataStore(File shapeFileTemplate, File targetDirectory) throws IOException {
        this.init(shapeFileTemplate, targetDirectory);
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    private void init(File shapeFileTemplate, File targetDirectory) throws IOException {
        if (shapeFileTemplate == null) {
            throw new IllegalArgumentException("ShapeFileOutputDateStore cannot be initialized, because shapeFileTemplate must not be null.");
        }
        if (!(shapeFileTemplate.isFile() && shapeFileTemplate.exists() && shapeFileTemplate.getName().endsWith(".shp"))) {
            throw new IllegalArgumentException("ShapeFileOutputDateStore cannot be initialized, because shapeFileTemplate (%1) is not a shapefile.".replace("%1", shapeFileTemplate.getAbsolutePath()));
        }
        this.shapeFileTemplate = shapeFileTemplate;
        if (targetDirectory == null) {
            throw new IllegalArgumentException("ShapeFileOutputDateStore cannot be initialized, because targetDirectory must not be null.");
        }
        if (!targetDirectory.isDirectory()) {
            throw new IllegalArgumentException("ShapeFileOutputDateStore cannot be initialized, because targetDirectory (%1) is not a directory.".replace("%1", targetDirectory.getAbsolutePath()));
        }
        this.targetDirectory = targetDirectory;
        if (!targetDirectory.exists()) {
            targetDirectory.mkdirs();
        }
        this.targetFile = new File(targetDirectory, shapeFileTemplate.getName().replace(".shp", ".dbf"));
        File directory = shapeFileTemplate.getParentFile();
        String name = shapeFileTemplate.getName().replace(".shp", "");
        for (File srcFile : directory.listFiles()) {
            if (!srcFile.getName().startsWith(name)) continue;
            try {
                Path dest = Paths.get(targetDirectory.getAbsolutePath() + "/" + srcFile.getName(), new String[0]);
                Path src = Paths.get(srcFile.getAbsolutePath(), new String[0]);
                if (Files.exists(dest, new LinkOption[0])) {
                    if (Files.size(dest) == Files.size(src)) continue;
                    Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new IOException("The file " + srcFile.getAbsolutePath() + " could not be copied to the output directy!\n" + ioe.toString());
            }
        }
    }

    public String[] getFieldNames() throws IOException {
        InputStream inputStream = null;
        DBFReader dbfReader = null;
        FileOutputStream outStream = null;
        String[] fieldNames = null;
        try {
            inputStream = new FileInputStream(new File(this.shapeFileTemplate.getParentFile(), this.shapeFileTemplate.getName().replace(".shp", ".dbf")));
            dbfReader = new DBFReader(inputStream);
            fieldNames = new String[dbfReader.getFieldCount()];
            for (int i = 0; i < dbfReader.getFieldCount(); ++i) {
                fieldNames[i] = dbfReader.getField(i).getName();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IOException("Could not write shape file, because of: " + ioe.toString());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
                if (this.writer != null) {
                    this.writer.close();
                }
            }
            catch (IOException iOException) {}
        }
        return fieldNames;
    }

    public void addDataToShpFiles(NamedDataSupplier<Double>[] I, String idFieldName) throws IOException {
        InputStream inputStream = null;
        DBFReader dbfReader = null;
        FileOutputStream outStream = null;
        try {
            int i;
            inputStream = new FileInputStream(new File(this.shapeFileTemplate.getParentFile(), this.shapeFileTemplate.getName().replace(".shp", ".dbf")));
            dbfReader = new DBFReader(inputStream);
            DBFWriter writer = new DBFWriter();
            DBFField[] dbfFields = new DBFField[dbfReader.getFieldCount() + I.length];
            int k = dbfReader.getFieldCount();
            int m = I.length;
            int n = k + m;
            int idFieldIndex = -1;
            for (i = 0; i < k; ++i) {
                dbfFields[i] = dbfReader.getField(i);
                if (idFieldName == null || dbfFields[i].getName().compareToIgnoreCase(idFieldName) != 0) continue;
                idFieldIndex = i;
            }
            if (idFieldIndex == -1) {
                System.out.println("Error field with name " + idFieldName + " was not found in shapefile!");
                idFieldIndex = 0;
            }
            for (i = 0; i < I.length; ++i) {
                dbfFields[i + k] = new DBFField();
                String name = I[i].getName().replaceAll(" [0-9][0-9]:[0-9][0-9]", "");
                name = name.substring(0, Math.min(10, name.length()));
                dbfFields[i + k].setName(name);
                dbfFields[i + k].setDataType((byte)78);
                dbfFields[i + k].setFieldLength(12);
                dbfFields[i + k].setDecimalCount(5);
            }
            writer.setFields(dbfFields);
            outStream = new FileOutputStream(this.targetFile);
            writer.write(outStream);
            outStream.close();
            outStream = null;
            writer = new DBFWriter(this.targetFile);
            for (int j = 0; j < dbfReader.getRecordCount(); ++j) {
                int i2;
                Object[] objIn = dbfReader.nextRecord();
                Object[] objOut = new Object[n];
                double id = Double.parseDouble(objIn[idFieldIndex].toString());
                for (i2 = 0; i2 < k; ++i2) {
                    objOut[i2] = objIn[i2];
                }
                for (i2 = 0; i2 < m; ++i2) {
                    objOut[i2 + k] = I[i2].get((int)id);
                }
                try {
                    writer.addRecord(objOut);
                    continue;
                }
                catch (DBFException dbfe) {
                    System.out.println("Error writing field: " + dbfe.toString());
                    System.out.println("Fields in question are: " + Arrays.toString(objOut));
                }
            }
            writer.write();
            writer = null;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IOException("Could not write shape file, because of: " + ioe.toString());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
                if (this.writer != null) {
                    this.writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void addDataToShpFiles(SimpleOutputDataStore store, String idFieldName) throws IOException {
        InputStream inputStream = null;
        DBFReader dbfReader = null;
        FileOutputStream outStream = null;
        try {
            int i;
            String[] fields = store.getEntries();
            inputStream = new FileInputStream(new File(this.shapeFileTemplate.getParentFile(), this.shapeFileTemplate.getName().replace(".shp", ".dbf")));
            dbfReader = new DBFReader(inputStream);
            DBFWriter writer = new DBFWriter();
            DBFField[] dbfFields = new DBFField[fields.length + dbfReader.getFieldCount()];
            int k = dbfReader.getFieldCount();
            int m = fields.length;
            int n = k + m;
            int idFieldIndex = -1;
            for (i = 0; i < k; ++i) {
                dbfFields[i] = dbfReader.getField(i);
                if (idFieldName == null || dbfFields[i].getName().compareToIgnoreCase(idFieldName) != 0) continue;
                idFieldIndex = i;
            }
            if (idFieldIndex == -1) {
                System.out.println("Error field with name " + idFieldName + " was not found in shapefile!");
                idFieldIndex = 0;
            }
            for (i = 0; i < fields.length; ++i) {
                dbfFields[i + k] = new DBFField();
                dbfFields[i + k].setName(fields[i].replaceAll(" [0-9][0-9]:[0-9][0-9]", ""));
                dbfFields[i + k].setDataType((byte)78);
                dbfFields[i + k].setFieldLength(12);
                dbfFields[i + k].setDecimalCount(5);
            }
            writer.setFields(dbfFields);
            outStream = new FileOutputStream(this.targetFile);
            writer.write(outStream);
            outStream.close();
            outStream = null;
            writer = new DBFWriter(this.targetFile);
            for (int j = 0; j < dbfReader.getRecordCount(); ++j) {
                int i2;
                Object[] objIn = dbfReader.nextRecord();
                Object[] objOut = new Object[n];
                double id = Double.parseDouble(objIn[idFieldIndex].toString());
                int position = store.getPositionOfEntity(id);
                for (i2 = 0; i2 < k; ++i2) {
                    objOut[i2] = objIn[i2];
                }
                for (i2 = 0; i2 < m; ++i2) {
                    objOut[i2 + k] = position == -1 ? null : Double.valueOf(store.getData(fields[i2], position));
                }
                try {
                    writer.addRecord(objOut);
                    continue;
                }
                catch (DBFException dbfe) {
                    System.out.println("Error writing field: " + dbfe.toString());
                    System.out.println("Fields in question are: " + Arrays.toString(objOut));
                }
            }
            writer.write();
            writer = null;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IOException("Could not write shape file, because of: " + ioe.toString());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
                if (this.writer != null) {
                    this.writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

