/*
 * Decompiled with CFR 0.152.
 */
package jams.gui.input;

import jams.JAMS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class TableInput
extends JPanel {
    private static ImageIcon UP_ICON = new ImageIcon(new ImageIcon(ClassLoader.getSystemResource("resources/images/arrowup.png")).getImage().getScaledInstance(10, 5, 4));
    private static ImageIcon DOWN_ICON = new ImageIcon(new ImageIcon(ClassLoader.getSystemResource("resources/images/arrowdown.png")).getImage().getScaledInstance(10, 5, 4));
    static final int BUTTON_SIZE = 20;
    private static final Dimension BUTTON_DIMENSION = new Dimension(20, 20);
    private JTable table;
    protected JButton addButton;
    protected JButton removeButton;
    protected JButton upButton;
    protected JButton downButton;
    protected JButton editButton;
    protected JScrollPane scrollPane;
    protected TableData tableData = new TableData();
    protected MouseListener editListener;
    private String[] header = null;
    private Class[] columnClasses = null;
    private boolean[] editable = null;

    public TableInput(String[] header, Class[] columnClasses, boolean[] editable) {
        this(header, columnClasses, editable, true);
    }

    public TableInput(String[] header, Class[] columnClasses, boolean[] editable, boolean orderButtons) {
        this(header, columnClasses, editable, orderButtons, true);
    }

    public TableInput(String[] header, Class[] columnClasses, boolean[] editable, boolean orderButtons, boolean editButtons) {
        this.header = header;
        this.columnClasses = columnClasses;
        this.editable = editable;
        BorderLayout layout = new BorderLayout();
        layout.setHgap(5);
        this.setLayout(layout);
        this.table = new JTable(new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return TableInput.this.tableData.getRowCount();
            }

            @Override
            public String getColumnName(int col) {
                return TableInput.this.header[col];
            }

            public Class getColumnClass(int c) {
                return TableInput.this.columnClasses[c];
            }

            @Override
            public int getColumnCount() {
                return TableInput.this.header.length;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return TableInput.this.tableData.getElementAt(rowIndex)[columnIndex];
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return TableInput.this.editable[col];
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                TableInput.this.tableData.getElementAt((int)row)[col] = value;
                this.fireTableCellUpdated(row, col);
            }
        });
        this.table.setSelectionMode(0);
        this.editListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    TableInput.this.editItem();
                }
            }
        };
        this.table.addMouseListener(this.editListener);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().add(this.getTable());
        this.add((Component)this.scrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setPreferredSize(new Dimension(20, 20));
        buttonPanel.setLayout(new FlowLayout());
        this.add((Component)buttonPanel, "East");
        this.addButton = new JButton("+");
        this.addButton.setMargin(new Insets(0, 1, 1, 0));
        this.addButton.setPreferredSize(BUTTON_DIMENSION);
        buttonPanel.add(this.addButton);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TableInput.this.addItem();
            }
        });
        this.removeButton = new JButton("-");
        this.removeButton.setMargin(new Insets(0, 1, 1, 0));
        this.removeButton.setPreferredSize(BUTTON_DIMENSION);
        buttonPanel.add(this.removeButton);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TableInput.this.removeItem();
            }
        });
        if (editButtons) {
            this.editButton = new JButton("...");
            this.editButton.setMargin(new Insets(0, 1, 1, 0));
            this.editButton.setPreferredSize(BUTTON_DIMENSION);
            this.editButton.setToolTipText(JAMS.i18n("Edit"));
            buttonPanel.add(this.editButton);
            this.editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableInput.this.editItem();
                }
            });
        }
        if (orderButtons) {
            this.upButton = new JButton();
            this.upButton.setMargin(new Insets(0, 1, 1, 0));
            this.upButton.setPreferredSize(BUTTON_DIMENSION);
            this.upButton.setToolTipText(JAMS.i18n("Move_up"));
            this.upButton.setIcon(UP_ICON);
            this.upButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableInput.this.moveUp();
                }
            });
            this.downButton = new JButton();
            this.downButton.setMargin(new Insets(0, 1, 1, 0));
            this.downButton.setPreferredSize(BUTTON_DIMENSION);
            this.downButton.setToolTipText(JAMS.i18n("Move_down"));
            this.downButton.setIcon(DOWN_ICON);
            this.downButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableInput.this.moveDown();
                }
            });
            buttonPanel.add(this.upButton);
            buttonPanel.add(this.downButton);
        }
    }

    private void swapRows(int r1, int r2) {
        TableModel model = this.table.getModel();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            Object o1 = model.getValueAt(r1, i);
            Object o2 = model.getValueAt(r2, i);
            model.setValueAt(o2, r1, i);
            model.setValueAt(o1, r2, i);
        }
    }

    private void moveUp() {
        int row = this.table.getSelectedRow();
        if (row != 0) {
            this.swapRows(row, row - 1);
        }
    }

    private void moveDown() {
        int row = this.table.getSelectedRow();
        if (row != this.table.getRowCount() - 1) {
            this.swapRows(row, row + 1);
        }
    }

    public void addListDataObserver(Observer obs) {
        this.tableData.addObserver(obs);
    }

    public void setTableData(ArrayList<Object[]> listData) {
        this.tableData.setValue(listData);
        this.scrollPane.revalidate();
        this.scrollPane.repaint();
    }

    public void revalidateScroll() {
        this.scrollPane.revalidate();
        this.scrollPane.repaint();
    }

    public ArrayList<Object[]> getTableData() {
        return this.tableData.getValue();
    }

    public Object[] getSelectedString() {
        int selection = this.getTable().getSelectedRow();
        if (selection >= 0) {
            return this.tableData.getValue().get(selection);
        }
        return null;
    }

    public JTable getTable() {
        return this.table;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getTable().setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
        if (this.editButton != null) {
            this.editButton.setEnabled(enabled);
        }
        if (this.upButton != null) {
            this.upButton.setEnabled(enabled);
        }
        if (this.downButton != null) {
            this.downButton.setEnabled(enabled);
        }
    }

    protected void addItem() {
    }

    protected void removeItem() {
        int selection = this.getTable().getSelectedRow();
        if (selection >= 0) {
            this.tableData.removeElementAt(selection);
            this.scrollPane.revalidate();
            this.scrollPane.repaint();
            if (selection >= this.tableData.getValue().size()) {
                selection = this.tableData.getValue().size() - 1;
            }
            if (selection == -1) {
                this.getTable().getSelectionModel().clearSelection();
            } else {
                this.getTable().setRowSelectionInterval(selection, selection);
            }
        }
    }

    protected void editItem() {
    }

    protected class TableData
    extends Observable {
        private ArrayList<Object[]> tableData = new ArrayList();

        protected TableData() {
        }

        public int getRowCount() {
            return this.tableData.size();
        }

        public void addElement(Object[] s) {
            this.tableData.add(s);
            TableInput.this.getTable().setColumnSelectionInterval(TableInput.this.getTable().getColumnCount() - 1, TableInput.this.getTable().getColumnCount() - 1);
            this.setChanged();
            this.notifyObservers();
        }

        public void removeElementAt(int selection) {
            this.tableData.remove(selection);
            this.setChanged();
            this.notifyObservers();
        }

        public Object[] getElementAt(int selection) {
            return this.tableData.get(selection);
        }

        public void setElementAt(int selection, Object[] s) {
            this.tableData.set(selection, s);
        }

        public ArrayList<Object[]> getValue() {
            return this.tableData;
        }

        public void setValue(ArrayList<Object[]> tableData) {
            this.tableData = tableData;
            this.setChanged();
            ((AbstractTableModel)TableInput.this.getTable().getModel()).fireTableDataChanged();
            this.notifyObservers();
        }
    }
}

