/*
 * Decompiled with CFR 0.152.
 */
package jams.gui.input;

import jams.gui.input.JTimeButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JTimePopup
extends JList
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    protected String m_strDateParam = "date";
    public static final long KMS_IN_A_DAY = 86400000L;
    protected Date m_timeTarget = null;
    protected Date m_timeSelected = null;
    protected Date m_timeNow = null;
    protected DateFormat m_tf = DateFormat.getTimeInstance(3);
    protected Calendar m_calendar = Calendar.getInstance();
    protected boolean m_bTransferFocus = true;
    public static final String TIME_ICON = "Time";

    public JTimePopup() {
    }

    public JTimePopup(Date date) {
        this();
        this.init(null, date, null);
    }

    public JTimePopup(String strDateParam, Date date) {
        this();
        this.init(strDateParam, date, null);
    }

    public JTimePopup(String strDateParam, Date date, String strLanguage) {
        this();
        this.init(strDateParam, date, strLanguage);
    }

    public void init(String strDateParam, Date timeTarget, String strLanguage) {
        Locale locale;
        if (strDateParam != null) {
            this.m_strDateParam = strDateParam;
        }
        this.m_timeNow = new Date();
        if (timeTarget == null) {
            timeTarget = this.m_timeNow;
        }
        this.m_timeSelected = timeTarget;
        if (strLanguage != null && (locale = new Locale(strLanguage, "")) != null) {
            this.m_calendar = Calendar.getInstance(locale);
            this.m_tf = DateFormat.getTimeInstance(3, locale);
        }
        this.m_timeTarget = new Date(timeTarget.getTime());
        this.layoutCalendar(this.m_timeTarget);
        this.addListSelectionListener(this);
    }

    public void layoutCalendar(Date timeTarget) {
        this.m_calendar.setTime(timeTarget);
        int hour = this.m_calendar.get(11);
        int minute = this.m_calendar.get(12);
        String[] array = new String[48];
        this.m_calendar.set(11, 0);
        this.m_calendar.set(12, 0);
        this.m_calendar.set(13, 0);
        this.m_calendar.set(14, 0);
        int selectedIndex = -1;
        for (int i = 0; i < array.length; ++i) {
            String strTime;
            if (hour == this.m_calendar.get(11) && minute == this.m_calendar.get(12)) {
                selectedIndex = i;
            }
            Date time = this.m_calendar.getTime();
            array[i] = strTime = this.m_tf.format(time);
            this.m_calendar.add(12, 30);
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(array);
        this.setVisibleRowCount(10);
        this.setModel(model);
        if (selectedIndex != -1) {
            this.setSelectedIndex(selectedIndex);
        }
    }

    private JPopupMenu getJPopupMenu() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JPopupMenu)) continue;
            return (JPopupMenu)parent;
        }
        return null;
    }

    public static JTimePopup createTimePopup(Date dateTarget, Component button) {
        return JTimePopup.createTimePopup(null, dateTarget, button, null);
    }

    public static JTimePopup createTimePopup(String strDateParam, Date dateTarget, Component button) {
        return JTimePopup.createTimePopup(null, dateTarget, button, null);
    }

    public static JTimePopup createTimePopup(String strDateParam, Date dateTarget, Component button, String strLanguage) {
        JPopupMenu popup;
        JPopupMenu c = popup = new JPopupMenu();
        c.setLayout(new BorderLayout());
        JTimePopup calendar = new JTimePopup(strDateParam, dateTarget, strLanguage);
        JScrollPane scrollPane = new JScrollPane(calendar);
        if (calendar.getSelectedIndex() != -1) {
            calendar.ensureIndexIsVisible(calendar.getSelectedIndex());
        }
        c.add((Component)scrollPane, "Center");
        popup.show(button, button.getBounds().width, 0);
        return calendar;
    }

    public static JButton createCalendarButton(String strDateParam, Date dateTarget) {
        JTimeButton button = new JTimeButton(strDateParam, dateTarget);
        button.setOpaque(false);
        return button;
    }

    public void setTransferFocus(boolean bTransferFocus) {
        this.m_bTransferFocus = bTransferFocus;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int index = this.getSelectedIndex();
        if (index != -1) {
            int hour = index / 2;
            int minute = (int)(((float)index / 2.0f - (float)hour) * 60.0f);
            this.m_calendar.setTime(this.m_timeTarget);
            this.m_calendar.set(11, hour);
            this.m_calendar.set(12, minute);
            Date date = this.m_calendar.getTime();
            JPopupMenu popupMenu = this.getJPopupMenu();
            if (popupMenu != null) {
                Component invoker = popupMenu.getInvoker();
                this.getParent().remove(this);
                Container container = popupMenu.getParent();
                container.remove(popupMenu);
                popupMenu.setVisible(false);
                if (invoker != null && this.m_bTransferFocus) {
                    invoker.transferFocus();
                }
            }
            Date oldTime = this.m_timeSelected;
            if (this.m_timeSelected == this.m_timeTarget) {
                oldTime = null;
            }
            this.firePropertyChange(this.m_strDateParam, oldTime, date);
        }
    }
}

