/*
 * Decompiled with CFR 0.152.
 */
package jams.gui.input;

import jams.JAMS;
import jams.data.Attribute;
import jams.data.DefaultDataFactory;
import jams.gui.input.InputComponent;
import jams.gui.input.JCalendarButton;
import jams.gui.input.JTimeButton;
import jams.gui.input.ValueChangeListener;
import jams.gui.tools.GUIHelper;
import jams.tools.StringTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CalendarInput
extends JPanel
implements InputComponent {
    private JTextField dateText;
    private JTextField timeText;
    private JPanel datePanel;
    private JPanel timePanel;
    private ValueChangeListener l;
    private JCalendarButton dateButton;
    private JTimeButton timeButton;
    private String oldDateString;
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm".split(" ")[0]);
    private static DateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm".split(" ")[1]);
    private static DateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private Color oldColor;

    public CalendarInput() {
        this(true);
    }

    public CalendarInput(boolean doLayout) {
        timeFormat.setTimeZone(Attribute.Calendar.DEFAULT_TIME_ZONE);
        dateFormat.setTimeZone(Attribute.Calendar.DEFAULT_TIME_ZONE);
        dateTimeFormat.setTimeZone(Attribute.Calendar.DEFAULT_TIME_ZONE);
        this.createPanels();
        if (doLayout) {
            GridBagLayout gbl = new GridBagLayout();
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setLayout(gbl);
            GUIHelper.addGBComponent(this, gbl, this.datePanel, 1, 1, 1, 1, 0.0, 0.0);
            GUIHelper.addGBComponent(this, gbl, this.timePanel, 11, 1, 1, 1, 0.0, 0.0);
            this.dateText.setToolTipText(JAMS.i18n("Date"));
            this.timeText.setToolTipText(JAMS.i18n("Time"));
        }
    }

    public void createPanels() {
        dateFormat.setTimeZone(Attribute.Calendar.DEFAULT_TIME_ZONE);
        dateTimeFormat.setTimeZone(Attribute.Calendar.DEFAULT_TIME_ZONE);
        this.datePanel = new JPanel();
        this.dateText = new JTextField();
        this.dateText.setPreferredSize(new Dimension(100, 20));
        this.dateText.setBorder(BorderFactory.createEtchedBorder());
        this.datePanel.add(this.dateText);
        this.dateButton = new JCalendarButton();
        this.dateButton.setText("");
        this.dateButton.setPreferredSize(new Dimension(20, 20));
        this.dateButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/Calendar.gif")));
        this.dateButton.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof Date) {
                    CalendarInput.this.setDate((Date)evt.getNewValue());
                }
            }
        });
        this.dateText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                String dateString = CalendarInput.this.getDateText().getText();
                Date date = null;
                try {
                    if (!StringTools.isEmptyString(dateString)) {
                        date = dateFormat.parse(dateString);
                    }
                }
                catch (Exception e) {
                    date = null;
                }
                CalendarInput.this.setDate(date);
            }
        });
        this.datePanel.add(this.dateButton);
        this.timePanel = new JPanel();
        this.timeText = new JTextField();
        this.timeText.setPreferredSize(new Dimension(80, 20));
        this.timeText.setBorder(BorderFactory.createEtchedBorder());
        this.timePanel.add(this.timeText);
        this.timeButton = new JTimeButton();
        this.timeButton.setText("");
        this.timeButton.setPreferredSize(new Dimension(20, 20));
        this.timeButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/Time.gif")));
        this.timeButton.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof Date) {
                    CalendarInput.this.setTime((Date)evt.getNewValue());
                }
            }
        });
        this.timeText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                String timeString = CalendarInput.this.getTimeText().getText();
                Date time = null;
                try {
                    if (!StringTools.isEmptyString(timeString)) {
                        String dateString = CalendarInput.this.dateText.getText();
                        if (StringTools.isEmptyString(dateString)) {
                            dateString = "1970-01-01";
                        }
                        time = timeFormat.parse(timeString);
                        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
                        LocalDateTime dt = LocalDateTime.parse(dateString + " " + timeString, format);
                        time = Date.from(dt.atZone(ZoneId.systemDefault()).toInstant());
                    }
                }
                catch (Exception e) {
                    time = null;
                }
                CalendarInput.this.setTime(time);
            }
        });
        this.timePanel.add(this.timeButton);
    }

    public void setDate(Date date) {
        String dateString = this.oldDateString;
        if (date != null) {
            this.oldDateString = dateString = dateFormat.format(date);
        }
        this.dateText.setText(dateString);
        this.dateButton.setTargetDate(date);
    }

    public void setTime(Date time) {
        if (time != null) {
            Instant instant = Instant.ofEpochMilli(time.getTime());
            LocalDateTime ldt = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            Date dateTime = Date.from(instant);
            this.timeText.setText(ldt.toLocalTime().toString());
            this.timeButton.setTargetDate(dateTime);
        }
    }

    @Override
    public String getValue() {
        return this.getCalendarValue().toString();
    }

    public Attribute.Calendar getCalendarValue() {
        String dateString = this.dateText.getText();
        String timeString = this.timeText.getText();
        if (StringTools.isEmptyString(timeString)) {
            timeString = "00:00";
        }
        Date dateTime = new Date(0L);
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        try {
            LocalDateTime dt = LocalDateTime.parse(dateString + " " + timeString, format);
            dateTime = Date.from(dt.atZone(ZoneId.of(Attribute.Calendar.DEFAULT_TIME_ZONE.getID())).toInstant());
        }
        catch (DateTimeParseException dt) {
            // empty catch block
        }
        Attribute.Calendar cal = DefaultDataFactory.getDataFactory().createCalendar();
        cal.setTime(dateTime);
        return cal;
    }

    @Override
    public void setValue(String value) {
        Attribute.Calendar cal = DefaultDataFactory.getDataFactory().createCalendar();
        if (!StringTools.isEmptyString(value)) {
            cal.setValue(value);
        }
        this.setValue(cal);
    }

    public void setValue(Attribute.Calendar calendar) {
        Date d = calendar.getTime();
        String dateString = dateFormat.format(d);
        String timeString = timeFormat.format(d);
        this.oldDateString = dateString;
        this.dateText.setText(dateString);
        this.timeText.setText(timeString);
        try {
            DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
            LocalDateTime dt = LocalDateTime.parse(this.dateText.getText() + " " + this.timeText.getText(), format);
            Date newDate = Date.from(dt.atZone(ZoneId.systemDefault()).toInstant());
            this.timeButton.setTargetDate(newDate);
            this.dateButton.setTargetDate(newDate);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.dateText.setEnabled(enabled);
        this.timeText.setEnabled(enabled);
        this.dateButton.setEnabled(enabled);
        this.timeButton.setEnabled(enabled);
    }

    @Override
    public void setRange(double lower, double upper) {
    }

    @Override
    public boolean verify() {
        try {
            if (StringTools.isEmptyString(this.getValue())) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public int getErrorCode() {
        return 0;
    }

    @Override
    public void setLength(int length) {
    }

    @Override
    public void addValueChangeListener(ValueChangeListener l) {
        this.l = l;
        this.dateText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }
        });
        this.timeText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CalendarInput.this.l.valueChanged();
            }
        });
    }

    @Override
    public void setMarked(boolean marked) {
        if (marked) {
            this.oldColor = this.getBackground();
            this.setBackground(new Color(255, 0, 0));
        } else {
            this.setBackground(this.oldColor);
        }
    }

    public static void main(String[] args) {
        LocalDateTime dt = LocalDateTime.parse("1996-11-01T23:30");
        CalendarInput tii = new CalendarInput();
        Attribute.Calendar c = DefaultDataFactory.getDataFactory().createCalendar();
        c.setValue("1996-11-01 00:30");
        System.out.println(c);
        Date d = c.getTime();
        tii.setValue(c.toString());
        System.out.println("in : " + tii.getValue());
        JDialog frame = new JDialog();
        frame.add(tii.getComponent());
        frame.pack();
        frame.setModal(true);
        frame.setVisible(true);
        System.out.println("out: " + tii.getValue());
        frame.dispose();
    }

    public JPanel getDatePanel() {
        return this.datePanel;
    }

    public JPanel getTimePanel() {
        return this.timePanel;
    }

    public JTextField getDateText() {
        return this.dateText;
    }

    public JTextField getTimeText() {
        return this.timeText;
    }

    @Override
    public void setHelpText(String text) {
        text = "<html>" + text + "</html>";
        this.getComponent().setToolTipText(text);
    }
}

