/*
 * Decompiled with CFR 0.152.
 */
package jams.gui;

import jams.JAMS;
import jams.runtime.RuntimeManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RuntimeManagerPanel
extends JPanel {
    private static final int UPDATE_INTERVAL_MILLIS = 1000;
    private JList runtimeList;
    private DefaultListModel listModel = new DefaultListModel();
    private JButton stopButton;
    private JPanel buttonPanel;
    private transient ScheduledExecutorService exec;

    public RuntimeManagerPanel() {
        this.setLayout(new BorderLayout());
        this.runtimeList = new JList(this.listModel);
        this.runtimeList.setSelectionMode(2);
        this.runtimeList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    // empty if block
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.stopButton = new JButton(JAMS.i18n("stop_model"));
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] rtInfoArray = RuntimeManagerPanel.this.runtimeList.getSelectedValues();
                if (rtInfoArray != null) {
                    for (Object o : rtInfoArray) {
                        RuntimeManager.RuntimeInfo rtInfo = (RuntimeManager.RuntimeInfo)o;
                        rtInfo.getRuntime().sendHalt();
                    }
                }
            }
        });
        this.runtimeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (RuntimeManagerPanel.this.runtimeList.getSelectedIndex() == -1) {
                        RuntimeManagerPanel.this.stopButton.setEnabled(false);
                    } else {
                        RuntimeManagerPanel.this.stopButton.setEnabled(true);
                    }
                }
            }
        });
        RuntimeManager.getInstance().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                RuntimeManager.RuntimeInfo rtInfo = (RuntimeManager.RuntimeInfo)arg;
                if (rtInfo.getEndTime() == null) {
                    if (!RuntimeManagerPanel.this.listModel.contains(rtInfo)) {
                        RuntimeManagerPanel.this.listModel.addElement(rtInfo);
                    }
                } else {
                    RuntimeManagerPanel.this.listModel.removeElement(rtInfo);
                }
            }
        });
        this.exec = Executors.newSingleThreadScheduledExecutor();
        this.exec.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int i = RuntimeManagerPanel.this.runtimeList.getSelectedIndex();
                        Object[] entries = RuntimeManagerPanel.this.listModel.toArray();
                        RuntimeManagerPanel.this.listModel.removeAllElements();
                        for (Object o : entries) {
                            RuntimeManagerPanel.this.listModel.addElement(o);
                        }
                        RuntimeManagerPanel.this.runtimeList.setSelectedIndex(i);
                    }
                });
            }
        }, 0L, 1000L, TimeUnit.MILLISECONDS);
        JScrollPane listScrollPane = new JScrollPane(this.runtimeList);
        this.add((Component)listScrollPane, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.stopButton);
        this.add((Component)this.buttonPanel, "South");
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }
}

