/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import nom.tam.util.TruncationException;

public final class ByteFormatter {
    private byte[] tbuf1 = new byte[32];
    private byte[] tbuf2 = new byte[32];
    private static final double ilog10 = 1.0 / Math.log(10.0);
    private boolean truncateOnOverflow = true;
    private byte truncationFill = (byte)42;
    private boolean truncationThrow = true;
    private boolean align = false;
    double simpleMin = 0.001;
    double simpleMax = 1000000.0;
    private static final double[] tenpow;
    private static final int zeropow;
    private static final byte[] digits;

    public void setTruncateOnOverflow(boolean bl) {
        this.truncateOnOverflow = bl;
    }

    public void setTruncationThrow(boolean bl) {
        this.truncationThrow = bl;
    }

    public void setTruncationFill(char c) {
        this.truncationFill = (byte)c;
    }

    public void setAlign(boolean bl) {
        this.align = bl;
    }

    public void setSimpleRange(double d, double d2) {
        this.simpleMin = d;
        this.simpleMax = d2;
    }

    public int format(int n, byte[] byArray) throws TruncationException {
        return this.format(n, byArray, 0, byArray.length);
    }

    public int format(int n, byte[] byArray, int n2, int n3) throws TruncationException {
        if (n == Integer.MIN_VALUE) {
            if (n3 > 10 || !this.truncateOnOverflow && byArray.length - n2 > 10) {
                return this.format("-2147483648", byArray, n2, n3);
            }
            this.truncationFiller(byArray, n2, n3);
            return n2 + n3;
        }
        int n4 = Math.abs(n);
        int n5 = 1;
        int n6 = 10;
        while (n5 < 10 && n4 >= n6) {
            ++n5;
            n6 *= 10;
        }
        if (n < 0) {
            ++n5;
        }
        if (this.truncateOnOverflow && n5 > n3 || n5 > byArray.length - n2) {
            this.truncationFiller(byArray, n2, n3);
            return n2 + n3;
        }
        if (this.align) {
            n2 = this.alignFill(byArray, n2, n3 - n5);
        }
        int n7 = (n2 += n5) - 1;
        do {
            byArray[n7] = digits[n4 % 10];
            --n7;
        } while ((n4 /= 10) > 0);
        if (n < 0) {
            byArray[n7] = 45;
        }
        return n2;
    }

    public int format(long l, byte[] byArray) throws TruncationException {
        return this.format(l, byArray, 0, byArray.length);
    }

    public int format(long l, byte[] byArray, int n, int n2) throws TruncationException {
        if (l == Long.MIN_VALUE) {
            if (n2 > 19 || !this.truncateOnOverflow && byArray.length - n > 19) {
                return this.format("-9223372036854775808", byArray, n, n2);
            }
            this.truncationFiller(byArray, n, n2);
            return n + n2;
        }
        long l2 = Math.abs(l);
        int n3 = 1;
        long l3 = 10L;
        while (n3 < 19 && l2 >= l3) {
            ++n3;
            l3 *= 10L;
        }
        if (l < 0L) {
            ++n3;
        }
        if (this.truncateOnOverflow && n3 > n2 || n3 > byArray.length - n) {
            this.truncationFiller(byArray, n, n2);
            return n + n2;
        }
        if (this.align) {
            n = this.alignFill(byArray, n, n2 - n3);
        }
        int n4 = (n += n3) - 1;
        byArray[n4] = 48;
        boolean bl = l2 == 0L;
        block1: while (!bl) {
            int n5 = (int)(l2 % 1000000000L);
            bl = (l2 /= 1000000000L) == 0L;
            int n6 = 0;
            while (n6 < 9) {
                byArray[n4] = digits[n5 % 10];
                --n4;
                if (bl && (n5 /= 10) == 0) continue block1;
                ++n6;
            }
        }
        if (l < 0L) {
            byArray[n4] = 45;
        }
        return n;
    }

    public int format(boolean bl, byte[] byArray) {
        return this.format(bl, byArray, 0, byArray.length);
    }

    public int format(boolean bl, byte[] byArray, int n, int n2) {
        if (this.align && n2 > 1) {
            n = this.alignFill(byArray, n, n2 - 1);
        }
        if (n2 > 0) {
            byArray[n] = bl ? 84 : 70;
            ++n;
        }
        return n;
    }

    public int format(String string, byte[] byArray) {
        return this.format(string, byArray, 0, byArray.length);
    }

    public int format(String string, byte[] byArray, int n, int n2) {
        if (string == null) {
            int n3 = 0;
            while (n3 < n2) {
                byArray[n + n3] = 32;
                ++n3;
            }
            return n + n2;
        }
        int n4 = string.length();
        if (this.truncateOnOverflow && n4 > n2 || n4 > byArray.length - n) {
            string = string.substring(0, n2);
            n4 = n2;
        }
        if (this.align && n2 > n4) {
            n = this.alignFill(byArray, n, n2 - n4);
        }
        System.arraycopy(string.getBytes(), 0, byArray, n, n4);
        return n + n4;
    }

    public int format(float f, byte[] byArray) throws TruncationException {
        return this.format(f, byArray, 0, byArray.length);
    }

    public int format(float f, byte[] byArray, int n, int n2) throws TruncationException {
        float f2;
        float f3 = Math.abs(f);
        if ((double)f3 == 0.0) {
            return this.format("0.0", byArray, n, n2);
        }
        if (Float.isNaN(f)) {
            return this.format("NaN", byArray, n, n2);
        }
        if (Float.isInfinite(f)) {
            if (f > 0.0f) {
                return this.format("Infinity", byArray, n, n2);
            }
            return this.format("-Infinity", byArray, n, n2);
        }
        int n3 = (int)Math.floor(Math.log(f3) * ilog10);
        int n4 = 8 - n3;
        float f4 = 1.0f;
        if (n4 < 30) {
            f2 = (float)tenpow[n4 + zeropow];
        } else {
            f4 = (float)tenpow[30 + zeropow];
            f2 = (float)tenpow[n4 - 30 + zeropow];
        }
        f3 = f3 * f2 * f4;
        int n5 = Float.floatToIntBits(f3);
        int n6 = ((n5 & 0x7F800000) >> 23) - 127;
        int n7 = n5 & 0x7FFFFF;
        if (n6 > -127) {
            n7 |= 0x800000;
        } else {
            ++n6;
        }
        boolean bl = this.align;
        this.align = false;
        int n8 = this.format(n7 <<= (int)((long)n6 - 23L), this.tbuf1, 0, 32);
        this.align = bl;
        return this.combineReal(f, byArray, n, n2, this.tbuf1, n8, n4);
    }

    public int format(double d, byte[] byArray) throws TruncationException {
        return this.format(d, byArray, 0, byArray.length);
    }

    public int format(double d, byte[] byArray, int n, int n2) throws TruncationException {
        double d2;
        double d3 = Math.abs(d);
        if (d3 == 0.0) {
            return this.format("0.0", byArray, n, n2);
        }
        if (Double.isNaN(d)) {
            return this.format("NaN", byArray, n, n2);
        }
        if (Double.isInfinite(d)) {
            if (d > 0.0) {
                return this.format("Infinity", byArray, n, n2);
            }
            return this.format("-Infinity", byArray, n, n2);
        }
        int n3 = (int)(Math.log(d3) * ilog10);
        int n4 = 17 - n3;
        double d4 = 1.0;
        if (n4 < 200) {
            d2 = tenpow[n4 + zeropow];
        } else {
            d4 = tenpow[200 + zeropow];
            d2 = tenpow[n4 - 200 + zeropow];
        }
        d3 = d3 * d2 * d4;
        long l = Double.doubleToLongBits(d3);
        int n5 = (int)(((l & 0x7FF0000000000000L) >> 52) - 1023L);
        long l2 = l & 0xFFFFFFFFFFFFFL;
        if (n5 > -1023) {
            l2 |= 0x10000000000000L;
        } else {
            ++n5;
        }
        boolean bl = this.align;
        this.align = false;
        int n6 = this.format(l2 <<= n5 - 52, this.tbuf1, 0, 32);
        this.align = bl;
        return this.combineReal(d, byArray, n, n2, this.tbuf1, n6, n4);
    }

    int combineReal(double d, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws TruncationException {
        int n5;
        int n6;
        int n7;
        double d2 = Math.abs(d);
        boolean bl = false;
        if (d2 >= this.simpleMin && d2 <= this.simpleMax) {
            bl = true;
        }
        int n8 = n3 - n4 - 1;
        int n9 = 0;
        if (!bl) {
            n7 = this.align;
            this.align = false;
            n9 = this.format(n8, this.tbuf2, 0, 32);
            this.align = n7;
            n6 = n9 + 2;
            n5 = n9 + n3 + 2;
        } else if (n8 >= 0) {
            n6 = n8 + 1;
            n7 = 0;
            while (n7 < n3 && n7 <= n8) {
                if (byArray2[n7] != 57) break;
                ++n7;
            }
            if (n7 > n8 && n7 < n3 && byArray2[n7] >= 53) {
                ++n6;
            }
            if ((n5 = n3 + 1) <= n6) {
                n5 = n6 + 1;
            }
        } else {
            n6 = 2;
            n5 = 1 + Math.abs(n8) + n3;
        }
        if (d < 0.0) {
            ++n6;
            ++n5;
        }
        if (this.truncateOnOverflow && n6 > n2 || n6 > byArray.length - n) {
            this.truncationFiller(byArray, n, n2);
            return n + n2;
        }
        if (n5 < n2 && this.align) {
            n7 = n2 - n5;
            n = this.alignFill(byArray, n, n7);
            n2 -= n7;
        }
        n7 = n;
        if (d < 0.0) {
            byArray[n] = 45;
            ++n;
            --n2;
        }
        if (bl) {
            return Math.abs(this.mantissa(byArray2, n3, n8, bl, byArray, n, n2));
        }
        if ((n = this.mantissa(byArray2, n3, 0, bl, byArray, n, n2 - n9 - 1)) < 0) {
            n = -n;
            n2 -= n;
            if (n8 == 9 || n8 == 99) {
                if (n + n2 == n6) {
                    this.truncationFiller(byArray, n, n2);
                    return n + n2;
                }
                --n;
            }
            n9 = this.format(++n8, this.tbuf2, 0, 32);
        }
        byArray[n] = 69;
        System.arraycopy(this.tbuf2, 0, byArray, ++n, n9);
        return n + n9;
    }

    /*
     * Unable to fully structure code
     */
    int mantissa(byte[] var1_1, int var2_2, int var3_3, boolean var4_4, byte[] var5_5, int var6_6, int var7_7) {
        block15: {
            var8_8 = var6_6;
            var9_9 = 0;
            if (var3_3 >= 0) ** GOTO lbl23
            var5_5[var6_6] = 48;
            ++var6_6;
            if (--var7_7 > 0) {
                var5_5[var6_6] = 46;
                ++var6_6;
                --var7_7;
            }
            var10_10 = var3_3;
            while (var10_10 < -1 && var7_7 > 0) {
                var5_5[var6_6] = 48;
                ++var10_10;
                ++var6_6;
                --var7_7;
            }
            break block15;
lbl-1000:
            // 1 sources

            {
                var5_5[var6_6] = var1_1[var9_9];
                ++var6_6;
                ++var9_9;
                --var7_7;
                --var3_3;
lbl23:
                // 2 sources

                ** while (var3_3 >= 0 && var9_9 < var2_2)
            }
lbl24:
            // 1 sources

            var10_10 = 0;
            while (var10_10 <= var3_3) {
                var5_5[var6_6] = 48;
                ++var6_6;
                --var7_7;
                ++var10_10;
            }
            if (var7_7 > 0) {
                var5_5[var6_6] = 46;
                --var7_7;
                ++var6_6;
            }
        }
        while (var7_7 > 0 && var9_9 < var2_2) {
            var5_5[var6_6] = var1_1[var9_9];
            ++var6_6;
            --var3_3;
            --var7_7;
            ++var9_9;
        }
        if (var9_9 < var2_2 && var1_1[var9_9] >= 53) {
            var10_10 = var6_6 - 1;
            while (var10_10 >= var8_8) {
                if (var5_5[var10_10] != 46 && var5_5[var10_10] != 45) {
                    if (var5_5[var10_10] == 57) {
                        var5_5[var10_10] = 48;
                    } else {
                        v0 = var10_10;
                        var5_5[v0] = (byte)(var5_5[v0] + 1);
                        break;
                    }
                }
                --var10_10;
            }
            if (var10_10 < var8_8) {
                var5_5[var8_8] = 49;
                var11_11 = false;
                var10_10 = var8_8 + 1;
                while (var10_10 < var6_6) {
                    if (var5_5[var10_10] == 46) {
                        var11_11 = true;
                        if (!var4_4) break;
                        var5_5[var10_10] = 48;
                        if (++var10_10 >= var6_6) break;
                        var5_5[var10_10] = 46;
                        break;
                    }
                    ++var10_10;
                }
                if (var4_4 && !var11_11) {
                    var5_5[var6_6 + 1] = 48;
                    ++var6_6;
                }
                var6_6 = -var6_6;
            }
        }
        return var6_6;
    }

    void truncationFiller(byte[] byArray, int n, int n2) throws TruncationException {
        int n3 = n;
        while (n3 < n + n2) {
            byArray[n3] = this.truncationFill;
            ++n3;
        }
        if (this.truncationThrow) {
            throw new TruncationException();
        }
    }

    public int alignFill(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            byArray[n3] = 32;
            ++n3;
        }
        return n + n2;
    }

    static {
        int n = (int)Math.floor((int)(Math.log(Double.MIN_VALUE) * ilog10));
        int n2 = (int)Math.floor((int)(Math.log(Double.MAX_VALUE) * ilog10));
        tenpow = new double[++n2 - n + 1];
        int n3 = 0;
        while (n3 < tenpow.length) {
            ByteFormatter.tenpow[n3] = Math.pow(10.0, n3 + n);
            ++n3;
        }
        zeropow = -n;
        digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    }
}

