/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.RandomAccess;

public class BufferedFile
implements ArrayDataInput,
ArrayDataOutput,
RandomAccess {
    private int bufferOffset;
    private int bufferLength;
    private int bufferSize;
    private int primitiveArrayCount;
    private byte[] buffer;
    private String filename;
    private RandomAccessFile raf;
    private long fileOffset;
    private boolean doingInput;

    public BufferedFile(String string) throws IOException {
        this(string, "r", 32768);
    }

    public BufferedFile(String string, String string2) throws IOException {
        this(string, string2, 32768);
    }

    public BufferedFile(String string, String string2, int n) throws IOException {
        this.raf = new RandomAccessFile(string, string2);
        this.buffer = new byte[n];
        this.bufferOffset = 0;
        this.bufferLength = 0;
        this.fileOffset = 0L;
        this.bufferSize = n;
        this.filename = string;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkBuffer(-1);
        int n3 = 0;
        while (n2 > 0) {
            if (this.bufferOffset < this.bufferLength) {
                int n4 = n2;
                if (this.bufferOffset + n4 > this.bufferLength) {
                    n4 = this.bufferLength - this.bufferOffset;
                }
                System.arraycopy(this.buffer, this.bufferOffset, byArray, n, n4);
                n2 -= n4;
                this.bufferOffset += n4;
                n += n4;
                n3 += n4;
                continue;
            }
            try {
                if (n2 > this.bufferSize) {
                    this.checkBuffer(this.bufferSize);
                    continue;
                }
                this.checkBuffer(n2);
            }
            catch (EOFException eOFException) {
                if (this.bufferLength > 0) {
                    System.arraycopy(this.buffer, 0, byArray, n, this.bufferLength);
                    n3 += this.bufferLength;
                    this.bufferLength = 0;
                }
                if (n3 == 0) {
                    throw eOFException;
                }
                return n3;
            }
        }
        return n3;
    }

    private void checkBuffer(int n) throws IOException {
        if (!this.doingInput && this.bufferOffset > 0) {
            this.flush();
        }
        this.doingInput = true;
        if (this.bufferOffset + n < this.bufferLength) {
            return;
        }
        int n2 = this.bufferLength - this.bufferOffset;
        this.fileOffset += (long)this.bufferOffset;
        if (n2 > 0) {
            System.arraycopy(this.buffer, this.bufferOffset, this.buffer, 0, n2);
        }
        n -= n2;
        this.bufferLength = n2;
        this.bufferOffset = 0;
        while (n > 0) {
            n2 = this.raf.read(this.buffer, this.bufferLength, this.bufferSize - this.bufferLength);
            if (n2 < 0) {
                throw new EOFException();
            }
            n -= n2;
            this.bufferLength += n2;
        }
    }

    public int read() throws IOException {
        this.checkBuffer(1);
        ++this.bufferOffset;
        return this.buffer[this.bufferOffset - 1];
    }

    public long skip(long l) throws IOException {
        if (l > 0L && this.fileOffset + (long)this.bufferOffset + l > this.raf.length()) {
            l = this.raf.length() - this.fileOffset - (long)this.bufferOffset;
            this.seek(this.raf.length());
        } else if (this.fileOffset + (long)this.bufferOffset + l < 0L) {
            l = -(this.fileOffset + (long)this.bufferOffset);
            this.seek(0L);
        } else {
            this.seek(this.fileOffset + (long)this.bufferOffset + l);
        }
        return l;
    }

    public void seek(long l) throws IOException {
        if (!this.doingInput) {
            this.flush();
        }
        if (this.fileOffset <= l && l < this.fileOffset + (long)this.bufferLength) {
            this.bufferOffset = (int)(l - this.fileOffset);
        } else {
            if (l < 0L) {
                l = 0L;
            }
            this.fileOffset = l;
            this.raf.seek(this.fileOffset);
            this.bufferLength = 0;
            this.bufferOffset = 0;
        }
    }

    public boolean readBoolean() throws IOException {
        return this.convertToBoolean();
    }

    private boolean convertToBoolean() throws IOException {
        this.checkBuffer(1);
        ++this.bufferOffset;
        return this.buffer[this.bufferOffset - 1] == 1;
    }

    public byte readByte() throws IOException {
        this.checkBuffer(1);
        ++this.bufferOffset;
        return this.buffer[this.bufferOffset - 1];
    }

    public int readUnsignedByte() throws IOException {
        this.checkBuffer(1);
        ++this.bufferOffset;
        return this.buffer[this.bufferOffset - 1] | 0xFF;
    }

    public int readInt() throws IOException {
        return this.convertToInt();
    }

    private int convertToInt() throws IOException {
        this.checkBuffer(4);
        int n = this.bufferOffset;
        int n2 = this.buffer[n] << 24 | (this.buffer[n + 1] & 0xFF) << 16 | (this.buffer[n + 2] & 0xFF) << 8 | this.buffer[n + 3] & 0xFF;
        this.bufferOffset += 4;
        return n2;
    }

    public short readShort() throws IOException {
        return this.convertToShort();
    }

    private short convertToShort() throws IOException {
        this.checkBuffer(2);
        short s = (short)(this.buffer[this.bufferOffset] << 8 | this.buffer[this.bufferOffset + 1] & 0xFF);
        this.bufferOffset += 2;
        return s;
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public char readChar() throws IOException {
        return this.convertToChar();
    }

    private char convertToChar() throws IOException {
        this.checkBuffer(2);
        char c = (char)(this.buffer[this.bufferOffset] << 8 | this.buffer[this.bufferOffset + 1] & 0xFF);
        this.bufferOffset += 2;
        return c;
    }

    public long readLong() throws IOException {
        return this.convertToLong();
    }

    private long convertToLong() throws IOException {
        this.checkBuffer(8);
        int n = this.bufferOffset;
        int n2 = this.buffer[n] << 24 | (this.buffer[n + 1] & 0xFF) << 16 | (this.buffer[n + 2] & 0xFF) << 8 | this.buffer[n + 3] & 0xFF;
        int n3 = this.buffer[n + 4] << 24 | (this.buffer[n + 5] & 0xFF) << 16 | (this.buffer[n + 6] & 0xFF) << 8 | this.buffer[n + 7] & 0xFF;
        this.bufferOffset += 8;
        return (long)n2 << 32 | (long)n3 & 0xFFFFFFFFL;
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.convertToInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.convertToLong());
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IOException("Attempt to read outside byte array");
        }
        if (this.read(byArray, n, n2) < n2) {
            throw new EOFException();
        }
    }

    public int skipBytes(int n) throws IOException {
        if (this.skip(n) < (long)n) {
            throw new EOFException();
        }
        return n;
    }

    public String readUTF() throws IOException {
        this.checkBuffer(-1);
        this.raf.seek(this.fileOffset + (long)this.bufferOffset);
        String string = this.raf.readUTF();
        this.fileOffset = this.raf.getFilePointer();
        this.bufferLength = 0;
        this.bufferOffset = 0;
        return string;
    }

    public String readLine() throws IOException {
        this.checkBuffer(-1);
        this.raf.seek(this.fileOffset + (long)this.bufferOffset);
        String string = this.raf.readLine();
        this.fileOffset = this.raf.getFilePointer();
        this.bufferLength = 0;
        this.bufferOffset = 0;
        return string;
    }

    public int readArray(Object object) throws IOException {
        this.primitiveArrayCount = 0;
        return this.primitiveArrayRecurse(object);
    }

    protected int primitiveArrayRecurse(Object object) throws IOException {
        if (object == null) {
            return this.primitiveArrayCount;
        }
        String string = object.getClass().getName();
        if (string.charAt(0) != '[') {
            throw new IOException("Invalid object passed to BufferedDataInputStream.readArray:" + string);
        }
        if (string.charAt(1) == '[') {
            int n = 0;
            while (n < ((Object[])object).length) {
                this.primitiveArrayRecurse(((Object[])object)[n]);
                ++n;
            }
        } else {
            switch (string.charAt(1)) {
                case 'Z': {
                    this.primitiveArrayCount += this.read((boolean[])object, 0, ((boolean[])object).length);
                    break;
                }
                case 'B': {
                    int n = this.read((byte[])object, 0, ((byte[])object).length);
                    break;
                }
                case 'C': {
                    this.primitiveArrayCount += this.read((char[])object, 0, ((char[])object).length);
                    break;
                }
                case 'S': {
                    this.primitiveArrayCount += this.read((short[])object, 0, ((short[])object).length);
                    break;
                }
                case 'I': {
                    this.primitiveArrayCount += this.read((int[])object, 0, ((int[])object).length);
                    break;
                }
                case 'J': {
                    this.primitiveArrayCount += this.read((long[])object, 0, ((long[])object).length);
                    break;
                }
                case 'F': {
                    this.primitiveArrayCount += this.read((float[])object, 0, ((float[])object).length);
                    break;
                }
                case 'D': {
                    this.primitiveArrayCount += this.read((double[])object, 0, ((double[])object).length);
                    break;
                }
                case 'L': {
                    if (string.equals("[Ljava.lang.Object;")) {
                        int n = 0;
                        while (n < ((Object[])object).length) {
                            this.primitiveArrayRecurse(((Object[])object)[n]);
                            ++n;
                        }
                        break;
                    }
                    throw new IOException("Invalid object passed to BufferedFile.readPrimitiveArray: " + string);
                }
                default: {
                    throw new IOException("Invalid object passed to BufferedDataInputStream.readArray: " + string);
                }
            }
        }
        return this.primitiveArrayCount;
    }

    public int read(boolean[] blArray) throws IOException {
        return this.read(blArray, 0, blArray.length);
    }

    public int read(boolean[] blArray, int n, int n2) throws IOException {
        int n3 = n;
        try {
            while (n3 < n + n2) {
                blArray[n3] = this.convertToBoolean();
                ++n3;
            }
            return n2;
        }
        catch (EOFException eOFException) {
            return this.eofCheck(eOFException, n, n3, 1);
        }
    }

    public int read(short[] sArray) throws IOException {
        return this.read(sArray, 0, sArray.length);
    }

    public int read(short[] sArray, int n, int n2) throws IOException {
        int n3 = n;
        try {
            while (n3 < n + n2) {
                sArray[n3] = this.convertToShort();
                ++n3;
            }
            return n2 * 2;
        }
        catch (EOFException eOFException) {
            return this.eofCheck(eOFException, n, n3, 2);
        }
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = n;
        try {
            while (n3 < n + n2) {
                cArray[n3] = this.convertToChar();
                ++n3;
            }
            return n2 * 2;
        }
        catch (EOFException eOFException) {
            return this.eofCheck(eOFException, n, n3, 2);
        }
    }

    public int read(int[] nArray) throws IOException {
        return this.read(nArray, 0, nArray.length);
    }

    public int read(int[] nArray, int n, int n2) throws IOException {
        int n3 = n;
        try {
            while (n3 < n + n2) {
                nArray[n3] = this.convertToInt();
                ++n3;
            }
            return n2 * 4;
        }
        catch (EOFException eOFException) {
            return this.eofCheck(eOFException, n, n3, 4);
        }
    }

    public int read(long[] lArray) throws IOException {
        return this.read(lArray, 0, lArray.length);
    }

    public int read(long[] lArray, int n, int n2) throws IOException {
        int n3 = n;
        try {
            while (n3 < n + n2) {
                lArray[n3] = this.convertToLong();
                ++n3;
            }
            return n2 * 8;
        }
        catch (EOFException eOFException) {
            return this.eofCheck(eOFException, n, n3, 8);
        }
    }

    public int read(float[] fArray) throws IOException {
        return this.read(fArray, 0, fArray.length);
    }

    public int read(float[] fArray, int n, int n2) throws IOException {
        int n3 = n;
        try {
            while (n3 < n + n2) {
                fArray[n3] = Float.intBitsToFloat(this.convertToInt());
                ++n3;
            }
            return n2 * 4;
        }
        catch (EOFException eOFException) {
            return this.eofCheck(eOFException, n, n3, 4);
        }
    }

    public int read(double[] dArray) throws IOException {
        return this.read(dArray, 0, dArray.length);
    }

    public int read(double[] dArray, int n, int n2) throws IOException {
        int n3 = n;
        try {
            while (n3 < n + n2) {
                dArray[n3] = Double.longBitsToDouble(this.convertToLong());
                ++n3;
            }
            return n2 * 8;
        }
        catch (EOFException eOFException) {
            return this.eofCheck(eOFException, n, n3, 8);
        }
    }

    private int eofCheck(EOFException eOFException, int n, int n2, int n3) throws EOFException {
        if (n == n2) {
            throw eOFException;
        }
        return (n2 - n) * n3;
    }

    private void needBuffer(int n) throws IOException {
        if (this.doingInput) {
            this.fileOffset += (long)this.bufferOffset;
            this.raf.seek(this.fileOffset);
            this.doingInput = false;
            this.bufferOffset = 0;
            this.bufferLength = 0;
        }
        if (this.bufferOffset + n >= this.bufferSize) {
            this.raf.write(this.buffer, 0, this.bufferOffset);
            this.fileOffset += (long)this.bufferOffset;
            this.bufferOffset = 0;
        }
    }

    public void write(int n) throws IOException {
        this.convertFromByte(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < this.bufferSize) {
            this.needBuffer(n2);
            System.arraycopy(byArray, n, this.buffer, this.bufferOffset, n2);
            this.bufferOffset += n2;
        } else {
            this.flush();
            this.raf.write(byArray, n, n2);
            this.fileOffset += (long)n2;
            this.doingInput = false;
            this.bufferOffset = 0;
            this.bufferLength = 0;
        }
    }

    public void flush() throws IOException {
        if (!this.doingInput && this.bufferOffset > 0) {
            this.raf.write(this.buffer, 0, this.bufferOffset);
            this.fileOffset += (long)this.bufferOffset;
            this.bufferOffset = 0;
            this.bufferLength = 0;
        }
    }

    protected void finalize() {
        try {
            if (this.getFD().valid()) {
                this.flush();
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.convertFromBoolean(bl);
    }

    private void convertFromBoolean(boolean bl) throws IOException {
        this.needBuffer(1);
        this.buffer[this.bufferOffset] = bl ? (byte)1 : 0;
        ++this.bufferOffset;
    }

    public void writeByte(int n) throws IOException {
        this.convertFromByte(n);
    }

    private void convertFromByte(int n) throws IOException {
        this.needBuffer(1);
        this.buffer[this.bufferOffset++] = (byte)n;
    }

    public void writeInt(int n) throws IOException {
        this.convertFromInt(n);
    }

    private void convertFromInt(int n) throws IOException {
        this.needBuffer(4);
        this.buffer[this.bufferOffset++] = (byte)(n >>> 24);
        this.buffer[this.bufferOffset++] = (byte)(n >>> 16);
        this.buffer[this.bufferOffset++] = (byte)(n >>> 8);
        this.buffer[this.bufferOffset++] = (byte)n;
    }

    public void writeShort(int n) throws IOException {
        this.convertFromShort(n);
    }

    private void convertFromShort(int n) throws IOException {
        this.needBuffer(2);
        this.buffer[this.bufferOffset++] = (byte)(n >>> 8);
        this.buffer[this.bufferOffset++] = (byte)n;
    }

    public void writeChar(int n) throws IOException {
        this.convertFromChar(n);
    }

    private void convertFromChar(int n) throws IOException {
        this.needBuffer(2);
        this.buffer[this.bufferOffset++] = (byte)(n >>> 8);
        this.buffer[this.bufferOffset++] = (byte)n;
    }

    public void writeLong(long l) throws IOException {
        this.convertFromLong(l);
    }

    private void convertFromLong(long l) throws IOException {
        this.needBuffer(8);
        this.buffer[this.bufferOffset++] = (byte)(l >>> 56);
        this.buffer[this.bufferOffset++] = (byte)(l >>> 48);
        this.buffer[this.bufferOffset++] = (byte)(l >>> 40);
        this.buffer[this.bufferOffset++] = (byte)(l >>> 32);
        this.buffer[this.bufferOffset++] = (byte)(l >>> 24);
        this.buffer[this.bufferOffset++] = (byte)(l >>> 16);
        this.buffer[this.bufferOffset++] = (byte)(l >>> 8);
        this.buffer[this.bufferOffset++] = (byte)l;
    }

    public void writeFloat(float f) throws IOException {
        this.convertFromInt(Float.floatToIntBits(f));
    }

    public void writeDouble(double d) throws IOException {
        this.convertFromLong(Double.doubleToLongBits(d));
    }

    public void writeBytes(String string) throws IOException {
        this.write(string.getBytes(), 0, string.length());
    }

    public void writeChars(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.convertFromChar(string.charAt(n2));
            ++n2;
        }
    }

    public void writeUTF(String string) throws IOException {
        this.flush();
        this.raf.writeUTF(string);
        this.fileOffset = this.raf.getFilePointer();
    }

    public void writeArray(Object object) throws IOException {
        String string = object.getClass().getName();
        if (string.charAt(0) != '[') {
            throw new IOException("Invalid object passed to BufferedFile.writeArray:" + string);
        }
        if (string.charAt(1) == '[') {
            int n = 0;
            while (n < ((Object[])object).length) {
                this.writeArray(((Object[])object)[n]);
                ++n;
            }
        } else {
            switch (string.charAt(1)) {
                case 'Z': {
                    this.write((boolean[])object, 0, ((boolean[])object).length);
                    break;
                }
                case 'B': {
                    this.write((byte[])object, 0, ((byte[])object).length);
                    break;
                }
                case 'C': {
                    this.write((char[])object, 0, ((char[])object).length);
                    break;
                }
                case 'S': {
                    this.write((short[])object, 0, ((short[])object).length);
                    break;
                }
                case 'I': {
                    this.write((int[])object, 0, ((int[])object).length);
                    break;
                }
                case 'J': {
                    this.write((long[])object, 0, ((long[])object).length);
                    break;
                }
                case 'F': {
                    this.write((float[])object, 0, ((float[])object).length);
                    break;
                }
                case 'D': {
                    this.write((double[])object, 0, ((double[])object).length);
                    break;
                }
                case 'L': {
                    if (string.equals("[Ljava.lang.String;")) {
                        this.write((String[])object, 0, ((String[])object).length);
                        break;
                    }
                    if (string.equals("[Ljava.lang.Object;")) {
                        int n = 0;
                        while (n < ((Object[])object).length) {
                            this.writeArray(((Object[])object)[n]);
                            ++n;
                        }
                        break;
                    }
                    throw new IOException("Invalid object passed to BufferedFile.write: " + string);
                }
                default: {
                    throw new IOException("Invalid object passed to BufferedFile.write: " + string);
                }
            }
        }
    }

    public void write(boolean[] blArray) throws IOException {
        this.write(blArray, 0, blArray.length);
    }

    public void write(boolean[] blArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            this.convertFromBoolean(blArray[n3]);
            ++n3;
        }
    }

    public void write(short[] sArray) throws IOException {
        this.write(sArray, 0, sArray.length);
    }

    public void write(short[] sArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            this.convertFromShort(sArray[n3]);
            ++n3;
        }
    }

    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            this.convertFromChar(cArray[n3]);
            ++n3;
        }
    }

    public void write(int[] nArray) throws IOException {
        this.write(nArray, 0, nArray.length);
    }

    public void write(int[] nArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            this.convertFromInt(nArray[n3]);
            ++n3;
        }
    }

    public void write(long[] lArray) throws IOException {
        this.write(lArray, 0, lArray.length);
    }

    public void write(long[] lArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            this.convertFromLong(lArray[n3]);
            ++n3;
        }
    }

    public void write(float[] fArray) throws IOException {
        this.write(fArray, 0, fArray.length);
    }

    public void write(float[] fArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            this.convertFromInt(Float.floatToIntBits(fArray[n3]));
            ++n3;
        }
    }

    public void write(double[] dArray) throws IOException {
        this.write(dArray, 0, dArray.length);
    }

    public void write(double[] dArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            this.convertFromLong(Double.doubleToLongBits(dArray[n3]));
            ++n3;
        }
    }

    public void write(String[] stringArray) throws IOException {
        this.write(stringArray, 0, stringArray.length);
    }

    public void write(String[] stringArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            this.writeBytes(stringArray[n3]);
            ++n3;
        }
    }

    public void close() throws IOException {
        this.flush();
        this.raf.close();
    }

    public FileDescriptor getFD() throws IOException {
        return this.raf.getFD();
    }

    public long length() throws IOException {
        this.flush();
        return this.raf.length();
    }

    public long getFilePointer() {
        return this.fileOffset + (long)this.bufferOffset;
    }

    public void setLength(long l) throws IOException {
        this.flush();
        this.raf.setLength(l);
        if (l < this.fileOffset) {
            this.fileOffset = l;
        }
    }
}

