/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;

public class RandomGroupsData
extends Data {
    private Object[][] dataArray;

    public RandomGroupsData() {
        this.dataArray = new Object[0][];
    }

    public RandomGroupsData(Object[][] objectArray) {
        this.dataArray = objectArray;
    }

    protected int getTrueSize() {
        if (this.dataArray != null && this.dataArray.length > 0) {
            return (ArrayFuncs.computeSize(this.dataArray[0][0]) + ArrayFuncs.computeSize(this.dataArray[0][1])) * this.dataArray.length;
        }
        return 0;
    }

    public void read(ArrayDataInput arrayDataInput) throws FitsException {
        this.setFileOffset(arrayDataInput);
        try {
            arrayDataInput.readArray(this.dataArray);
        }
        catch (IOException iOException) {
            throw new FitsException("IO error reading Random Groups data " + iOException);
        }
        int n = FitsUtil.padding(this.getTrueSize());
        try {
            arrayDataInput.skipBytes(n);
        }
        catch (IOException iOException) {
            throw new FitsException("IO error reading padding.");
        }
    }

    public void write(ArrayDataOutput arrayDataOutput) throws FitsException {
        try {
            arrayDataOutput.writeArray(this.dataArray);
            byte[] byArray = new byte[FitsUtil.padding(this.getTrueSize())];
            arrayDataOutput.write(byArray);
            arrayDataOutput.flush();
        }
        catch (IOException iOException) {
            throw new FitsException("IO error writing random groups data " + iOException);
        }
    }

    protected void fillHeader(Header header) throws FitsException {
        Class clazz;
        if (this.dataArray.length <= 0 || this.dataArray[0].length != 2) {
            throw new FitsException("Data not conformable to Random Groups");
        }
        int n = this.dataArray.length;
        Object object = this.dataArray[0][0];
        Object object2 = this.dataArray[0][1];
        Class clazz2 = ArrayFuncs.getBaseClass(object);
        if (clazz2 != (clazz = ArrayFuncs.getBaseClass(object2))) {
            throw new FitsException("Data and parameters do not agree in type for random group");
        }
        int[] nArray = ArrayFuncs.getDimensions(object);
        int[] nArray2 = ArrayFuncs.getDimensions(object2);
        if (nArray.length != 1) {
            throw new FitsException("Parameters are not 1 d array for random groups");
        }
        header.setSimple(true);
        if (clazz == Byte.TYPE) {
            header.setBitpix(8);
        } else if (clazz == Short.TYPE) {
            header.setBitpix(16);
        } else if (clazz == Integer.TYPE) {
            header.setBitpix(32);
        } else if (clazz == Long.TYPE) {
            header.setBitpix(64);
        } else if (clazz == Float.TYPE) {
            header.setBitpix(-32);
        } else if (clazz == Double.TYPE) {
            header.setBitpix(-64);
        } else {
            throw new FitsException("Data type:" + clazz + " not supported for random groups");
        }
        header.setNaxes(nArray2.length + 1);
        header.addValue("NAXIS1", 0L, "");
        int n2 = 2;
        while (n2 <= nArray2.length + 1) {
            header.addValue("NAXIS" + n2, nArray2[n2 - 2], "");
            ++n2;
        }
        header.addValue("GROUPS", true, "");
        header.addValue("GCOUNT", this.dataArray.length, "");
        header.addValue("PCOUNT", nArray[0], "");
    }

    public Object getData() {
        return this.dataArray;
    }
}

