/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import nom.tam.fits.FitsElement;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;
import nom.tam.util.RandomAccess;

public class FitsHeap
implements FitsElement {
    private byte[] heap;
    private int heapSize;
    private long fileOffset = -1L;
    private ArrayDataInput input;
    private int heapOffset = 0;
    private BufferedDataInputStream bstr;

    FitsHeap(int n) {
        this.heap = new byte[n];
        this.heapSize = n;
    }

    public void read(ArrayDataInput arrayDataInput) throws FitsException {
        if (arrayDataInput instanceof RandomAccess) {
            this.fileOffset = FitsUtil.findOffset(arrayDataInput);
            this.input = arrayDataInput;
        }
        if (this.heap != null) {
            try {
                arrayDataInput.read(this.heap, 0, this.heapSize);
            }
            catch (IOException iOException) {
                throw new FitsException("Error reading heap:" + iOException);
            }
        }
    }

    public void write(ArrayDataOutput arrayDataOutput) throws FitsException {
        try {
            arrayDataOutput.write(this.heap, 0, this.heapSize);
        }
        catch (IOException iOException) {
            throw new FitsException("Error writing heap:" + iOException);
        }
    }

    public boolean rewriteable() {
        return this.fileOffset >= 0L && this.input instanceof ArrayDataOutput;
    }

    public void rewrite() throws IOException, FitsException {
        if (!this.rewriteable()) {
            throw new FitsException("Invalid attempt to rewrite FitsHeap");
        }
        ArrayDataOutput arrayDataOutput = (ArrayDataOutput)((Object)this.input);
        FitsUtil.reposition(arrayDataOutput, this.fileOffset);
        this.write(arrayDataOutput);
    }

    public void getData(int n, Object object) throws FitsException {
        try {
            if (this.bstr == null || this.heapOffset > n) {
                this.heapOffset = 0;
                this.bstr = new BufferedDataInputStream(new ByteArrayInputStream(this.heap));
            }
            this.bstr.skipBytes(n - this.heapOffset);
            this.heapOffset = n;
            this.heapOffset += this.bstr.readArray(object);
        }
        catch (IOException iOException) {
            throw new FitsException("Error decoding heap area at offset=" + n + ".  Exception: Exception " + iOException);
        }
    }

    void expandHeap(int n) {
        if (this.heapSize + n > this.heap.length) {
            int n2 = (this.heapSize + n) * 2;
            if (n2 < 16384) {
                n2 = 16384;
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.heap, 0, byArray, 0, this.heapSize);
            this.heap = byArray;
        }
    }

    int putData(Object object) throws FitsException {
        int n = ArrayFuncs.computeSize(object);
        this.expandHeap(n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        try {
            BufferedDataOutputStream bufferedDataOutputStream = new BufferedDataOutputStream(byteArrayOutputStream);
            bufferedDataOutputStream.writeArray(object);
            bufferedDataOutputStream.flush();
            bufferedDataOutputStream.close();
        }
        catch (IOException iOException) {
            throw new FitsException("Unable to write variable column length data");
        }
        System.arraycopy(byteArrayOutputStream.toByteArray(), 0, this.heap, this.heapSize, n);
        int n2 = this.heapSize;
        this.heapSize += n;
        this.heapOffset = this.heapSize;
        return n2;
    }

    public int getOffset() {
        return this.heapOffset;
    }

    public int size() {
        return this.heapSize;
    }

    public long getSize() {
        return this.size();
    }

    public long getFileOffset() {
        return this.fileOffset;
    }
}

