/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.tree.DefaultMutableTreeNode;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.view.ViewProperties;

public final class Tools {
    public static final long MAX_INT8 = 127L;
    public static final long MAX_UINT8 = 255L;
    public static final long MAX_INT16 = 32767L;
    public static final long MAX_UINT16 = 65535L;
    public static final long MAX_INT32 = Integer.MAX_VALUE;
    public static final long MAX_UINT32 = 0xFFFFFFFFL;
    public static final long MAX_INT64 = Long.MAX_VALUE;
    public static final BigInteger MAX_UINT64 = new BigInteger("18446744073709551615");
    public static final String FILE_TYPE_JPEG = "JPEG";
    public static final String FILE_TYPE_TIFF = "TIFF";
    public static final String FILE_TYPE_PNG = "PNG";
    public static final String FILE_TYPE_GIF = "GIF";
    public static final String FILE_TYPE_BMP = "BMP";
    public static final String FILE_TYPE_IMAGE = "IMG";

    public static final void debug(Object caller, Object msg) {
        if (caller != null) {
            System.out.println("*** " + caller.getClass().getName() + ": " + msg);
        }
    }

    public static void convertImageToHDF(String imgFileName, String hFileName, String fromType, String toType) throws Exception {
        File imgFile = null;
        if (imgFileName == null) {
            throw new NullPointerException("The source image file is null.");
        }
        imgFile = new File(imgFileName);
        if (!imgFile.exists()) {
            throw new NullPointerException("The source image file does not exist.");
        }
        if (hFileName == null) {
            throw new NullPointerException("The target HDF file is null.");
        }
        if (!fromType.equals(FILE_TYPE_IMAGE)) {
            throw new UnsupportedOperationException("Unsupported image type.");
        }
        if (!toType.equals("HDF4") && !toType.equals("HDF5")) {
            throw new UnsupportedOperationException("Unsupported destination file type.");
        }
        BufferedImage image = null;
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(imgFileName));
            image = ImageIO.read(in);
            in.close();
        }
        catch (Throwable err) {
            image = null;
        }
        if (image == null) {
            throw new UnsupportedOperationException("Failed to read image: " + imgFileName);
        }
        int h = image.getHeight();
        int w = image.getWidth();
        byte[] data = null;
        try {
            data = new byte[3 * h * w];
        }
        catch (OutOfMemoryError err) {
            err.printStackTrace();
            throw new RuntimeException("Out of memory error.");
        }
        int idx = 0;
        int rgb = 0;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                rgb = image.getRGB(j, i);
                data[idx++] = (byte)(rgb >> 16);
                data[idx++] = (byte)(rgb >> 8);
                data[idx++] = (byte)rgb;
            }
        }
        long[] dims = null;
        Datatype type = null;
        Group pgroup = null;
        String imgName = imgFile.getName();
        FileFormat newfile = null;
        FileFormat thefile = null;
        if (toType.equals("HDF5")) {
            long[] h5dims;
            thefile = FileFormat.getFileFormat((String)"HDF5");
            dims = h5dims = new long[]{h, w, 3L};
        } else if (toType.equals("HDF4")) {
            thefile = FileFormat.getFileFormat((String)"HDF4");
            long[] h4dims = new long[]{w, h, 3L};
            dims = h4dims;
        } else {
            thefile = null;
        }
        if (thefile != null) {
            newfile = thefile.createInstance(hFileName, 8);
            newfile.open();
            pgroup = (Group)((DefaultMutableTreeNode)newfile.getRootNode()).getUserObject();
            type = newfile.createDatatype(2, 1, -1, 0);
            newfile.createImage(imgName, pgroup, type, dims, null, null, -1, 3, 0, (Object)data);
            newfile.close();
        }
        data = null;
        image = null;
        Runtime.getRuntime().gc();
    }

    public static void saveImageAs(BufferedImage image, File file, String type) throws Exception {
        if (image == null) {
            throw new NullPointerException("The source image is null.");
        }
        ImageIO.write((RenderedImage)image, type, file);
    }

    public static final byte[][] createGrayPalette() {
        byte[][] p = new byte[3][256];
        for (int i = 0; i < 256; ++i) {
            byte by = (byte)i;
            p[2][i] = by;
            p[1][i] = by;
            p[0][i] = by;
        }
        return p;
    }

    public static final byte[][] createReverseGrayPalette() {
        byte[][] p = new byte[3][256];
        for (int i = 0; i < 256; ++i) {
            byte by = (byte)(255 - i);
            p[2][i] = by;
            p[1][i] = by;
            p[0][i] = by;
        }
        return p;
    }

    public static final byte[][] createGrayWavePalette() {
        byte[][] p = new byte[3][256];
        for (int i = 0; i < 256; ++i) {
            byte by = (byte)(127.0 + 127.0 * Math.sin((double)(i - 32) / 20.3));
            p[2][i] = by;
            p[1][i] = by;
            p[0][i] = by;
        }
        return p;
    }

    public static final byte[][] createRainbowPalette() {
        byte[][] p = new byte[3][256];
        for (int i = 1; i < 255; ++i) {
            int b;
            int g;
            byte r;
            if (i <= 29) {
                r = (byte)(129.36 - (double)i * 4.36);
                g = 0;
                b = -1;
            } else if (i <= 86) {
                r = 0;
                g = (byte)(-133.54 + (double)i * 4.52);
                b = -1;
            } else if (i <= 141) {
                r = 0;
                g = -1;
                b = (byte)(665.83 - (double)i * 4.72);
            } else if (i <= 199) {
                r = (byte)(-635.26 + (double)i * 4.47);
                g = -1;
                b = 0;
            } else {
                r = (byte)-1;
                g = (byte)(1166.81 - (double)i * 4.57);
                b = 0;
            }
            p[0][i] = r;
            p[1][i] = g;
            p[2][i] = b;
        }
        p[2][0] = 0;
        p[1][0] = 0;
        p[0][0] = 0;
        p[2][255] = -1;
        p[1][255] = -1;
        p[0][255] = -1;
        return p;
    }

    public static final byte[][] createNaturePalette() {
        int i;
        byte[][] p = new byte[3][256];
        for (i = 1; i < 210; ++i) {
            p[0][i] = (byte)((Math.sin((double)(i - 5) / 16.0) + 1.0) * 90.0);
            p[1][i] = (byte)((1.0 - Math.sin((double)(i - 30) / 12.0)) * 64.0 * (1.0 - (double)i / 255.0) + 128.0 - (double)(i / 2));
            p[2][i] = (byte)((1.0 - Math.sin((double)(i - 8) / 9.0)) * 110.0 + 30.0);
        }
        for (i = 210; i < 255; ++i) {
            p[0][i] = 80;
            p[1][i] = 0;
            p[2][i] = -56;
        }
        p[2][0] = 0;
        p[1][0] = 0;
        p[0][0] = 0;
        p[2][255] = -1;
        p[1][255] = -1;
        p[0][255] = -1;
        return p;
    }

    public static final byte[][] createWavePalette() {
        byte[][] p = new byte[3][256];
        for (int i = 1; i < 255; ++i) {
            p[0][i] = (byte)((Math.sin((double)i / 40.0 - 3.2) + 1.0) * 128.0);
            p[1][i] = (byte)((1.0 - Math.sin((double)i / 2.55 - 3.1)) * 70.0 + 30.0);
            p[2][i] = (byte)((1.0 - Math.sin((double)i / 40.0 - 3.1)) * 128.0);
        }
        p[2][0] = 0;
        p[1][0] = 0;
        p[0][0] = 0;
        p[2][255] = -1;
        p[1][255] = -1;
        p[0][255] = -1;
        return p;
    }

    public static final byte[][] readPalette(String filename) {
        int j;
        int i;
        int COLOR256 = 256;
        BufferedReader in = null;
        String line = null;
        int nentries = 0;
        float[][] tbl = new float[256][4];
        if (filename == null) {
            return null;
        }
        try {
            in = new BufferedReader(new FileReader(filename));
        }
        catch (Exception ex) {
            in = null;
        }
        if (in == null) {
            return null;
        }
        int idx = 0;
        float min_color = 0.0f;
        float max_color = 0.0f;
        float min_v = 0.0f;
        float max_v = 0.0f;
        float ratio = 0.0f;
        float b = 0.0f;
        float g = 0.0f;
        float r = 0.0f;
        float v = 0.0f;
        do {
            StringTokenizer st;
            try {
                line = in.readLine();
            }
            catch (Exception ex) {
                line = null;
            }
            if (line == null || (st = new StringTokenizer(line)).countTokens() != 4) continue;
            try {
                v = Float.valueOf(st.nextToken()).floatValue();
                r = Float.valueOf(st.nextToken()).floatValue();
                g = Float.valueOf(st.nextToken()).floatValue();
                b = Float.valueOf(st.nextToken()).floatValue();
            }
            catch (NumberFormatException ex) {
                continue;
            }
            tbl[idx][0] = v;
            tbl[idx][1] = r;
            tbl[idx][2] = g;
            tbl[idx][3] = b;
            if (idx == 0) {
                max_v = min_v = v;
                max_color = min_color = r;
            }
            max_v = Math.max(max_v, v);
            max_color = Math.max(max_color, r);
            max_color = Math.max(max_color, g);
            max_color = Math.max(max_color, b);
            min_v = Math.min(min_v, v);
            min_color = Math.min(min_color, r);
            min_color = Math.min(min_color, g);
            min_color = Math.min(min_color, b);
            if (++idx >= 256) break;
        } while (line != null);
        try {
            in.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        nentries = idx;
        if (nentries <= 1) {
            return null;
        }
        nentries = idx;
        if (max_color <= 1.0f) {
            ratio = min_color == max_color ? 1.0f : 255.0f / (max_color - min_color);
            for (i = 0; i < nentries; ++i) {
                for (j = 1; j < 4; ++j) {
                    tbl[i][j] = (tbl[i][j] - min_color) * ratio;
                }
            }
        }
        idx = 0;
        ratio = min_v == max_v ? 1.0f : 255.0f / (max_v - min_v);
        int[][] p = new int[3][256];
        for (i = 0; i < nentries; ++i) {
            idx = (int)((tbl[i][0] - min_v) * ratio);
            for (j = 0; j < 3; ++j) {
                p[j][idx] = (int)tbl[i][j + 1];
            }
        }
        for (i = 1; i < 256; ++i) {
            if (p[0][i] + p[1][i] + p[2][i] != 0) continue;
            for (j = i + 1; j < 256 && p[0][j] + p[1][j] + p[2][j] == 0; ++j) {
            }
            if (j >= 256) break;
            float d1 = (p[0][j] - p[0][i - 1]) / (j - i);
            float d2 = (p[1][j] - p[1][i - 1]) / (j - i);
            float d3 = (p[2][j] - p[2][i - 1]) / (j - i);
            for (int k = i; k <= j; ++k) {
                p[0][k] = (int)((float)p[0][i - 1] + d1 * (float)(k - i + 1));
                p[1][k] = (int)((float)p[1][i - 1] + d2 * (float)(k - i + 1));
                p[2][k] = (int)((float)p[2][i - 1] + d3 * (float)(k - i + 1));
            }
            i = j + 1;
        }
        byte[][] pal = new byte[3][256];
        for (i = 1; i < 256; ++i) {
            for (j = 0; j < 3; ++j) {
                pal[j][i] = (byte)p[j][i];
            }
        }
        return pal;
    }

    public static boolean hasAlpha(Image image) {
        if (image == null) {
            return false;
        }
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static Image createIndexedImage(byte[] imageData, byte[][] palette, int w, int h) {
        Image theImage = null;
        IndexColorModel colorModel = new IndexColorModel(8, 256, palette[0], palette[1], palette[2]);
        theImage = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w, h, (ColorModel)colorModel, imageData, 0, w));
        return theImage;
    }

    public static Image createTrueColorImage(byte[] imageData, boolean planeInterlace, int w, int h) {
        Image theImage = null;
        int imgSize = w * h;
        int[] packedImageData = new int[imgSize];
        int pixel = 0;
        int idx = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                b = 0;
                g = 0;
                r = 0;
                pixel = 0;
                if (planeInterlace) {
                    r = imageData[idx];
                    g = imageData[imgSize + idx];
                    b = imageData[imgSize * 2 + idx];
                } else {
                    r = imageData[idx * 3];
                    g = imageData[idx * 3 + 1];
                    b = imageData[idx * 3 + 2];
                }
                r = r << 16 & 0xFF0000;
                g = g << 8 & 0xFF00;
                pixel = 0xFF000000 | r | g | (b &= 0xFF);
                packedImageData[idx++] = pixel;
            }
        }
        DirectColorModel dcm = (DirectColorModel)ColorModel.getRGBdefault();
        theImage = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(w, h, (ColorModel)dcm, packedImageData, 0, w));
        packedImageData = null;
        return theImage;
    }

    public static byte[] getBytes(Object rawData, double[] minmax, byte[] byteData) {
        return Tools.getBytes(rawData, minmax, -1, -1, false, null, false, byteData);
    }

    public static byte[] getBytes(Object rawData, double[] minmax, int w, int h, boolean isTransposed, byte[] byteData) {
        return Tools.getBytes(rawData, minmax, w, h, isTransposed, null, false, byteData);
    }

    public static byte[] getBytes(Object rawData, double[] minmax, Object fillValue, byte[] byteData) {
        return Tools.getBytes(rawData, minmax, -1, -1, false, fillValue, false, byteData);
    }

    public static byte[] getBytes(Object rawData, double[] minmax, int w, int h, boolean isTransposed, Object fillValue, byte[] byteData) {
        return Tools.getBytes(rawData, minmax, w, h, isTransposed, fillValue, false, byteData);
    }

    public static byte[] getBytes(Object rawData, double[] minmax, int w, int h, boolean isTransposed, Object fillValue, boolean convertByteData, byte[] byteData) {
        if (rawData == null) {
            return null;
        }
        if (!rawData.getClass().isArray()) {
            return null;
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double ratio = 1.0;
        String cname = rawData.getClass().getName();
        char dname = cname.charAt(cname.lastIndexOf("[") + 1);
        int size = Array.getLength(rawData);
        if (minmax == null) {
            minmax = new double[2];
            minmax[1] = 0.0;
            minmax[0] = 0.0;
        }
        if (dname == 'B') {
            return Tools.convertByteData((byte[])rawData, minmax, w, h, isTransposed, fillValue, convertByteData, byteData);
        }
        if (byteData == null || size != byteData.length) {
            byteData = new byte[size];
        }
        if (minmax[0] == minmax[1]) {
            Tools.findMinMax(rawData, minmax, fillValue);
        }
        ratio = (min = minmax[0]) == (max = minmax[1]) ? 1.0 : 255.0 / (max - min);
        int idxSrc = 0;
        int idxDst = 0;
        switch (dname) {
            case 'S': {
                short[] s = (short[])rawData;
                short fvs = 0;
                if (fillValue != null) {
                    fvs = ((short[])fillValue)[0];
                }
                if (isTransposed) {
                    for (int i = 0; i < h; ++i) {
                        for (int j = 0; j < w; ++j) {
                            idxSrc = j * h + i;
                            idxDst = i * w + j;
                            byteData[idxDst] = (double)s[idxSrc] <= min || s[idxSrc] == fvs ? 0 : ((double)s[idxSrc] >= max ? -1 : (byte)(((double)s[idxSrc] - min) * ratio));
                        }
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        byteData[i] = (double)s[i] <= min || s[i] == fvs ? 0 : ((double)s[i] >= max ? -1 : (byte)(((double)s[i] - min) * ratio));
                    }
                }
                break;
            }
            case 'I': {
                int[] ia = (int[])rawData;
                int fvi = 0;
                if (fillValue != null) {
                    fvi = ((int[])fillValue)[0];
                }
                if (isTransposed) {
                    for (int i = 0; i < h; ++i) {
                        for (int j = 0; j < w; ++j) {
                            idxSrc = j * h + i;
                            idxDst = i * w + j;
                            byteData[idxDst] = (double)ia[idxSrc] <= min || ia[idxSrc] == fvi ? 0 : ((double)ia[idxSrc] >= max ? -1 : (byte)(((double)ia[idxSrc] - min) * ratio));
                        }
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        byteData[i] = (double)ia[i] <= min || ia[i] == fvi ? 0 : ((double)ia[i] >= max ? -1 : (byte)(((double)ia[i] - min) * ratio));
                    }
                }
                break;
            }
            case 'J': {
                long[] l = (long[])rawData;
                long fvl = 0L;
                if (fillValue != null) {
                    fvl = ((long[])fillValue)[0];
                }
                if (isTransposed) {
                    for (int i = 0; i < h; ++i) {
                        for (int j = 0; j < w; ++j) {
                            idxSrc = j * h + i;
                            idxDst = i * w + j;
                            byteData[idxDst] = (double)l[idxSrc] <= min || l[idxSrc] == fvl ? 0 : ((double)l[idxSrc] >= max ? -1 : (byte)(((double)l[idxSrc] - min) * ratio));
                        }
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        byteData[i] = (double)l[i] <= min || l[i] == fvl ? 0 : ((double)l[i] >= max ? -1 : (byte)(((double)l[i] - min) * ratio));
                    }
                }
                break;
            }
            case 'F': {
                float[] f = (float[])rawData;
                float fvf = 0.0f;
                if (fillValue != null) {
                    fvf = ((float[])fillValue)[0];
                }
                if (isTransposed) {
                    for (int i = 0; i < h; ++i) {
                        for (int j = 0; j < w; ++j) {
                            idxSrc = j * h + i;
                            idxDst = i * w + j;
                            byteData[idxDst] = (double)f[idxSrc] <= min || f[idxSrc] == fvf || Tools.isNaNINF(f[idxSrc]) ? 0 : ((double)f[idxSrc] >= max ? -1 : (byte)(((double)f[idxSrc] - min) * ratio));
                        }
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        byteData[i] = (double)f[i] <= min | f[i] == fvf || Tools.isNaNINF(f[i]) ? 0 : ((double)f[i] >= max ? -1 : (byte)(((double)f[i] - min) * ratio));
                    }
                }
                break;
            }
            case 'D': {
                double[] d = (double[])rawData;
                double fvd = 0.0;
                if (fillValue != null) {
                    fvd = ((double[])fillValue)[0];
                }
                if (isTransposed) {
                    for (int i = 0; i < h; ++i) {
                        for (int j = 0; j < w; ++j) {
                            idxSrc = j * h + i;
                            idxDst = i * w + j;
                            byteData[idxDst] = d[idxSrc] <= min || d[idxSrc] == fvd || Tools.isNaNINF(d[idxSrc]) ? 0 : (d[idxSrc] >= max ? -1 : (byte)((d[idxSrc] - min) * ratio));
                        }
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        byteData[i] = d[i] <= min || d[i] == fvd || Tools.isNaNINF(d[i]) ? 0 : (d[i] >= max ? -1 : (byte)((d[i] - min) * ratio));
                    }
                }
                break;
            }
            default: {
                byteData = null;
            }
        }
        return byteData;
    }

    private static byte[] convertByteData(byte[] rawData, double[] minmax, int w, int h, boolean isTransposed, Object fillValue, boolean convertByteData, byte[] byteData) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double ratio = 1.0;
        if (rawData == null) {
            return null;
        }
        if (convertByteData && minmax[0] == minmax[1]) {
            Tools.findMinMax(rawData, minmax, fillValue);
        }
        if (minmax[0] == 0.0 && minmax[1] == 255.0) {
            convertByteData = false;
        }
        if (!convertByteData && !isTransposed) {
            if (byteData != null && byteData.length == rawData.length) {
                System.arraycopy(rawData, 0, byteData, 0, rawData.length);
                return byteData;
            }
            return rawData;
        }
        if (byteData == null || rawData == byteData) {
            byteData = new byte[rawData.length];
        }
        if (!convertByteData) {
            minmax[0] = 0.0;
            minmax[1] = 255.0;
            if (isTransposed) {
                for (int i = 0; i < h; ++i) {
                    for (int j = 0; j < w; ++j) {
                        byteData[i * w + j] = rawData[j * h + i];
                    }
                }
            }
            return byteData;
        }
        min = minmax[0];
        max = minmax[1];
        double d = ratio = min == max ? 1.0 : 255.0 / (max - min);
        if (isTransposed) {
            for (int i = 0; i < h; ++i) {
                for (int j = 0; j < w; ++j) {
                    int idxSrc = j * h + i;
                    int idxDst = i * w + j;
                    byteData[idxDst] = (double)rawData[idxSrc] >= max ? -1 : ((double)rawData[idxSrc] <= min ? 0 : (int)((int)(((double)rawData[idxSrc] - min) * ratio)));
                }
            }
        } else {
            for (int i = 0; i < rawData.length; ++i) {
                byteData[i] = (double)rawData[i] >= max ? -1 : ((double)rawData[i] <= min ? 0 : (int)((int)(((double)rawData[i] - min) * ratio)));
            }
        }
        return byteData;
    }

    public static Object newInstance(Class<?> cls, Object[] initargs) throws Exception {
        Object instance = null;
        if (cls == null) {
            return null;
        }
        if (initargs == null || initargs.length == 0) {
            instance = cls.newInstance();
        } else {
            Constructor<?>[] constructors = cls.getConstructors();
            if (constructors == null || constructors.length == 0) {
                return null;
            }
            boolean isConstructorMatched = false;
            Constructor<?> constructor = null;
            Class<?>[] params = null;
            int m = constructors.length;
            int n = initargs.length;
            for (int i = 0; i < m; ++i) {
                constructor = constructors[i];
                params = constructor.getParameterTypes();
                if (params.length != n) continue;
                isConstructorMatched = params[0].isInstance(initargs[0]);
                for (int j = 1; j < n; ++j) {
                    isConstructorMatched = isConstructorMatched && params[j].isInstance(initargs[j]);
                }
                if (!isConstructorMatched) continue;
                instance = constructor.newInstance(initargs);
                break;
            }
        }
        return instance;
    }

    public static int autoContrastCompute(Object data, double[] params, boolean isUnsigned) {
        int retval = 1;
        long maxDataValue = 255L;
        double[] minmax = new double[2];
        if (data == null || params == null || Array.getLength(data) <= 0 || params.length < 2) {
            return -1;
        }
        retval = Tools.autoContrastComputeMinMax(data, minmax);
        if (retval < 0 || minmax[1] - minmax[0] < 10.0) {
            retval = Tools.findMinMax(data, minmax, null);
        }
        if (retval < 0) {
            return -1;
        }
        String cname = data.getClass().getName();
        char dname = cname.charAt(cname.lastIndexOf("[") + 1);
        switch (dname) {
            case 'B': {
                maxDataValue = 127L;
                break;
            }
            case 'S': {
                maxDataValue = 32767L;
                if (!isUnsigned) break;
                maxDataValue = 255L;
                break;
            }
            case 'I': {
                maxDataValue = Integer.MAX_VALUE;
                if (!isUnsigned) break;
                maxDataValue = 65535L;
                break;
            }
            case 'J': {
                maxDataValue = Long.MAX_VALUE;
                if (!isUnsigned) break;
                maxDataValue = 0xFFFFFFFFL;
                break;
            }
            default: {
                retval = -1;
            }
        }
        if (minmax[0] == minmax[1]) {
            params[0] = 1.0;
            params[1] = 0.0;
        } else {
            double diff = minmax[1] - minmax[0];
            double newmax = minmax[1] + diff * 0.1;
            double newmin = minmax[0] - diff * 0.1;
            if (newmax <= (double)maxDataValue) {
                minmax[1] = newmax;
            }
            if (newmin >= 0.0) {
                minmax[0] = newmin;
            }
            params[0] = (double)maxDataValue / (minmax[1] - minmax[0]);
            params[1] = -minmax[0];
        }
        return retval;
    }

    public static Object autoContrastApply(Object data_in, Object data_out, double[] params, double[] minmax, boolean isUnsigned) {
        int size = 0;
        double min = -9.223372036854776E18;
        double max = 9.223372036854776E18;
        if (data_in == null || params == null || params.length < 2) {
            return null;
        }
        if (minmax != null) {
            min = minmax[0];
            max = minmax[1];
        }
        size = Array.getLength(data_in);
        if (data_out != null && size != Array.getLength(data_out)) {
            return null;
        }
        double gain = params[0];
        double bias = params[1];
        String cname = data_in.getClass().getName();
        char dname = cname.charAt(cname.lastIndexOf("[") + 1);
        switch (dname) {
            case 'B': {
                byte[] b_in = (byte[])data_in;
                if (data_out == null) {
                    data_out = new byte[size];
                }
                byte[] b_out = (byte[])data_out;
                int b_max = 127;
                for (int i = 0; i < size; ++i) {
                    double value_in = Math.max((double)b_in[i], min);
                    value_in = Math.min((double)b_in[i], max);
                    double value_out = (value_in + bias) * gain;
                    value_out = Math.max(value_out, 0.0);
                    value_out = Math.min(value_out, (double)b_max);
                    b_out[i] = (byte)value_out;
                }
                break;
            }
            case 'S': {
                short[] s_in = (short[])data_in;
                if (data_out == null) {
                    data_out = new short[size];
                }
                short[] s_out = (short[])data_out;
                int s_max = Short.MAX_VALUE;
                if (isUnsigned) {
                    s_max = 255;
                }
                for (int i = 0; i < size; ++i) {
                    double value_in = Math.max((double)s_in[i], min);
                    value_in = Math.min((double)s_in[i], max);
                    double value_out = (value_in + bias) * gain;
                    value_out = Math.max(value_out, 0.0);
                    value_out = Math.min(value_out, (double)s_max);
                    s_out[i] = (byte)value_out;
                }
                break;
            }
            case 'I': {
                int[] i_in = (int[])data_in;
                if (data_out == null) {
                    data_out = new int[size];
                }
                int[] i_out = (int[])data_out;
                int i_max = Integer.MAX_VALUE;
                if (isUnsigned) {
                    i_max = 65535;
                }
                for (int i = 0; i < size; ++i) {
                    double value_in = Math.max((double)i_in[i], min);
                    value_in = Math.min((double)i_in[i], max);
                    double value_out = (value_in + bias) * gain;
                    value_out = Math.max(value_out, 0.0);
                    value_out = Math.min(value_out, (double)i_max);
                    i_out[i] = (byte)value_out;
                }
                break;
            }
            case 'J': {
                long[] l_in = (long[])data_in;
                if (data_out == null) {
                    data_out = new long[size];
                }
                long[] l_out = (long[])data_out;
                long l_max = Long.MAX_VALUE;
                if (isUnsigned) {
                    l_max = 0xFFFFFFFFL;
                }
                for (int i = 0; i < size; ++i) {
                    double value_in = Math.max((double)l_in[i], min);
                    value_in = Math.min((double)l_in[i], max);
                    double value_out = (value_in + bias) * gain;
                    value_out = Math.max(value_out, 0.0);
                    value_out = Math.min(value_out, (double)l_max);
                    l_out[i] = (byte)value_out;
                }
                break;
            }
        }
        return data_out;
    }

    public static int autoContrastConvertImageBuffer(Object src, byte[] dst, boolean isUnsigned) {
        int retval = 0;
        if (src == null || dst == null || dst.length != Array.getLength(src)) {
            return -1;
        }
        int size = dst.length;
        String cname = src.getClass().getName();
        char dname = cname.charAt(cname.lastIndexOf("[") + 1);
        switch (dname) {
            case 'B': {
                byte[] b_src = (byte[])src;
                if (isUnsigned) {
                    for (int i = 0; i < size; ++i) {
                        dst[i] = b_src[i];
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        dst[i] = (byte)((b_src[i] & 0x7F) << 1);
                    }
                }
                break;
            }
            case 'S': {
                short[] s_src = (short[])src;
                if (isUnsigned) {
                    for (int i = 0; i < size; ++i) {
                        dst[i] = (byte)s_src[i];
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        dst[i] = (byte)(s_src[i] >> 7 & 0xFF);
                    }
                }
                break;
            }
            case 'I': {
                int[] i_src = (int[])src;
                if (isUnsigned) {
                    for (int i = 0; i < size; ++i) {
                        dst[i] = (byte)(i_src[i] >> 8 & 0xFF);
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        dst[i] = (byte)(i_src[i] >> 23 & 0xFF);
                    }
                }
                break;
            }
            case 'J': {
                long[] l_src = (long[])src;
                if (isUnsigned) {
                    for (int i = 0; i < size; ++i) {
                        dst[i] = (byte)(l_src[i] >> 24 & 0xFFL);
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        dst[i] = (byte)(l_src[i] >> 55 & 0xFFL);
                    }
                }
                break;
            }
            default: {
                retval = -1;
            }
        }
        return retval;
    }

    public static int autoContrastComputeMinMax(Object data, double[] minmax) {
        int retval = 1;
        if (data == null || minmax == null || Array.getLength(data) <= 0 || Array.getLength(minmax) < 2) {
            return -1;
        }
        double[] avgstd = new double[]{0.0, 0.0};
        retval = Tools.computeStatistics(data, avgstd, null);
        if (retval < 0) {
            return retval;
        }
        minmax[0] = avgstd[0] - 3.0 * avgstd[1];
        minmax[1] = avgstd[0] + 3.0 * avgstd[1];
        return retval;
    }

    public static int findMinMax(Object data, double[] minmax, Object fillValue) {
        int retval = 1;
        if (data == null || minmax == null || Array.getLength(data) <= 0 || Array.getLength(minmax) < 2) {
            return -1;
        }
        int n = Array.getLength(data);
        double fill = 0.0;
        boolean hasFillValue = fillValue != null && fillValue.getClass().isArray();
        String cname = data.getClass().getName();
        char dname = cname.charAt(cname.lastIndexOf("[") + 1);
        minmax[0] = 3.4028234663852886E38;
        minmax[1] = -3.4028234663852886E38;
        switch (dname) {
            case 'B': {
                byte[] b = (byte[])data;
                minmax[0] = minmax[1] = (double)b[0];
                if (hasFillValue) {
                    fill = ((byte[])fillValue)[0];
                }
                for (int i = 0; i < n; ++i) {
                    if (hasFillValue && (double)b[i] == fill) continue;
                    if (minmax[0] > (double)b[i]) {
                        minmax[0] = b[i];
                    }
                    if (!(minmax[1] < (double)b[i])) continue;
                    minmax[1] = b[i];
                }
                break;
            }
            case 'S': {
                short[] s = (short[])data;
                minmax[0] = minmax[1] = (double)s[0];
                if (hasFillValue) {
                    fill = ((short[])fillValue)[0];
                }
                for (int i = 0; i < n; ++i) {
                    if (hasFillValue && (double)s[i] == fill) continue;
                    if (minmax[0] > (double)s[i]) {
                        minmax[0] = s[i];
                    }
                    if (!(minmax[1] < (double)s[i])) continue;
                    minmax[1] = s[i];
                }
                break;
            }
            case 'I': {
                int[] ia = (int[])data;
                minmax[0] = minmax[1] = (double)ia[0];
                if (hasFillValue) {
                    fill = ((int[])fillValue)[0];
                }
                for (int i = 0; i < n; ++i) {
                    if (hasFillValue && (double)ia[i] == fill) continue;
                    if (minmax[0] > (double)ia[i]) {
                        minmax[0] = ia[i];
                    }
                    if (!(minmax[1] < (double)ia[i])) continue;
                    minmax[1] = ia[i];
                }
                break;
            }
            case 'J': {
                long[] l = (long[])data;
                minmax[0] = minmax[1] = (double)l[0];
                if (hasFillValue) {
                    fill = ((long[])fillValue)[0];
                }
                for (int i = 0; i < n; ++i) {
                    if (hasFillValue && (double)l[i] == fill) continue;
                    if (minmax[0] > (double)l[i]) {
                        minmax[0] = l[i];
                    }
                    if (!(minmax[1] < (double)l[i])) continue;
                    minmax[1] = l[i];
                }
                break;
            }
            case 'F': {
                float[] f = (float[])data;
                minmax[0] = minmax[1] = (double)f[0];
                if (hasFillValue) {
                    fill = ((float[])fillValue)[0];
                }
                for (int i = 0; i < n; ++i) {
                    if (hasFillValue && (double)f[i] == fill || Tools.isNaNINF(f[i])) continue;
                    if (minmax[0] > (double)f[i]) {
                        minmax[0] = f[i];
                    }
                    if (!(minmax[1] < (double)f[i])) continue;
                    minmax[1] = f[i];
                }
                break;
            }
            case 'D': {
                double[] d = (double[])data;
                minmax[0] = minmax[1] = d[0];
                if (hasFillValue) {
                    fill = ((double[])fillValue)[0];
                }
                for (int i = 0; i < n; ++i) {
                    if (hasFillValue && d[i] == fill || Tools.isNaNINF(d[i])) continue;
                    if (minmax[0] > d[i]) {
                        minmax[0] = d[i];
                    }
                    if (!(minmax[1] < d[i])) continue;
                    minmax[1] = d[i];
                }
                break;
            }
            default: {
                retval = -1;
            }
        }
        return retval;
    }

    public static int findDataDist(Object data, int[] dataDist, double[] minmax) {
        int retval = 0;
        double delt = 1.0;
        if (data == null || minmax == null || dataDist == null) {
            return -1;
        }
        int n = Array.getLength(data);
        if (minmax[1] != minmax[0]) {
            delt = (double)(dataDist.length - 1) / (minmax[1] - minmax[0]);
        }
        for (int i = 0; i < dataDist.length; ++i) {
            dataDist[i] = 0;
        }
        for (int i = 0; i < n; ++i) {
            int idx;
            double val = ((Number)Array.get(data, i)).doubleValue();
            int n2 = idx = (int)((val - minmax[0]) * delt);
            dataDist[n2] = dataDist[n2] + 1;
        }
        return retval;
    }

    public static int computeStatistics(Object data, double[] avgstd, Object fillValue) {
        int retval = 1;
        int npoints = 0;
        double sum = 0.0;
        double avg = 0.0;
        double var = 0.0;
        double diff = 0.0;
        double fill = 0.0;
        if (data == null || avgstd == null || Array.getLength(data) <= 0 || Array.getLength(avgstd) < 2) {
            return -1;
        }
        int n = Array.getLength(data);
        boolean hasFillValue = fillValue != null && fillValue.getClass().isArray();
        String cname = data.getClass().getName();
        char dname = cname.charAt(cname.lastIndexOf("[") + 1);
        npoints = 0;
        switch (dname) {
            case 'B': {
                int i;
                byte[] b = (byte[])data;
                if (hasFillValue) {
                    fill = ((byte[])fillValue)[0];
                }
                for (i = 0; i < n; ++i) {
                    if (hasFillValue && (double)b[i] == fill) continue;
                    sum += (double)b[i];
                    ++npoints;
                }
                avg = sum / (double)npoints;
                for (i = 0; i < n; ++i) {
                    if (hasFillValue && (double)b[i] == fill) continue;
                    diff = (double)b[i] - avg;
                    var += diff * diff;
                }
                break;
            }
            case 'S': {
                int i;
                short[] s = (short[])data;
                if (hasFillValue) {
                    fill = ((short[])fillValue)[0];
                }
                for (i = 0; i < n; ++i) {
                    if (hasFillValue && (double)s[i] == fill) continue;
                    sum += (double)s[i];
                    ++npoints;
                }
                avg = sum / (double)npoints;
                for (i = 0; i < n; ++i) {
                    if (hasFillValue && (double)s[i] == fill) continue;
                    diff = (double)s[i] - avg;
                    var += diff * diff;
                }
                break;
            }
            case 'I': {
                int i;
                int[] ia = (int[])data;
                if (hasFillValue) {
                    fill = ((int[])fillValue)[0];
                }
                for (i = 0; i < n; ++i) {
                    if (hasFillValue && (double)ia[i] == fill) continue;
                    sum += (double)ia[i];
                    ++npoints;
                }
                avg = sum / (double)npoints;
                for (i = 0; i < n; ++i) {
                    if (hasFillValue && (double)ia[i] == fill) continue;
                    diff = (double)ia[i] - avg;
                    var += diff * diff;
                }
                break;
            }
            case 'J': {
                int i;
                long[] l = (long[])data;
                if (hasFillValue) {
                    fill = ((long[])fillValue)[0];
                }
                for (i = 0; i < n; ++i) {
                    if (hasFillValue && (double)l[i] == fill) continue;
                    sum += (double)l[i];
                    ++npoints;
                }
                avg = sum / (double)npoints;
                for (i = 0; i < n; ++i) {
                    if (hasFillValue && (double)l[i] == fill) continue;
                    diff = (double)l[i] - avg;
                    var += diff * diff;
                }
                break;
            }
            case 'F': {
                int i;
                float[] f = (float[])data;
                if (hasFillValue) {
                    fill = ((float[])fillValue)[0];
                }
                for (i = 0; i < n; ++i) {
                    if (hasFillValue && (double)f[i] == fill) continue;
                    sum += (double)f[i];
                    ++npoints;
                }
                avg = sum / (double)npoints;
                for (i = 0; i < n; ++i) {
                    if (hasFillValue && (double)f[i] == fill) continue;
                    diff = (double)f[i] - avg;
                    var += diff * diff;
                }
                break;
            }
            case 'D': {
                int i;
                double[] d = (double[])data;
                if (hasFillValue) {
                    fill = ((double[])fillValue)[0];
                }
                for (i = 0; i < n; ++i) {
                    if (hasFillValue && d[i] == fill) continue;
                    sum += d[i];
                    ++npoints;
                }
                avg = sum / (double)npoints;
                for (i = 0; i < n; ++i) {
                    if (hasFillValue && d[i] == fill) continue;
                    diff = d[i] - avg;
                    var += diff * diff;
                }
                break;
            }
            default: {
                retval = -1;
            }
        }
        if (npoints <= 1) {
            if (npoints < 1) {
                avgstd[0] = fill;
            }
            avgstd[1] = 0.0;
        } else {
            avgstd[0] = avg;
            avgstd[1] = Math.sqrt(var / (double)(npoints - 1));
        }
        return retval;
    }

    public static final String toBinaryString(long v, int nbytes) {
        if (nbytes <= 0) {
            return null;
        }
        int nhex = nbytes * 2;
        short[] hex = new short[nhex];
        for (int i = 0; i < nhex; ++i) {
            hex[i] = (short)(0xFL & v >> i * 4);
        }
        StringBuffer sb = new StringBuffer();
        boolean isEven = true;
        block19: for (int i = nhex - 1; i >= 0; --i) {
            if (isEven) {
                sb.append(" ");
            }
            isEven = !isEven;
            switch (hex[i]) {
                case 0: {
                    sb.append("0000");
                    continue block19;
                }
                case 1: {
                    sb.append("0001");
                    continue block19;
                }
                case 2: {
                    sb.append("0010");
                    continue block19;
                }
                case 3: {
                    sb.append("0011");
                    continue block19;
                }
                case 4: {
                    sb.append("0100");
                    continue block19;
                }
                case 5: {
                    sb.append("0101");
                    continue block19;
                }
                case 6: {
                    sb.append("0110");
                    continue block19;
                }
                case 7: {
                    sb.append("0111");
                    continue block19;
                }
                case 8: {
                    sb.append("1000");
                    continue block19;
                }
                case 9: {
                    sb.append("1001");
                    continue block19;
                }
                case 10: {
                    sb.append("1010");
                    continue block19;
                }
                case 11: {
                    sb.append("1011");
                    continue block19;
                }
                case 12: {
                    sb.append("1100");
                    continue block19;
                }
                case 13: {
                    sb.append("1101");
                    continue block19;
                }
                case 14: {
                    sb.append("1110");
                    continue block19;
                }
                case 15: {
                    sb.append("1111");
                }
            }
        }
        return sb.toString();
    }

    public static final boolean applyBitmask(Object theData, BitSet theMask, ViewProperties.BITMASK_OP op) {
        int i;
        if (theData == null || Array.getLength(theData) <= 0 || theMask == null) {
            return false;
        }
        int nt = 48;
        String cName = theData.getClass().getName();
        int cIndex = cName.lastIndexOf("[");
        if (cIndex >= 0) {
            nt = cName.charAt(cIndex + 1);
        }
        if (nt != 66 && nt != 83) {
            return false;
        }
        int bmask = 0;
        int theValue = 0;
        int packedValue = 0;
        int nbits = theMask.length();
        int len = Array.getLength(theData);
        for (i = 0; i < nbits; ++i) {
            if (!theMask.get(i)) continue;
            bmask += 1 << i;
        }
        for (i = 0; i < len; ++i) {
            theValue = nt == 66 ? ((byte[])theData)[i] & bmask : ((short[])theData)[i] & bmask;
            if (op == ViewProperties.BITMASK_OP.AND) {
                packedValue = theValue;
            } else {
                packedValue = 0;
                int bitPosition = 0;
                int bitValue = 0;
                for (int j = 0; j < nbits; ++j) {
                    if (theMask.get(j)) {
                        bitValue = theValue & 1;
                        packedValue += bitValue << bitPosition;
                        ++bitPosition;
                    }
                    theValue >>= 1;
                }
            }
            if (nt == 66) {
                ((byte[])theData)[i] = (byte)packedValue;
                continue;
            }
            ((short[])theData)[i] = (short)packedValue;
        }
        return true;
    }

    public static final void launchBrowser(String url) throws Exception {
        String os = System.getProperty("os.name");
        Runtime runtime = Runtime.getRuntime();
        if (os.startsWith("Windows")) {
            String cmd = "rundll32 url.dll,FileProtocolHandler " + url;
            if (new File(url).exists()) {
                cmd = "cmd /c start \"\" \"" + url + "\"";
            }
            runtime.exec(cmd);
        } else if (os.startsWith("Mac OS")) {
            Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
            Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
            if (new File(url).exists()) {
                url = "file://" + url;
            }
            openURL.invoke(null, url);
        } else {
            String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
            String browser = null;
            for (int count = 0; count < browsers.length && browser == null; ++count) {
                if (runtime.exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                browser = browsers[count];
            }
            if (browser == null) {
                throw new Exception("Could not find web browser");
            }
            runtime.exec(new String[]{browser, url});
        }
    }

    public static final File checkNewFile(String path, String ext) {
        File file = new File(path + "new" + ext);
        int i = 1;
        while (file.exists()) {
            file = new File(path + "new" + i + ext);
            ++i;
        }
        return file;
    }

    public static final boolean isNaNINF(double val) {
        return Double.isNaN(val) || val == Double.NEGATIVE_INFINITY || val == Double.POSITIVE_INFINITY || val == Double.NEGATIVE_INFINITY || val == Double.POSITIVE_INFINITY;
    }
}

