/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.object.DataFormat;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.view.DefaultFileFilter;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class NewLinkDialog
extends JDialog
implements ActionListener,
DocumentListener,
ItemListener {
    private static final long serialVersionUID = 7100424106041533918L;
    private JTextField nameField;
    private JComboBox parentChoice;
    private JComboBox targetObject;
    private String currentDir;
    private JTextField targetFile;
    private JButton targetFileButton;
    private JRadioButton hardLink;
    private JRadioButton softLink;
    private JRadioButton externalLink;
    private JCheckBox checkUnsigned;
    private List groupList;
    private List objList;
    private HObject newObject;
    private FileFormat fileFormat;
    private final Toolkit toolkit;
    private ViewManager viewer;
    private final List fileList;

    public NewLinkDialog(JFrame owner, Group pGroup, List objs) {
        super(owner, "New Link...", true);
        JButton b;
        this.viewer = (ViewManager)((Object)owner);
        this.fileList = this.viewer.getTreeView().getCurrentFiles();
        this.newObject = null;
        this.fileFormat = pGroup.getFileFormat();
        this.toolkit = Toolkit.getDefaultToolkit();
        this.objList = objs;
        this.currentDir = ViewProperties.getWorkDir();
        this.parentChoice = new JComboBox();
        this.targetObject = new JComboBox();
        this.targetObject.setEditable(false);
        this.groupList = new Vector(objs.size());
        HObject obj = null;
        Iterator iterator = objs.iterator();
        String full_name = null;
        int idx_root = -1;
        int idx = -1;
        while (iterator.hasNext()) {
            obj = (HObject)iterator.next();
            ++idx;
            if (obj instanceof Group) {
                Group g = (Group)obj;
                this.groupList.add(obj);
                if (g.isRoot()) {
                    full_name = "/";
                    idx_root = idx;
                } else {
                    full_name = g.getPath() + g.getName() + "/";
                }
                this.parentChoice.addItem(full_name);
            } else {
                full_name = obj.getPath() + obj.getName();
            }
            this.targetObject.addItem(full_name);
        }
        this.targetObject.removeItemAt(idx_root);
        this.objList.remove(idx_root);
        if (pGroup.isRoot()) {
            this.parentChoice.setSelectedItem("/");
        } else {
            this.parentChoice.setSelectedItem(pGroup.getPath() + pGroup.getName() + "/");
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int w = 600 + (ViewProperties.getFontSize() - 12) * 15;
        int h = 280 + (ViewProperties.getFontSize() - 12) * 10;
        contentPane.setPreferredSize(new Dimension(w, h));
        JButton okButton = new JButton("   Ok   ");
        okButton.setActionCommand("Ok");
        okButton.setMnemonic(79);
        okButton.addActionListener(this);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setMnemonic(67);
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        contentPane.add((Component)buttonPanel, "South");
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BorderLayout(5, 5));
        JPanel tmpP = new JPanel();
        tmpP.setLayout(new GridLayout(5, 1, 5, 5));
        tmpP.add(new JLabel("Link name: "));
        tmpP.add(new JLabel("Parent group: "));
        JPanel tmpLinkJPanel = new JPanel();
        tmpLinkJPanel.setLayout(new GridLayout(2, 1));
        tmpLinkJPanel.add(new JLabel("Type of Link: "));
        JButton helpButton = new JButton(ViewProperties.getHelpIcon());
        helpButton.setToolTipText("Help on Links");
        helpButton.setMargin(new Insets(0, 0, 0, 0));
        helpButton.addActionListener(this);
        helpButton.setActionCommand("Help on Links");
        tmpLinkJPanel.add(helpButton);
        tmpP.add(tmpLinkJPanel);
        tmpP.add(new JLabel("Target File: "));
        tmpP.add(new JLabel("Target Object: "));
        namePanel.add((Component)tmpP, "West");
        tmpP = new JPanel();
        tmpP.setLayout(new GridLayout(5, 1, 5, 5));
        this.nameField = new JTextField();
        tmpP.add(this.nameField);
        tmpP.add(this.parentChoice);
        JPanel tmpP0 = new JPanel();
        tmpP0.setLayout(new GridLayout(1, 3));
        this.hardLink = new JRadioButton("Hard Link ", true);
        tmpP0.add(this.hardLink);
        this.softLink = new JRadioButton("Soft Link ");
        tmpP0.add(this.softLink);
        this.externalLink = new JRadioButton("External Link ");
        tmpP0.add(this.externalLink);
        tmpP0.setBorder(new TitledBorder(""));
        tmpP.add(tmpP0);
        ButtonGroup bgroup = new ButtonGroup();
        bgroup.add(this.hardLink);
        bgroup.add(this.softLink);
        bgroup.add(this.externalLink);
        this.hardLink.addItemListener(this);
        this.softLink.addItemListener(this);
        this.externalLink.addItemListener(this);
        JPanel p0 = new JPanel();
        p0.setLayout(new BorderLayout());
        this.targetFile = new JTextField();
        p0.add((Component)this.targetFile, "Center");
        this.targetFile.getDocument().addDocumentListener(this);
        this.targetFile.addActionListener(this);
        this.targetFile.setActionCommand("Link to File");
        this.targetFileButton = b = new JButton("Browse...");
        b.setActionCommand("Browse File");
        b.addActionListener(this);
        p0.add((Component)b, "East");
        tmpP.add(p0);
        this.targetFile.setEnabled(false);
        this.targetFileButton.setEnabled(false);
        tmpP.add(this.targetObject);
        namePanel.add((Component)tmpP, "Center");
        contentPane.add((Component)namePanel, "Center");
        Point l = owner.getLocation();
        l.x += 250;
        l.y += 100;
        this.setLocation(l);
        this.validate();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String cmd = e.getActionCommand();
        if (cmd.equals("Help on Links")) {
            String msg = "The Type of Link specifies which type of link the user wants to create. \nIt could be hard, soft or external links. \n\n<html><b>Hard Link</b></html> \nHard Link creates a hard link to a pre-existing object in an HDF5 file. \nThe target object must already exist in the file.\nThe HDF5 library keeps a count of all hard links pointing to an object. \n\n<html><b>Soft Link</b></html> \nSoft Link creates a new soft link to an object in an HDF5 file. \nSoft links are only for use only if the target object is in the current file. \nUnlike hard links, a soft link in an HDF5 file is allowed to dangle, \nmeaning that the target object need not exist at the time that the link is created.\nThe HDF5 library does not keep a count of soft links  \n\n<html><b>External Link</b></html> \nExternal Link creates a new soft link to an external object, which is an object\nin a different HDF5 file from the location of the link. External links are \nallowed to dangle like soft links. \n\nSoft links and external links are also known as symbolic links as they use \na name to point to an object; hard links employ an object's address in the file.  \n\n\n";
            JOptionPane.showMessageDialog(this, "The Type of Link specifies which type of link the user wants to create. \nIt could be hard, soft or external links. \n\n<html><b>Hard Link</b></html> \nHard Link creates a hard link to a pre-existing object in an HDF5 file. \nThe target object must already exist in the file.\nThe HDF5 library keeps a count of all hard links pointing to an object. \n\n<html><b>Soft Link</b></html> \nSoft Link creates a new soft link to an object in an HDF5 file. \nSoft links are only for use only if the target object is in the current file. \nUnlike hard links, a soft link in an HDF5 file is allowed to dangle, \nmeaning that the target object need not exist at the time that the link is created.\nThe HDF5 library does not keep a count of soft links  \n\n<html><b>External Link</b></html> \nExternal Link creates a new soft link to an external object, which is an object\nin a different HDF5 file from the location of the link. External links are \nallowed to dangle like soft links. \n\nSoft links and external links are also known as symbolic links as they use \na name to point to an object; hard links employ an object's address in the file.  \n\n\n");
        }
        if (cmd.equals("Browse File")) {
            String filename = null;
            filename = this.openTargetFile();
            if (filename == null) {
                return;
            }
            this.targetFile.setText(filename);
        }
        if (cmd.equals("Ok")) {
            this.newObject = this.createLink();
            if (this.newObject != null) {
                this.dispose();
            }
        }
        if (cmd.equals("Cancel")) {
            this.newObject = null;
            this.dispose();
            ((Vector)this.groupList).setSize(0);
        }
    }

    private String openTargetFile() {
        JFileChooser fchooser = new JFileChooser(this.currentDir);
        fchooser.setFileFilter(DefaultFileFilter.getFileFilter());
        int returnVal = fchooser.showOpenDialog(this);
        if (returnVal != 0) {
            return null;
        }
        File choosedFile = fchooser.getSelectedFile();
        if (choosedFile == null) {
            return null;
        }
        this.currentDir = choosedFile.isDirectory() ? choosedFile.getPath() : choosedFile.getParent();
        return choosedFile.getAbsolutePath();
    }

    private final List breadthFirstUserObjects(TreeNode node) {
        if (node == null) {
            return null;
        }
        Vector<Object> list = new Vector<Object>();
        DefaultMutableTreeNode theNode = null;
        Enumeration<TreeNode> local_enum = ((DefaultMutableTreeNode)node).breadthFirstEnumeration();
        while (local_enum.hasMoreElements()) {
            theNode = (DefaultMutableTreeNode)local_enum.nextElement();
            list.add(theNode.getUserObject());
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HObject createLink() {
        String name = null;
        Group pgroup = null;
        HObject obj = null;
        name = this.nameField.getText().trim();
        if (name == null || name.length() < 1) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Link name is not specified.", this.getTitle(), 0);
            return null;
        }
        if (name.indexOf("/") >= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Link name cannot contain path.", this.getTitle(), 0);
            return null;
        }
        pgroup = (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
        if (pgroup == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Parent group is null.", this.getTitle(), 0);
            return null;
        }
        if (this.hardLink.isSelected()) {
            HObject targetObj = (HObject)this.objList.get(this.targetObject.getSelectedIndex());
            if (targetObj == null) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Target object is null.", this.getTitle(), 0);
                return null;
            }
            if (targetObj instanceof Group && ((Group)targetObj).isRoot()) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Cannot make a link to the root group.", this.getTitle(), 0);
                return null;
            }
            try {
                return this.fileFormat.createLink(pgroup, name, (Object)targetObj);
            }
            catch (Exception ex) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
                return null;
            }
        }
        if (this.softLink.isSelected()) {
            String target_name = this.targetObject.getEditor().getItem().toString();
            if (target_name.length() < 1) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Target object name is not specified.", this.getTitle(), 0);
                return null;
            }
            HObject targetObj = null;
            try {
                targetObj = this.fileFormat.get(this.targetObject.getEditor().getItem().toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
            String tObj = null;
            if (targetObj == null && !(tObj = this.targetObject.getEditor().getItem().toString()).startsWith("/")) {
                tObj = "/" + tObj;
            }
            if (targetObj instanceof Group && ((Group)targetObj).isRoot()) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Cannot make a link to the root group.", this.getTitle(), 0);
                return null;
            }
            try {
                if (targetObj != null) {
                    return this.fileFormat.createLink(pgroup, name, targetObj, 1);
                }
                if (tObj == null) return obj;
                return this.fileFormat.createLink(pgroup, name, tObj, 1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
                return null;
            }
        }
        if (!this.externalLink.isSelected()) return obj;
        String TargetFileName = this.targetFile.getText();
        FileFormat TargetFileFormat = null;
        int fileAccessID = 20;
        File TargetFile = new File(TargetFileName);
        if (!TargetFile.exists()) {
            return null;
        }
        FileFormat h5format = FileFormat.getFileFormat((String)"HDF5");
        try {
            TargetFileFormat = h5format.createInstance(TargetFileName, fileAccessID);
            TargetFileFormat.open();
        }
        catch (Exception ex) {
            return null;
        }
        HObject targetObj = null;
        try {
            targetObj = TargetFileFormat.get(this.targetObject.getEditor().getItem().toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            TargetFileFormat.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        String tFileObj = null;
        if (targetObj == null) {
            String tObj = null;
            tObj = this.targetObject.getEditor().getItem().toString();
            if (tObj.length() < 1) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Target object name not specified.", this.getTitle(), 0);
                return null;
            }
            tFileObj = TargetFileName + "://" + tObj;
        }
        try {
            if (targetObj != null) {
                return this.fileFormat.createLink(pgroup, name, targetObj, 64);
            }
            if (tFileObj == null) return obj;
            return this.fileFormat.createLink(pgroup, name, tFileObj, 64);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
            return null;
        }
    }

    public DataFormat getObject() {
        return this.newObject;
    }

    public Group getParentGroup() {
        return (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.targetObject.setEnabled(true);
        this.getTargetFileObjs();
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.targetObject.setEnabled(true);
        this.getTargetFileObjs();
    }

    private void getTargetFileObjs() {
        FileFormat fileFormatC = null;
        int fileAccessID = 20;
        String filename = null;
        filename = this.targetFile.getText();
        if (filename == null || filename.length() < 1) {
            return;
        }
        String CurrentFileName = this.fileFormat.getAbsolutePath();
        if (CurrentFileName.equals(filename)) {
            this.targetObject.setEnabled(false);
        }
        if (this.isFileOpen(filename)) {
            return;
        }
        File choosedFile = new File(filename);
        if (!choosedFile.exists()) {
            this.targetObject.setEnabled(false);
            return;
        }
        FileFormat h5format = FileFormat.getFileFormat((String)"HDF5");
        try {
            fileFormatC = h5format.createInstance(filename, fileAccessID);
            fileFormatC.open();
        }
        catch (Exception ex) {
            this.targetObject.setEnabled(false);
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Invalid File Format", this.getTitle(), 0);
            return;
        }
        this.retriveObjects(fileFormatC);
        try {
            fileFormatC.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private boolean isFileOpen(String filename) {
        boolean isOpen = false;
        FileFormat theFile2 = null;
        for (FileFormat theFile2 : this.fileList) {
            if (!theFile2.getFilePath().equals(filename)) continue;
            isOpen = true;
            if (!theFile2.isThisType(FileFormat.getFileFormat((String)"HDF5"))) {
                this.targetObject.setEnabled(false);
            }
            this.retriveObjects(theFile2);
            break;
        }
        return isOpen;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source instanceof JRadioButton && (source.equals(this.hardLink) || source.equals(this.softLink) || source.equals(this.externalLink))) {
            if (this.hardLink.isSelected()) {
                this.targetFile.setEnabled(false);
                this.targetFileButton.setEnabled(false);
                this.targetObject.setEnabled(true);
                this.targetObject.setEditable(false);
                this.retriveObjects(this.fileFormat);
            } else if (this.softLink.isSelected()) {
                this.targetFile.setEnabled(false);
                this.targetFileButton.setEnabled(false);
                this.targetObject.setEnabled(true);
                this.targetObject.setEditable(true);
                this.retriveObjects(this.fileFormat);
            } else if (this.externalLink.isSelected()) {
                this.targetFile.setEnabled(true);
                this.targetFileButton.setEnabled(true);
                this.targetObject.setEnabled(true);
                this.targetObject.setEditable(true);
                this.targetObject.removeAllItems();
            }
        }
    }

    private void retriveObjects(FileFormat file) {
        List objsFile = this.breadthFirstUserObjects(file.getRootNode());
        Vector<HObject> groupListFile = new Vector<HObject>(objsFile.size());
        HObject obj = null;
        Iterator iterator = objsFile.iterator();
        List objListFile = objsFile;
        String full_name = null;
        int idx_root = -1;
        int idx = -1;
        this.targetObject.removeAllItems();
        while (iterator.hasNext()) {
            obj = (HObject)iterator.next();
            ++idx;
            if (obj instanceof Group) {
                Group g = (Group)obj;
                groupListFile.add(obj);
                if (g.isRoot()) {
                    full_name = "/";
                    idx_root = idx;
                } else {
                    full_name = g.getPath() + g.getName() + "/";
                }
            } else {
                full_name = obj.getPath() + obj.getName();
            }
            this.targetObject.addItem(full_name);
        }
        this.targetObject.removeItemAt(idx_root);
        objListFile.remove(idx_root);
    }
}

