/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.view.ViewProperties;

public class NewAttributeDialog
extends JDialog
implements ActionListener,
ItemListener,
HyperlinkListener {
    private static final long serialVersionUID = 4883237570834215275L;
    public static final int DEFAULT_STRING_ATTRIBUTE_LENGTH = 256;
    private HObject hObject;
    private Attribute newAttribute;
    private JTextField nameField;
    private JComboBox typeChoice;
    private JTextField valueField;
    private JComboBox objChoice;
    private FileFormat fileFormat;
    private JTextField lengthField;
    private JLabel arrayLengthLabel;
    private final boolean isH5;
    private JDialog helpDialog;
    private JRadioButton h4GrAttrRadioButton;

    public NewAttributeDialog(Dialog owner, HObject obj, Enumeration<?> objList) {
        super(owner, "New Attribute...", true);
        this.hObject = obj;
        this.newAttribute = null;
        this.isH5 = obj.getFileFormat().isThisType(FileFormat.getFileFormat((String)"HDF5"));
        this.helpDialog = null;
        this.fileFormat = obj.getFileFormat();
        this.typeChoice = new JComboBox();
        this.typeChoice.addItem("string");
        this.typeChoice.addItem("byte (8-bit)");
        this.typeChoice.addItem("short (16-bit)");
        this.typeChoice.addItem("int (32-bit)");
        this.typeChoice.addItem("unsigned byte (8-bit)");
        this.typeChoice.addItem("unsigned short (16-bit)");
        this.typeChoice.addItem("unsigned int (32-bit)");
        this.typeChoice.addItem("long (64-bit)");
        this.typeChoice.addItem("float");
        this.typeChoice.addItem("double");
        if (this.isH5) {
            this.typeChoice.addItem("object reference");
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.setBorder(BorderFactory.createEmptyBorder(20, 10, 0, 10));
        int w = 400 + (ViewProperties.getFontSize() - 12) * 15;
        int h = 180 + (ViewProperties.getFontSize() - 12) * 10;
        contentPane.setPreferredSize(new Dimension(w, h));
        JButton okButton = new JButton("   Ok   ");
        okButton.setActionCommand("Ok");
        okButton.setMnemonic(79);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("Cancel");
        cancelButton.setMnemonic(67);
        JButton helpButton = new JButton(" Help ");
        helpButton.setActionCommand("Show help");
        helpButton.setMnemonic(72);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(5, 5));
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(5, 1, 3, 3));
        p2.add(new JLabel("Name: "));
        p2.add(new JLabel("Type: "));
        this.arrayLengthLabel = new JLabel("Max String Length: ");
        p2.add(this.arrayLengthLabel);
        p2.add(new JLabel("Value: "));
        p2.add(new JLabel("Object List: "));
        p.add("West", p2);
        JPanel typePane = new JPanel();
        typePane.setLayout(new BorderLayout());
        JPanel h4GattrPane = new JPanel();
        h4GattrPane.setLayout(new GridLayout(1, 2, 3, 3));
        ButtonGroup bg = new ButtonGroup();
        JRadioButton grAttr = new JRadioButton("GR");
        JRadioButton sdAttr = new JRadioButton("SD");
        bg.add(sdAttr);
        bg.add(grAttr);
        sdAttr.setSelected(true);
        h4GattrPane.add(sdAttr);
        h4GattrPane.add(grAttr);
        typePane.add((Component)this.typeChoice, "Center");
        typePane.add((Component)h4GattrPane, "East");
        this.h4GrAttrRadioButton = grAttr;
        p2 = new JPanel();
        p2.setLayout(new GridLayout(5, 1, 3, 3));
        this.nameField = new JTextField("", 30);
        p2.add(this.nameField);
        if (!this.isH5 && obj instanceof Group && ((Group)obj).isRoot()) {
            p2.add(typePane);
        } else {
            p2.add(this.typeChoice);
        }
        this.lengthField = new JTextField("1");
        p2.add(this.lengthField);
        this.valueField = new JTextField("0");
        p2.add(this.valueField);
        this.objChoice = new JComboBox();
        p2.add(this.objChoice);
        p.add("Center", p2);
        contentPane.add("Center", p);
        p = new JPanel();
        p.add(okButton);
        p.add(cancelButton);
        p.add(helpButton);
        contentPane.add("South", p);
        this.typeChoice.addItemListener(this);
        okButton.addActionListener(this);
        cancelButton.addActionListener(this);
        helpButton.addActionListener(this);
        this.objChoice.addItemListener(this);
        this.objChoice.setEnabled(false);
        while (objList.hasMoreElements()) {
            DefaultMutableTreeNode theNode = (DefaultMutableTreeNode)objList.nextElement();
            HObject hobj = (HObject)theNode.getUserObject();
            if (hobj instanceof Group && ((Group)hobj).isRoot()) continue;
            String str = hobj.getFullName();
            this.objChoice.addItem(str);
        }
        Point l = owner.getLocation();
        l.x += 50;
        l.y += 80;
        this.setLocation(l);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Ok")) {
            if (this.createAttribute()) {
                this.dispose();
            }
        } else if (cmd.equals("Cancel")) {
            this.newAttribute = null;
            this.dispose();
        } else if (cmd.equals("Show help")) {
            if (this.helpDialog == null) {
                this.createHelpDialog();
            }
            this.helpDialog.setVisible(true);
        } else if (cmd.equals("Hide help") && this.helpDialog != null) {
            this.helpDialog.setVisible(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source.equals(this.typeChoice)) {
            int idx = this.typeChoice.getSelectedIndex();
            this.objChoice.setEnabled(false);
            this.lengthField.setEnabled(true);
            if (idx == 0) {
                this.arrayLengthLabel.setText("Max String Length: ");
            } else if (this.typeChoice.getSelectedItem().equals("object reference")) {
                this.lengthField.setText("1");
                this.lengthField.setEnabled(false);
                this.arrayLengthLabel.setText("Array Size: ");
                this.objChoice.setEnabled(true);
                this.valueField.setText("");
            } else {
                this.arrayLengthLabel.setText("Array Size: ");
            }
        } else if (source.equals(this.objChoice)) {
            String objName = (String)this.objChoice.getSelectedItem();
            if (e.getStateChange() != 1) {
                return;
            }
            long ref = -1L;
            try {
                HObject obj = this.fileFormat.get(objName);
                ref = obj.getOID()[0];
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (ref > 0L) {
                if (this.valueField.getText().length() > 1) {
                    this.valueField.setText(this.valueField.getText() + "," + ref);
                    StringTokenizer st = new StringTokenizer(this.valueField.getText(), ",");
                    this.lengthField.setText(String.valueOf(st.countTokens()));
                } else {
                    this.valueField.setText(String.valueOf(ref));
                    this.lengthField.setText("1");
                }
            }
        }
    }

    private boolean createAttribute() {
        int j;
        Object[] i;
        short[] s;
        byte[] b;
        int string_length = 0;
        int tclass = -1;
        int tsize = -1;
        int torder = -1;
        int tsign = -1;
        Object[] value = null;
        String dt = (String)this.typeChoice.getSelectedItem();
        String strValue = this.valueField.getText();
        String attrName = this.nameField.getText();
        if (attrName != null) {
            attrName = attrName.trim();
        }
        if (attrName == null || attrName.length() < 1) {
            JOptionPane.showMessageDialog(this, "No attribute name.", this.getTitle(), 0);
            return false;
        }
        String lengthStr = this.lengthField.getText();
        int arraySize = 0;
        if (lengthStr == null || lengthStr.length() <= 0) {
            arraySize = 1;
        } else {
            try {
                arraySize = Integer.parseInt(lengthStr);
            }
            catch (Exception e) {
                arraySize = -1;
            }
        }
        if (arraySize <= 0) {
            JOptionPane.showMessageDialog(this, "Invalid attribute length.", this.getTitle(), 0);
            return false;
        }
        StringTokenizer st = new StringTokenizer(strValue, ",");
        int count = Math.min(arraySize, st.countTokens());
        if (dt.startsWith("byte")) {
            b = new byte[arraySize];
            for (int j2 = 0; j2 < count; ++j2) {
                String theToken = st.nextToken().trim();
                try {
                    b[j2] = Byte.parseByte(theToken);
                    continue;
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
                    return false;
                }
            }
            value = b;
            tclass = 0;
            tsize = 1;
            torder = -1;
        } else if (dt.startsWith("short")) {
            s = new short[arraySize];
            for (int j3 = 0; j3 < count; ++j3) {
                String theToken = st.nextToken().trim();
                try {
                    s[j3] = Short.parseShort(theToken);
                    continue;
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
                    return false;
                }
            }
            value = s;
            tclass = 0;
            tsize = 2;
            torder = -1;
        } else if (dt.startsWith("int")) {
            i = new int[arraySize];
            for (int j4 = 0; j4 < count; ++j4) {
                String theToken = st.nextToken().trim();
                try {
                    i[j4] = Integer.parseInt(theToken);
                    continue;
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
                    return false;
                }
            }
            value = i;
            tclass = 0;
            tsize = 4;
            torder = -1;
        } else if (dt.startsWith("unsigned byte")) {
            b = new byte[arraySize];
            int sv = 0;
            for (j = 0; j < count; ++j) {
                String theToken = st.nextToken().trim();
                try {
                    sv = Short.parseShort(theToken);
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
                    return false;
                }
                if (sv < 0) {
                    sv = 0;
                } else if (sv > 255) {
                    sv = 255;
                }
                b[j] = (byte)sv;
            }
            value = b;
            tclass = 0;
            tsize = 1;
            torder = -1;
            tsign = 0;
        } else if (dt.startsWith("unsigned short")) {
            s = new short[arraySize];
            int iv = 0;
            for (j = 0; j < count; ++j) {
                String theToken = st.nextToken().trim();
                try {
                    iv = Integer.parseInt(theToken);
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
                    return false;
                }
                if (iv < 0) {
                    iv = 0;
                } else if (iv > 65535) {
                    iv = 65535;
                }
                s[j] = (short)iv;
            }
            value = s;
            tclass = 0;
            tsize = 2;
            torder = -1;
            tsign = 0;
        } else if (dt.startsWith("unsigned int")) {
            i = new int[arraySize];
            long lv = 0L;
            for (int j5 = 0; j5 < count; ++j5) {
                String theToken = st.nextToken().trim();
                try {
                    lv = Long.parseLong(theToken);
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
                    return false;
                }
                if (lv < 0L) {
                    lv = 0L;
                }
                if (lv > 0xFFFFFFFFL) {
                    lv = 0xFFFFFFFFL;
                }
                i[j5] = (int)lv;
            }
            value = i;
            tclass = 0;
            tsize = 4;
            torder = -1;
            tsign = 0;
        } else if (dt.startsWith("long")) {
            long[] l = new long[arraySize];
            for (int j6 = 0; j6 < count; ++j6) {
                String theToken = st.nextToken().trim();
                try {
                    l[j6] = Long.parseLong(theToken);
                    continue;
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
                    return false;
                }
            }
            value = l;
            tclass = 0;
            tsize = 8;
            torder = -1;
        } else if (dt.startsWith("unsigned long")) {
            i = new long[arraySize];
            BigInteger lv = BigInteger.valueOf(0L);
            for (j = 0; j < count; ++j) {
                String theToken = st.nextToken().trim();
                try {
                    lv = new BigInteger(theToken);
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
                    return false;
                }
                i[j] = (int)lv.longValue();
            }
            value = i;
            tclass = 0;
            tsize = 8;
            torder = -1;
            tsign = 0;
        } else if (dt.startsWith("float")) {
            float[] f = new float[arraySize];
            for (int j7 = 0; j7 < count; ++j7) {
                String theToken = st.nextToken().trim();
                try {
                    f[j7] = Float.parseFloat(theToken);
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
                    return false;
                }
                if (!Float.isInfinite(f[j7]) && !Float.isNaN(f[j7])) continue;
                f[j7] = 0.0f;
            }
            value = f;
            tclass = 1;
            tsize = 4;
            torder = -1;
        } else if (dt.startsWith("double")) {
            double[] d = new double[arraySize];
            for (int j8 = 0; j8 < count; ++j8) {
                String theToken = st.nextToken().trim();
                try {
                    d[j8] = Double.parseDouble(theToken);
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
                    return false;
                }
                if (!Double.isInfinite(d[j8]) && !Double.isNaN(d[j8])) continue;
                d[j8] = 0.0;
            }
            value = d;
            tclass = 1;
            tsize = 8;
            torder = -1;
        } else if (dt.startsWith("object reference")) {
            arraySize = st.countTokens();
            long[] ref = new long[arraySize];
            for (int j9 = 0; j9 < arraySize; ++j9) {
                String theToken = st.nextToken().trim();
                try {
                    ref[j9] = Long.parseLong(theToken);
                    continue;
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
                    return false;
                }
            }
            value = ref;
            tclass = 7;
            tsize = 8;
            torder = -1;
        } else if (dt.equals("string")) {
            try {
                string_length = Integer.parseInt(this.lengthField.getText());
            }
            catch (Exception e) {
                string_length = 0;
            }
            if (string_length <= 0) {
                string_length = 256;
            }
            if (strValue.length() > string_length) {
                strValue = strValue.substring(0, string_length);
            }
            tclass = 3;
            tsize = string_length;
            String[] strArray = new String[]{strValue};
            value = strArray;
            arraySize = this.isH5 ? 1 : string_length;
        }
        Datatype datatype = null;
        try {
            datatype = this.fileFormat.createDatatype(tclass, tsize, torder, tsign);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            return false;
        }
        long[] dims = new long[]{arraySize};
        Attribute attr = new Attribute(attrName, datatype, dims);
        attr.setValue((Object)value);
        try {
            if (!this.isH5 && this.hObject instanceof Group && ((Group)this.hObject).isRoot() && this.h4GrAttrRadioButton.isSelected()) {
                this.hObject.getFileFormat().writeAttribute(this.hObject, attr, false);
                if (this.hObject.getMetadata() == null) {
                    this.hObject.getMetadata().add(attr);
                }
            } else {
                this.hObject.writeMetadata((Object)attr);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            return false;
        }
        this.newAttribute = attr;
        return true;
    }

    private void createHelpDialog() {
        this.helpDialog = new JDialog((Dialog)this, "Creation New Attribute");
        JPanel contentPane = (JPanel)this.helpDialog.getContentPane();
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int w = 500 + (ViewProperties.getFontSize() - 12) * 15;
        int h = 400 + (ViewProperties.getFontSize() - 12) * 10;
        contentPane.setPreferredSize(new Dimension(w, h));
        JButton b = new JButton("  Ok  ");
        b.addActionListener(this);
        b.setActionCommand("Hide help");
        JPanel tmpP = new JPanel();
        tmpP.add(b);
        contentPane.add((Component)tmpP, "South");
        JEditorPane infoPane = new JEditorPane();
        infoPane.setEditable(false);
        JScrollPane editorScrollPane = new JScrollPane(infoPane);
        contentPane.add((Component)editorScrollPane, "Center");
        try {
            URL url = null;
            URL url2 = null;
            URL url3 = null;
            String rootPath = ViewProperties.getViewRoot();
            try {
                url = new URL("file:" + rootPath + "/lib/jhdfview.jar");
            }
            catch (MalformedURLException mfu) {
                // empty catch block
            }
            try {
                url2 = new URL("file:" + rootPath + "/");
            }
            catch (MalformedURLException mfu) {
                // empty catch block
            }
            try {
                url3 = new URL("file:" + rootPath + "/src/");
            }
            catch (MalformedURLException mfu) {
                // empty catch block
            }
            URL[] uu = new URL[]{url, url2, url3};
            URLClassLoader cl = new URLClassLoader(uu);
            URL u = cl.findResource("ncsa/hdf/view/NewAttrHelp.html");
            infoPane.setPage(u);
            infoPane.addHyperlinkListener(this);
        }
        catch (Exception e) {
            infoPane.setContentType("text/html");
            StringBuffer buff = new StringBuffer();
            buff.append("<html>");
            buff.append("<body>");
            buff.append("ERROR: cannot load help information.");
            buff.append("</body>");
            buff.append("</html>");
            infoPane.setText(buff.toString());
        }
        Point l = this.helpDialog.getOwner().getLocation();
        l.x += 50;
        l.y += 80;
        this.helpDialog.setLocation(l);
        this.helpDialog.validate();
        this.helpDialog.pack();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                try {
                    pane.setPage(e.getURL());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public Attribute getAttribute() {
        return this.newAttribute;
    }
}

