/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ncsa.hdf.view.ViewProperties;

public class MathConversionDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 5136554941147830371L;
    private JTextField aField;
    private JTextField bField;
    private JTextArea infoArea;
    private JList functionList;
    private Object dataValue;
    private char NT;
    private final Toolkit toolkit = Toolkit.getDefaultToolkit();
    private String[] functionDescription;
    private boolean isConverted = false;

    public MathConversionDialog(JFrame owner, Object data) {
        super(owner, "Convert Data...", true);
        this.dataValue = data;
        this.NT = (char)32;
        String cName = data.getClass().getName();
        int cIndex = cName.lastIndexOf("[");
        if (cIndex >= 0) {
            this.NT = cName.charAt(cIndex + 1);
        }
        String[] functionNames = new String[]{"[a, b]", "abs (x)", "a + b * x", "pow (x, a)", "exp (x)", "ln (x)", "log (a, x)", "sin (x)", "cos (x)", "tan (x)"};
        this.functionList = new JList<String>(functionNames);
        this.functionList.setSelectionMode(0);
        this.functionList.addListSelectionListener(this);
        String[] tmpStrs = new String[]{"The filter by lower and upper bounds. x=a if x<a; x=b if x>b.\ne.g.\n x=5, [0, 127]=5\n x=-5, [0, 127]=0\n x=255, [0, 127]=127.", "The absolute value of a number, the number without its sign.\ne.g.\n abs(5)=5\n abs(-5)=5.", "Linear function.\ne.g.\n a=5, b=2, x=2.5, a+b*x=10.", "The result of a number raised to power of a.\ne.g.\n x=2.5, a=10, pow(x, a)=9536.743\n x=25, a=0.5, pow(x, a)=5.", "The exponential number e (i.e., 2.718...) raised to the power of x.\ne.g.\n exp(5.0)=148.41316\n exp(5.5)=244.69193", "The natural logarithm (base e) of x.\ne.g.\n ln(20.085541)=3\n ln(10)=2.302585", "The logarithm of x to the base of a, \"a\" must be an integer > 0.\ne.g.\n log(10, 2)=3.321928\n log(2, 10)=0.30103", "The trigonometric sine of angle x in radians.\ne.g.\n sin(0.523599)=0.5\n sin(1.047198)=0.866025", "The trigonometric cosine of angle x in radians.\ne.g.\n cos(0.523599)=0.866025\n cos(1.047198)=0.5", "The trigonometric tangent of angle x in radians.\ne.g.\n tan(0.785398)=1\n tan(1.047198)=1.732051"};
        this.functionDescription = tmpStrs;
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        int w = 500 + (ViewProperties.getFontSize() - 12) * 15;
        int h = 300 + (ViewProperties.getFontSize() - 12) * 10;
        contentPane.setPreferredSize(new Dimension(w, h));
        JButton okButton = new JButton("   Ok   ");
        okButton.setActionCommand("Ok");
        okButton.setMnemonic(79);
        okButton.addActionListener(this);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setMnemonic(67);
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        contentPane.add((Component)buttonPanel, "South");
        JPanel centerP = new JPanel();
        centerP.setLayout(new BorderLayout(10, 10));
        JScrollPane scroller = new JScrollPane(this.functionList);
        centerP.add((Component)scroller, "Center");
        JPanel tmpP = new JPanel();
        tmpP.setLayout(new BorderLayout(5, 5));
        JPanel tmpP0 = new JPanel();
        tmpP0.setLayout(new GridLayout(4, 1, 5, 5));
        tmpP0.add(new JLabel("a = "));
        tmpP0.add(new JLabel("b = "));
        tmpP0.add(new JLabel("                     "));
        tmpP0.add(new JLabel("                     "));
        tmpP.add((Component)tmpP0, "West");
        tmpP0 = new JPanel();
        tmpP0.setLayout(new GridLayout(4, 1, 5, 5));
        this.aField = new JTextField("0");
        tmpP0.add(this.aField);
        this.bField = new JTextField("1");
        tmpP0.add(this.bField);
        tmpP0.add(new JLabel("                     "));
        tmpP0.add(new JLabel("                     "));
        tmpP.add((Component)tmpP0, "Center");
        centerP.add((Component)tmpP, "East");
        centerP.setBorder(new TitledBorder("Converting Data With A Mathematic Function"));
        this.infoArea = new JTextArea(4, 80);
        centerP.add((Component)this.infoArea, "South");
        this.infoArea.setEditable(false);
        this.infoArea.setLineWrap(true);
        this.infoArea.setBackground(Color.lightGray);
        this.infoArea.setWrapStyleWord(true);
        this.aField.setEnabled(false);
        this.bField.setEnabled(false);
        contentPane.add((Component)centerP, "Center");
        Point l = owner.getLocation();
        l.x += 250;
        l.y += 80;
        this.setLocation(l);
        this.validate();
        this.pack();
    }

    private boolean convertData() {
        double a = 0.0;
        double b = 1.0;
        int index = this.functionList.getSelectedIndex();
        try {
            if (index == 0 || index == 2) {
                a = Double.parseDouble(this.aField.getText().trim());
                b = Double.parseDouble(this.bField.getText().trim());
            } else if (index == 3) {
                a = Double.parseDouble(this.aField.getText().trim());
            } else if (index == 6 && (a = (double)Integer.parseInt(this.aField.getText().trim())) <= 0.0) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "a must be an integer greater than zero.", this.getTitle(), 0);
                return false;
            }
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            return false;
        }
        int n = Array.getLength(this.dataValue);
        double value = 0.0;
        double x = 0.0;
        switch (this.NT) {
            case 'B': {
                byte[] bdata = (byte[])this.dataValue;
                for (int i = 0; i < n; ++i) {
                    x = bdata[i];
                    value = this.y(index, x, a, b);
                    if (value > 127.0 || value < -128.0) {
                        JOptionPane.showMessageDialog(this, "Invalid byte value: " + (long)value, this.getTitle(), 0);
                        return false;
                    }
                    bdata[i] = (byte)value;
                }
                break;
            }
            case 'S': {
                short[] sdata = (short[])this.dataValue;
                for (int i = 0; i < n; ++i) {
                    x = sdata[i];
                    value = this.y(index, x, a, b);
                    if (value > 32767.0 || value < -32768.0) {
                        JOptionPane.showMessageDialog(this, "Invalid short value: " + (long)value, this.getTitle(), 0);
                        return false;
                    }
                    sdata[i] = (short)value;
                }
                break;
            }
            case 'I': {
                int[] idata = (int[])this.dataValue;
                for (int i = 0; i < n; ++i) {
                    x = idata[i];
                    value = this.y(index, x, a, b);
                    if (value > 2.147483647E9 || value < -2.147483648E9) {
                        JOptionPane.showMessageDialog(this, "Invalid int value: " + (long)value, this.getTitle(), 0);
                        return false;
                    }
                    idata[i] = (int)value;
                }
                break;
            }
            case 'J': {
                long[] ldata = (long[])this.dataValue;
                for (int i = 0; i < n; ++i) {
                    x = ldata[i];
                    value = this.y(index, x, a, b);
                    if (value > 9.223372036854776E18 || value < -9.223372036854776E18) {
                        JOptionPane.showMessageDialog(this, "Invalid long value: " + (long)value, this.getTitle(), 0);
                        return false;
                    }
                    ldata[i] = (long)value;
                }
                break;
            }
            case 'F': {
                float[] fdata = (float[])this.dataValue;
                for (int i = 0; i < n; ++i) {
                    x = fdata[i];
                    value = this.y(index, x, a, b);
                    if (value > 3.4028234663852886E38 || value < -3.4028234663852886E38 || value == Double.NaN) {
                        JOptionPane.showMessageDialog(this, "Invalid float value: " + value, this.getTitle(), 0);
                        return false;
                    }
                    fdata[i] = (float)value;
                }
                break;
            }
            case 'D': {
                double[] ddata = (double[])this.dataValue;
                for (int i = 0; i < n; ++i) {
                    x = ddata[i];
                    value = this.y(index, x, a, b);
                    if (value > Double.MAX_VALUE || value < -1.7976931348623157E308 || value == Double.NaN) {
                        JOptionPane.showMessageDialog(this, "Invalid double value: " + value, this.getTitle(), 0);
                        return false;
                    }
                    ddata[i] = value;
                }
                break;
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String cmd = e.getActionCommand();
        if (cmd.equals("Ok")) {
            this.isConverted = this.convertData();
            this.dispose();
        }
        if (cmd.equals("Cancel")) {
            this.isConverted = false;
            this.dispose();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (!e.getSource().equals(this.functionList)) {
            return;
        }
        if (this.functionList.isSelectionEmpty()) {
            return;
        }
        int index = this.functionList.getSelectedIndex();
        this.infoArea.setText(this.functionDescription[index]);
        if (index == 0 || index == 2) {
            this.aField.setEnabled(true);
            this.bField.setEnabled(true);
        } else if (index == 3 || index == 6) {
            this.aField.setEnabled(true);
            this.bField.setEnabled(false);
        } else {
            this.aField.setEnabled(false);
            this.bField.setEnabled(false);
        }
    }

    private double y(int index, double x, double a, double b) {
        double y = x;
        switch (index) {
            case 0: {
                if (x < a) {
                    y = a;
                    break;
                }
                if (!(x > b)) break;
                y = b;
                break;
            }
            case 1: {
                y = Math.abs(x);
                break;
            }
            case 2: {
                y = a + b * x;
                break;
            }
            case 3: {
                y = Math.pow(x, a);
                break;
            }
            case 4: {
                y = Math.exp(x);
                break;
            }
            case 5: {
                y = Math.log(x);
                break;
            }
            case 6: {
                y = Math.log(x) / Math.log(a);
                break;
            }
            case 7: {
                y = Math.sin(x);
                break;
            }
            case 8: {
                y = Math.cos(x);
                break;
            }
            case 9: {
                y = Math.tan(x);
                break;
            }
            default: {
                y = x;
            }
        }
        return y;
    }

    public boolean isConverted() {
        return this.isConverted;
    }
}

