/*
 * Decompiled with CFR 0.152.
 */
package Isotopes;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="Isotope_fractionation", author="Andrew Watson, Christian Birkel, Sven Kralisch", description="liquid-vapor equilibrium isotopic fractionation, (Horita and Wesolowski)and kinetic isotopic separation", date="2023-04-04", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class Isotope_fractionation
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temp", defaultValue="0", unit="\u00b0C", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double temp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="tempK", defaultValue="0", unit="Kelvin", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double tempK;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="rhum", defaultValue="0", unit="%", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double rhum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Precipitation water vapor concentration", defaultValue="0", unit="permil", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double pConc;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="concentration of water in the soil", defaultValue="0", unit="permil", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double concS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="isotopic composition of water in the atmosphere", defaultValue="0", unit="permil", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double concA;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="isotopic composition of water evaporated from the soil", defaultValue="0", unit="permil", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double concE;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="seasonality factor", defaultValue="1", unit="unitless", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double k;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="exchange factor", defaultValue="0.9", unit="unitless", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double x;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="initital soil-water Isototope composition", defaultValue="0", unit="permil", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double init_concS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="alphamas", defaultValue="0", unit="permil", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double alphamas;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="epsimas", defaultValue="0", unit="permil", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double epsimas;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="enrichment_slope", defaultValue="0", unit="permil", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double enrichment_slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="dstar", defaultValue="0", unit="permil", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double dstar;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="epsk_H", defaultValue="0", unit="permil", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double epsk_H;

    public void init() {
    }

    public void run() {
        double concA = this.concA.getValue();
        double concE = this.concE.getValue();
        double concS = this.concS.getValue();
        double alphamas = this.alphamas.getValue();
        double epsimas = this.epsimas.getValue();
        double epsk_H = this.epsk_H.getValue();
        double enrichment_slope = this.enrichment_slope.getValue();
        double dstar = this.dstar.getValue();
        this.tempK.setValue(273.13 + this.temp.getValue());
        alphamas = Math.exp(0.001 * (1158.8 * Math.pow(this.tempK.getValue(), 3.0) / Math.pow(10.0, 9.0) - 1620.1 * Math.pow(this.tempK.getValue(), 2.0) / Math.pow(10.0, 6.0) + 794.84 * this.tempK.getValue() / Math.pow(10.0, 3.0) - 161.04 + 2.9992 * Math.pow(10.0, 9.0) / Math.pow(this.tempK.getValue(), 3.0)));
        epsimas = (alphamas - 1.0) * 1000.0;
        epsk_H = 23.89974999999997 * (1.0 - this.rhum.getValue());
        enrichment_slope = (this.rhum.getValue() - Math.pow(10.0, -3.0) * (epsk_H + epsimas / alphamas)) / (1.0 - this.rhum.getValue() + Math.pow(10.0, -3.0) * epsk_H);
        concA = (this.pConc.getValue() - this.k.getValue() * epsimas) / (1.0 + epsimas * Math.pow(10.0, -3.0));
        dstar = (this.rhum.getValue() * concA + epsk_H + epsimas / alphamas) / (this.rhum.getValue() - Math.pow(10.0, -3.0) * (epsk_H + epsimas / alphamas));
        concS = this.init_concS.getValue() - dstar * Math.pow(1.0 - this.x.getValue(), enrichment_slope) + dstar;
        concE = ((concS - epsimas) / alphamas - this.rhum.getValue() * concA - epsk_H) / (1.0 - this.rhum.getValue() + Math.pow(10.0, -3.0) * epsk_H);
        this.concA.setValue(concA);
        this.concS.setValue(concS);
        this.alphamas.setValue(alphamas);
        this.epsimas.setValue(epsimas);
        this.enrichment_slope.setValue(enrichment_slope);
        this.dstar.setValue(dstar);
        this.epsk_H.setValue(epsk_H);
        this.concE.setValue(concE);
    }

    public void cleanup() {
    }
}

