/*
 * Decompiled with CFR 0.152.
 */
package Isotopes;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="Title", author="Author", description="Description", date="YYYY-MM-DD", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version"), @VersionComments.Entry(version="1.0_1", comment="Some improvements")})
public class IsotopeMultiMixer
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="intial_volume", defaultValue="0", unit="L", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double volA;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Initial_concentration", defaultValue="0", unit="mol/L", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double concA;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="intial_volume", defaultValue="0", unit="L", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double[] volB;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Initial_concentration", defaultValue="0", unit="mol/L", lowerBound=0.0, upperBound=-Infinity)
    public Attribute.Double[] concB;

    public void run() {
        double volume = 0.0;
        for (int i = 0; i < this.volB.length; ++i) {
            volume += this.volB[i].getValue();
        }
        double concSum = 0.0;
        for (int i = 0; i < this.volB.length; ++i) {
            double x;
            double weight = this.volB[i].getValue() / volume;
            double volA_weighted = this.volA.getValue() * weight;
            if (this.volA.getValue() + this.volB[i].getValue() == 0.0 || volume == 0.0) {
                x = 0.0;
            } else {
                x = (this.concA.getValue() * volA_weighted + this.concB[i].getValue() * this.volB[i].getValue()) / (volA_weighted + this.volB[i].getValue());
                concSum += x * weight;
            }
            System.out.println(x + " - " + volA_weighted + " - " + this.volB[i].getValue());
            this.concB[i].setValue(x);
        }
        this.concA.setValue(concSum);
    }
}

