/*
 * Decompiled with CFR 0.152.
 */
package dryver.routing;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="ReachRouting_Deepsink", author="Peter Krause", description="Calculates flow processes in the river network by a simplified kinematic wave approach", version="1.0_1", date="2011-05-30")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version"), @VersionComments.Entry(version="1.0_1", comment="Added slopeAsProportion parameter to allow switching between reaches providiong slope either in % or in proportions (elevation difference / length). When using old models with this component, make sure to check if this value was set correctly. Otherwise you might experience a damped signal."), @VersionComments.Entry(version="1.0_2", date="2016-05-24", comment="Added checking of reach slopes to avoid misconfiguration of slope parameters. Use \"checkSlopes\" switch to turn this off!")})
public class ReachRouting_DeepSink
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The reach collection")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="reach length", unit="m")
    public Attribute.Double length;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="reach slope", unit="%")
    public Attribute.Double slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Is slope provided as proportion of length and elevation difference [m/m]?", defaultValue="false")
    public Attribute.Boolean slopeAsProportion;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="If true, slopes of all reaches will be checked if they are compliant to the value of the \"slopeAsProportion\" parameter", defaultValue="true")
    public Attribute.Boolean checkSlopes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="reach width", unit="m")
    public Attribute.Double width;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="reach roughness")
    public Attribute.Double roughness;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RD1 inflow to reach", unit="L")
    public Attribute.Double inRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RD2 inflow to reach", unit="L")
    public Attribute.Double inRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RG1 inflow to reach", unit="L")
    public Attribute.Double inRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RG2 inflow to reach", unit="L")
    public Attribute.Double inRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="additional inflow to reach", unit="L", defaultValue="0")
    public Attribute.Double inAddIn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="RD1 outflow from reach", unit="L")
    public Attribute.Double outRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="RD2 outflow from reach", unit="L")
    public Attribute.Double outRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="RG1 outflow from reach", unit="L")
    public Attribute.Double outRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="RG2 outflow from reach", unit="L")
    public Attribute.Double outRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="additional outflow from reach", unit="L", defaultValue="0")
    public Attribute.Double outAddIn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="simulated runoff from reach", unit="L")
    public Attribute.Double simRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RD1 storage inside reach", unit="L")
    public Attribute.Double actRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RD2 storage inside reach", unit="L")
    public Attribute.Double actRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RG1 storage inside reach", unit="L")
    public Attribute.Double actRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RG2 storage inside reach", unit="L")
    public Attribute.Double actRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="additional inflow storage inside reach", unit="L", defaultValue="0")
    public Attribute.Double actAddIn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Channel storage inside reach", unit="L")
    public Attribute.Double channelStorage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="flow routing coefficient TA", lowerBound=0.0, upperBound=50.0, defaultValue="1.0")
    public Attribute.Double flowRouteTA;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Catchment outlet RD1 storage", unit="L")
    public Attribute.Double catchmentRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Catchment outlet RD2 storage", unit="L")
    public Attribute.Double catchmentRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Catchment outlet RG1 storage", unit="L")
    public Attribute.Double catchmentRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Catchment outlet RG2 storage", unit="L")
    public Attribute.Double catchmentRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Catchment additional input outlet storage", unit="L", defaultValue="0")
    public Attribute.Double catchmentAddIn;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Catchment outlet RG2 storage", unit="L")
    public Attribute.Double catchmentSimRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Temporal resoultion in number of minutes (must be integer divisor of 60)", defaultValue="60")
    public Attribute.Integer tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="water level in reach")
    public Attribute.Double waterLevel;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="switch whether deep sink is allowed or not", defaultValue="0")
    public Attribute.Double deepsink;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="amount of water lost by deep sink in l/d")
    public Attribute.Double DeepsinkW;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="K-Value for the riverbed in cm/d")
    public Attribute.Double Ksink;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Calibration mulitplier for Ksink")
    public Attribute.Double sink_alpha;
    int count = 0;
    double avg = 0.0;
    int slopefactor;
    double deepsinkW = 0.0;
    double rh = 0.0;

    public void init() {
        this.slopefactor = this.slopeAsProportion.getValue() ? 100 : 1;
    }

    public void initAll() {
        if (this.checkSlopes.getValue()) {
            this.avg = (this.avg * (double)this.count + (double)this.slopefactor * this.slope.getValue()) / (double)(++this.count);
            if (this.avg >= 100.0) {
                this.getModel().getRuntime().sendHalt("Average reach slope exceeds 100%. please check your reach parameter file and \"slopeAsProportion\" parameter value!");
            }
            if (this.avg <= 0.1) {
                this.getModel().getRuntime().sendHalt("Average reach slope is below 0.1%. please check your reach parameter file and \"slopeAsProportion\" parameter value!");
            }
        }
    }

    public void run() {
        Attribute.Entity entity = this.entities.getCurrent();
        Attribute.Entity DestReach = (Attribute.Entity)entity.getObject("to_reach");
        if (DestReach.isEmpty()) {
            DestReach = null;
        }
        Attribute.Entity DestReservoir = null;
        DestReservoir = entity.existsAttribute("to_reservoir") ? (Attribute.Entity)entity.getObject("to_reservoir") : null;
        double width = this.width.getValue();
        double rough = this.roughness.getValue();
        double length = this.length.getValue();
        double slope = this.slope.getValue();
        if (!this.slopeAsProportion.getValue()) {
            slope /= 100.0;
        }
        if (slope == 0.0) {
            this.getModel().getRuntime().println("WARNING: Found zero slope in reach entity which will prevent water routing!", 2);
        }
        double RD1act = this.actRD1.getValue() + this.inRD1.getValue();
        double RD2act = this.actRD2.getValue() + this.inRD2.getValue();
        double RG1act = this.actRG1.getValue() + this.inRG1.getValue();
        double RG2act = this.actRG2.getValue() + this.inRG2.getValue();
        double addInAct = this.actAddIn.getValue() + this.inAddIn.getValue();
        this.inRD1.setValue(0.0);
        this.inRD2.setValue(0.0);
        this.inRG1.setValue(0.0);
        this.inRG2.setValue(0.0);
        this.inAddIn.setValue(0.0);
        this.actRD1.setValue(0.0);
        this.actRD2.setValue(0.0);
        this.actRG1.setValue(0.0);
        this.actRG2.setValue(0.0);
        this.actAddIn.setValue(0.0);
        double RD1DestIn = 0.0;
        double RD2DestIn = 0.0;
        double RG1DestIn = 0.0;
        double RG2DestIn = 0.0;
        double addInDestIn = 0.0;
        if (DestReach == null && DestReservoir == null) {
            RD1DestIn = 0.0;
            RD2DestIn = 0.0;
            RG1DestIn = 0.0;
            RG2DestIn = 0.0;
            addInDestIn = 0.0;
        } else if (DestReservoir != null) {
            RD1DestIn = DestReservoir.getDouble("compRD1");
            RD2DestIn = DestReservoir.getDouble("compRD2");
            RG1DestIn = DestReservoir.getDouble("compRG1");
            RG2DestIn = DestReservoir.getDouble("compRG2");
        } else {
            RD1DestIn = DestReach.getDouble("inRD1");
            RD2DestIn = DestReach.getDouble("inRD2");
            RG1DestIn = DestReach.getDouble("inRG1");
            RG2DestIn = DestReach.getDouble("inRG2");
            try {
                addInDestIn = DestReach.getDouble("inAddIn");
            }
            catch (Attribute.Entity.NoSuchAttributeException e) {
                addInDestIn = 0.0;
            }
        }
        double q_act_tot = RD1act + RD2act + RG1act + RG2act + addInAct;
        if (q_act_tot == 0.0) {
            this.outRD1.setValue(0.0);
            this.outRD2.setValue(0.0);
            this.outRG1.setValue(0.0);
            this.outRG2.setValue(0.0);
            this.outAddIn.setValue(0.0);
            return;
        }
        double RD1_part = RD1act / q_act_tot;
        double RD2_part = RD2act / q_act_tot;
        double RG1_part = RG1act / q_act_tot;
        double RG2_part = RG2act / q_act_tot;
        double addInPart = addInAct / q_act_tot;
        int sec_inTStep = this.tempRes.getValue() * 60;
        double flow_veloc = this.calcFlowVelocity(q_act_tot, width, slope, rough, sec_inTStep);
        double Rk = flow_veloc / length * this.flowRouteTA.getValue() * 3600.0;
        double q_act_out = Rk > 0.0 ? q_act_tot * Math.exp(-1.0 / Rk) : 0.0;
        if (this.deepsink.getValue() == 1.0) {
            double Larea = Math.pow(this.rh, 2.0) * length;
            this.deepsinkW = Larea * this.Ksink.getValue() * 10.0 * this.sink_alpha.getValue();
            this.deepsinkW = Math.min(this.deepsinkW, q_act_out);
            this.deepsinkW = Math.max(this.deepsinkW, 0.0);
        } else {
            this.deepsinkW = 0.0;
        }
        this.DeepsinkW.setValue(this.deepsinkW);
        double RD1outdeep = this.deepsinkW * RD1_part;
        double RD2outdeep = this.deepsinkW * RD2_part;
        double RG1outdeep = this.deepsinkW * RG1_part;
        double RG2outdeep = this.deepsinkW * RG2_part;
        double RD1out = q_act_out * RD1_part - RD1outdeep;
        double RD2out = q_act_out * RD2_part - RD2outdeep;
        double RG1out = q_act_out * RG1_part - RG1outdeep;
        double RG2out = q_act_out * RG2_part - RG2outdeep;
        double addInOut = q_act_out * addInPart;
        RD1DestIn += RD1out;
        RD2DestIn += RD2out;
        RG1DestIn += RG1out;
        RG2DestIn += RG2out;
        addInDestIn += addInOut;
        double channelStorage = (RD1act -= q_act_out * RD1_part) + (RD2act -= q_act_out * RD2_part) + (RG1act -= q_act_out * RG1_part) + (RG2act -= q_act_out * RG2_part) + (addInAct -= q_act_out * addInPart);
        double cumOutflow = RD1out + RD2out + RG1out + RG2out + addInOut;
        this.simRunoff.setValue(cumOutflow);
        this.channelStorage.setValue(channelStorage);
        this.inRD1.setValue(0.0);
        this.inRD2.setValue(0.0);
        this.inRG1.setValue(0.0);
        this.inRG2.setValue(0.0);
        this.inAddIn.setValue(0.0);
        this.actRD1.setValue(RD1act);
        this.actRD2.setValue(RD2act);
        this.actRG1.setValue(RG1act);
        this.actRG2.setValue(RG2act);
        this.actAddIn.setValue(addInAct);
        this.outRD1.setValue(RD1out);
        this.outRD2.setValue(RD2out);
        this.outRG1.setValue(RG1out);
        this.outRG2.setValue(RG2out);
        this.outAddIn.setValue(addInOut);
        if (DestReach != null && DestReservoir == null) {
            DestReach.setDouble("inRD1", RD1DestIn);
            DestReach.setDouble("inRD2", RD2DestIn);
            DestReach.setDouble("inRG1", RG1DestIn);
            DestReach.setDouble("inRG2", RG2DestIn);
            DestReach.setDouble("inAddIn", addInDestIn);
        } else if (DestReservoir != null) {
            DestReservoir.setDouble("compRD1", RD1DestIn);
            DestReservoir.setDouble("compRD2", RD2DestIn);
            DestReservoir.setDouble("compRG1", RG1DestIn);
            DestReservoir.setDouble("compRG2", RG2DestIn);
        } else if (DestReach == null && DestReservoir == null) {
            this.catchmentRD1.setValue(RD1out);
            this.catchmentRD2.setValue(RD2out);
            this.catchmentRG1.setValue(RG1out);
            this.catchmentRG2.setValue(RG2out);
            this.catchmentAddIn.setValue(addInOut);
            this.catchmentSimRunoff.setValue(cumOutflow);
        }
        this.waterLevel.setValue(channelStorage / (1000.0 * width * length));
    }

    public void cleanup() {
    }

    public double calcFlowVelocity(double q, double width, double slope, double rough, int secondsOfTimeStep) {
        double afv = 1.0;
        double veloc = 0.0;
        double q_m = q / (double)(1000 * secondsOfTimeStep);
        this.rh = ReachRouting_DeepSink.calcHydraulicRadius(afv, q_m, width);
        boolean cont = true;
        while (cont) {
            veloc = rough * Math.pow(this.rh, 0.6666666666666666) * Math.sqrt(slope);
            if (Math.abs(veloc - afv) > 0.001) {
                afv = veloc;
                this.rh = ReachRouting_DeepSink.calcHydraulicRadius(afv, q_m, width);
                continue;
            }
            cont = false;
            afv = veloc;
        }
        return afv;
    }

    public static double calcHydraulicRadius(double v, double q, double width) {
        double A = q / v;
        double rh = A / (width + 2.0 * (A / width));
        return rh;
    }
}

