/*
 * Decompiled with CFR 0.152.
 */
package dryver.flow;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="PatchyIndex", author="Sven Kralisch", description="Calculates the 'patchy' index", date="2022-10-06", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class PatchyIndex
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily flow state")
    public Attribute.Double flowState;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily flow state attribute name", defaultValue="flowstate")
    public Attribute.String flowStatAttributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Description")
    public Attribute.Entity toReach;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Patchy state")
    public Attribute.Double patchy;

    public void init() {
    }

    public void run() {
        if (this.toReach.getKeys().length != 0) {
            double nextState = this.toReach.getDouble(this.flowStatAttributeName.getValue());
            double thisState = this.flowState.getValue();
            nextState = Math.min(nextState, 1.0);
            if ((thisState = Math.min(thisState, 1.0)) == nextState) {
                this.patchy.setValue(0.0);
            } else {
                this.patchy.setValue(1.0);
            }
        } else {
            this.patchy.setValue(0.0);
        }
    }

    public void cleanup() {
    }
}

