/*
 * Decompiled with CFR 0.152.
 */
package dryver.flow;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="FlowIndices", author="Sven Kralisch", description="Calculates various flow indices", date="2022-08-10", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version", date="2022-08-10")})
public class FlowIndices
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily flow state")
    public Attribute.Double flowState;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates if dry condition did occur")
    public Attribute.Double isDry;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates if pool condition did occur")
    public Attribute.Double isPool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates if flowing condition did occur")
    public Attribute.Double isFlowing;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="number of consecutive days with dry condition")
    public Attribute.Double consecutiveDaysDry;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="number of consecutive days with flowing condition")
    public Attribute.Double consecutiveDaysFlowing;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="number of consecutive days with pool condition")
    public Attribute.Double consecutiveDaysPool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="number of consecutive days with non-dry condition")
    public Attribute.Double consecutiveDaysNoDry;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="number of consecutive days with non-flowing condition")
    public Attribute.Double consecutiveDaysNoFlowing;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="number of consecutive days with non-pool condition")
    public Attribute.Double consecutiveDaysNoPool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="number of periods with non-dry condition")
    public Attribute.Double periodsNoDry;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="number of periods with non-flowing condition")
    public Attribute.Double periodsNoFlowing;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="number of periods with non-pool condition")
    public Attribute.Double periodsNoPool;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="number of consecutive days with dry condition within a year")
    public Attribute.Double consecutiveDaysDryYear;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="number of consecutive days with pool condition within a year")
    public Attribute.Double consecutiveDaysPoolYear;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="number of consecutive days with flowing condition within a year")
    public Attribute.Double consecutiveDaysFlowingYear;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="length of period with dry condition")
    public Attribute.Double lengthPeriodDryYear;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="length of period with pool condition")
    public Attribute.Double lengthPeriodPoolYear;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="length of period with flowing condition")
    public Attribute.Double lengthPeriodFlowingYear;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="number of consecutive days with dry condition within a month")
    public Attribute.Double consecutiveDaysDryMonth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="number of consecutive days with pool condition within a month")
    public Attribute.Double consecutiveDaysPoolMonth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="number of consecutive days with flowing condition within a month")
    public Attribute.Double consecutiveDaysFlowingMonth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="length of period with dry condition")
    public Attribute.Double lengthPeriodDryMonth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="length of period with pool condition")
    public Attribute.Double lengthPeriodPoolMonth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="length of period with flowing condition")
    public Attribute.Double lengthPeriodFlowingMonth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="start of a rewetting event")
    public Attribute.Double startFlowing;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="start of a drying event")
    public Attribute.Double startDrying;

    public void init() {
    }

    public void run() {
        int lastDayMonth = this.time.getActualMaximum(5);
        int lastDayYear = this.time.getActualMaximum(6);
        int currentDayMonth = this.time.get(5);
        int currentDayYear = this.time.get(6);
        this.isDry.setValue(0.0);
        this.isPool.setValue(0.0);
        this.isFlowing.setValue(0.0);
        this.startDrying.setValue(0.0);
        this.startFlowing.setValue(0.0);
        this.lengthPeriodDryYear.setValue(0.0);
        this.lengthPeriodPoolYear.setValue(0.0);
        this.lengthPeriodFlowingYear.setValue(0.0);
        this.lengthPeriodDryMonth.setValue(0.0);
        this.lengthPeriodPoolMonth.setValue(0.0);
        this.lengthPeriodFlowingMonth.setValue(0.0);
        this.consecutiveDaysNoFlowing.setValue(0.0);
        this.consecutiveDaysNoDry.setValue(0.0);
        this.consecutiveDaysNoPool.setValue(0.0);
        if (this.flowState.getValue() == 1.0) {
            this.isFlowing.setValue(1.0);
            this.consecutiveDaysFlowing.setValue(this.consecutiveDaysFlowing.getValue() + 1.0);
            if (this.consecutiveDaysFlowing.getValue() == 1.0) {
                this.consecutiveDaysNoFlowing.setValue(this.consecutiveDaysDry.getValue() + this.consecutiveDaysPool.getValue());
                if (this.consecutiveDaysNoFlowing.getValue() != 0.0) {
                    this.periodsNoFlowing.setValue(this.periodsNoFlowing.getValue() + 1.0);
                }
            }
            this.consecutiveDaysDry.setValue(0.0);
            this.consecutiveDaysPool.setValue(0.0);
            this.consecutiveDaysFlowingYear.setValue(this.consecutiveDaysFlowingYear.getValue() + 1.0);
            this.lengthPeriodDryYear.setValue(this.consecutiveDaysDryYear.getValue());
            this.consecutiveDaysDryYear.setValue(0.0);
            this.lengthPeriodPoolYear.setValue(this.consecutiveDaysPoolYear.getValue());
            this.consecutiveDaysPoolYear.setValue(0.0);
            this.consecutiveDaysFlowingMonth.setValue(this.consecutiveDaysFlowingMonth.getValue() + 1.0);
            this.lengthPeriodDryMonth.setValue(this.consecutiveDaysDryMonth.getValue());
            this.consecutiveDaysDryMonth.setValue(0.0);
            this.lengthPeriodPoolMonth.setValue(this.consecutiveDaysPoolMonth.getValue());
            this.consecutiveDaysPoolMonth.setValue(0.0);
        } else if (this.flowState.getValue() == 0.0) {
            this.isDry.setValue(1.0);
            this.consecutiveDaysDry.setValue(this.consecutiveDaysDry.getValue() + 1.0);
            if (this.consecutiveDaysDry.getValue() == 1.0) {
                this.consecutiveDaysNoDry.setValue(this.consecutiveDaysFlowing.getValue() + this.consecutiveDaysPool.getValue());
                if (this.consecutiveDaysNoDry.getValue() != 0.0) {
                    this.periodsNoDry.setValue(this.periodsNoDry.getValue() + 1.0);
                }
            }
            this.consecutiveDaysFlowing.setValue(0.0);
            this.consecutiveDaysPool.setValue(0.0);
            this.consecutiveDaysDryYear.setValue(this.consecutiveDaysDryYear.getValue() + 1.0);
            this.lengthPeriodFlowingYear.setValue(this.consecutiveDaysFlowingYear.getValue());
            this.consecutiveDaysFlowingYear.setValue(0.0);
            this.lengthPeriodPoolYear.setValue(this.consecutiveDaysPoolYear.getValue());
            this.consecutiveDaysPoolYear.setValue(0.0);
            this.consecutiveDaysDryMonth.setValue(this.consecutiveDaysDryMonth.getValue() + 1.0);
            this.lengthPeriodFlowingMonth.setValue(this.consecutiveDaysFlowingMonth.getValue());
            this.consecutiveDaysFlowingMonth.setValue(0.0);
            this.lengthPeriodPoolMonth.setValue(this.consecutiveDaysPoolMonth.getValue());
            this.consecutiveDaysPoolMonth.setValue(0.0);
        } else if (this.flowState.getValue() == 2.0) {
            this.isPool.setValue(1.0);
            this.consecutiveDaysPool.setValue(this.consecutiveDaysPool.getValue() + 1.0);
            if (this.consecutiveDaysPool.getValue() == 1.0) {
                this.consecutiveDaysNoPool.setValue(this.consecutiveDaysFlowing.getValue() + this.consecutiveDaysDry.getValue());
                if (this.consecutiveDaysNoPool.getValue() != 0.0) {
                    this.periodsNoPool.setValue(this.periodsNoPool.getValue() + 1.0);
                }
            }
            this.consecutiveDaysDry.setValue(0.0);
            this.consecutiveDaysFlowing.setValue(0.0);
            this.consecutiveDaysPoolYear.setValue(this.consecutiveDaysPoolYear.getValue() + 1.0);
            this.lengthPeriodDryYear.setValue(this.consecutiveDaysDryYear.getValue());
            this.consecutiveDaysDryYear.setValue(0.0);
            this.lengthPeriodFlowingYear.setValue(this.consecutiveDaysFlowingYear.getValue());
            this.consecutiveDaysFlowingYear.setValue(0.0);
            this.consecutiveDaysPoolMonth.setValue(this.consecutiveDaysPoolMonth.getValue() + 1.0);
            this.lengthPeriodDryMonth.setValue(this.consecutiveDaysDryMonth.getValue());
            this.consecutiveDaysDryMonth.setValue(0.0);
            this.lengthPeriodFlowingMonth.setValue(this.consecutiveDaysFlowingMonth.getValue());
            this.consecutiveDaysFlowingMonth.setValue(0.0);
        }
        if (this.consecutiveDaysFlowing.getValue() == 1.0) {
            this.startFlowing.setValue(1.0);
        }
        if (this.consecutiveDaysDry.getValue() == 1.0) {
            this.startDrying.setValue(1.0);
        }
        if (currentDayYear == lastDayYear) {
            if (this.lengthPeriodDryYear.getValue() == 0.0) {
                this.lengthPeriodDryYear.setValue(this.consecutiveDaysDryYear.getValue());
            }
            if (this.lengthPeriodPoolYear.getValue() == 0.0) {
                this.lengthPeriodPoolYear.setValue(this.consecutiveDaysPoolYear.getValue());
            }
            if (this.lengthPeriodFlowingYear.getValue() == 0.0) {
                this.lengthPeriodFlowingYear.setValue(this.consecutiveDaysFlowingYear.getValue());
            }
            this.consecutiveDaysDryYear.setValue(0.0);
            this.consecutiveDaysPoolYear.setValue(0.0);
            this.consecutiveDaysFlowingYear.setValue(0.0);
        }
        if (currentDayMonth == lastDayMonth) {
            if (this.lengthPeriodDryMonth.getValue() == 0.0) {
                this.lengthPeriodDryMonth.setValue(this.consecutiveDaysDryMonth.getValue());
            }
            if (this.lengthPeriodPoolMonth.getValue() == 0.0) {
                this.lengthPeriodPoolMonth.setValue(this.consecutiveDaysPoolMonth.getValue());
            }
            if (this.lengthPeriodFlowingMonth.getValue() == 0.0) {
                this.lengthPeriodFlowingMonth.setValue(this.consecutiveDaysFlowingMonth.getValue());
            }
            this.consecutiveDaysDryMonth.setValue(0.0);
            this.consecutiveDaysPoolMonth.setValue(0.0);
            this.consecutiveDaysFlowingMonth.setValue(0.0);
        }
        if (this.lengthPeriodDryYear.getValue() == 0.0) {
            this.lengthPeriodDryYear.setValue(JAMS.getMissingDataValue());
        }
        if (this.lengthPeriodPoolYear.getValue() == 0.0) {
            this.lengthPeriodPoolYear.setValue(JAMS.getMissingDataValue());
        }
        if (this.lengthPeriodFlowingYear.getValue() == 0.0) {
            this.lengthPeriodFlowingYear.setValue(JAMS.getMissingDataValue());
        }
        if (this.lengthPeriodDryMonth.getValue() == 0.0) {
            this.lengthPeriodDryMonth.setValue(JAMS.getMissingDataValue());
        }
        if (this.lengthPeriodPoolMonth.getValue() == 0.0) {
            this.lengthPeriodPoolMonth.setValue(JAMS.getMissingDataValue());
        }
        if (this.lengthPeriodFlowingMonth.getValue() == 0.0) {
            this.lengthPeriodFlowingMonth.setValue(JAMS.getMissingDataValue());
        }
    }

    public void cleanup() {
    }
}

