/*
 * Decompiled with CFR 0.152.
 */
package dryver.flow;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="Component to calculate flow conditions", author="Sven Kralisch & Annika K\u00fcnne", description="Uses a threshold for the simulated runoff to define different flow conditions", date="2022-04-06", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class FlowCondition
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="current runoff", unit="L")
    public Attribute.Double runoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="runoff threshold value for flow/no-flow separation", unit="L")
    public Attribute.Double[] threshold;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="flow state (0 - no flow, 1 - flow, 2 - pools)", unit="L")
    public Attribute.Double flowState;

    public void run() {
        if (this.threshold.length == 1) {
            if (this.runoff.getValue() < this.threshold[0].getValue()) {
                this.flowState.setValue(0.0);
            } else {
                this.flowState.setValue(1.0);
            }
        }
    }
}

