/*
 * Decompiled with CFR 0.152.
 */
package javax.units;

import javax.units.SI;
import javax.units.Unit;
import javax.units.UnitFormat;

public final class NonSI {
    private static double STANDARD_GRAVITY = 9.80665;
    private static double INTERNATIONAL_FOOT = 0.3048;
    private static double AVOIRDUPOIS_POUND = 0.45359237;
    private static double AVOGADRO_CONSTANT = 6.02214199E23;
    private static double ELEMENTARY_CHARGE = 1.602176462E-19;
    public static final Unit PERCENT = UnitFormat.label(Unit.ONE.multiply(0.01), "%");
    public static final Unit GALILEO = SI.METER.multiply(0.01).divide(SI.SECOND.pow(2));
    public static final Unit G = UnitFormat.label(SI.METER.divide(SI.SECOND.pow(2)).multiply(STANDARD_GRAVITY), "grav");
    public static final Unit ATOM = UnitFormat.label(SI.MOLE.multiply(1.0 / AVOGADRO_CONSTANT), "atom");
    public static final Unit REVOLUTION = UnitFormat.label(SI.RADIAN.multiply(Math.PI * 2), "rev");
    public static final Unit DEGREE_ANGLE = UnitFormat.label(REVOLUTION.multiply(0.002777777777777778), "\u00b0");
    public static final Unit MINUTE_ANGLE = UnitFormat.label(DEGREE_ANGLE.multiply(0.016666666666666666), "\u2032");
    public static final Unit SECOND_ANGLE = UnitFormat.label(MINUTE_ANGLE.multiply(0.016666666666666666), "\u2033");
    public static final Unit CENTIRADIAN = UnitFormat.label(SI.RADIAN.multiply(0.01), "centiradian");
    public static final Unit GRADE = UnitFormat.label(REVOLUTION.multiply(0.0025), "grade");
    public static final Unit ARE = UnitFormat.label(SI.METER.pow(2).multiply(100.0), "a");
    public static final Unit HECTARE = UnitFormat.label(ARE.multiply(100.0), "ha");
    public static final Unit BARN = UnitFormat.label(SI.METER.pow(2).multiply(1.0E-28), "b");
    public static final Unit BYTE;
    public static final Unit OCTET;
    public static final Unit MINUTE;
    public static final Unit HOUR;
    public static final Unit DAY;
    public static final Unit WEEK;
    public static final Unit YEAR;
    public static final Unit MONTH;
    public static final Unit DAY_SIDEREAL;
    public static final Unit YEAR_SIDEREAL;
    public static final Unit YEAR_CALENDAR;
    public static final Unit AEON;
    public static final Unit E;
    public static final Unit FARADAY;
    public static final Unit FRANKLIN;
    public static final Unit GILBERT;
    public static final Unit BTU;
    public static final Unit BTU_TH;
    public static final Unit BTU_MEAN;
    public static final Unit CALORIE;
    public static final Unit KILOCALORIE;
    public static final Unit ERG;
    public static final Unit ELECTRON_VOLT;
    public static final Unit THERM;
    public static final Unit LAMBERT;
    public static final Unit FOOT;
    public static final Unit YARD;
    public static final Unit INCH;
    public static final Unit MILE;
    public static final Unit NAUTICAL_MILE;
    public static final Unit ANGSTROM;
    public static final Unit ASTRONOMICAL_UNIT;
    public static final Unit LIGHT_YEAR;
    public static final Unit PARSEC;
    public static final Unit BOHR;
    public static final Unit POINT;
    public static final Unit PIXEL;
    public static final Unit COMPUTER_POINT;
    public static final Unit PICA;
    public static final Unit DIDOT;
    public static final Unit CICERO;
    public static final Unit MAXWELL;
    public static final Unit GAUSS;
    public static final Unit ATOMIC_MASS;
    public static final Unit ELECTRON_MASS;
    public static final Unit CARAT;
    public static final Unit POUND;
    public static final Unit OUNCE;
    public static final Unit TON_US;
    public static final Unit TON_UK;
    public static final Unit METRIC_TON;
    public static final Unit DYNE;
    public static final Unit KILOGRAM_FORCE;
    public static final Unit POUND_FORCE;
    public static final Unit HORSEPOWER;
    public static final Unit ATMOSPHERE;
    public static final Unit BAR;
    public static final Unit MILLIBAR;
    public static final Unit MILLIMETER_OF_MERCURY;
    public static final Unit INCH_OF_MERCURY;
    public static final Unit RAD;
    public static final Unit REM;
    public static final Unit CURIE;
    public static final Unit RUTHERFORD;
    public static final Unit SPHERE;
    public static final Unit RANKINE;
    public static final Unit FAHRENHEIT;
    public static final Unit KNOT;
    public static final Unit MACH;
    public static final Unit C;
    public static final Unit LITER;
    public static final Unit GALLON_LIQUID_US;
    public static final Unit PINT_LIQUID_US;
    public static final Unit FLUID_OUNCE_US;
    public static final Unit GALLON_DRY_US;
    public static final Unit PINT_DRY_US;
    public static final Unit GALLON_UK;
    public static final Unit PINT_UK;
    public static final Unit FLUID_OUNCE_UK;
    public static final Unit CUP_US;
    public static final Unit CUP_UK;
    public static final Unit TABLESPOON_US;
    public static final Unit TABLESPOON_UK;
    public static final Unit TEASPOON_US;
    public static final Unit TEASPOON_UK;
    public static final Unit TABLESPOON_AU;
    public static final Unit ROENTGEN;

    private NonSI() {
    }

    static {
        OCTET = BYTE = UnitFormat.label(SI.BIT.multiply(8.0), "byte");
        MINUTE = UnitFormat.label(SI.SECOND.multiply(60.0), "min");
        HOUR = UnitFormat.label(MINUTE.multiply(60.0), "h");
        DAY = UnitFormat.label(HOUR.multiply(24.0), "d");
        WEEK = UnitFormat.label(DAY.multiply(7.0), "week");
        YEAR = UnitFormat.label(SI.SECOND.multiply(3.1556952E7), "year");
        MONTH = UnitFormat.label(YEAR.multiply(0.08333333333333333), "month");
        DAY_SIDEREAL = UnitFormat.label(SI.SECOND.multiply(86164.09), "day_sidereal");
        YEAR_SIDEREAL = UnitFormat.label(SI.SECOND.multiply(3.155814954E7), "year_sidereal");
        YEAR_CALENDAR = UnitFormat.label(DAY.multiply(365.0), "year_calendar");
        AEON = YEAR.multiply(1.0E9);
        E = UnitFormat.label(SI.COULOMB.multiply(ELEMENTARY_CHARGE), "e");
        FARADAY = UnitFormat.label(SI.COULOMB.multiply(ELEMENTARY_CHARGE * AVOGADRO_CONSTANT), "Fd");
        FRANKLIN = UnitFormat.label(SI.COULOMB.multiply(3.3356E-10), "Fr");
        GILBERT = UnitFormat.label(SI.AMPERE.multiply(0.7957747154594768), "Gi");
        BTU = UnitFormat.label(SI.JOULE.multiply(1055.056), "Btu");
        BTU_TH = UnitFormat.label(SI.JOULE.multiply(1054.35), "Btu_Th");
        BTU_MEAN = UnitFormat.label(SI.JOULE.multiply(1055.87), "Btu_mean");
        CALORIE = UnitFormat.label(SI.JOULE.multiply(4.1868), "cal");
        KILOCALORIE = UnitFormat.label(CALORIE.multiply(1000.0), "Cal");
        ERG = UnitFormat.label(SI.JOULE.multiply(1.0E-7), "erg");
        ELECTRON_VOLT = UnitFormat.label(SI.JOULE.multiply(ELEMENTARY_CHARGE), "eV");
        UnitFormat.label(ELECTRON_VOLT.multiply(1000.0), "keV");
        UnitFormat.label(ELECTRON_VOLT.multiply(1000000.0), "MeV");
        UnitFormat.label(ELECTRON_VOLT.multiply(1.0E9), "GeV");
        THERM = UnitFormat.label(SI.JOULE.multiply(1.054804E8), "thm");
        LAMBERT = UnitFormat.label(SI.LUX.multiply(10000.0), "La");
        FOOT = UnitFormat.label(SI.METER.multiply(INTERNATIONAL_FOOT), "ft");
        YARD = UnitFormat.label(FOOT.multiply(3.0), "yd");
        INCH = UnitFormat.label(FOOT.multiply(0.08333333333333333), "in");
        MILE = UnitFormat.label(SI.METER.multiply(1609.344), "mi");
        NAUTICAL_MILE = UnitFormat.label(SI.METER.multiply(1852.0), "nmi");
        ANGSTROM = UnitFormat.label(SI.METER.multiply(1.0E-10), "\u00c5");
        ASTRONOMICAL_UNIT = UnitFormat.label(SI.METER.multiply(1.49597870691E11), "ua");
        LIGHT_YEAR = UnitFormat.label(SI.METER.multiply(9.460528405E15), "ly");
        PARSEC = UnitFormat.label(SI.METER.multiply(3.085677E16), "pc");
        BOHR = UnitFormat.label(SI.METER.multiply(5.2918E-11), "Bohr");
        POINT = UnitFormat.label(INCH.multiply(0.013837), "pt");
        COMPUTER_POINT = PIXEL = UnitFormat.label(INCH.multiply(0.013888888888888888), "pixel");
        PICA = UnitFormat.label(POINT.multiply(12.0), "pi");
        DIDOT = UnitFormat.label(SI.METER.multiply(3.7592E-4), "Didot");
        CICERO = UnitFormat.label(DIDOT.multiply(12.0), "cicero");
        MAXWELL = UnitFormat.label(SI.WEBER.multiply(1.0E-8), "Mx");
        GAUSS = UnitFormat.label(SI.TESLA.multiply(1.0E-4), "G");
        ATOMIC_MASS = UnitFormat.label(SI.KILOGRAM.multiply(0.001 / AVOGADRO_CONSTANT), "u");
        ELECTRON_MASS = UnitFormat.label(SI.KILOGRAM.multiply(9.10938188E-31), "me");
        CARAT = UnitFormat.label(SI.KILOGRAM.multiply(2.0E-4), "ct");
        POUND = UnitFormat.label(SI.KILOGRAM.multiply(AVOIRDUPOIS_POUND), "lb");
        OUNCE = UnitFormat.label(POUND.multiply(0.0625), "oz_av");
        TON_US = UnitFormat.label(POUND.multiply(2000.0), "ton_US");
        TON_UK = UnitFormat.label(POUND.multiply(2240.0), "ton_UK");
        METRIC_TON = UnitFormat.label(SI.KILOGRAM.multiply(1000.0), "t");
        DYNE = UnitFormat.label(SI.NEWTON.multiply(1.0E-5), "dyn");
        KILOGRAM_FORCE = UnitFormat.label(SI.NEWTON.multiply(STANDARD_GRAVITY), "kgf");
        POUND_FORCE = UnitFormat.label(SI.NEWTON.multiply(AVOIRDUPOIS_POUND * STANDARD_GRAVITY), "lbf");
        HORSEPOWER = UnitFormat.label(SI.WATT.multiply(735.499), "hp");
        ATMOSPHERE = UnitFormat.label(SI.PASCAL.multiply(101325.0), "atm");
        BAR = UnitFormat.label(SI.PASCAL.multiply(100000.0), "bar");
        MILLIBAR = UnitFormat.label(BAR.multiply(0.001), "mbar");
        MILLIMETER_OF_MERCURY = UnitFormat.label(SI.PASCAL.multiply(133.322), "mm_Hg");
        INCH_OF_MERCURY = UnitFormat.label(SI.PASCAL.multiply(3386.388), "in_Hg");
        RAD = UnitFormat.label(SI.GRAY.multiply(0.01), "rd");
        REM = UnitFormat.label(SI.SIEVERT.multiply(0.01), "rem");
        CURIE = UnitFormat.label(SI.BECQUEREL.multiply(3.7E10), "Ci");
        RUTHERFORD = UnitFormat.label(SI.BECQUEREL.multiply(1000000.0), "Rd");
        SPHERE = UnitFormat.label(SI.STERADIAN.multiply(Math.PI * 4), "sphere");
        RANKINE = UnitFormat.label(SI.KELVIN.multiply(0.5555555555555556), "\u00b0R");
        FAHRENHEIT = UnitFormat.label(RANKINE.add(459.67), "\u00b0F");
        KNOT = NAUTICAL_MILE.divide(HOUR);
        MACH = UnitFormat.label(SI.METER.divide(SI.SECOND).multiply(331.6), "M");
        C = UnitFormat.label(SI.METER.divide(SI.SECOND).multiply(2.99792458E8), "c");
        LITER = UnitFormat.label(SI.METER.pow(3).multiply(0.001), "L");
        UnitFormat.label(LITER.multiply(1.0E-6), "\u00b5L");
        UnitFormat.label(LITER.multiply(0.001), "mL");
        UnitFormat.label(LITER.multiply(0.01), "cL");
        UnitFormat.label(LITER.multiply(0.1), "dL");
        GALLON_LIQUID_US = UnitFormat.label(INCH.pow(3).multiply(231.0), "gallon_liquid_US");
        PINT_LIQUID_US = UnitFormat.label(GALLON_LIQUID_US.multiply(0.125), "pint_liquid_US");
        FLUID_OUNCE_US = UnitFormat.label(PINT_LIQUID_US.multiply(0.0625), "fluid_ounce_US");
        GALLON_DRY_US = UnitFormat.label(INCH.pow(3).multiply(268.8025), "gallon_dry_US");
        PINT_DRY_US = UnitFormat.label(GALLON_DRY_US.multiply(0.125), "pint_dry_US");
        GALLON_UK = UnitFormat.label(LITER.multiply(4.54609), "gallon_UK");
        PINT_UK = UnitFormat.label(GALLON_UK.multiply(0.125), "pint_UK");
        FLUID_OUNCE_UK = UnitFormat.label(GALLON_UK.multiply(0.00625), "fluid_ounce_UK");
        CUP_US = UnitFormat.label(FLUID_OUNCE_US.multiply(8.0), "cup_US");
        CUP_UK = UnitFormat.label(FLUID_OUNCE_UK.multiply(10.0), "cup_UK");
        TABLESPOON_US = UnitFormat.label(FLUID_OUNCE_US.multiply(0.5), "tablespoon_US");
        TABLESPOON_UK = UnitFormat.label(FLUID_OUNCE_UK.multiply(0.625), "taplespoon_UK");
        TEASPOON_US = UnitFormat.label(FLUID_OUNCE_US.multiply(0.16666666666666666), "teaspoon_US");
        TEASPOON_UK = UnitFormat.label(FLUID_OUNCE_UK.multiply(0.16666666666666666), "teaspoon_UK");
        TABLESPOON_AU = UnitFormat.label(SI.METER.pow(3).multiply(2.0E-5), "tablespoon_AU");
        ROENTGEN = UnitFormat.label(SI.COULOMB.divide(SI.KILOGRAM).multiply(2.58E-4), "R");
    }
}

